/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import jams.tools.JAMSTools;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@JAMSComponentDescription(title="StationDataWriter", author="Peter Krause", description="Writes standard ASCII timeseries data files")
public class StationDataWriter_new
extends JAMSComponent {
    public static final String EMPTY_CHAR = "";
    public static final String SEPARATOR = "\t";
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EntitySet")
    public Attribute.EntityCollection entitySet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="data set description [type min max unit]")
    public Attribute.String dataSetDesc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution", defaultValue="")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the name of the attribute to write", defaultValue="")
    public Attribute.String value;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="missing data value")
    public Attribute.Double missDataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output data precision")
    public Attribute.Integer precision;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="write file with input header", defaultValue="true")
    public Attribute.String withInputHeader;
    private GenericDataWriter writer;
    private DateFormat dateFormat;

    public void init() {
        int ent = this.entitySet.getEntityArray().length;
        this.getModel().getRuntime().println(" start init " + this.fileName.getValue() + ".. ", 2);
        Date dt = new Date();
        int tu = this.timeInterval.getTimeUnit();
        String timeFormat = "%1$tY-%1$tm-%1$td %1$tH:%1$tM";
        if (tu == 11) {
            timeFormat = "%1$td.%1$tm.%1$tY %1$tH:%1$tM";
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        } else if (tu == 6) {
            timeFormat = "%1$td.%1$tm.%1$tY";
            this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        } else if (tu == 2) {
            timeFormat = "%1$tm/%1$tY";
            this.dateFormat = new SimpleDateFormat("MM/yyyy");
        } else if (tu == 1) {
            timeFormat = "%1$tY";
            this.dateFormat = new SimpleDateFormat("yyyy");
        }
        this.dateFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        this.writer = new GenericDataWriter(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspace().getOutputDataDirectory().getPath(), (String)this.fileName.getValue()));
        String inputHeader = this.withInputHeader.getValue();
        if (inputHeader != null && inputHeader.equalsIgnoreCase("true")) {
            int i;
            this.writer.writeLine("#Calculated input data, generated: " + dt);
            this.writer.writeLine("@dataValueAttribs");
            this.writer.writeLine(this.dataSetDesc.getValue());
            this.writer.writeLine("@dataSetAttribs");
            this.writer.writeLine("missingDataVal\t" + this.missDataValue.getValue());
            this.writer.writeLine("dataStart\t" + this.timeInterval.getStart().toString(this.dateFormat));
            this.writer.writeLine("dataEnd\t" + this.timeInterval.getEnd().toString(this.dateFormat));
            this.writer.writeLine("tres\t" + this.tempRes);
            this.writer.writeLine("@statAttribVal");
            this.writer.addColumn("name");
            for (i = 0; i < ent; ++i) {
                this.writer.addColumn((String)((Attribute.Entity)this.entitySet.getEntities().get(i)).getObject("NAME"));
            }
            this.writer.writeHeader();
            this.writer.write("ID");
            for (i = 0; i < ent; ++i) {
                this.writer.write(SEPARATOR + ((Attribute.Entity)this.entitySet.getEntities().get(i)).getInt("ID"));
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.write("elevation");
            for (i = 0; i < ent; ++i) {
                this.writer.write(SEPARATOR + ((Attribute.Entity)this.entitySet.getEntities().get(i)).getDouble("ELEVATION"));
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.write("x");
            for (i = 0; i < ent; ++i) {
                this.writer.write(SEPARATOR + ((Attribute.Entity)this.entitySet.getEntities().get(i)).getDouble("X"));
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.write("y");
            for (i = 0; i < ent; ++i) {
                this.writer.write(SEPARATOR + ((Attribute.Entity)this.entitySet.getEntities().get(i)).getDouble("Y"));
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.write("dataColumn");
            for (i = 0; i < ent; ++i) {
                int col = i + 1;
                this.writer.write(SEPARATOR + col);
            }
            this.writer.writeLine(EMPTY_CHAR);
            this.writer.writeLine("@dataVal");
        } else {
            int cols = ent + 1;
            String[] hdr = new String[cols];
            hdr[0] = "date";
            for (int i = 1; i < cols; ++i) {
                hdr[i] = (String)((Attribute.Entity)this.entitySet.getEntities().get(i - 1)).getObject("NAME");
            }
            this.writer.writeHeader();
        }
        this.getModel().getRuntime().println(" end init " + this.fileName.getValue() + ".. ", 2);
    }

    public void run() {
        int ent = this.entitySet.getEntityArray().length;
        this.writer.addData((Object)this.time.toString(this.dateFormat));
        for (int i = 0; i < ent; ++i) {
            this.writer.addData(((Attribute.Entity)this.entitySet.getEntities().get(i)).getDouble(this.value.getValue()), this.precision.getValue());
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().println(jre.getMessage());
        }
    }

    public void cleanup() {
        try {
            this.writer.writer.flush();
            this.writer.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

