/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;

@JAMSComponentDescription(title="StandardPixelPositionReader", author="Sven Kralisch", description="This component reads an ASCII file containing pixel  information and adds them to model entities.", date="2005-11-10", version="1.1_0")
public class StandardPixelPositionReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Land use parameter file name")
    public Attribute.String pixelPositionFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hru objects")
    public Attribute.String pixelIDAttribute;

    public void init() {
        Attribute.EntityCollection pixels = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        pixels.setEntities(J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.pixelPositionFile.getValue()), this.getModel()));
        HashMap<Double, Attribute.Entity> pixelMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity pixel : pixels.getEntities()) {
            pixelMap.put(pixel.getDouble(this.pixelIDAttribute.getValue()), pixel);
        }
        for (Attribute.Entity e : this.hrus.getEntities()) {
            Object[] attrs;
            Attribute.Entity pixel;
            Object cell = e.getObject("Cell_ID");
            if (cell instanceof Attribute.Double) {
                pixel = (Attribute.Entity)pixelMap.get(e.getDouble("Cell_ID"));
                e.setObject("Cell_ID", (Object)pixel);
                attrs = pixel.getKeys();
                for (int i = 0; i < attrs.length; ++i) {
                    Object o = pixel.getObject((String)attrs[i]);
                    if (o instanceof Attribute.String) continue;
                    e.setObject((String)attrs[i], o);
                }
                continue;
            }
            if (!(cell instanceof Attribute.DoubleArray)) continue;
            Attribute.DoubleArray pixelIDs = (Attribute.DoubleArray)cell;
            HashMap<String, Attribute.DoubleArray> data = new HashMap<String, Attribute.DoubleArray>();
            int j = 0;
            double[] dArray = pixelIDs.getValue();
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double pixelID = dArray[i];
                pixel = (Attribute.Entity)pixelMap.get(pixelID);
                attrs = pixel.getKeys();
                for (int i2 = 0; i2 < attrs.length; ++i2) {
                    Attribute.DoubleArray array = (Attribute.DoubleArray)data.get((String)attrs[i2]);
                    if (array == null) {
                        array = DefaultDataFactory.getDataFactory().createDoubleArray();
                        array.setValue(new double[pixelIDs.getValue().length]);
                        data.put((String)attrs[i2], array);
                    }
                    array.getValue()[j] = pixel.getDouble((String)attrs[i2]);
                    e.setObject((String)attrs[i2], (Object)array);
                }
                ++j;
            }
        }
        this.getModel().getRuntime().println("Pixel parameter file processed ...", 2);
    }
}

