/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.util.HashMap;
import java.util.Iterator;
import org.unijena.j2k.J2KFunctions;

@JAMSComponentDescription(title="Res_OperationPlan_reader", author="Manfred Fink", description="This component reads an ASCII file containing Pool-based Operating Plan information and adds them to model entities.", date="2025-05-20", version="1.0_0")
public class Res_OperationPlan_reader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Pool-based Operating Plan parameter file name")
    public Attribute.String LamelleName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of Reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of reach where the reservoir is located")
    public Attribute.Double RID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="initial storage in the reservoir [m\u00b3]", unit="m\u00b3", defaultValue="0.0")
    public Attribute.Double res_init;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Initial RD1 storage proportion in the reservoir", unit="-", defaultValue="0.25")
    public Attribute.Double res_init_porp_RD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Initial RD2 storage proportion in the reservoir", unit="-", defaultValue="0.25")
    public Attribute.Double res_init_porp_RD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Initial RG1 storage proportion in the reservoir", unit="-", defaultValue="0.25")
    public Attribute.Double res_init_porp_RG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Initial RG2 storage proportion in the reservoir", unit="-", defaultValue="0.25")
    public Attribute.Double res_init_porp_RG2;

    public void init() {
        Attribute.EntityCollection PBOPS = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        PBOPS.setEntities(J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.LamelleName.getValue()), this.getModel()));
        HashMap<Double, Attribute.Entity> PBOPSMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity PBOP : PBOPS.getEntities()) {
            PBOPSMap.put(PBOP.getDouble("Pool"), PBOP);
        }
        Iterator reachIterator = this.reaches.getEntities().iterator();
        int nrPools = 0;
        while (reachIterator.hasNext()) {
            Attribute.Entity e = (Attribute.Entity)reachIterator.next();
            if (e.getDouble("ID") != this.RID.getValue()) continue;
            nrPools = PBOPSMap.size();
            int i = 0;
            while (i < nrPools) {
                Attribute.Entity PBOP;
                double j = ++i;
                PBOP = (Attribute.Entity)PBOPSMap.get(j);
                Object[] attrs = PBOP.getKeys();
                for (int k = 0; k < attrs.length; ++k) {
                    Object o = PBOP.getObject((String)attrs[k]);
                    e.setObject((String)attrs[k] + i, o);
                }
                e.setObject("attributes", (Object)attrs);
                e.setInt("nrPools", nrPools);
            }
            double res_storage = this.res_init.getValue() * 1000.0;
            double propsum = this.res_init_porp_RD1.getValue() + this.res_init_porp_RD2.getValue() + this.res_init_porp_RG1.getValue() + this.res_init_porp_RG2.getValue();
            e.setDouble("res_storage", res_storage);
            e.setDouble("res_storage_RD1", res_storage * this.res_init_porp_RD1.getValue() / propsum);
            e.setDouble("res_storage_RD2", res_storage * this.res_init_porp_RD2.getValue() / propsum);
            e.setDouble("res_storage_RG1", res_storage * this.res_init_porp_RG1.getValue() / propsum);
            e.setDouble("res_storage_RG2", res_storage * this.res_init_porp_RG2.getValue() / propsum);
        }
        this.getModel().getRuntime().println("Pool-based Operating Plan parameter file for RID: " + this.RID.getValue() + " processed", 2);
    }
}

