/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.unijena.j2k.J2KFunctions;

public class MultiEntityReaderTS_old_obsolete
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU parameter file name")
    public Attribute.String hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach parameter file name")
    public Attribute.String reachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for topological linkage with receiver entities")
    public Attribute.String to_hru_FileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for weighting of receiver entity")
    public Attribute.String bfl_FileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects with their topology")
    public Attribute.EntityCollection topology;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the HRU identifiers", defaultValue="ID")
    public Attribute.String hruIDAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the reach identifiers", defaultValue="ID")
    public Attribute.String reachIDAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_poly")
    public Attribute.String hru2hruAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String hru2reachAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the reach to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String reach2reachAttribute;

    public void init() {
        this.hrus.setEntities(J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.hruFileName.getValue()), this.getModel()));
        for (Attribute.Entity e : this.hrus.getEntityArray()) {
            try {
                e.setId((long)e.getDouble(this.hruIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K HRUu parameter file (" + this.hruFileName.getValue() + ")!");
            }
        }
        this.reaches.setEntities(J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.reachFileName.getValue()), this.getModel()));
        for (Attribute.Entity e : this.reaches.getEntityArray()) {
            try {
                e.setId((long)e.getDouble(this.reachIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K Reach parameter file (" + this.reachFileName.getValue() + ")!");
            }
        }
        this.createTopology();
        this.getModel().getRuntime().println("Create ordered hru-list", 2);
        this.createOrderedList(this.hrus, this.hru2hruAttribute.getValue());
        this.getModel().getRuntime().println("HRU entities read successfully", 1);
        this.getModel().getRuntime().println("Create ordered reach-list", 2);
        this.createOrderedList(this.reaches, this.reach2reachAttribute.getValue());
        this.getModel().getRuntime().println("Reach entities read successfully", 1);
    }

    private void createTopology() {
        Attribute.Entity toReach;
        HashMap<Double, Attribute.Entity> hruMap = new HashMap<Double, Attribute.Entity>();
        HashMap<Double, Attribute.Entity> reachMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity e : this.hrus.getEntities()) {
            hruMap.put(e.getDouble(this.hruIDAttribute.getValue()), e);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            reachMap.put(e.getDouble(this.reachIDAttribute.getValue()), e);
        }
        Attribute.Entity nullEntity = this.getModel().getRuntime().getDataFactory().createEntity();
        hruMap.put(new Double(0.0), nullEntity);
        reachMap.put(new Double(0.0), nullEntity);
        for (Attribute.Entity e : this.hrus.getEntities()) {
            Attribute.Entity toPoly = (Attribute.Entity)hruMap.get(e.getDouble(this.hru2hruAttribute.getValue()));
            toReach = (Attribute.Entity)reachMap.get(e.getDouble(this.hru2reachAttribute.getValue()));
            if (toPoly == null || toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological neighbour for HRU with ID " + e.getId() + " could not be found. This may cause errors!");
            }
            e.setObject(this.hru2hruAttribute.getValue(), (Object)toPoly);
            e.setObject(this.hru2reachAttribute.getValue(), (Object)toReach);
        }
        reachMap.put(new Double(0.0), nullEntity);
        try {
            BufferedReader reader1 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.to_hru_FileName.getValue()));
            BufferedReader reader2 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.bfl_FileName.getValue()));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader1.readLine();
            }
            String t = "#";
            while (t.startsWith("#")) {
                t = reader2.readLine();
            }
            while (s != null && !s.startsWith("#")) {
                Attribute.Entity e;
                StringTokenizer tokenizer_to_hru = new StringTokenizer(s, "\t");
                double eID = Double.parseDouble(tokenizer_to_hru.nextToken());
                double eBFl = Double.parseDouble(tokenizer_to_hru.nextToken());
                String recIDs = tokenizer_to_hru.nextToken();
                e = (Attribute.Entity)hruMap.get(eID);
                e.setDouble("BFl", eBFl);
                StringTokenizer tokenizer_weights = new StringTokenizer(t, "\t");
                double eID2 = Double.parseDouble(tokenizer_weights.nextToken());
                double eBFl2 = Double.parseDouble(tokenizer_weights.nextToken());
                String recWeights = tokenizer_weights.nextToken();
                if (eID != eID2) {
                    this.getModel().getRuntime().sendHalt("One of tables topologie_to_hru or topologie_bfl is missorted");
                }
                ArrayList<Attribute.Entity> receiverHRUs = new ArrayList<Attribute.Entity>();
                ArrayList<Attribute.Entity> receiverReaches = new ArrayList<Attribute.Entity>();
                ArrayList<Double> receiverHRUsWeights = new ArrayList<Double>();
                ArrayList<Double> receiverReachesWeights = new ArrayList<Double>();
                ArrayList receiverArea = new ArrayList();
                StringTokenizer sTok = new StringTokenizer(recIDs, ",");
                StringTokenizer tTok = new StringTokenizer(recWeights, ",");
                boolean tschuessnull = false;
                double sumWeight = 1.0;
                while (sTok.hasMoreTokens() && !tschuessnull) {
                    String stringID = sTok.nextToken();
                    double doubleID = Double.parseDouble(stringID);
                    String stringWeight = tTok.nextToken();
                    double doubleWeight = Double.parseDouble(stringWeight);
                    sumWeight = Math.round((sumWeight - doubleWeight) * 10000.0) / 10000L;
                    if (doubleID == 0.0 && doubleWeight != 0.0 || doubleID != 0.0 && doubleWeight == 0.0) {
                        this.getModel().getRuntime().sendHalt("No. of receivers and their weights do not match!");
                    }
                    if (doubleID > 0.0) {
                        Attribute.Entity f = (Attribute.Entity)hruMap.get(doubleID);
                        receiverHRUs.add(f);
                        receiverHRUsWeights.add(doubleWeight);
                    }
                    if (doubleID < 0.0) {
                        double reachID = doubleID * -1.0;
                        Attribute.Entity r = (Attribute.Entity)reachMap.get(reachID);
                        receiverReaches.add(r);
                        receiverReachesWeights.add(doubleWeight);
                    }
                    if (doubleID != 0.0) continue;
                    tschuessnull = true;
                }
                if ((sumWeight = Math.abs(sumWeight)) >= 0.001) {
                    System.out.println("Error in processing entity with ID " + eID);
                    this.getModel().getRuntime().sendHalt("Sum of weights is not equal 1! Process entity:" + eID);
                }
                Attribute.Entity[] to_hru_Array = receiverHRUs.toArray(new Attribute.Entity[receiverHRUs.size()]);
                Attribute.Entity[] to_reach_Array = receiverReaches.toArray(new Attribute.Entity[receiverReaches.size()]);
                Double[] to_hru_weights_Array = receiverHRUsWeights.toArray(new Double[receiverHRUsWeights.size()]);
                Double[] to_reach_weights_Array = receiverReachesWeights.toArray(new Double[receiverReachesWeights.size()]);
                Double[] to_hru_bfl_Array = receiverArea.toArray(new Double[receiverHRUsWeights.size()]);
                e.setObject("to_poly", (Object)to_hru_Array);
                e.setObject("to_reach", (Object)to_reach_Array);
                e.setObject("to_poly_weights", (Object)to_hru_weights_Array);
                e.setObject("to_reach_weights", (Object)to_reach_weights_Array);
                e.setObject("bfl", (Object)to_hru_bfl_Array);
                sumWeight = 1.0;
                s = reader1.readLine();
                t = reader2.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            toReach = (Attribute.Entity)reachMap.get(e.getDouble(this.reach2reachAttribute.getValue()));
            if (toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological neighbour for reach with ID " + e.getId() + " could not be found. This may cause errors!");
            }
            e.setObject(this.reach2reachAttribute.getValue(), (Object)toReach);
        }
    }

    protected void createOrderedList(Attribute.EntityCollection col, String asso) {
        int i;
        int i2;
        Attribute.Entity[] e_ziel_to_hru;
        Iterator entityIterator;
        Attribute.Entity e2 = null;
        ArrayList<Attribute.Entity> newList = new ArrayList<Attribute.Entity>();
        HashMap<Attribute.Entity, Integer> statusMap = new HashMap<Attribute.Entity, Integer>();
        HashMap<Attribute.Entity, Attribute.Entity> fromHruMap = new HashMap<Attribute.Entity, Attribute.Entity>();
        HashMap<Attribute.Entity, Integer> fromIMap = new HashMap<Attribute.Entity, Integer>();
        HashMap<Object, Integer> depthMap = new HashMap<Object, Integer>();
        boolean aufloesbar = false;
        boolean unaufloesbar = false;
        if (asso.toString().equals("to_poly")) {
            entityIterator = col.getEntities().iterator();
            block0: while (entityIterator.hasNext()) {
                if (!aufloesbar) {
                    e2 = (Attribute.Entity)entityIterator.next();
                }
                aufloesbar = false;
                Attribute.Entity e_ziel_neu = e2;
                for (Attribute.Entity next : col.getEntities()) {
                    statusMap.put(next, new Integer(0));
                    fromHruMap.put(next, null);
                    fromIMap.put(next, new Integer(0));
                }
                statusMap.put(e2, new Integer(1));
                while ((Integer)statusMap.get(e2) != -3) {
                    Attribute.Entity e_ziel = e_ziel_neu;
                    statusMap.put(e_ziel, new Integer(-2));
                    e_ziel_to_hru = (Attribute.Entity[])e_ziel.getObject("to_poly");
                    if (e_ziel_to_hru.length > 0) {
                        for (i2 = 0; i2 < e_ziel_to_hru.length; ++i2) {
                            if (e_ziel_to_hru[i2] == null) continue;
                            double bfl_weitergabe = 0.0;
                            Double[] e_ziel_to_hru_weights = (Double[])e_ziel.getObject("to_poly_weights");
                            bfl_weitergabe = e_ziel.getDouble("BFl") * e_ziel_to_hru_weights[i2];
                            Double[] e_ziel_to_hru_bfl = (Double[])e_ziel.getObject("bfl");
                            e_ziel_to_hru_bfl[i2] = bfl_weitergabe;
                            e_ziel.setObject("bfl", (Object)e_ziel_to_hru_bfl);
                            if (e2 == e_ziel_to_hru[i2]) {
                                Attribute.Entity eZirkel = e_ziel;
                                Attribute.Entity eBflMin = null;
                                int iZirkel = i2;
                                int iZirkelMin = -1;
                                int teilerMin = -1;
                                double bflZirkelMin = -1.0;
                                while (eZirkel != null) {
                                    Attribute.Entity[] eZirkel_to_reach = (Attribute.Entity[])eZirkel.getObject("to_reach");
                                    Attribute.Entity[] eZirkel_to_hru = (Attribute.Entity[])eZirkel.getObject("to_poly");
                                    int eZirkel_to_hru_length = 0;
                                    for (int l = 0; l < eZirkel_to_hru.length; ++l) {
                                        if (eZirkel_to_hru[l] == null) continue;
                                        ++eZirkel_to_hru_length;
                                    }
                                    if (eZirkel_to_hru_length + eZirkel_to_reach.length > 1) {
                                        Double[] eZirkel_to_hru_bfl = (Double[])eZirkel.getObject("bfl");
                                        double bflZirkel = eZirkel_to_hru_bfl[iZirkel];
                                        if (bflZirkelMin == -1.0 || bflZirkel < bflZirkelMin) {
                                            aufloesbar = true;
                                            bflZirkelMin = bflZirkel;
                                            eBflMin = eZirkel;
                                            iZirkelMin = iZirkel;
                                            teilerMin = eZirkel_to_hru_length;
                                        }
                                    }
                                    iZirkel = (Integer)fromIMap.get(eZirkel);
                                    eZirkel = (Attribute.Entity)fromHruMap.get(eZirkel);
                                }
                                if (eBflMin != null && iZirkelMin != -1 && teilerMin != -1) {
                                    Attribute.Entity[] eBflMin_to_reach = (Attribute.Entity[])eBflMin.getObject("to_reach");
                                    Attribute.Entity[] eBflMin_to_hru = (Attribute.Entity[])eBflMin.getObject("to_poly");
                                    Double[] eBflMin_to_reach_weights = (Double[])eBflMin.getObject("to_reach_weights");
                                    Double[] eBflMin_to_hru_weights = (Double[])eBflMin.getObject("to_poly_weights");
                                    double eBflMin_to_hruId = eBflMin_to_hru[iZirkelMin].getDouble("ID");
                                    if (eBflMin_to_reach.length > 0) {
                                        double eBflMin_to_reachId = eBflMin_to_reach[0].getDouble("ID");
                                        eBflMin_to_reach_weights[0] = eBflMin_to_reach_weights[0] + eBflMin_to_hru_weights[iZirkelMin];
                                        eBflMin.setObject("to_reach_weights", (Object)eBflMin_to_reach_weights);
                                        System.out.println("HRU " + eBflMin.getDouble("ID") + ": Unterbrechung der Fliessbeziehung zu HRU " + eBflMin_to_hruId + ". Umleitung in das Fliessgewaessersegment -" + eBflMin_to_reachId + "; Beitragende Flaeche: " + (double)Math.round(eBflMin.getDouble("BFl") * eBflMin_to_hru_weights[iZirkelMin] / 1000.0) / 1000.0 + " qkm");
                                    } else {
                                        for (int s = 0; s < eBflMin_to_hru.length; ++s) {
                                            if (eBflMin_to_hru[s] == null || s == iZirkelMin) continue;
                                            eBflMin_to_hru_weights[s] = eBflMin_to_hru_weights[s] + eBflMin_to_hru_weights[iZirkelMin] / (double)(teilerMin - 1);
                                        }
                                        System.out.println("HRU " + eBflMin.getDouble("ID") + ": Unterbrechung der Fliessbeziehung zu HRU " + eBflMin_to_hruId + ". Verteilung des Wassers auf alle anderen Fliessbeziehungen der HRU; Beitragende Flaeche: " + (double)Math.round(eBflMin.getDouble("BFl") * eBflMin_to_hru_weights[iZirkelMin] / 1000.0) / 1000.0 + " qkm");
                                    }
                                    eBflMin_to_hru[iZirkelMin] = null;
                                    eBflMin.setObject("to_poly", (Object)eBflMin_to_hru);
                                    eBflMin_to_hru_weights[iZirkelMin] = null;
                                    eBflMin.setObject("to_poly_weights", (Object)eBflMin_to_hru_weights);
                                    continue block0;
                                }
                                unaufloesbar = true;
                                System.out.println("Nicht aufloesbarer Zirkel! Fliessbeziehung von HRU " + e_ziel.getDouble("ID") + " zu HRU " + e_ziel_to_hru[i2].getDouble("ID") + " kann nicht unterbrochen werden.");
                                continue block0;
                            }
                            if ((Integer)statusMap.get(e_ziel_to_hru[i2]) != 0) continue;
                            statusMap.put(e_ziel_to_hru[i2], new Integer(1));
                            fromHruMap.put(e_ziel_to_hru[i2], e_ziel);
                            fromIMap.put(e_ziel_to_hru[i2], new Integer(i2));
                        }
                        for (i2 = 0; i2 < e_ziel_to_hru.length; ++i2) {
                            if (statusMap.get(e_ziel_to_hru[i2]) == null || (Integer)statusMap.get(e_ziel_to_hru[i2]) != 1) continue;
                            e_ziel_neu = e_ziel_to_hru[i2];
                        }
                    }
                    int anzahl = 0;
                    for (int i3 = 0; i3 < e_ziel_to_hru.length; ++i3) {
                        if (statusMap.get(e_ziel_to_hru[i3]) == null || (Integer)statusMap.get(e_ziel_to_hru[i3]) < 0) continue;
                        ++anzahl;
                    }
                    if (anzahl != 0) continue;
                    statusMap.put(e_ziel, new Integer(-3));
                    e_ziel_neu = (Attribute.Entity)fromHruMap.get(e_ziel);
                }
            }
            if (unaufloesbar) {
                this.getModel().getRuntime().sendHalt("Nicht aufloesbare Zirkel in HRU-Muster");
            }
        }
        boolean mapChanged = true;
        entityIterator = col.getEntities().iterator();
        while (entityIterator.hasNext()) {
            depthMap.put(entityIterator.next(), new Integer(0));
        }
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e2 : col.getEntities()) {
                Integer fDepth;
                Integer eDepth = (Integer)depthMap.get(e2);
                if (asso.toString().equals("to_poly") && (e_ziel_to_hru = (Attribute.Entity[])e2.getObject(asso)).length > 0) {
                    for (i2 = 0; i2 < e_ziel_to_hru.length; ++i2) {
                        if (e_ziel_to_hru[i2] == null || (fDepth = (Integer)depthMap.get(e_ziel_to_hru[i2])) > eDepth) continue;
                        depthMap.put(e_ziel_to_hru[i2], new Integer(eDepth + 1));
                        mapChanged = true;
                    }
                }
                if (!asso.toString().equals("to_reach")) continue;
                Attribute.Entity eff = (Attribute.Entity)e2.getObject(asso);
                if (eff.isEmpty()) {
                    eff = null;
                }
                if (eff == null || (fDepth = (Integer)depthMap.get(eff)) > eDepth) continue;
                depthMap.put(eff, new Integer(eDepth + 1));
                mapChanged = true;
            }
        }
        int maxDepth = 0;
        for (Attribute.Entity e2 : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e2));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e2 : col.getEntities()) {
            int depth = (Integer)depthMap.get(e2);
            ((ArrayList)alList.get(depth)).add(e2);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity e2 : (ArrayList)alList.get(i)) {
                newList.add(e2);
            }
        }
        col.setEntities(newList);
    }
}

