/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.unijena.j2k.J2KFunctions;

public class MultiEntityReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU parameter file name")
    public Attribute.String hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach parameter file name")
    public Attribute.String reachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for topological linkage with receiver entities")
    public Attribute.String to_hru_FileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter file name for weighting of receiver entity")
    public Attribute.String bfl_FileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects with their topology")
    public Attribute.EntityCollection topology;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the HRU identifiers", defaultValue="ID")
    public Attribute.String hruIDAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the reach identifiers", defaultValue="ID")
    public Attribute.String reachIDAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_poly")
    public Attribute.String hru2hruAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_poly_weights")
    public Attribute.String hru2hruWeightAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String hru2reachAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_reach_weights")
    public Attribute.String hru2reachWeightAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the reach to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String reach2reachAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="bfl")
    public Attribute.String bflAttribute;

    public void init() {
        ArrayList<Attribute.Entity> hruCollection = J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.hruFileName.getValue()), this.getModel());
        for (Attribute.Entity e : hruCollection) {
            try {
                e.setId((long)e.getDouble(this.hruIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K HRUu parameter file (" + this.hruFileName.getValue() + ")!");
            }
        }
        this.hrus.setEntities(hruCollection);
        ArrayList<Attribute.Entity> reachCollection = J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.reachFileName.getValue()), this.getModel());
        for (Attribute.Entity e : reachCollection) {
            try {
                e.setId((long)e.getDouble(this.reachIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K Reach parameter file (" + this.reachFileName.getValue() + ")!");
            }
        }
        this.reaches.setEntities(reachCollection);
        this.createTopology();
        this.getModel().getRuntime().println("Create ordered hru-list", 2);
        this.createOrderedList(this.hrus, this.hru2hruAttribute.getValue());
        this.getModel().getRuntime().println("HRU entities read successfully", 1);
        this.getModel().getRuntime().println("Create ordered reach-list", 2);
        this.createOrderedList(this.reaches, this.reach2reachAttribute.getValue());
        this.getModel().getRuntime().println("Reach entities read successfully", 1);
    }

    protected void createTopology() {
        TreeMap<Double, Attribute.Entity> hruMap = new TreeMap<Double, Attribute.Entity>();
        TreeMap<Double, Attribute.Entity> reachMap = new TreeMap<Double, Attribute.Entity>();
        for (Attribute.Entity e : this.hrus.getEntities()) {
            hruMap.put(e.getDouble(this.hruIDAttribute.getValue()), e);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            reachMap.put(e.getDouble(this.reachIDAttribute.getValue()), e);
        }
        Attribute.Entity nullEntity = this.getModel().getRuntime().getDataFactory().createEntity();
        hruMap.put(new Double(0.0), nullEntity);
        reachMap.put(new Double(0.0), nullEntity);
        for (Attribute.Entity e : this.hrus.getEntities()) {
            e.setObject(this.hru2hruAttribute.getValue(), (Object)new Attribute.Entity[0]);
            e.setObject(this.hru2hruWeightAttribute.getValue(), (Object)new Double[0]);
            e.setObject(this.hru2reachWeightAttribute.getValue(), (Object)new Double[0]);
            e.setObject(this.hru2reachAttribute.getValue(), (Object)new Attribute.Entity[0]);
        }
        try {
            BufferedReader reader1 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.to_hru_FileName.getValue()));
            BufferedReader reader2 = new BufferedReader(new FileReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.bfl_FileName.getValue()));
            String toHRUsLine = "#";
            String toHRUsWeightsLine = "#";
            while (toHRUsLine != null && toHRUsLine.startsWith("#")) {
                toHRUsLine = reader1.readLine();
            }
            while (toHRUsWeightsLine != null && toHRUsWeightsLine.startsWith("#")) {
                toHRUsWeightsLine = reader2.readLine();
            }
            while (toHRUsLine != null && !toHRUsLine.startsWith("#") && toHRUsWeightsLine != null) {
                Attribute.Entity e;
                String[] toHRUsSplitArray = toHRUsLine.split("\t");
                String[] toHRUsWeightsSplitArray = toHRUsWeightsLine.split("\t");
                double HRUsID = Double.parseDouble(toHRUsSplitArray[0]);
                double HRUsBFl = Double.parseDouble(toHRUsSplitArray[1]);
                String toHRUsString = toHRUsSplitArray[3];
                e = (Attribute.Entity)hruMap.get(HRUsID);
                if (e == null) {
                    this.getModel().getRuntime().sendHalt("missing HRU with ID = " + HRUsID);
                }
                e.setDouble("BFLDouble", HRUsBFl);
                double HRUsID2 = Double.parseDouble(toHRUsWeightsSplitArray[0]);
                String toHRUsWeightsString = toHRUsWeightsSplitArray[2];
                if (HRUsID != HRUsID2) {
                    this.getModel().getRuntime().sendHalt("One of tables topologie_to_hru or topologie_bfl is missorted");
                }
                ArrayList<Attribute.Entity> toHRUsArrayList = new ArrayList<Attribute.Entity>();
                ArrayList<Attribute.Entity> toReachesArrayList = new ArrayList<Attribute.Entity>();
                ArrayList<Double> toHRUsWeightsArrayList = new ArrayList<Double>();
                ArrayList<Double> toReachesWeightsArrayList = new ArrayList<Double>();
                ArrayList toHRUsBFlArrayList = new ArrayList();
                StringTokenizer toHRUsToken = new StringTokenizer(toHRUsString, ",");
                StringTokenizer toHRUsWeightsToken = new StringTokenizer(toHRUsWeightsString, ",");
                double sumWeights = 1.0;
                while (toHRUsToken.hasMoreTokens()) {
                    double toHRUsID = 0.0;
                    double toHRUsWeight = 0.0;
                    try {
                        toHRUsID = Double.parseDouble(toHRUsToken.nextToken());
                    }
                    catch (NoSuchElementException nsee) {
                        nsee.printStackTrace();
                        System.out.println("Not enough tokens in line:" + toHRUsLine);
                    }
                    try {
                        toHRUsWeight = Double.parseDouble(toHRUsWeightsToken.nextToken());
                    }
                    catch (NoSuchElementException nsee) {
                        nsee.printStackTrace();
                        System.out.println("Not enough tokens in line:" + toHRUsWeightsLine);
                    }
                    sumWeights -= toHRUsWeight;
                    if (toHRUsID == 0.0 && toHRUsWeight != 0.0 || toHRUsID != 0.0 && toHRUsWeight == 0.0) {
                        this.getModel().getRuntime().sendHalt("Fehler bei HRU " + HRUsID + ". Anzahl der Empfaenger-HRUs und der Wichtungen stimmen nicht ueberein.");
                    }
                    if (toHRUsID > 0.0) {
                        Attribute.Entity zielHRU = (Attribute.Entity)hruMap.get(toHRUsID);
                        toHRUsArrayList.add(zielHRU);
                        toHRUsWeightsArrayList.add(toHRUsWeight);
                    }
                    if (toHRUsID < 0.0) {
                        double toReachesID = toHRUsID * -1.0;
                        Attribute.Entity zielReach = (Attribute.Entity)reachMap.get(toReachesID);
                        toReachesArrayList.add(zielReach);
                        toReachesWeightsArrayList.add(toHRUsWeight);
                    }
                    if (toHRUsID != 0.0) continue;
                    break;
                }
                if (Math.abs(sumWeights) > 0.03) {
                    this.getModel().getRuntime().sendHalt("Fehler bei HRU " + HRUsID + ". Summe der einzelnen Gewichte ungleich 1");
                }
                Attribute.Entity[] toHRUsArray = toHRUsArrayList.toArray(new Attribute.Entity[toHRUsArrayList.size()]);
                Attribute.Entity[] toReachesArray = toReachesArrayList.toArray(new Attribute.Entity[toReachesArrayList.size()]);
                Double[] toHRUsWeightsArray = toHRUsWeightsArrayList.toArray(new Double[toHRUsWeightsArrayList.size()]);
                Double[] toReachesWeightsArray = toReachesWeightsArrayList.toArray(new Double[toReachesWeightsArrayList.size()]);
                Double[] toHRUsBflArray = toHRUsBFlArrayList.toArray(new Double[toHRUsWeightsArrayList.size()]);
                e.setObject(this.hru2hruAttribute.getValue(), (Object)toHRUsArray);
                e.setObject(this.hru2reachAttribute.getValue(), (Object)toReachesArray);
                e.setObject(this.hru2hruWeightAttribute.getValue(), (Object)toHRUsWeightsArray);
                e.setObject(this.hru2reachWeightAttribute.getValue(), (Object)toReachesWeightsArray);
                e.setObject(this.bflAttribute.getValue(), (Object)toHRUsBflArray);
                toHRUsLine = reader1.readLine();
                toHRUsWeightsLine = reader2.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            Attribute.Entity toReach = (Attribute.Entity)reachMap.get(e.getDouble(this.reach2reachAttribute.getValue()));
            if (toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological neighbour for reach with ID " + e.getId() + " could not be found. This may cause errors!");
            }
            e.setObject(this.reach2reachAttribute.getValue(), (Object)toReach);
        }
        this.cycleCheck();
    }

    protected boolean cycleCheck(Attribute.Entity node, Stack<Attribute.Entity> searchStack, HashSet<Attribute.Double> closedList, HashSet<Attribute.Double> visitedList) {
        if (searchStack.indexOf(node) != -1) {
            int index = searchStack.indexOf(node);
            String cyc_output = new String();
            for (int i = index; i < searchStack.size(); ++i) {
                cyc_output = cyc_output + ((Attribute.Entity)searchStack.get(i)).getDouble("ID") + " ";
                closedList.add((Attribute.Double)((Attribute.Entity)searchStack.get(i)).getObject("ID"));
            }
            this.getModel().getRuntime().println("Found circle with ids:" + cyc_output);
            return true;
        }
        this.getModel().getRuntime().println("ID " + node.getObject("ID"));
        if (closedList.contains(node.getObject("ID"))) {
            return false;
        }
        visitedList.add((Attribute.Double)node.getObject("ID"));
        if (node.getObject("to_poly") instanceof Attribute.Entity) {
            return false;
        }
        Attribute.Entity[] child_node = (Attribute.Entity[])node.getObject("to_poly");
        boolean result = false;
        searchStack.push(node);
        for (int i = 0; i < child_node.length; ++i) {
            result = this.cycleCheck(child_node[i], searchStack, closedList, visitedList);
        }
        searchStack.pop();
        return result;
    }

    protected boolean cycleCheck() {
        HashSet<Attribute.Double> closedList = new HashSet<Attribute.Double>();
        HashSet<Attribute.Double> visitedList = new HashSet<Attribute.Double>();
        this.getModel().getRuntime().println("Cycle checking...");
        Iterator hruIterator = this.hrus.getEntities().iterator();
        boolean result = false;
        while (hruIterator.hasNext()) {
            Attribute.Entity start_node = (Attribute.Entity)hruIterator.next();
            if (closedList.contains(start_node.getObject("ID"))) continue;
            if (this.cycleCheck(start_node, new Stack<Attribute.Entity>(), closedList, visitedList)) {
                result = true;
            }
            closedList.addAll(visitedList);
            visitedList.clear();
        }
        return result;
    }

    protected void createOrderedList(Attribute.EntityCollection col, String asso) {
        int i;
        Attribute.Entity e2 = null;
        ArrayList<Attribute.Entity> newList = new ArrayList<Attribute.Entity>();
        HashMap<Attribute.Entity, Integer> depthMap = new HashMap<Attribute.Entity, Integer>();
        boolean mapChanged = true;
        for (Attribute.Entity entity : col.getEntities()) {
            depthMap.put(entity, 0);
        }
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e2 : col.getEntities()) {
                Integer fDepth;
                Attribute.Entity[] e_ziel_to_hru;
                Integer eDepth = (Integer)depthMap.get(e2);
                if (asso.toString().equals("to_poly") && (e_ziel_to_hru = (Attribute.Entity[])e2.getObject(asso)).length > 0) {
                    for (int i2 = 0; i2 < e_ziel_to_hru.length; ++i2) {
                        if (e_ziel_to_hru[i2] == null || (fDepth = (Integer)depthMap.get(e_ziel_to_hru[i2])) > eDepth) continue;
                        depthMap.put(e_ziel_to_hru[i2], new Integer(eDepth + 1));
                        mapChanged = true;
                    }
                }
                if (!asso.toString().equals("to_reach")) continue;
                Attribute.Entity eff = (Attribute.Entity)e2.getObject(asso);
                if (eff.isEmpty()) {
                    eff = null;
                }
                if (eff == null || (fDepth = (Integer)depthMap.get(eff)) > eDepth) continue;
                depthMap.put(eff, new Integer(eDepth + 1));
                mapChanged = true;
            }
        }
        int maxDepth = 0;
        for (Attribute.Entity e2 : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e2));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e2 : col.getEntities()) {
            int depth = (Integer)depthMap.get(e2);
            ((ArrayList)alList.get(depth)).add(e2);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity e2 : (ArrayList)alList.get(i)) {
                newList.add(e2);
            }
        }
        col.setEntities(newList);
    }
}

