/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.JAMSTools;
import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;

public class LayeredSoilParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Soil types parameter file name")
    public Attribute.String stFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;

    public void init() {
        Attribute.EntityCollection soilTypes = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        soilTypes.setEntities(J2KFunctions.readParas(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.stFileName.getValue()), this.getModel()));
        HashMap<Double, Attribute.Entity> stMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity st : soilTypes.getEntities()) {
            stMap.put(st.getDouble("SID"), st);
        }
        for (Attribute.Entity e : this.hrus.getEntities()) {
            e.setDouble("depth", 100.0);
            double hruSID = e.getDouble("soilID") * 100.0 + 1.0;
            int horizon = 0;
            while (stMap.containsKey(hruSID)) {
                Attribute.Entity st;
                Double hSID = new Double("" + hruSID);
                st = (Attribute.Entity)stMap.get(hSID);
                e.setObject("soilHorizon", (Object)st);
                Object[] attrs = st.getKeys();
                for (int i = 0; i < attrs.length; ++i) {
                    Object o = st.getObject((String)attrs[i]);
                    if (o instanceof Attribute.String) continue;
                    e.setObject((String)attrs[i] + "_h" + horizon, o);
                }
                hruSID += 1.0;
                ++horizon;
            }
            e.setDouble("horizons", (double)horizon);
        }
        this.getModel().getRuntime().println("Layered soil parameter file processed ...");
    }
}

