/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import jams.tools.JAMSTools;

public class FullSetEntityWriter_1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EntitySet")
    public Attribute.EntityCollection entitySet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.String header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attribute names")
    public Attribute.String attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity attribute name for weight [attName | none]")
    public Attribute.String weight;
    private GenericDataWriter writer;
    private String[] attrs;
    private boolean headerWritten;
    int nEnts = 0;
    int tsteps = 0;
    double[][] valArray;
    int tcounter = 0;
    String[] dateStr;

    public void init() {
        this.writer = new GenericDataWriter(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.fileName.getValue()));
        this.writer.addComment("J2K model output" + this.header.getValue());
        this.writer.addComment("");
        this.nEnts = this.entitySet.getEntityArray().length;
        this.tsteps = (int)this.timeInterval.getNumberOfTimesteps();
        this.valArray = new double[this.nEnts][this.tsteps];
        this.dateStr = new String[this.tsteps];
    }

    public void run() {
        this.dateStr[this.tcounter] = this.time.toString();
        this.entitySet.getEntityEnumerator().reset();
        int setCounter = 0;
        int entCounter = 0;
        boolean cont = true;
        while (cont) {
            double val;
            Object ob;
            double weightVal = 1.0;
            if (!this.weight.getValue().equals("none")) {
                weightVal = ((Attribute.Double)this.entitySet.getCurrent().getObject(this.weight.getValue())).getValue();
            }
            if ((ob = this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getClass().getName().contains("DoubleArray")) {
                double[] da = ((Attribute.DoubleArray)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue();
                for (int i = 0; i < da.length; ++i) {
                    this.valArray[entCounter][this.tcounter] = val = da[i] / weightVal;
                }
            } else {
                double da = ((Attribute.Double)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue();
                this.valArray[entCounter][this.tcounter] = val = da / weightVal;
            }
            if (setCounter < this.nEnts - 1) {
                ++setCounter;
            }
            if (this.entitySet.getEntityEnumerator().hasNext() && setCounter < this.nEnts) {
                this.entitySet.getEntityEnumerator().next();
                cont = true;
                ++entCounter;
                continue;
            }
            cont = false;
        }
        ++this.tcounter;
    }

    public void cleanup() {
        try {
            this.writer.addColumn("ID");
            for (int i = 0; i < this.tcounter; ++i) {
                this.writer.addColumn(this.dateStr[i]);
            }
            this.writer.writeHeader();
            for (int e = 0; e < this.nEnts; ++e) {
                this.writer.addData((Object)this.entitySet.getEntityArray()[e].getDouble("ID"));
                for (int t = 0; t < this.tcounter; ++t) {
                    this.writer.addData((Object)this.valArray[e][t]);
                }
                this.writer.writeData();
            }
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Throwable)jre);
        }
        this.writer.flush();
        this.writer.close();
    }
}

