/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.groundwater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Groundwater_uptake", author="Manfred Fink", description="Calculation of a withdraw of water in a storage variable according to a reduction factor")
public class Groundwater_uptake
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Storage filling of HRU", unit="L")
    public Attribute.Double HRU_storage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Factor reducing storage (smaller then one)")
    public Attribute.Double Reduction_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Sum of the water taken from storage", unit="L")
    public Attribute.Double control_amount_sum;

    public void init() {
        this.control_amount_sum.setValue(0.0);
        this.Reduction_factor.setValue(1.0);
    }

    public void run() {
        double run_storage = this.HRU_storage.getValue();
        if (this.Reduction_factor.getValue() >= 0.0 && this.Reduction_factor.getValue() <= 1.0) {
            run_storage *= this.Reduction_factor.getValue();
        } else {
            System.out.println("reduction Factor out of range (0-1) " + this.Reduction_factor.getValue());
        }
        this.control_amount_sum.setValue(this.control_amount_sum.getValue() + (this.HRU_storage.getValue() - run_storage));
        this.HRU_storage.setValue(run_storage);
    }

    public void cleanup() {
    }
}

