/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.Component;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import java.util.Random;
import java.util.StringTokenizer;

@JAMSComponentDescription(title="Regular2dParameterSampler", author="Peter Krause", description="Samples one parameter over its range in a regular way")
public class Regular1DSampler
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter identifiers to be sampled")
    public Attribute.String parameterID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Parameter value bounaries corresponding to parameter identifiers")
    public Attribute.String boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="resolution")
    public Attribute.Integer resolution;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="efficiency methods")
    public Attribute.String effMethodNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="efficiency values")
    public Attribute.Double[] effValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Flag for enabling this sampler")
    public Attribute.Boolean enable;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String paraFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String attribFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The model time interval")
    public Attribute.TimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.String attribHeader;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Output file attribute")
    public Attribute.DoubleArray targetValue;
    Attribute.Double parameter;
    String parameterName;
    double lowBound;
    double upBound;
    int currentCount;
    Random generator;
    GenericDataWriter paraWriter;
    GenericDataWriter attribWriter;
    double[][] valueArray;
    int timeStepCounter = 0;
    int runCounter = 0;
    int timeSteps = 0;
    double stepSize;
    int currentStep = 0;
    int sampleCount = 0;

    private boolean hasNext() {
        int sampleCount = this.resolution.getValue();
        return this.currentCount < sampleCount;
    }

    public void init() {
        if (this.enable.getValue()) {
            this.parameterName = this.parameterID.getValue();
            this.parameter = (Attribute.Double)this.getModel().getRuntime().getDataHandles().get(this.parameterName);
            String key = this.boundaries.getValue().substring(1, this.boundaries.getValue().length() - 1);
            StringTokenizer boundTok = new StringTokenizer(key, ">");
            this.lowBound = Double.parseDouble(boundTok.nextToken());
            this.upBound = Double.parseDouble(boundTok.nextToken());
            if (this.upBound <= this.lowBound) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
            }
            int i = 0;
            StringTokenizer tok = new StringTokenizer(this.effMethodNames.getValue(), ";");
            String[] effNames = new String[tok.countTokens()];
            i = 0;
            while (tok.hasMoreTokens()) {
                effNames[i] = key = tok.nextToken();
                ++i;
            }
            this.paraWriter = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.paraFileName.getValue());
            this.paraWriter.addColumn("Run");
            this.paraWriter.addColumn(this.parameterName);
            for (int e = 0; e < effNames.length; ++e) {
                this.paraWriter.addColumn(effNames[e]);
            }
            this.paraWriter.writeHeader();
            this.attribWriter = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.attribFileName.getValue());
            this.attribWriter.addComment("J2K model output");
            this.attribWriter.addComment("");
            this.attribWriter.addColumn("date/time");
            this.sampleCount = this.resolution.getValue();
            for (int s = 0; s < this.sampleCount; ++s) {
                int counter = s + 1;
                this.attribWriter.addColumn(this.attribHeader.getValue() + "_run_" + counter);
            }
            this.attribWriter.writeHeader();
            this.timeSteps = (int)this.modelTimeInterval.getNumberOfTimesteps();
            this.valueArray = new double[this.sampleCount][this.timeSteps];
            this.timeStepCounter = 0;
            this.runCounter = 0;
            this.stepSize = (this.upBound - this.lowBound) / (double)(this.resolution.getValue() - 1);
            this.parameter.setValue(this.lowBound);
            this.currentStep = 0;
        }
    }

    private void updateValues() {
        int sampleCount = this.resolution.getValue();
        int count = this.currentCount + 1;
        this.getModel().getRuntime().println("Run No. " + count + " of " + sampleCount);
        if (this.currentCount > 0 && this.currentStep < this.resolution.getValue()) {
            this.parameter.setValue(this.parameter.getValue() + this.stepSize);
        }
        this.getModel().getRuntime().println("Para: " + this.parameterName + " = " + this.parameter);
        ++this.currentCount;
        ++this.currentStep;
    }

    private void resetValues() {
        this.parameter.setValue(this.lowBound);
        this.currentCount = 0;
    }

    private void singleRun() {
        Component comp;
        System.gc();
        long start = System.currentTimeMillis();
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.initAll();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception exception) {}
        }
        long end = System.currentTimeMillis();
        this.getModel().getRuntime().println("Exec time: " + (end - start) + " ms", 1);
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        if (!this.enable.getValue()) {
            this.singleRun();
        } else {
            this.resetValues();
            while (this.hasNext()) {
                this.updateValues();
                this.singleRun();
                this.paraWriter.addData((Object)this.currentCount);
                this.paraWriter.addData((Object)this.parameter.getValue());
                for (int e = 0; e < this.effValues.length; ++e) {
                    this.paraWriter.addData((Object)this.effValues[e].getValue());
                }
                try {
                    this.paraWriter.writeData();
                    this.paraWriter.flush();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                this.valueArray[this.runCounter] = this.targetValue.getValue();
                ++this.runCounter;
            }
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext() && this.doRun) {
                Component component = this.runEnumerator.next();
            }
        }
    }

    public void initAll() {
    }

    public void cleanupAll() {
    }

    public long getNumberOfIterations() {
        return 1L;
    }

    public long getRunCount() {
        return this.runCounter;
    }

    public void cleanup() {
        if (this.enable.getValue()) {
            int sampleCount = this.resolution.getValue();
            Attribute.Calendar timeStamp = this.modelTimeInterval.getStart();
            for (int t = 0; t <= this.timeSteps; ++t) {
                this.attribWriter.addData((Object)timeStamp.toString());
                timeStamp.add(this.modelTimeInterval.getTimeUnit(), 1);
                for (int r = 0; r < sampleCount; ++r) {
                    this.attribWriter.addData((Object)this.valueArray[r][t]);
                }
                try {
                    this.attribWriter.writeData();
                    continue;
                }
                catch (RuntimeException jre) {
                    this.getModel().getRuntime().println(jre.getMessage());
                }
            }
            this.attribWriter.close();
            this.paraWriter.close();
        }
    }
}

