/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.util.Random;

@JAMSComponentDescription(title="InputErrorEstimation", author="Peter Krause", description="Adds a stochastic error to input data")
public class InputErrorEstimation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="original data")
    public Attribute.DoubleArray inData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the biased data")
    public Attribute.DoubleArray outData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum relative error")
    public Attribute.Double maxRelError;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="true for relativ error and false for absolute error", defaultValue="0")
    public Attribute.Boolean relativeOrAbsolute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="sign (0 = +/-; 1 = +; -1 = -)", defaultValue="0")
    public Attribute.Double sign;
    Random generator = new Random();

    public void run() {
        boolean pos = true;
        if (this.sign.getValue() == 0.0) {
            pos = this.generator.nextBoolean();
        } else if (this.sign.getValue() == 1.0) {
            pos = true;
        } else if (this.sign.getValue() == -1.0) {
            pos = false;
        }
        double[] inDat = this.inData.getValue();
        double[] outDat = new double[inDat.length];
        for (int i = 0; i < inDat.length; ++i) {
            double error = this.generator.nextDouble();
            error *= this.maxRelError.getValue();
            if (!pos) {
                error *= -1.0;
            }
            if (inDat[i] != JAMS.getMissingDataValue()) {
                outDat[i] = inDat[i] + inDat[i] * error;
                if (this.relativeOrAbsolute.getValue()) {
                    outDat[i] = inDat[i] + inDat[i] * error;
                    continue;
                }
                outDat[i] = inDat[i] + error;
                continue;
            }
            outDat[i] = inDat[i];
        }
        this.outData.setValue(outDat);
    }
}

