/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import java.util.Formatter;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.proj4.MapMath;

public class PolyconicProjection
extends ProjectionImpl {
    private double ml0;
    private double[] en;
    private static final double TOL = 1.0E-10;
    private static final double CONV = 1.0E-10;
    private static final int N_ITER = 10;
    private static final int I_ITER = 20;
    private static final double ITOL = 1.0E-12;
    private boolean spherical = true;
    private double projectionLatitude;
    private double projectionLongitude;
    private Earth ellipsoid;
    private double es;
    private double falseEasting;
    private double falseNorthing;
    private double totalScale;
    private double _lat0;
    private double _lon0;

    public PolyconicProjection() {
        this(23.56, 76.54);
    }

    public PolyconicProjection(double lat0, double lon0) {
        this(lat0, lon0, new Earth());
    }

    public PolyconicProjection(double lat0, double lon0, Earth ellipsoid) {
        this(lat0, lon0, 0.0, 0.0, ellipsoid);
    }

    public PolyconicProjection(double lat0, double lon0, double falseEasting, double falseNorthing, Earth ellipsoid) {
        super("Polyconic", false);
        this._lat0 = lat0;
        this._lon0 = lon0;
        this.projectionLatitude = Math.toRadians(lat0);
        this.projectionLongitude = Math.toRadians(lon0);
        this.ellipsoid = ellipsoid;
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.es = this.ellipsoid.getEccentricitySquared();
        this.totalScale = this.ellipsoid.getMajor() * 0.001;
        this.initialize();
        this.addParameter("grid_mapping_name", this.name);
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_central_meridian", lon0);
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            this.addParameter("false_easting", falseEasting);
            this.addParameter("false_northing", falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", ellipsoid.getMajor());
        this.addParameter("inverse_flattening", 1.0 / ellipsoid.getFlattening());
    }

    private ProjectionPoint project(double lplam, double lpphi) {
        double d;
        if (this.spherical) {
            if (Math.abs(lpphi) <= 1.0E-10) {
                return ProjectionPoint.create(lplam, this.ml0);
            }
            double cot = 1.0 / Math.tan(lpphi);
            double E = lplam * Math.sin(lpphi);
            double x = Math.sin(E) * cot;
            double y = lpphi - this.projectionLatitude + cot * (1.0 - Math.cos(E));
            return ProjectionPoint.create(x, y);
        }
        if (Math.abs(lpphi) <= 1.0E-10) {
            return ProjectionPoint.create(lplam, -this.ml0);
        }
        double sp = Math.sin(lpphi);
        double cp = Math.cos(lpphi);
        double ms = Math.abs(d) > 1.0E-10 ? MapMath.msfn(sp, cp, this.es) / sp : 0.0;
        double x = ms * Math.sin(lplam *= sp);
        double y = MapMath.mlfn(lpphi, sp, cp, this.en) - this.ml0 + ms * (1.0 - Math.cos(lplam));
        return ProjectionPoint.create(x, y);
    }

    private ProjectionPoint projectInverse(double xyx, double xyy, ProjectionPointImpl out) {
        if (this.spherical) {
            double d;
            xyy = this.projectionLatitude + xyy;
            if (Math.abs(d) <= 1.0E-10) {
                out.setLocation(xyx, 0.0);
            } else {
                double dphi;
                double lpphi = xyy;
                double B = xyx * xyx + xyy * xyy;
                int i = 10;
                do {
                    double tp = Math.tan(lpphi);
                    dphi = (xyy * (lpphi * tp + 1.0) - lpphi - 0.5 * (lpphi * lpphi + B) * tp) / ((lpphi - xyy) / tp - 1.0);
                    lpphi -= dphi;
                } while (Math.abs(dphi) > 1.0E-10 && --i > 0);
                if (i == 0) {
                    out.setLocation(Double.NaN, Double.NaN);
                }
                double x = Math.asin(xyx * Math.tan(lpphi)) / Math.sin(lpphi);
                double y = lpphi;
                out.setLocation(x, y);
            }
        } else if (Math.abs(xyy += this.ml0) <= 1.0E-10) {
            out.setLocation(xyx, 0.0);
        } else {
            double c;
            int i;
            double r = xyy * xyy + xyx * xyx;
            double lpphi = xyy;
            for (i = 20; i > 0; --i) {
                double sp = Math.sin(lpphi);
                double cp = Math.cos(lpphi);
                double s2ph = sp * cp;
                if (Math.abs(cp) < 1.0E-12) {
                    throw new RuntimeException("I");
                }
                double mlp = Math.sqrt(1.0 - this.es * sp * sp);
                c = sp * mlp / cp;
                double ml = MapMath.mlfn(lpphi, sp, cp, this.en);
                double mlb = ml * ml + r;
                mlp = 1.0 / this.es / (mlp * mlp * mlp);
                double dPhi = (ml + ml + c * mlb - 2.0 * xyy * (c * ml + 1.0)) / (this.es * s2ph * (mlb - 2.0 * xyy * ml) / c + 2.0 * (xyy - ml) * (c * mlp - 1.0 / s2ph) - mlp - mlp);
                lpphi += dPhi;
                if (Math.abs(dPhi) <= 1.0E-12) break;
            }
            if (i == 0) {
                out.setLocation(Double.NaN, Double.NaN);
            }
            c = Math.sin(lpphi);
            double x = Math.asin(xyx * Math.tan(lpphi) * Math.sqrt(1.0 - this.es * c * c)) / Math.sin(lpphi);
            double y = lpphi;
            out.setLocation(x, y);
        }
        return out;
    }

    private void initialize() {
        if (!this.spherical) {
            this.en = MapMath.enfn(this.es);
            if (this.en == null) {
                throw new RuntimeException("E");
            }
            this.ml0 = MapMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
        } else {
            this.ml0 = -this.projectionLatitude;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolyconicProjection that = (PolyconicProjection)o;
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.projectionLatitude, this.projectionLatitude) != 0) {
            return false;
        }
        if (Double.compare(that.projectionLongitude, this.projectionLongitude) != 0) {
            return false;
        }
        return this.ellipsoid.equals(that.ellipsoid);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.projectionLatitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.projectionLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.ellipsoid.hashCode();
        temp = Double.doubleToLongBits(this.falseEasting);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.falseNorthing);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Earth getEarth() {
        return this.ellipsoid;
    }

    @Deprecated
    public void setOriginLatitude(double lat) {
        this._lat0 = lat;
        this.projectionLatitude = Math.toRadians(lat);
    }

    public double getOriginLatitude() {
        return this._lat0;
    }

    @Deprecated
    public void setOriginLongitude(double lon) {
        this._lon0 = lon;
        this.projectionLongitude = Math.toRadians(lon);
    }

    public double getOriginLongitude() {
        return this._lon0;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    @Deprecated
    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    @Deprecated
    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Polyconic Projection";
    }

    @Override
    public String paramsToString() {
        Formatter f = new Formatter();
        f.format("origin lat=%f, origin lon=%f earth=%s", this._lat0, this._lon0, this.ellipsoid);
        return f.toString();
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 20000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl result) {
        double fromLat = Math.toRadians(latlon.getLatitude());
        double theta = Math.toRadians(latlon.getLongitude());
        if (this.projectionLongitude != 0.0 && !Double.isNaN(theta)) {
            theta = MapMath.normalizeLongitude(theta - this.projectionLongitude);
        }
        ProjectionPoint out = this.project(theta, fromLat);
        result.setLocation(this.totalScale * out.getX() + this.falseEasting, this.totalScale * out.getY() + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = (world.getX() - this.falseEasting) / this.totalScale;
        double fromY = (world.getY() - this.falseNorthing) / this.totalScale;
        ProjectionPointImpl pp = new ProjectionPointImpl();
        this.projectInverse(fromX, fromY, pp);
        if (pp.getX() < -Math.PI) {
            pp.setX(-Math.PI);
        } else if (pp.getX() > Math.PI) {
            pp.setX(Math.PI);
        }
        if (this.projectionLongitude != 0.0 && !Double.isNaN(pp.getX())) {
            pp.setX(MapMath.normalizeLongitude(pp.getX() + this.projectionLongitude));
        }
        result.setLatitude(Math.toDegrees(pp.getY()));
        result.setLongitude(Math.toDegrees(pp.getX()));
        return result;
    }

    @Override
    public ProjectionImpl constructCopy() {
        PolyconicProjection result = new PolyconicProjection(this.getOriginLatitude(), this.getOriginLongitude(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarth());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }
}

