/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.entropy.encoder;

import java.util.Stack;
import ucar.jpeg.jj2000.j2k.StringSpec;
import ucar.jpeg.jj2000.j2k.entropy.CBlkSizeSpec;
import ucar.jpeg.jj2000.j2k.entropy.PrecinctSizeSpec;
import ucar.jpeg.jj2000.j2k.entropy.StdEntropyCoderOptions;
import ucar.jpeg.jj2000.j2k.entropy.encoder.BitToByteOutput;
import ucar.jpeg.jj2000.j2k.entropy.encoder.ByteOutputBuffer;
import ucar.jpeg.jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import ucar.jpeg.jj2000.j2k.entropy.encoder.EntropyCoder;
import ucar.jpeg.jj2000.j2k.entropy.encoder.MQCoder;
import ucar.jpeg.jj2000.j2k.image.Coord;
import ucar.jpeg.jj2000.j2k.quantization.quantizer.CBlkQuantDataSrcEnc;
import ucar.jpeg.jj2000.j2k.util.ArrayUtil;
import ucar.jpeg.jj2000.j2k.util.FacilityManager;
import ucar.jpeg.jj2000.j2k.util.ThreadPool;
import ucar.jpeg.jj2000.j2k.wavelet.analysis.CBlkWTData;

public class StdEntropyCoder
extends EntropyCoder
implements StdEntropyCoderOptions {
    private static final boolean DO_TIMING = false;
    private long[] time;
    public static final String THREADS_PROP_NAME = "ucar.jpeg.jj2000.j2k.entropy.encoder.StdEntropyCoder.nthreads";
    public static final String DEF_THREADS_NUM = "0";
    public static final int THREADS_PRIORITY_INC = 0;
    private ThreadPool tPool;
    private Stack idleComps;
    private Stack[] completedComps;
    private int[] nBusyComps;
    private boolean[] finishedTileComponent;
    private MQCoder[] mqT;
    private BitToByteOutput[] boutT;
    private ByteOutputBuffer[] outT;
    private CBlkSizeSpec cblks;
    private PrecinctSizeSpec pss;
    public StringSpec bms;
    public StringSpec mqrs;
    public StringSpec rts;
    public StringSpec css;
    public StringSpec sss;
    public StringSpec lcs;
    public StringSpec tts;
    private int[][] opts = null;
    private int[][] lenCalc = null;
    private int[][] tType = null;
    private static final int ZC_LUT_BITS = 8;
    private static final int[] ZC_LUT_LH;
    private static final int[] ZC_LUT_HL;
    private static final int[] ZC_LUT_HH;
    private static final int SC_LUT_BITS = 9;
    private static final int[] SC_LUT;
    private static final int SC_LUT_MASK = 15;
    private static final int SC_SPRED_SHIFT = 31;
    private static final int INT_SIGN_BIT = Integer.MIN_VALUE;
    private static final int MR_LUT_BITS = 9;
    private static final int[] MR_LUT;
    private static final int NUM_CTXTS = 19;
    private static final int RLC_CTXT = 1;
    private static final int UNIF_CTXT = 0;
    private static final int[] MQ_INIT;
    private static final int[] SEG_SYMBOLS;
    private static final int[] SEG_SYMB_CTXTS;
    private int[][] stateT;
    private static final int STATE_SEP = 16;
    private static final int STATE_SIG_R1 = 32768;
    private static final int STATE_VISITED_R1 = 16384;
    private static final int STATE_NZ_CTXT_R1 = 8192;
    private static final int STATE_H_L_SIGN_R1 = 4096;
    private static final int STATE_H_R_SIGN_R1 = 2048;
    private static final int STATE_V_U_SIGN_R1 = 1024;
    private static final int STATE_V_D_SIGN_R1 = 512;
    private static final int STATE_PREV_MR_R1 = 256;
    private static final int STATE_H_L_R1 = 128;
    private static final int STATE_H_R_R1 = 64;
    private static final int STATE_V_U_R1 = 32;
    private static final int STATE_V_D_R1 = 16;
    private static final int STATE_D_UL_R1 = 8;
    private static final int STATE_D_UR_R1 = 4;
    private static final int STATE_D_DL_R1 = 2;
    private static final int STATE_D_DR_R1 = 1;
    private static final int STATE_SIG_R2 = Integer.MIN_VALUE;
    private static final int STATE_VISITED_R2 = 0x40000000;
    private static final int STATE_NZ_CTXT_R2 = 0x20000000;
    private static final int STATE_H_L_SIGN_R2 = 0x10000000;
    private static final int STATE_H_R_SIGN_R2 = 0x8000000;
    private static final int STATE_V_U_SIGN_R2 = 0x4000000;
    private static final int STATE_V_D_SIGN_R2 = 0x2000000;
    private static final int STATE_PREV_MR_R2 = 0x1000000;
    private static final int STATE_H_L_R2 = 0x800000;
    private static final int STATE_H_R_R2 = 0x400000;
    private static final int STATE_V_U_R2 = 0x200000;
    private static final int STATE_V_D_R2 = 0x100000;
    private static final int STATE_D_UL_R2 = 524288;
    private static final int STATE_D_UR_R2 = 262144;
    private static final int STATE_D_DL_R2 = 131072;
    private static final int STATE_D_DR_R2 = 65536;
    private static final int SIG_MASK_R1R2 = -2147450880;
    private static final int VSTD_MASK_R1R2 = 0x40004000;
    private static final int RLC_MASK_R1R2 = -536813568;
    private static final int ZC_MASK = 255;
    private static final int SC_SHIFT_R1 = 4;
    private static final int SC_SHIFT_R2 = 20;
    private static final int SC_MASK = 511;
    private static final int MR_MASK = 511;
    private static final int MSE_LKP_BITS = 7;
    private static final int MSE_LKP_FRAC_BITS = 13;
    private static final int[] FS_LOSSY;
    private static final int[] FM_LOSSY;
    private static final int[] FS_LOSSLESS;
    private static final int[] FM_LOSSLESS;
    private double[][] distbufT;
    private int[][] ratebufT;
    private boolean[][] istermbufT;
    private CBlkWTData[] srcblkT;
    private int[][] symbufT;
    private int[][] ctxtbufT;
    private boolean[][] precinctPartition;

    public StdEntropyCoder(CBlkQuantDataSrcEnc src, CBlkSizeSpec cblks, PrecinctSizeSpec pss, StringSpec bms, StringSpec mqrs, StringSpec rts, StringSpec css, StringSpec sss, StringSpec lcs, StringSpec tts) {
        super(src);
        int i;
        int tsl;
        int nt;
        this.cblks = cblks;
        this.pss = pss;
        this.bms = bms;
        this.mqrs = mqrs;
        this.rts = rts;
        this.css = css;
        this.sss = sss;
        this.lcs = lcs;
        this.tts = tts;
        int maxCBlkWidth = cblks.getMaxCBlkWidth();
        int maxCBlkHeight = cblks.getMaxCBlkHeight();
        try {
            nt = Integer.parseInt(System.getProperty(THREADS_PROP_NAME, DEF_THREADS_NUM));
            if (nt < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number of threads for entropy coding in property ucar.jpeg.jj2000.j2k.entropy.encoder.StdEntropyCoder.nthreads");
        }
        if (nt > 0) {
            FacilityManager.getMsgLogger().printmsg(1, "Using multithreaded entropy coder with " + nt + " compressor threads.");
            tsl = nt;
            this.tPool = new ThreadPool(nt, Thread.currentThread().getPriority() + 0, "StdEntropyCoder");
            this.idleComps = new Stack();
            this.completedComps = new Stack[src.getNumComps()];
            this.nBusyComps = new int[src.getNumComps()];
            this.finishedTileComponent = new boolean[src.getNumComps()];
            for (i = src.getNumComps() - 1; i >= 0; --i) {
                this.completedComps[i] = new Stack();
            }
            for (i = 0; i < nt; ++i) {
                this.idleComps.push(new Compressor(i));
            }
        } else {
            tsl = 1;
            this.tPool = null;
            this.idleComps = null;
            this.completedComps = null;
            this.nBusyComps = null;
            this.finishedTileComponent = null;
        }
        this.outT = new ByteOutputBuffer[tsl];
        this.mqT = new MQCoder[tsl];
        this.boutT = new BitToByteOutput[tsl];
        this.stateT = new int[tsl][(maxCBlkWidth + 2) * ((maxCBlkHeight + 1) / 2 + 2)];
        this.symbufT = new int[tsl][maxCBlkWidth * 10];
        this.ctxtbufT = new int[tsl][maxCBlkWidth * 10];
        this.distbufT = new double[tsl][96];
        this.ratebufT = new int[tsl][96];
        this.istermbufT = new boolean[tsl][96];
        this.srcblkT = new CBlkWTData[tsl];
        for (i = 0; i < tsl; ++i) {
            this.outT[i] = new ByteOutputBuffer();
            this.mqT[i] = new MQCoder(this.outT[i], 19, MQ_INIT);
        }
        this.precinctPartition = new boolean[src.getNumComps()][src.getNumTiles()];
        Object sb = null;
        Coord numTiles = null;
        int nc = this.getNumComps();
        numTiles = src.getNumTiles(numTiles);
        this.initTileComp(this.getNumTiles(), nc);
        for (int c = 0; c < nc; ++c) {
            for (int tY = 0; tY < numTiles.y; ++tY) {
                for (int tX = 0; tX < numTiles.x; ++tX) {
                    this.precinctPartition[c][this.tIdx] = false;
                }
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public int getCBlkWidth(int t, int c) {
        return this.cblks.getCBlkWidth((byte)3, t, c);
    }

    @Override
    public int getCBlkHeight(int t, int c) {
        return this.cblks.getCBlkHeight((byte)3, t, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CBlkRateDistStats getNextCodeBlock(int c, CBlkRateDistStats ccb) {
        int cIdx;
        Compressor compr;
        long stime = 0L;
        if (this.tPool == null) {
            this.srcblkT[0] = this.src.getNextInternCodeBlock(c, this.srcblkT[0]);
            if (this.srcblkT[0] == null) {
                return null;
            }
            if ((this.opts[this.tIdx][c] & 1) != 0 && this.boutT[0] == null) {
                this.boutT[0] = new BitToByteOutput(this.outT[0]);
            }
            if (ccb == null) {
                ccb = new CBlkRateDistStats();
            }
            StdEntropyCoder.compressCodeBlock(c, ccb, this.srcblkT[0], this.mqT[0], this.boutT[0], this.outT[0], this.stateT[0], this.distbufT[0], this.ratebufT[0], this.istermbufT[0], this.symbufT[0], this.ctxtbufT[0], this.opts[this.tIdx][c], this.isReversible(this.tIdx, c), this.lenCalc[this.tIdx][c], this.tType[this.tIdx][c]);
            return ccb;
        }
        while (!this.finishedTileComponent[c] && !this.idleComps.empty()) {
            compr = (Compressor)this.idleComps.pop();
            cIdx = compr.getIdx();
            this.srcblkT[cIdx] = this.src.getNextInternCodeBlock(c, this.srcblkT[cIdx]);
            if (this.srcblkT[cIdx] != null) {
                if ((this.opts[this.tIdx][c] & 1) != 0 && this.boutT[cIdx] == null) {
                    this.boutT[cIdx] = new BitToByteOutput(this.outT[cIdx]);
                }
                if (ccb == null) {
                    ccb = new CBlkRateDistStats();
                }
                compr.ccb = ccb;
                compr.c = c;
                compr.options = this.opts[this.tIdx][c];
                compr.rev = this.isReversible(this.tIdx, c);
                compr.lcType = this.lenCalc[this.tIdx][c];
                compr.tType = this.tType[this.tIdx][c];
                int n = c;
                this.nBusyComps[n] = this.nBusyComps[n] + 1;
                ccb = null;
                this.tPool.runTarget(compr, this.completedComps[c]);
                continue;
            }
            this.idleComps.push(compr);
            this.finishedTileComponent[c] = true;
        }
        if (this.nBusyComps[c] > 0) {
            Stack stack = this.completedComps[c];
            synchronized (stack) {
                if (this.completedComps[c].empty()) {
                    try {
                        this.completedComps[c].wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                compr = (Compressor)this.completedComps[c].pop();
                cIdx = compr.getIdx();
                int n = c;
                this.nBusyComps[n] = this.nBusyComps[n] - 1;
                this.idleComps.push(compr);
                this.tPool.checkTargetErrors();
                return compr.ccb;
            }
        }
        this.tPool.checkTargetErrors();
        return null;
    }

    @Override
    public void setTile(int x, int y) {
        super.setTile(x, y);
        if (this.finishedTileComponent != null) {
            for (int c = this.src.getNumComps() - 1; c >= 0; --c) {
                this.finishedTileComponent[c] = false;
            }
        }
    }

    @Override
    public void nextTile() {
        if (this.finishedTileComponent != null) {
            for (int c = this.src.getNumComps() - 1; c >= 0; --c) {
                this.finishedTileComponent[c] = false;
            }
        }
        super.nextTile();
    }

    private static void compressCodeBlock(int c, CBlkRateDistStats ccb, CBlkWTData srcblk, MQCoder mq, BitToByteOutput bout, ByteOutputBuffer out, int[] state, double[] distbuf, int[] ratebuf, boolean[] istermbuf, int[] symbuf, int[] ctxtbuf, int options, boolean rev, int lcType, int tType) {
        int[] zc_lut;
        if ((options & 0x10) != 0 && tType != 3) {
            throw new IllegalArgumentException("Embedded error-resilient info in MQ termination option specified but incorrect MQ termination policy specified");
        }
        mq.setLenCalcType(lcType);
        mq.setTermType(tType);
        int lmb = 30 - srcblk.magbits + 1;
        lmb = lmb < 0 ? 0 : lmb;
        ArrayUtil.intArraySet(state, 0);
        int skipbp = StdEntropyCoder.calcSkipMSBP(srcblk, lmb);
        ccb.m = srcblk.m;
        ccb.n = srcblk.n;
        ccb.sb = srcblk.sb;
        ccb.nROIcoeff = srcblk.nROIcoeff;
        ccb.skipMSBP = skipbp;
        ccb.nROIcp = ccb.nROIcoeff != 0 ? 3 * (srcblk.nROIbp - skipbp - 1) + 1 : 0;
        switch (srcblk.sb.orientation) {
            case 1: {
                zc_lut = ZC_LUT_HL;
                break;
            }
            case 0: 
            case 2: {
                zc_lut = ZC_LUT_LH;
                break;
            }
            case 3: {
                zc_lut = ZC_LUT_HH;
                break;
            }
            default: {
                throw new Error("JJ2000 internal error");
            }
        }
        int curbp = 30 - skipbp;
        int[] fs = FS_LOSSY;
        int[] fm = FM_LOSSY;
        double msew = Math.pow(2.0, (curbp - lmb << 1) - 13) * (double)srcblk.sb.stepWMSE * (double)srcblk.wmseScaling;
        double totdist = 0.0;
        int npass = 0;
        int ltpidx = -1;
        if (curbp >= lmb) {
            if (rev && curbp == lmb) {
                fs = FM_LOSSLESS;
            }
            istermbuf[npass] = (options & 4) != 0 || curbp == lmb || (options & 1) != 0 && 27 - skipbp >= curbp;
            distbuf[npass] = totdist += (double)StdEntropyCoder.cleanuppass(srcblk, mq, istermbuf[npass], curbp, state, fs, zc_lut, symbuf, ctxtbuf, ratebuf, npass, ltpidx, options) * msew;
            if (istermbuf[npass]) {
                ltpidx = npass;
            }
            ++npass;
            msew *= 0.25;
            --curbp;
        }
        while (curbp >= lmb) {
            if (rev && curbp == lmb) {
                fs = FS_LOSSLESS;
                fm = FM_LOSSLESS;
            }
            boolean bl = istermbuf[npass] = (options & 4) != 0;
            if ((options & 1) == 0 || 27 - skipbp <= curbp) {
                totdist += (double)StdEntropyCoder.sigProgPass(srcblk, mq, istermbuf[npass], curbp, state, fs, zc_lut, symbuf, ctxtbuf, ratebuf, npass, ltpidx, options) * msew;
            } else {
                bout.setPredTerm((options & 0x10) != 0);
                totdist += (double)StdEntropyCoder.rawSigProgPass(srcblk, bout, istermbuf[npass], curbp, state, fs, ratebuf, npass, ltpidx, options) * msew;
            }
            distbuf[npass] = totdist;
            if (istermbuf[npass]) {
                ltpidx = npass;
            }
            boolean bl2 = istermbuf[++npass] = (options & 4) != 0 || (options & 1) != 0 && 27 - skipbp > curbp;
            if ((options & 1) == 0 || 27 - skipbp <= curbp) {
                totdist += (double)StdEntropyCoder.magRefPass(srcblk, mq, istermbuf[npass], curbp, state, fm, symbuf, ctxtbuf, ratebuf, npass, ltpidx, options) * msew;
            } else {
                bout.setPredTerm((options & 0x10) != 0);
                totdist += (double)StdEntropyCoder.rawMagRefPass(srcblk, bout, istermbuf[npass], curbp, state, fm, ratebuf, npass, ltpidx, options) * msew;
            }
            distbuf[npass] = totdist;
            if (istermbuf[npass]) {
                ltpidx = npass;
            }
            istermbuf[++npass] = (options & 4) != 0 || curbp == lmb || (options & 1) != 0 && 27 - skipbp >= curbp;
            distbuf[npass] = totdist += (double)StdEntropyCoder.cleanuppass(srcblk, mq, istermbuf[npass], curbp, state, fs, zc_lut, symbuf, ctxtbuf, ratebuf, npass, ltpidx, options) * msew;
            if (istermbuf[npass]) {
                ltpidx = npass;
            }
            ++npass;
            msew *= 0.25;
            --curbp;
        }
        ccb.data = new byte[out.size()];
        out.toByteArray(0, out.size(), ccb.data, 0);
        StdEntropyCoder.checkEndOfPassFF(ccb.data, ratebuf, istermbuf, npass);
        ccb.selectConvexHull(ratebuf, distbuf, (boolean[])((options & 5) != 0 ? istermbuf : null), npass, rev);
        mq.reset();
        if (bout != null) {
            bout.reset();
        }
    }

    private static int calcSkipMSBP(CBlkWTData cblk, int lmb) {
        int[] data = (int[])cblk.getData();
        int w = cblk.w;
        int h2 = cblk.h;
        int maxmag = 0;
        int mask = Integer.MAX_VALUE & ~((1 << lmb) - 1);
        int k = cblk.offset;
        for (int l = h2 - 1; l >= 0; --l) {
            int kmax = k + w;
            while (k < kmax) {
                int mag = data[k] & mask;
                if (mag > maxmag) {
                    maxmag = mag;
                }
                ++k;
            }
            k += cblk.scanw - w;
        }
        int msbp = 30;
        while ((1 << msbp & maxmag) == 0 && --msbp >= lmb) {
        }
        return 30 - msbp;
    }

    /*
     * Unable to fully structure code
     */
    private static int sigProgPass(CBlkWTData srcblk, MQCoder mq, boolean doterm, int bp, int[] state, int[] fs, int[] zc_lut, int[] symbuf, int[] ctxtbuf, int[] ratebuf, int pidx, int ltpidx, int options) {
        nsym = 0;
        dscanw = srcblk.scanw;
        sscanw = srcblk.w + 2;
        jstep = sscanw * 4 / 2 - srcblk.w;
        kstep = dscanw * 4 - srcblk.w;
        mask = 1 << bp;
        data = (int[])srcblk.getData();
        nstripes = (srcblk.h + 4 - 1) / 4;
        dist = 0;
        shift = bp - 6;
        upshift = shift >= 0 ? 0 : -shift;
        downshift = shift <= 0 ? 0 : shift;
        causal = (options & 8) != 0;
        off_ul = -sscanw - 1;
        off_ur = -sscanw + 1;
        off_dr = sscanw + 1;
        off_dl = sscanw - 1;
        sk = srcblk.offset;
        sj = sscanw + 1;
        s = nstripes - 1;
        while (s >= 0) {
            sheight = s != 0 ? 4 : srcblk.h - (nstripes - 1) * 4;
            stopsk = sk + srcblk.w;
            nsym = 0;
            while (sk < stopsk) {
                j = sj;
                csj = state[j];
                if ((~csj & csj << 2 & -2147450880) == 0) ** GOTO lbl101
                k = sk;
                if ((csj & 40960) == 8192) {
                    ctxtbuf[nsym] = zc_lut[csj & 255];
                    symbuf[nsym++] = (data[k] & mask) >>> bp;
                    if (symbuf[nsym++] != 0) {
                        sym = data[k] >>> 31;
                        ctxt = StdEntropyCoder.SC_LUT[csj >>> 4 & 511];
                        symbuf[nsym] = sym ^ ctxt >>> 31;
                        ctxtbuf[nsym++] = ctxt & 15;
                        if (!causal) {
                            v0 = j + off_ul;
                            state[v0] = state[v0] | 0x20010000;
                            v1 = j + off_ur;
                            state[v1] = state[v1] | 0x20020000;
                        }
                        if (sym != 0) {
                            csj |= 606126080;
                            if (!causal) {
                                v2 = j - sscanw;
                                state[v2] = state[v2] | 0x22100000;
                            }
                            v3 = j + 1;
                            state[v3] = state[v3] | 537407616;
                            v4 = j - 1;
                            state[v4] = state[v4] | 537143360;
                        } else {
                            csj |= 0x2020C000;
                            if (!causal) {
                                v5 = j - sscanw;
                                state[v5] = state[v5] | 0x20100000;
                            }
                            v6 = j + 1;
                            state[v6] = state[v6] | 0x20082080;
                            v7 = j - 1;
                            state[v7] = state[v7] | 0x20042040;
                        }
                        normval = data[k] >> downshift << upshift;
                        dist += fs[normval & 63];
                    } else {
                        csj |= 16384;
                    }
                }
                if (sheight < 2) {
                    state[j] = csj;
                } else {
                    if ((csj & -1610612736) == 0x20000000) {
                        ctxtbuf[nsym] = zc_lut[csj >>> 16 & 255];
                        symbuf[nsym++] = (data[k += dscanw] & mask) >>> bp;
                        if (symbuf[nsym++] != 0) {
                            sym = data[k] >>> 31;
                            ctxt = StdEntropyCoder.SC_LUT[csj >>> 20 & 511];
                            symbuf[nsym] = sym ^ ctxt >>> 31;
                            ctxtbuf[nsym++] = ctxt & 15;
                            v8 = j + off_dl;
                            state[v8] = state[v8] | 8196;
                            v9 = j + off_dr;
                            state[v9] = state[v9] | 8200;
                            if (sym != 0) {
                                csj |= -1073733104;
                                v10 = j + sscanw;
                                state[v10] = state[v10] | 9248;
                                v11 = j + 1;
                                state[v11] = state[v11] | 813703170;
                                v12 = j - 1;
                                state[v12] = state[v12] | 675291137;
                            } else {
                                csj |= -1073733616;
                                v13 = j + sscanw;
                                state[v13] = state[v13] | 8224;
                                v14 = j + 1;
                                state[v14] = state[v14] | 0x20802002;
                                v15 = j - 1;
                                state[v15] = state[v15] | 541073409;
                            }
                            normval = data[k] >> downshift << upshift;
                            dist += fs[normval & 63];
                        } else {
                            csj |= 0x40000000;
                        }
                    }
                    state[j] = csj;
lbl101:
                    // 2 sources

                    if (sheight >= 3 && (~(csj = state[j += sscanw]) & csj << 2 & -2147450880) != 0) {
                        k = sk + (dscanw << 1);
                        if ((csj & 40960) == 8192) {
                            ctxtbuf[nsym] = zc_lut[csj & 255];
                            symbuf[nsym++] = (data[k] & mask) >>> bp;
                            if (symbuf[nsym++] != 0) {
                                sym = data[k] >>> 31;
                                ctxt = StdEntropyCoder.SC_LUT[csj >>> 4 & 511];
                                symbuf[nsym] = sym ^ ctxt >>> 31;
                                ctxtbuf[nsym++] = ctxt & 15;
                                v16 = j + off_ul;
                                state[v16] = state[v16] | 0x20010000;
                                v17 = j + off_ur;
                                state[v17] = state[v17] | 0x20020000;
                                if (sym != 0) {
                                    csj |= 606126080;
                                    v18 = j - sscanw;
                                    state[v18] = state[v18] | 0x22100000;
                                    v19 = j + 1;
                                    state[v19] = state[v19] | 537407616;
                                    v20 = j - 1;
                                    state[v20] = state[v20] | 537143360;
                                } else {
                                    csj |= 0x2020C000;
                                    v21 = j - sscanw;
                                    state[v21] = state[v21] | 0x20100000;
                                    v22 = j + 1;
                                    state[v22] = state[v22] | 0x20082080;
                                    v23 = j - 1;
                                    state[v23] = state[v23] | 0x20042040;
                                }
                                normval = data[k] >> downshift << upshift;
                                dist += fs[normval & 63];
                            } else {
                                csj |= 16384;
                            }
                        }
                        if (sheight < 4) {
                            state[j] = csj;
                        } else {
                            if ((csj & -1610612736) == 0x20000000) {
                                ctxtbuf[nsym] = zc_lut[csj >>> 16 & 255];
                                symbuf[nsym++] = (data[k += dscanw] & mask) >>> bp;
                                if (symbuf[nsym++] != 0) {
                                    sym = data[k] >>> 31;
                                    ctxt = StdEntropyCoder.SC_LUT[csj >>> 20 & 511];
                                    symbuf[nsym] = sym ^ ctxt >>> 31;
                                    ctxtbuf[nsym++] = ctxt & 15;
                                    v24 = j + off_dl;
                                    state[v24] = state[v24] | 8196;
                                    v25 = j + off_dr;
                                    state[v25] = state[v25] | 8200;
                                    if (sym != 0) {
                                        csj |= -1073733104;
                                        v26 = j + sscanw;
                                        state[v26] = state[v26] | 9248;
                                        v27 = j + 1;
                                        state[v27] = state[v27] | 813703170;
                                        v28 = j - 1;
                                        state[v28] = state[v28] | 675291137;
                                    } else {
                                        csj |= -1073733616;
                                        v29 = j + sscanw;
                                        state[v29] = state[v29] | 8224;
                                        v30 = j + 1;
                                        state[v30] = state[v30] | 0x20802002;
                                        v31 = j - 1;
                                        state[v31] = state[v31] | 541073409;
                                    }
                                    normval = data[k] >> downshift << upshift;
                                    dist += fs[normval & 63];
                                } else {
                                    csj |= 0x40000000;
                                }
                            }
                            state[j] = csj;
                        }
                    }
                }
                ++sk;
                ++sj;
            }
            mq.codeSymbols(symbuf, ctxtbuf, nsym);
            --s;
            sk += kstep;
            sj += jstep;
        }
        if ((options & 2) != 0) {
            mq.resetCtxts();
        }
        ratebuf[pidx] = doterm != false ? mq.terminate() : mq.getNumCodedBytes();
        if (ltpidx >= 0) {
            v32 = pidx;
            ratebuf[v32] = ratebuf[v32] + ratebuf[ltpidx];
        }
        if (doterm) {
            mq.finishLengthCalculation(ratebuf, pidx);
        }
        return dist;
    }

    /*
     * Unable to fully structure code
     */
    private static int rawSigProgPass(CBlkWTData srcblk, BitToByteOutput bout, boolean doterm, int bp, int[] state, int[] fs, int[] ratebuf, int pidx, int ltpidx, int options) {
        nsym = 0;
        dscanw = srcblk.scanw;
        sscanw = srcblk.w + 2;
        jstep = sscanw * 4 / 2 - srcblk.w;
        kstep = dscanw * 4 - srcblk.w;
        mask = 1 << bp;
        data = (int[])srcblk.getData();
        nstripes = (srcblk.h + 4 - 1) / 4;
        dist = 0;
        shift = bp - 6;
        upshift = shift >= 0 ? 0 : -shift;
        downshift = shift <= 0 ? 0 : shift;
        causal = (options & 8) != 0;
        off_ul = -sscanw - 1;
        off_ur = -sscanw + 1;
        off_dr = sscanw + 1;
        off_dl = sscanw - 1;
        sk = srcblk.offset;
        sj = sscanw + 1;
        s = nstripes - 1;
        while (s >= 0) {
            sheight = s != 0 ? 4 : srcblk.h - (nstripes - 1) * 4;
            stopsk = sk + srcblk.w;
            while (sk < stopsk) {
                j = sj;
                csj = state[j];
                if ((~csj & csj << 2 & -2147450880) == 0) ** GOTO lbl100
                k = sk;
                if ((csj & 40960) == 8192) {
                    sym = (data[k] & mask) >>> bp;
                    bout.writeBit(sym);
                    ++nsym;
                    if (sym != 0) {
                        sym = data[k] >>> 31;
                        bout.writeBit(sym);
                        ++nsym;
                        if (!causal) {
                            v0 = j + off_ul;
                            state[v0] = state[v0] | 0x20010000;
                            v1 = j + off_ur;
                            state[v1] = state[v1] | 0x20020000;
                        }
                        if (sym != 0) {
                            csj |= 606126080;
                            if (!causal) {
                                v2 = j - sscanw;
                                state[v2] = state[v2] | 0x22100000;
                            }
                            v3 = j + 1;
                            state[v3] = state[v3] | 537407616;
                            v4 = j - 1;
                            state[v4] = state[v4] | 537143360;
                        } else {
                            csj |= 0x2020C000;
                            if (!causal) {
                                v5 = j - sscanw;
                                state[v5] = state[v5] | 0x20100000;
                            }
                            v6 = j + 1;
                            state[v6] = state[v6] | 0x20082080;
                            v7 = j - 1;
                            state[v7] = state[v7] | 0x20042040;
                        }
                        normval = data[k] >> downshift << upshift;
                        dist += fs[normval & 63];
                    } else {
                        csj |= 16384;
                    }
                }
                if (sheight < 2) {
                    state[j] = csj;
                } else {
                    if ((csj & -1610612736) == 0x20000000) {
                        sym = (data[k += dscanw] & mask) >>> bp;
                        bout.writeBit(sym);
                        ++nsym;
                        if (sym != 0) {
                            sym = data[k] >>> 31;
                            bout.writeBit(sym);
                            ++nsym;
                            v8 = j + off_dl;
                            state[v8] = state[v8] | 8196;
                            v9 = j + off_dr;
                            state[v9] = state[v9] | 8200;
                            if (sym != 0) {
                                csj |= -1073733104;
                                v10 = j + sscanw;
                                state[v10] = state[v10] | 9248;
                                v11 = j + 1;
                                state[v11] = state[v11] | 813703170;
                                v12 = j - 1;
                                state[v12] = state[v12] | 675291137;
                            } else {
                                csj |= -1073733616;
                                v13 = j + sscanw;
                                state[v13] = state[v13] | 8224;
                                v14 = j + 1;
                                state[v14] = state[v14] | 0x20802002;
                                v15 = j - 1;
                                state[v15] = state[v15] | 541073409;
                            }
                            normval = data[k] >> downshift << upshift;
                            dist += fs[normval & 63];
                        } else {
                            csj |= 0x40000000;
                        }
                    }
                    state[j] = csj;
lbl100:
                    // 2 sources

                    if (sheight >= 3 && (~(csj = state[j += sscanw]) & csj << 2 & -2147450880) != 0) {
                        k = sk + (dscanw << 1);
                        if ((csj & 40960) == 8192) {
                            sym = (data[k] & mask) >>> bp;
                            bout.writeBit(sym);
                            ++nsym;
                            if (sym != 0) {
                                sym = data[k] >>> 31;
                                bout.writeBit(sym);
                                ++nsym;
                                v16 = j + off_ul;
                                state[v16] = state[v16] | 0x20010000;
                                v17 = j + off_ur;
                                state[v17] = state[v17] | 0x20020000;
                                if (sym != 0) {
                                    csj |= 606126080;
                                    v18 = j - sscanw;
                                    state[v18] = state[v18] | 0x22100000;
                                    v19 = j + 1;
                                    state[v19] = state[v19] | 537407616;
                                    v20 = j - 1;
                                    state[v20] = state[v20] | 537143360;
                                } else {
                                    csj |= 0x2020C000;
                                    v21 = j - sscanw;
                                    state[v21] = state[v21] | 0x20100000;
                                    v22 = j + 1;
                                    state[v22] = state[v22] | 0x20082080;
                                    v23 = j - 1;
                                    state[v23] = state[v23] | 0x20042040;
                                }
                                normval = data[k] >> downshift << upshift;
                                dist += fs[normval & 63];
                            } else {
                                csj |= 16384;
                            }
                        }
                        if (sheight < 4) {
                            state[j] = csj;
                        } else {
                            if ((csj & -1610612736) == 0x20000000) {
                                sym = (data[k += dscanw] & mask) >>> bp;
                                bout.writeBit(sym);
                                ++nsym;
                                if (sym != 0) {
                                    sym = data[k] >>> 31;
                                    bout.writeBit(sym);
                                    ++nsym;
                                    v24 = j + off_dl;
                                    state[v24] = state[v24] | 8196;
                                    v25 = j + off_dr;
                                    state[v25] = state[v25] | 8200;
                                    if (sym != 0) {
                                        csj |= -1073733104;
                                        v26 = j + sscanw;
                                        state[v26] = state[v26] | 9248;
                                        v27 = j + 1;
                                        state[v27] = state[v27] | 813703170;
                                        v28 = j - 1;
                                        state[v28] = state[v28] | 675291137;
                                    } else {
                                        csj |= -1073733616;
                                        v29 = j + sscanw;
                                        state[v29] = state[v29] | 8224;
                                        v30 = j + 1;
                                        state[v30] = state[v30] | 0x20802002;
                                        v31 = j - 1;
                                        state[v31] = state[v31] | 541073409;
                                    }
                                    normval = data[k] >> downshift << upshift;
                                    dist += fs[normval & 63];
                                } else {
                                    csj |= 0x40000000;
                                }
                            }
                            state[j] = csj;
                        }
                    }
                }
                ++sk;
                ++sj;
            }
            --s;
            sk += kstep;
            sj += jstep;
        }
        ratebuf[pidx] = doterm != false ? bout.terminate() : bout.length();
        if (ltpidx >= 0) {
            v32 = pidx;
            ratebuf[v32] = ratebuf[v32] + ratebuf[ltpidx];
        }
        return dist;
    }

    /*
     * Unable to fully structure code
     */
    private static int magRefPass(CBlkWTData srcblk, MQCoder mq, boolean doterm, int bp, int[] state, int[] fm, int[] symbuf, int[] ctxtbuf, int[] ratebuf, int pidx, int ltpidx, int options) {
        nsym = 0;
        dscanw = srcblk.scanw;
        sscanw = srcblk.w + 2;
        jstep = sscanw * 4 / 2 - srcblk.w;
        kstep = dscanw * 4 - srcblk.w;
        mask = 1 << bp;
        data = (int[])srcblk.getData();
        nstripes = (srcblk.h + 4 - 1) / 4;
        dist = 0;
        shift = bp - 6;
        upshift = shift >= 0 ? 0 : -shift;
        downshift = shift <= 0 ? 0 : shift;
        sk = srcblk.offset;
        sj = sscanw + 1;
        s = nstripes - 1;
        while (s >= 0) {
            sheight = s != 0 ? 4 : srcblk.h - (nstripes - 1) * 4;
            stopsk = sk + srcblk.w;
            nsym = 0;
            while (sk < stopsk) {
                j = sj;
                csj = state[j];
                if ((csj >>> 1 & ~csj & 0x40004000) == 0) ** GOTO lbl41
                k = sk;
                if ((csj & 49152) == 32768) {
                    symbuf[nsym] = (data[k] & mask) >>> bp;
                    ctxtbuf[nsym++] = StdEntropyCoder.MR_LUT[csj & 511];
                    csj |= 256;
                    normval = data[k] >> downshift << upshift;
                    dist += fm[normval & 127];
                }
                if (sheight < 2) {
                    state[j] = csj;
                } else {
                    if ((csj & -1073741824) == -2147483648) {
                        symbuf[nsym] = (data[k += dscanw] & mask) >>> bp;
                        ctxtbuf[nsym++] = StdEntropyCoder.MR_LUT[csj >>> 16 & 511];
                        csj |= 0x1000000;
                        normval = data[k] >> downshift << upshift;
                        dist += fm[normval & 127];
                    }
                    state[j] = csj;
lbl41:
                    // 2 sources

                    if (sheight >= 3 && ((csj = state[j += sscanw]) >>> 1 & ~csj & 0x40004000) != 0) {
                        k = sk + (dscanw << 1);
                        if ((csj & 49152) == 32768) {
                            symbuf[nsym] = (data[k] & mask) >>> bp;
                            ctxtbuf[nsym++] = StdEntropyCoder.MR_LUT[csj & 511];
                            csj |= 256;
                            normval = data[k] >> downshift << upshift;
                            dist += fm[normval & 127];
                        }
                        if (sheight < 4) {
                            state[j] = csj;
                        } else {
                            if ((state[j] & -1073741824) == -2147483648) {
                                symbuf[nsym] = (data[k += dscanw] & mask) >>> bp;
                                ctxtbuf[nsym++] = StdEntropyCoder.MR_LUT[csj >>> 16 & 511];
                                csj |= 0x1000000;
                                normval = data[k] >> downshift << upshift;
                                dist += fm[normval & 127];
                            }
                            state[j] = csj;
                        }
                    }
                }
                ++sk;
                ++sj;
            }
            if (nsym > 0) {
                mq.codeSymbols(symbuf, ctxtbuf, nsym);
            }
            --s;
            sk += kstep;
            sj += jstep;
        }
        if ((options & 2) != 0) {
            mq.resetCtxts();
        }
        ratebuf[pidx] = doterm != false ? mq.terminate() : mq.getNumCodedBytes();
        if (ltpidx >= 0) {
            v0 = pidx;
            ratebuf[v0] = ratebuf[v0] + ratebuf[ltpidx];
        }
        if (doterm) {
            mq.finishLengthCalculation(ratebuf, pidx);
        }
        return dist;
    }

    private static int rawMagRefPass(CBlkWTData srcblk, BitToByteOutput bout, boolean doterm, int bp, int[] state, int[] fm, int[] ratebuf, int pidx, int ltpidx, int options) {
        int nsym = 0;
        int dscanw = srcblk.scanw;
        int sscanw = srcblk.w + 2;
        int jstep = sscanw * 4 / 2 - srcblk.w;
        int kstep = dscanw * 4 - srcblk.w;
        int mask = 1 << bp;
        int[] data = (int[])srcblk.getData();
        int nstripes = (srcblk.h + 4 - 1) / 4;
        int dist = 0;
        int shift = bp - 6;
        int upshift = shift >= 0 ? 0 : -shift;
        int downshift = shift <= 0 ? 0 : shift;
        int sk = srcblk.offset;
        int sj = sscanw + 1;
        int s2 = nstripes - 1;
        while (s2 >= 0) {
            int sheight = s2 != 0 ? 4 : srcblk.h - (nstripes - 1) * 4;
            int stopsk = sk + srcblk.w;
            while (sk < stopsk) {
                block12: {
                    int normval;
                    int k;
                    int csj;
                    int j;
                    block11: {
                        j = sj;
                        csj = state[j];
                        if ((csj >>> 1 & ~csj & 0x40004000) == 0) break block11;
                        k = sk;
                        if ((csj & 0xC000) == 32768) {
                            bout.writeBit((data[k] & mask) >>> bp);
                            ++nsym;
                            normval = data[k] >> downshift << upshift;
                            dist += fm[normval & 0x7F];
                        }
                        if (sheight < 2) break block12;
                        if ((csj & 0xC0000000) == Integer.MIN_VALUE) {
                            bout.writeBit((data[k += dscanw] & mask) >>> bp);
                            ++nsym;
                            normval = data[k] >> downshift << upshift;
                            dist += fm[normval & 0x7F];
                        }
                    }
                    if (sheight >= 3 && ((csj = state[j += sscanw]) >>> 1 & ~csj & 0x40004000) != 0) {
                        k = sk + (dscanw << 1);
                        if ((csj & 0xC000) == 32768) {
                            bout.writeBit((data[k] & mask) >>> bp);
                            ++nsym;
                            normval = data[k] >> downshift << upshift;
                            dist += fm[normval & 0x7F];
                        }
                        if (sheight >= 4 && (state[j] & 0xC0000000) == Integer.MIN_VALUE) {
                            bout.writeBit((data[k += dscanw] & mask) >>> bp);
                            ++nsym;
                            normval = data[k] >> downshift << upshift;
                            dist += fm[normval & 0x7F];
                        }
                    }
                }
                ++sk;
                ++sj;
            }
            --s2;
            sk += kstep;
            sj += jstep;
        }
        ratebuf[pidx] = doterm ? bout.terminate() : bout.length();
        if (ltpidx >= 0) {
            int n = pidx;
            ratebuf[n] = ratebuf[n] + ratebuf[ltpidx];
        }
        return dist;
    }

    /*
     * Unable to fully structure code
     */
    private static int cleanuppass(CBlkWTData srcblk, MQCoder mq, boolean doterm, int bp, int[] state, int[] fs, int[] zc_lut, int[] symbuf, int[] ctxtbuf, int[] ratebuf, int pidx, int ltpidx, int options) {
        nsym = 0;
        dscanw = srcblk.scanw;
        sscanw = srcblk.w + 2;
        jstep = sscanw * 4 / 2 - srcblk.w;
        kstep = dscanw * 4 - srcblk.w;
        mask = 1 << bp;
        data = (int[])srcblk.getData();
        nstripes = (srcblk.h + 4 - 1) / 4;
        dist = 0;
        shift = bp - 6;
        upshift = shift >= 0 ? 0 : -shift;
        downshift = shift <= 0 ? 0 : shift;
        causal = (options & 8) != 0;
        off_ul = -sscanw - 1;
        off_ur = -sscanw + 1;
        off_dr = sscanw + 1;
        off_dl = sscanw - 1;
        sk = srcblk.offset;
        sj = sscanw + 1;
        s = nstripes - 1;
        while (s >= 0) {
            sheight = s != 0 ? 4 : srcblk.h - (nstripes - 1) * 4;
            stopsk = sk + srcblk.w;
            nsym = 0;
            while (sk < stopsk) {
                block42: {
                    block44: {
                        block45: {
                            block46: {
                                block36: {
                                    block43: {
                                        block38: {
                                            block41: {
                                                block40: {
                                                    block39: {
                                                        block37: {
                                                            j = sj;
                                                            csj = state[j];
                                                            broken = false;
                                                            if (csj != 0 || state[j + sscanw] != 0 || sheight != 4) break block36;
                                                            k = sk;
                                                            if ((data[k] & mask) == 0) break block37;
                                                            rlclen = 0;
                                                            break block38;
                                                        }
                                                        if ((data[k += dscanw] & mask) == 0) break block39;
                                                        rlclen = 1;
                                                        break block38;
                                                    }
                                                    if ((data[k += dscanw] & mask) == 0) break block40;
                                                    rlclen = 2;
                                                    csj = state[j += sscanw];
                                                    break block38;
                                                }
                                                if ((data[k += dscanw] & mask) != 0) break block41;
                                                symbuf[nsym] = 0;
                                                ctxtbuf[nsym++] = 1;
                                                break block42;
                                            }
                                            rlclen = 3;
                                            csj = state[j += sscanw];
                                        }
                                        symbuf[nsym] = 1;
                                        ctxtbuf[nsym++] = 1;
                                        symbuf[nsym] = rlclen >> 1;
                                        ctxtbuf[nsym++] = 0;
                                        symbuf[nsym] = rlclen & 1;
                                        ctxtbuf[nsym++] = 0;
                                        normval = data[k] >> downshift << upshift;
                                        dist += fs[normval & 63];
                                        sym = data[k] >>> 31;
                                        if ((rlclen & 1) != 0) break block43;
                                        ctxt = StdEntropyCoder.SC_LUT[csj >>> 4 & 511];
                                        symbuf[nsym] = sym ^ ctxt >>> 31;
                                        ctxtbuf[nsym++] = ctxt & 15;
                                        if (rlclen != 0 || !causal) {
                                            v0 = j + off_ul;
                                            state[v0] = state[v0] | 0x20010000;
                                            v1 = j + off_ur;
                                            state[v1] = state[v1] | 0x20020000;
                                        }
                                        if (sym != 0) {
                                            csj |= 606126080;
                                            if (rlclen != 0 || !causal) {
                                                v2 = j - sscanw;
                                                state[v2] = state[v2] | 0x22100000;
                                            }
                                            v3 = j + 1;
                                            state[v3] = state[v3] | 537407616;
                                            v4 = j - 1;
                                            state[v4] = state[v4] | 537143360;
                                        } else {
                                            csj |= 0x2020C000;
                                            if (rlclen != 0 || !causal) {
                                                v5 = j - sscanw;
                                                state[v5] = state[v5] | 0x20100000;
                                            }
                                            v6 = j + 1;
                                            state[v6] = state[v6] | 0x20082080;
                                            v7 = j - 1;
                                            state[v7] = state[v7] | 0x20042040;
                                        }
                                        if (rlclen >> 1 != 0) {
                                            broken = true;
                                        }
                                        break block36;
                                    }
                                    ctxt = StdEntropyCoder.SC_LUT[csj >>> 20 & 511];
                                    symbuf[nsym] = sym ^ ctxt >>> 31;
                                    ctxtbuf[nsym++] = ctxt & 15;
                                    v8 = j + off_dl;
                                    state[v8] = state[v8] | 8196;
                                    v9 = j + off_dr;
                                    state[v9] = state[v9] | 8200;
                                    if (sym != 0) {
                                        csj |= -2147474928;
                                        v10 = j + sscanw;
                                        state[v10] = state[v10] | 9248;
                                        v11 = j + 1;
                                        state[v11] = state[v11] | 813703170;
                                        v12 = j - 1;
                                        state[v12] = state[v12] | 675291137;
                                    } else {
                                        csj |= -2147475440;
                                        v13 = j + sscanw;
                                        state[v13] = state[v13] | 8224;
                                        v14 = j + 1;
                                        state[v14] = state[v14] | 0x20802002;
                                        v15 = j - 1;
                                        state[v15] = state[v15] | 541073409;
                                    }
                                    state[j] = csj;
                                    if (rlclen >> 1 != 0) break block42;
                                    csj = state[j += sscanw];
                                    broken = true;
                                }
                                if (broken) break block44;
                                if (((csj >> 1 | csj) & 0x40004000) == 0x40004000) break block45;
                                k = sk;
                                if ((csj & 49152) == 0) {
                                    ctxtbuf[nsym] = zc_lut[csj & 255];
                                    symbuf[nsym++] = (data[k] & mask) >>> bp;
                                    if (symbuf[nsym++] != 0) {
                                        sym = data[k] >>> 31;
                                        ctxt = StdEntropyCoder.SC_LUT[csj >>> 4 & 511];
                                        symbuf[nsym] = sym ^ ctxt >>> 31;
                                        ctxtbuf[nsym++] = ctxt & 15;
                                        if (!causal) {
                                            v16 = j + off_ul;
                                            state[v16] = state[v16] | 0x20010000;
                                            v17 = j + off_ur;
                                            state[v17] = state[v17] | 0x20020000;
                                        }
                                        if (sym != 0) {
                                            csj |= 606126080;
                                            if (!causal) {
                                                v18 = j - sscanw;
                                                state[v18] = state[v18] | 0x22100000;
                                            }
                                            v19 = j + 1;
                                            state[v19] = state[v19] | 537407616;
                                            v20 = j - 1;
                                            state[v20] = state[v20] | 537143360;
                                        } else {
                                            csj |= 0x2020C000;
                                            if (!causal) {
                                                v21 = j - sscanw;
                                                state[v21] = state[v21] | 0x20100000;
                                            }
                                            v22 = j + 1;
                                            state[v22] = state[v22] | 0x20082080;
                                            v23 = j - 1;
                                            state[v23] = state[v23] | 0x20042040;
                                        }
                                        normval = data[k] >> downshift << upshift;
                                        dist += fs[normval & 63];
                                    }
                                }
                                if (sheight >= 2) break block46;
                                state[j] = csj &= -1073758209;
                                break block42;
                            }
                            if ((csj & -1073741824) == 0) {
                                ctxtbuf[nsym] = zc_lut[csj >>> 16 & 255];
                                symbuf[nsym++] = (data[k += dscanw] & mask) >>> bp;
                                if (symbuf[nsym++] != 0) {
                                    sym = data[k] >>> 31;
                                    ctxt = StdEntropyCoder.SC_LUT[csj >>> 20 & 511];
                                    symbuf[nsym] = sym ^ ctxt >>> 31;
                                    ctxtbuf[nsym++] = ctxt & 15;
                                    v24 = j + off_dl;
                                    state[v24] = state[v24] | 8196;
                                    v25 = j + off_dr;
                                    state[v25] = state[v25] | 8200;
                                    if (sym != 0) {
                                        csj |= -1073733104;
                                        v26 = j + sscanw;
                                        state[v26] = state[v26] | 9248;
                                        v27 = j + 1;
                                        state[v27] = state[v27] | 813703170;
                                        v28 = j - 1;
                                        state[v28] = state[v28] | 675291137;
                                    } else {
                                        csj |= -1073733616;
                                        v29 = j + sscanw;
                                        state[v29] = state[v29] | 8224;
                                        v30 = j + 1;
                                        state[v30] = state[v30] | 0x20802002;
                                        v31 = j - 1;
                                        state[v31] = state[v31] | 541073409;
                                    }
                                    normval = data[k] >> downshift << upshift;
                                    dist += fs[normval & 63];
                                }
                            }
                        }
                        state[j] = csj &= -1073758209;
                        if (sheight < 3) break block42;
                        csj = state[j += sscanw];
                    }
                    if (((csj >> 1 | csj) & 0x40004000) == 0x40004000) ** GOTO lbl260
                    k = sk + (dscanw << 1);
                    if ((csj & 49152) == 0) {
                        ctxtbuf[nsym] = zc_lut[csj & 255];
                        symbuf[nsym++] = (data[k] & mask) >>> bp;
                        if (symbuf[nsym++] != 0) {
                            sym = data[k] >>> 31;
                            ctxt = StdEntropyCoder.SC_LUT[csj >>> 4 & 511];
                            symbuf[nsym] = sym ^ ctxt >>> 31;
                            ctxtbuf[nsym++] = ctxt & 15;
                            v32 = j + off_ul;
                            state[v32] = state[v32] | 0x20010000;
                            v33 = j + off_ur;
                            state[v33] = state[v33] | 0x20020000;
                            if (sym != 0) {
                                csj |= 606126080;
                                v34 = j - sscanw;
                                state[v34] = state[v34] | 0x22100000;
                                v35 = j + 1;
                                state[v35] = state[v35] | 537407616;
                                v36 = j - 1;
                                state[v36] = state[v36] | 537143360;
                            } else {
                                csj |= 0x2020C000;
                                v37 = j - sscanw;
                                state[v37] = state[v37] | 0x20100000;
                                v38 = j + 1;
                                state[v38] = state[v38] | 0x20082080;
                                v39 = j - 1;
                                state[v39] = state[v39] | 0x20042040;
                            }
                            normval = data[k] >> downshift << upshift;
                            dist += fs[normval & 63];
                        }
                    }
                    if (sheight < 4) {
                        state[j] = csj &= -1073758209;
                    } else {
                        if ((csj & -1073741824) == 0) {
                            ctxtbuf[nsym] = zc_lut[csj >>> 16 & 255];
                            symbuf[nsym++] = (data[k += dscanw] & mask) >>> bp;
                            if (symbuf[nsym++] != 0) {
                                sym = data[k] >>> 31;
                                ctxt = StdEntropyCoder.SC_LUT[csj >>> 20 & 511];
                                symbuf[nsym] = sym ^ ctxt >>> 31;
                                ctxtbuf[nsym++] = ctxt & 15;
                                v40 = j + off_dl;
                                state[v40] = state[v40] | 8196;
                                v41 = j + off_dr;
                                state[v41] = state[v41] | 8200;
                                if (sym != 0) {
                                    csj |= -1073733104;
                                    v42 = j + sscanw;
                                    state[v42] = state[v42] | 9248;
                                    v43 = j + 1;
                                    state[v43] = state[v43] | 813703170;
                                    v44 = j - 1;
                                    state[v44] = state[v44] | 675291137;
                                } else {
                                    csj |= -1073733616;
                                    v45 = j + sscanw;
                                    state[v45] = state[v45] | 8224;
                                    v46 = j + 1;
                                    state[v46] = state[v46] | 0x20802002;
                                    v47 = j - 1;
                                    state[v47] = state[v47] | 541073409;
                                }
                                normval = data[k] >> downshift << upshift;
                                dist += fs[normval & 63];
                            }
                        }
lbl260:
                        // 6 sources

                        state[j] = csj &= -1073758209;
                    }
                }
                ++sk;
                ++sj;
            }
            if (nsym > 0) {
                mq.codeSymbols(symbuf, ctxtbuf, nsym);
            }
            --s;
            sk += kstep;
            sj += jstep;
        }
        if ((options & 32) != 0) {
            mq.codeSymbols(StdEntropyCoder.SEG_SYMBOLS, StdEntropyCoder.SEG_SYMB_CTXTS, StdEntropyCoder.SEG_SYMBOLS.length);
        }
        if ((options & 2) != 0) {
            mq.resetCtxts();
        }
        ratebuf[pidx] = doterm != false ? mq.terminate() : mq.getNumCodedBytes();
        if (ltpidx >= 0) {
            v48 = pidx;
            ratebuf[v48] = ratebuf[v48] + ratebuf[ltpidx];
        }
        if (doterm) {
            mq.finishLengthCalculation(ratebuf, pidx);
        }
        return dist;
    }

    private static void checkEndOfPassFF(byte[] data, int[] rates, boolean[] isterm, int n) {
        if (isterm == null) {
            --n;
            while (n >= 0) {
                int dp = rates[n] - 1;
                if (dp >= 0 && data[dp] == -1) {
                    int n2 = n;
                    rates[n2] = rates[n2] - 1;
                }
                --n;
            }
        } else {
            --n;
            while (n >= 0) {
                int dp;
                if (!isterm[n] && (dp = rates[n] - 1) >= 0 && data[dp] == -1) {
                    int n3 = n;
                    rates[n3] = rates[n3] - 1;
                }
                --n;
            }
        }
    }

    public void initTileComp(int nt, int nc) {
        this.opts = new int[nt][nc];
        this.lenCalc = new int[nt][nc];
        this.tType = new int[nt][nc];
        for (int t = 0; t < nt; ++t) {
            for (int c = 0; c < nc; ++c) {
                String lCalcType;
                this.opts[t][c] = 0;
                if (((String)this.bms.getTileCompVal(t, c)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[t];
                    int n = c;
                    nArray[n] = nArray[n] | 1;
                }
                if (((String)this.mqrs.getTileCompVal(t, c)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[t];
                    int n = c;
                    nArray[n] = nArray[n] | 2;
                }
                if (((String)this.rts.getTileCompVal(t, c)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[t];
                    int n = c;
                    nArray[n] = nArray[n] | 4;
                }
                if (((String)this.css.getTileCompVal(t, c)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[t];
                    int n = c;
                    nArray[n] = nArray[n] | 8;
                }
                if (((String)this.sss.getTileCompVal(t, c)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[t];
                    int n = c;
                    nArray[n] = nArray[n] | 0x20;
                }
                if ((lCalcType = (String)this.lcs.getTileCompVal(t, c)).equals("near_opt")) {
                    this.lenCalc[t][c] = 2;
                } else if (lCalcType.equals("lazy_good")) {
                    this.lenCalc[t][c] = 1;
                } else if (lCalcType.equals("lazy")) {
                    this.lenCalc[t][c] = 0;
                } else {
                    throw new IllegalArgumentException("Unrecognized or unsupported MQ length calculation.");
                }
                String termType = (String)this.tts.getTileCompVal(t, c);
                if (termType.equalsIgnoreCase("easy")) {
                    this.tType[t][c] = 2;
                    continue;
                }
                if (termType.equalsIgnoreCase("full")) {
                    this.tType[t][c] = 0;
                    continue;
                }
                if (termType.equalsIgnoreCase("near_opt")) {
                    this.tType[t][c] = 1;
                    continue;
                }
                if (termType.equalsIgnoreCase("predict")) {
                    this.tType[t][c] = 3;
                    int[] nArray = this.opts[t];
                    int n = c;
                    nArray[n] = nArray[n] | 0x10;
                    if ((this.opts[t][c] & 5) != 0) continue;
                    FacilityManager.getMsgLogger().printmsg(1, "Using error resilient MQ termination, but terminating only at the end of code-blocks. The error protection offered by this option will be very weak. Specify the 'Cterminate' and/or 'Cbypass' option for increased error resilience.");
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized or unsupported MQ coder termination.");
            }
        }
    }

    @Override
    public int getPPX(int t, int c, int rl) {
        return this.pss.getPPX(t, c, rl);
    }

    @Override
    public int getPPY(int t, int c, int rl) {
        return this.pss.getPPY(t, c, rl);
    }

    @Override
    public boolean precinctPartitionUsed(int c, int t) {
        return this.precinctPartition[c][t];
    }

    static {
        double deltaMSE;
        double val;
        int j;
        int i;
        ZC_LUT_LH = new int[256];
        ZC_LUT_HL = new int[256];
        ZC_LUT_HH = new int[256];
        SC_LUT = new int[512];
        MR_LUT = new int[512];
        MQ_INIT = new int[]{46, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        SEG_SYMBOLS = new int[]{1, 0, 1, 0};
        SEG_SYMB_CTXTS = new int[]{0, 0, 0, 0};
        FS_LOSSY = new int[64];
        FM_LOSSY = new int[128];
        FS_LOSSLESS = new int[64];
        FM_LOSSLESS = new int[128];
        StdEntropyCoder.ZC_LUT_LH[0] = 2;
        for (i = 1; i < 16; ++i) {
            StdEntropyCoder.ZC_LUT_LH[i] = 4;
        }
        for (i = 0; i < 4; ++i) {
            StdEntropyCoder.ZC_LUT_LH[1 << i] = 3;
        }
        for (i = 0; i < 16; ++i) {
            StdEntropyCoder.ZC_LUT_LH[0x20 | i] = 5;
            StdEntropyCoder.ZC_LUT_LH[0x10 | i] = 5;
            StdEntropyCoder.ZC_LUT_LH[0x30 | i] = 6;
        }
        StdEntropyCoder.ZC_LUT_LH[128] = 7;
        StdEntropyCoder.ZC_LUT_LH[64] = 7;
        for (i = 1; i < 16; ++i) {
            StdEntropyCoder.ZC_LUT_LH[0x80 | i] = 8;
            StdEntropyCoder.ZC_LUT_LH[0x40 | i] = 8;
        }
        for (i = 1; i < 4; ++i) {
            for (j = 0; j < 16; ++j) {
                StdEntropyCoder.ZC_LUT_LH[0x80 | i << 4 | j] = 9;
                StdEntropyCoder.ZC_LUT_LH[0x40 | i << 4 | j] = 9;
            }
        }
        for (i = 0; i < 64; ++i) {
            StdEntropyCoder.ZC_LUT_LH[0xC0 | i] = 10;
        }
        StdEntropyCoder.ZC_LUT_HL[0] = 2;
        for (i = 1; i < 16; ++i) {
            StdEntropyCoder.ZC_LUT_HL[i] = 4;
        }
        for (i = 0; i < 4; ++i) {
            StdEntropyCoder.ZC_LUT_HL[1 << i] = 3;
        }
        for (i = 0; i < 16; ++i) {
            StdEntropyCoder.ZC_LUT_HL[0x80 | i] = 5;
            StdEntropyCoder.ZC_LUT_HL[0x40 | i] = 5;
            StdEntropyCoder.ZC_LUT_HL[0xC0 | i] = 6;
        }
        StdEntropyCoder.ZC_LUT_HL[32] = 7;
        StdEntropyCoder.ZC_LUT_HL[16] = 7;
        for (i = 1; i < 16; ++i) {
            StdEntropyCoder.ZC_LUT_HL[0x20 | i] = 8;
            StdEntropyCoder.ZC_LUT_HL[0x10 | i] = 8;
        }
        for (i = 1; i < 4; ++i) {
            for (j = 0; j < 16; ++j) {
                StdEntropyCoder.ZC_LUT_HL[i << 6 | 0x20 | j] = 9;
                StdEntropyCoder.ZC_LUT_HL[i << 6 | 0x10 | j] = 9;
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 16; ++j) {
                StdEntropyCoder.ZC_LUT_HL[i << 6 | 0x20 | 0x10 | j] = 10;
            }
        }
        int[] twoBits = new int[]{3, 5, 6, 9, 10, 12};
        int[] oneBit = new int[]{1, 2, 4, 8};
        int[] twoLeast = new int[]{3, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15};
        int[] threeLeast = new int[]{7, 11, 13, 14, 15};
        StdEntropyCoder.ZC_LUT_HH[0] = 2;
        for (i = 0; i < oneBit.length; ++i) {
            StdEntropyCoder.ZC_LUT_HH[oneBit[i] << 4] = 3;
        }
        for (i = 0; i < twoLeast.length; ++i) {
            StdEntropyCoder.ZC_LUT_HH[twoLeast[i] << 4] = 4;
        }
        for (i = 0; i < oneBit.length; ++i) {
            StdEntropyCoder.ZC_LUT_HH[oneBit[i]] = 5;
        }
        for (i = 0; i < oneBit.length; ++i) {
            for (j = 0; j < oneBit.length; ++j) {
                StdEntropyCoder.ZC_LUT_HH[oneBit[i] << 4 | oneBit[j]] = 6;
            }
        }
        for (i = 0; i < twoLeast.length; ++i) {
            for (j = 0; j < oneBit.length; ++j) {
                StdEntropyCoder.ZC_LUT_HH[twoLeast[i] << 4 | oneBit[j]] = 7;
            }
        }
        for (i = 0; i < twoBits.length; ++i) {
            StdEntropyCoder.ZC_LUT_HH[twoBits[i]] = 8;
        }
        for (j = 0; j < twoBits.length; ++j) {
            for (i = 1; i < 16; ++i) {
                StdEntropyCoder.ZC_LUT_HH[i << 4 | twoBits[j]] = 9;
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < threeLeast.length; ++j) {
                StdEntropyCoder.ZC_LUT_HH[i << 4 | threeLeast[j]] = 10;
            }
        }
        int[] inter_sc_lut = new int[36];
        inter_sc_lut[18] = 15;
        inter_sc_lut[17] = 14;
        inter_sc_lut[16] = 13;
        inter_sc_lut[10] = 12;
        inter_sc_lut[9] = 11;
        inter_sc_lut[8] = -2147483636;
        inter_sc_lut[2] = -2147483635;
        inter_sc_lut[1] = -2147483634;
        inter_sc_lut[0] = -2147483633;
        for (i = 0; i < 511; ++i) {
            int ds = i & 1;
            int us = i >> 1 & 1;
            int rs = i >> 2 & 1;
            int ls = i >> 3 & 1;
            int dsgn = i >> 5 & 1;
            int usgn = i >> 6 & 1;
            int lsgn = i >> 8 & 1;
            int rsgn = i >> 7 & 1;
            int h2 = ls * (1 - 2 * lsgn) + rs * (1 - 2 * rsgn);
            h2 = h2 >= -1 ? h2 : -1;
            h2 = h2 <= 1 ? h2 : 1;
            int v = us * (1 - 2 * usgn) + ds * (1 - 2 * dsgn);
            v = v >= -1 ? v : -1;
            v = v <= 1 ? v : 1;
            StdEntropyCoder.SC_LUT[i] = inter_sc_lut[h2 + 1 << 3 | v + 1];
        }
        inter_sc_lut = null;
        StdEntropyCoder.MR_LUT[0] = 16;
        for (i = 1; i < 256; ++i) {
            StdEntropyCoder.MR_LUT[i] = 17;
        }
        while (i < 512) {
            StdEntropyCoder.MR_LUT[i] = 18;
            ++i;
        }
        for (i = 0; i < 64; ++i) {
            val = (double)i / 64.0 + 1.0;
            deltaMSE = val * val;
            StdEntropyCoder.FS_LOSSLESS[i] = (int)Math.floor(deltaMSE * 8192.0 + 0.5);
            StdEntropyCoder.FS_LOSSY[i] = (int)Math.floor((deltaMSE -= (val -= 1.5) * val) * 8192.0 + 0.5);
        }
        for (i = 0; i < 128; ++i) {
            val = (double)i / 64.0;
            deltaMSE = (val - 1.0) * (val - 1.0);
            StdEntropyCoder.FM_LOSSLESS[i] = (int)Math.floor(deltaMSE * 8192.0 + 0.5);
            StdEntropyCoder.FM_LOSSY[i] = (int)Math.floor((deltaMSE -= (val -= i < 64 ? 0.5 : 1.5) * val) * 8192.0 + 0.5);
        }
    }

    private class Compressor
    implements Runnable {
        private final int idx;
        CBlkRateDistStats ccb;
        int c;
        int options;
        boolean rev;
        int lcType;
        int tType;
        private long[] time;

        Compressor(int idx) {
            this.idx = idx;
        }

        @Override
        public void run() {
            try {
                long stime = 0L;
                StdEntropyCoder.compressCodeBlock(this.c, this.ccb, StdEntropyCoder.this.srcblkT[this.idx], StdEntropyCoder.this.mqT[this.idx], StdEntropyCoder.this.boutT[this.idx], StdEntropyCoder.this.outT[this.idx], StdEntropyCoder.this.stateT[this.idx], StdEntropyCoder.this.distbufT[this.idx], StdEntropyCoder.this.ratebufT[this.idx], StdEntropyCoder.this.istermbufT[this.idx], StdEntropyCoder.this.symbufT[this.idx], StdEntropyCoder.this.ctxtbufT[this.idx], this.options, this.rev, this.lcType, this.tType);
            }
            finally {
                StdEntropyCoder.this.completedComps[this.c].push(this);
            }
        }

        synchronized long getTiming(int c) {
            return 0L;
        }

        public int getIdx() {
            return this.idx;
        }
    }
}

