/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewGroupDialog
extends JDialog
implements ActionListener,
ItemListener,
KeyListener {
    private static final long serialVersionUID = 7340860373483987075L;
    private JTextField nameField;
    private JTextField compactField;
    private JTextField indexedField;
    private JComboBox parentChoice;
    private JCheckBox useCreationOrder;
    private JCheckBox setLinkStorage;
    private JComboBox orderFlags;
    private List<Group> groupList;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;
    private int creationOrder;
    private JPanel useCreationOrderJPanel;
    private JPanel setLinkStorageJPanel;
    private JButton moreButton;
    private JPanel labelPanel;
    private JPanel textPanel;
    private JPanel contentPane;
    private JButton creationOrderHelpButton;
    private JButton storageTypeHelpButton;
    private boolean isH5;

    public NewGroupDialog(Frame owner, Group pGroup, List<?> objs) {
        super(owner, "New Group...", true);
        this.fileFormat = pGroup.getFileFormat();
        this.isH5 = pGroup.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.toolkit = Toolkit.getDefaultToolkit();
        this.parentChoice = new JComboBox();
        this.groupList = new Vector<Group>();
        Object obj2 = null;
        for (Object obj2 : objs) {
            if (!(obj2 instanceof Group)) continue;
            this.groupList.add(obj2);
            Group g = obj2;
            if (g.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(g.getPath() + g.getName() + "/");
        }
        if (pGroup.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(pGroup.getPath() + pGroup.getName() + "/");
        }
        this.orderFlags = new JComboBox();
        this.orderFlags.addItem("Tracked");
        this.orderFlags.addItem("Tracked+Indexed");
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout(5, 5));
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 150 + (ViewProperties.getFontSize() - 12) * 10;
        this.contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setName("OK");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.moreButton = new JButton("More");
        this.moreButton.setName("More");
        this.moreButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.contentPane.add((Component)buttonPanel, "South");
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout(5, 5));
        this.labelPanel = new JPanel();
        this.textPanel = new JPanel();
        if (!this.isH5) {
            this.labelPanel.setLayout(new GridLayout(2, 1));
            this.labelPanel.add(new JLabel("Group name: "));
            this.labelPanel.add(new JLabel("Parent group: "));
            this.textPanel.setLayout(new GridLayout(2, 1));
            this.nameField = new JTextField();
            this.textPanel.add(this.nameField);
            this.textPanel.add(this.parentChoice);
        } else {
            this.labelPanel.setLayout(new GridLayout(3, 1));
            this.labelPanel.add(new JLabel("Group name: "));
            this.labelPanel.add(new JLabel("Parent group: "));
            this.labelPanel.add(this.moreButton);
            this.textPanel.setLayout(new GridLayout(3, 1));
            this.nameField = new JTextField();
            this.textPanel.add(this.nameField);
            this.textPanel.add(this.parentChoice);
            this.textPanel.add(new JLabel(""));
        }
        this.nameField.setName("groupname");
        this.creationOrderHelpButton = new JButton(ViewProperties.getHelpIcon());
        this.creationOrderHelpButton.setToolTipText("Help on Creation Order");
        this.creationOrderHelpButton.setMargin(new Insets(0, 0, 0, 0));
        this.creationOrderHelpButton.addActionListener(this);
        this.creationOrderHelpButton.setActionCommand("Help on Creation Order");
        this.storageTypeHelpButton = new JButton(ViewProperties.getHelpIcon());
        this.storageTypeHelpButton.setToolTipText("Help on set Link Storage");
        this.storageTypeHelpButton.setMargin(new Insets(0, 0, 0, 0));
        this.storageTypeHelpButton.addActionListener(this);
        this.storageTypeHelpButton.setActionCommand("Help on set Link Storage");
        namePanel.add((Component)this.labelPanel, "West");
        this.useCreationOrderJPanel = new JPanel();
        this.useCreationOrderJPanel.setLayout(new GridLayout(1, 2));
        this.useCreationOrderJPanel.setBorder(new TitledBorder(""));
        this.useCreationOrder = new JCheckBox("Use Creation Order");
        this.useCreationOrderJPanel.add(this.useCreationOrder);
        this.useCreationOrder.addItemListener(this);
        JPanel orderFlagsJPanel = new JPanel();
        orderFlagsJPanel.setLayout(new GridLayout(1, 2));
        orderFlagsJPanel.add(new JLabel("Order Flags: "));
        orderFlagsJPanel.add(this.orderFlags);
        this.orderFlags.setEnabled(false);
        this.useCreationOrderJPanel.add(orderFlagsJPanel);
        this.setLinkStorageJPanel = new JPanel();
        this.setLinkStorageJPanel.setLayout(new GridLayout(1, 2));
        this.setLinkStorageJPanel.setBorder(new TitledBorder(""));
        this.setLinkStorage = new JCheckBox("Set Link Storage");
        this.setLinkStorageJPanel.add(this.setLinkStorage);
        this.setLinkStorage.addItemListener(this);
        JPanel storageTypeJPanel = new JPanel();
        storageTypeJPanel.setLayout(new GridLayout(2, 2));
        storageTypeJPanel.add(new JLabel("Min Indexed: "));
        storageTypeJPanel.add(new JLabel("Max Compact: "));
        this.indexedField = new JTextField();
        this.indexedField.addKeyListener(this);
        storageTypeJPanel.add(this.indexedField);
        this.indexedField.setDocument(new JTextFieldLimit(5));
        this.indexedField.setText("6");
        this.indexedField.setEnabled(false);
        this.compactField = new JTextField();
        storageTypeJPanel.add(this.compactField);
        this.compactField.addKeyListener(this);
        this.compactField.setDocument(new JTextFieldLimit(5));
        this.compactField.setText("8");
        this.compactField.setEnabled(false);
        this.setLinkStorageJPanel.add(storageTypeJPanel);
        namePanel.add((Component)this.textPanel, "Center");
        this.contentPane.add((Component)namePanel, "Center");
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int h;
        int w;
        String cmd = e.getActionCommand();
        if (cmd.equals("More")) {
            this.moreButton.setText("Less");
            w = 500 + (ViewProperties.getFontSize() - 12) * 15;
            h = 280 + (ViewProperties.getFontSize() - 12) * 10;
            this.contentPane.setPreferredSize(new Dimension(w, h));
            this.labelPanel.setLayout(new GridLayout(5, 1));
            this.labelPanel.add(this.creationOrderHelpButton);
            this.labelPanel.add(this.storageTypeHelpButton);
            this.textPanel.setLayout(new GridLayout(5, 1));
            this.textPanel.add(this.useCreationOrderJPanel);
            this.textPanel.add(this.setLinkStorageJPanel);
            this.validate();
            this.pack();
        }
        if (cmd.equals("Less")) {
            this.moreButton.setText("More");
            w = 400 + (ViewProperties.getFontSize() - 12) * 15;
            h = 150 + (ViewProperties.getFontSize() - 12) * 10;
            this.contentPane.setPreferredSize(new Dimension(w, h));
            this.labelPanel.setLayout(new GridLayout(3, 1));
            this.labelPanel.remove(this.creationOrderHelpButton);
            this.labelPanel.remove(this.storageTypeHelpButton);
            this.textPanel.setLayout(new GridLayout(3, 1));
            this.textPanel.remove(this.useCreationOrderJPanel);
            this.textPanel.remove(this.setLinkStorageJPanel);
            this.useCreationOrder.setSelected(false);
            this.setLinkStorage.setSelected(false);
            this.validate();
            this.pack();
        }
        if (cmd.equals("Help on Creation Order")) {
            String msg = "Use Creation Order allows the user to set the creation order \nof links in a group, so that tracking, indexing, and iterating over links\nin groups can be possible. \n\nIf the order flag Tracked is selected, links in a group can now \nbe explicitly tracked by the order that they were created. \n\nIf the order flag Tracked+Indexed is selected, links in a group can \nnow be explicitly tracked and indexed in the order that they were created. \n\nThe default order in which links in a group are listed is alphanumeric-by-name. \n\n\n";
            JOptionPane.showMessageDialog(this, "Use Creation Order allows the user to set the creation order \nof links in a group, so that tracking, indexing, and iterating over links\nin groups can be possible. \n\nIf the order flag Tracked is selected, links in a group can now \nbe explicitly tracked by the order that they were created. \n\nIf the order flag Tracked+Indexed is selected, links in a group can \nnow be explicitly tracked and indexed in the order that they were created. \n\nThe default order in which links in a group are listed is alphanumeric-by-name. \n\n\n");
        }
        if (cmd.equals("Help on set Link Storage")) {
            String msg = "Set Link Storage allows the users to explicitly set the storage  \ntype of a group to be Compact or Indexed. \n\nCompact Storage: For groups with only a few links, compact link storage\nallows groups containing only a few links to take up much less space \nin the file. \n\nIndexed Storage: For groups with large number of links, indexed link storage  \nprovides a faster and more scalable method for storing and working with  \nlarge groups containing many links. \n\nThe threshold for switching between the compact and indexed storage   \nformats is either set to default values or can be set by the user. \n\n<html><b>Max Compact</b></html> \nMax Compact is the maximum number of links to store in the group in a  \ncompact format, before converting the group to the Indexed format. Groups \nthat are in compact format and in which the number of links rises above \n this threshold are automatically converted to indexed format. \n\n<html><b>Min Indexed</b></html> \nMin Indexed is the minimum number of links to store in the Indexed format.   \nGroups which are in indexed format and in which the number of links falls    \nbelow this threshold are automatically converted to compact format. \n\n\n";
            JOptionPane.showMessageDialog(this, "Set Link Storage allows the users to explicitly set the storage  \ntype of a group to be Compact or Indexed. \n\nCompact Storage: For groups with only a few links, compact link storage\nallows groups containing only a few links to take up much less space \nin the file. \n\nIndexed Storage: For groups with large number of links, indexed link storage  \nprovides a faster and more scalable method for storing and working with  \nlarge groups containing many links. \n\nThe threshold for switching between the compact and indexed storage   \nformats is either set to default values or can be set by the user. \n\n<html><b>Max Compact</b></html> \nMax Compact is the maximum number of links to store in the group in a  \ncompact format, before converting the group to the Indexed format. Groups \nthat are in compact format and in which the number of links rises above \n this threshold are automatically converted to indexed format. \n\n<html><b>Min Indexed</b></html> \nMin Indexed is the minimum number of links to store in the Indexed format.   \nGroups which are in indexed format and in which the number of links falls    \nbelow this threshold are automatically converted to compact format. \n\n\n");
        }
        if (cmd.equals("Ok")) {
            this.newObject = this.create();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (cmd.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
        }
    }

    private HObject create() {
        String name = null;
        Group pgroup = null;
        int gcpl = 0;
        name = this.nameField.getText();
        if (name == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Group name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (name.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Group name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        pgroup = this.groupList.get(this.parentChoice.getSelectedIndex());
        if (pgroup == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        Group obj = null;
        if (this.orderFlags.isEnabled()) {
            String order = (String)this.orderFlags.getSelectedItem();
            if (order.equals("Tracked")) {
                this.creationOrder = 1;
            } else if (order.equals("Tracked+Indexed")) {
                this.creationOrder = 2;
            }
        } else {
            this.creationOrder = 0;
        }
        if (this.orderFlags.isEnabled() || this.setLinkStorage.isSelected()) {
            int maxCompact = Integer.parseInt(this.compactField.getText());
            int minDense = Integer.parseInt(this.indexedField.getText());
            if (maxCompact <= 0 || maxCompact > 65536 || minDense > 65536) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Max Compact and Min Indexed should be > 0 and < 65536.", this.getTitle(), 0);
                return null;
            }
            if (maxCompact < minDense) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Min Indexed should be <= Max Compact", this.getTitle(), 0);
                return null;
            }
            try {
                gcpl = this.fileFormat.createGcpl(this.creationOrder, maxCompact, minDense);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            obj = this.isH5 ? this.fileFormat.createGroup(name, pgroup, new int[]{0, gcpl}) : this.fileFormat.createGroup(name, pgroup);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return null;
        }
        return obj;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return this.groupList.get(this.parentChoice.getSelectedIndex());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.useCreationOrder)) {
            boolean isOrder = this.useCreationOrder.isSelected();
            if (isOrder) {
                this.orderFlags.setEnabled(true);
            } else {
                this.orderFlags.setEnabled(false);
            }
        }
        if (source.equals(this.setLinkStorage)) {
            boolean setStorage = this.setLinkStorage.isSelected();
            if (setStorage) {
                this.compactField.setEnabled(true);
                this.indexedField.setEnabled(true);
            } else {
                this.compactField.setText("8");
                this.compactField.setEnabled(false);
                this.indexedField.setText("6");
                this.indexedField.setEnabled(false);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
        char c = arg0.getKeyChar();
        if (!Character.isDigit(c)) {
            arg0.consume();
        }
    }

    class JTextFieldLimit
    extends PlainDocument {
        private static final long serialVersionUID = -5131438789797052658L;
        private int limit;

        JTextFieldLimit(int limit) {
            this.limit = limit;
        }

        JTextFieldLimit(int limit, boolean upper) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

