/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JdbcSQLConnector {
    private String hostname;
    private String database;
    private String username;
    private String passwd;
    private String driver;
    private Connection con;
    private Statement stmt;
    static transient HashMap<String, ConnectionInfo> connPool;
    private transient Set<ResultSet> resultSetPool;

    public String getKey() {
        return this.hostname + this.database + this.username + this.driver;
    }

    public JdbcSQLConnector(String hostname, String database, String username, String passwd, String driver) {
        this.hostname = hostname;
        this.database = database;
        this.username = username;
        this.passwd = passwd;
        this.driver = driver;
        try {
            if (driver.equalsIgnoreCase("jdbc:postgresql")) {
                Class.forName("org.postgresql.Driver");
            }
            if (driver.equalsIgnoreCase("jdbc:mysql")) {
                Class.forName("org.gjt.mm.mysql.Driver");
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        if (connPool == null) {
            connPool = new HashMap();
        }
        this.resultSetPool = new HashSet<ResultSet>();
    }

    public void connect() throws SQLException {
        ConnectionInfo info = connPool.get(this.getKey());
        if (info != null) {
            this.con = info.connection;
            ++info.useCount;
        }
        if (this.con == null || this.con.isClosed()) {
            this.con = DriverManager.getConnection(this.driver + "://" + this.hostname + "/" + this.database + "?autoReconnect=true", this.username, this.passwd);
            info = new ConnectionInfo();
            info.connection = this.con;
            ++info.useCount;
            connPool.put(this.getKey(), info);
        }
    }

    public int execUpdate(String sqlQuery) throws SQLException {
        if (this.con == null) {
            this.connect();
        }
        int trialCount = 0;
        while (!this.con.isValid(10) && trialCount++ < 4) {
            System.err.println("lost connection to database, attempt " + trialCount + " of 4 to reconnect");
            this.connect();
        }
        Statement stmt = this.con.createStatement();
        int result = stmt.executeUpdate(sqlQuery);
        stmt.close();
        return result;
    }

    public ResultSet execQuery(String sqlQuery) throws SQLException {
        if (this.con == null) {
            this.connect();
        }
        int trialCount = 0;
        while (true) {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                this.stmt = this.con.createStatement();
                ResultSet rs = this.stmt.executeQuery(sqlQuery);
                this.resultSetPool.add(rs);
                return rs;
            }
            catch (SQLException sqlex) {
                if (++trialCount > 4) {
                    throw sqlex;
                }
                this.connect();
                System.err.println("lost connection to database, attempt " + trialCount + " of 4 to reconnect" + sqlex.toString());
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                }
                continue;
            }
            break;
        }
    }

    public boolean isValid() throws SQLException {
        return this.con.isValid(10);
    }

    public void close() throws SQLException {
        ConnectionInfo info = connPool.get(this.getKey());
        if (info == null) {
            return;
        }
        --info.useCount;
        if (info.useCount == 0) {
            this.con.close();
            this.con = null;
            connPool.remove(this.getKey());
        }
        for (ResultSet set : this.resultSetPool) {
            set.close();
        }
        if (this.resultSetPool.size() > 0) {
            System.out.println("warning: resultSet-Pool was not empty after close");
        }
        this.resultSetPool.clear();
    }

    private class ConnectionInfo {
        Connection connection;
        int useCount;

        private ConnectionInfo() {
        }
    }
}

