/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.workspace.DataReader;
import jams.workspace.DataSet;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.Workspace;
import jams.workspace.datatypes.CalendarValue;
import jams.workspace.datatypes.DoubleValue;
import jams.workspace.datatypes.LongValue;
import jams.workspace.datatypes.ObjectValue;
import jams.workspace.datatypes.StringValue;
import jams.workspace.plugins.JdbcSQLConnector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class JdbcSQL
implements DataReader {
    static final int DOUBLE = 0;
    static final int LONG = 1;
    static final int STRING = 2;
    static final int TIMESTAMP = 3;
    static final int OBJECT = 4;
    private String user;
    private String password;
    private String host;
    private String db;
    private String query;
    private String metadataQuery;
    private String driver;
    private transient JdbcSQLConnector pgsql = null;
    private transient QueryResult metadataResult = null;
    private transient QueryResult dataResult = null;
    private final boolean alwaysReconnect = false;
    private DefaultDataSet[] currentData = null;
    private DefaultDataSet[] currentMetadata = null;
    private boolean isClosed = true;
    private int offset = 0;

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public DefaultDataSet[] getData() {
        return this.currentData;
    }

    public DataReader.ReaderType getReaderType() {
        if (this.metadataQuery != null && this.query != null) {
            return DataReader.ReaderType.ContentAndMetadataReader;
        }
        if (this.metadataQuery != null) {
            return DataReader.ReaderType.MetadataReader;
        }
        if (this.query != null) {
            return DataReader.ReaderType.ContentReader;
        }
        return DataReader.ReaderType.Empty;
    }

    public int numberOfColumns() {
        return this.dataResult.numberOfColumns;
    }

    public String getMetadataQuery() {
        return this.metadataQuery;
    }

    public void setMetadataQuery(String metadataQuery) {
        this.metadataQuery = metadataQuery;
    }

    public int fetchValues() {
        return this.fetchValues(Integer.MAX_VALUE);
    }

    public int fetchValues(int count) {
        if (this.getReaderType() != DataReader.ReaderType.ContentReader && this.getReaderType() != DataReader.ReaderType.ContentAndMetadataReader) {
            return 0;
        }
        if (this.dataResult == null) {
            this.query();
        }
        this.currentData = this.queryResultToDataSet(this.dataResult, count);
        this.offset += this.currentData.length;
        return 0;
    }

    public DataSet getMetadata(int i) {
        if (this.getReaderType() != DataReader.ReaderType.MetadataReader && this.getReaderType() != DataReader.ReaderType.ContentAndMetadataReader) {
            return null;
        }
        if (this.isClosed) {
            this.establishConnection();
        }
        if (this.currentMetadata == null) {
            this.metadataResult = this.executeQuery(this.getMetadataQuery());
            this.currentMetadata = this.queryResultToDataSet(this.metadataResult, 10000L);
        }
        if (this.currentMetadata == null) {
            return null;
        }
        return this.currentMetadata[i];
    }

    DefaultDataSet[] queryResultToDataSet(QueryResult r, long count) {
        ArrayList<DefaultDataSet> data = new ArrayList<DefaultDataSet>();
        if (r == null || r.rs == null) {
            return null;
        }
        try {
            int i = 0;
            while ((long)i < count && r.rs.next()) {
                ++i;
                DefaultDataSet dataSet = new DefaultDataSet(r.numberOfColumns);
                block11: for (int j = 0; j < r.numberOfColumns; ++j) {
                    switch (r.type[j]) {
                        case 0: {
                            double v = r.rs.getDouble(j + 1);
                            Object value = !r.rs.wasNull() ? new DoubleValue(v) : new StringValue("");
                            dataSet.setData(j, (DataValue)value);
                            continue block11;
                        }
                        case 1: {
                            Object value = new LongValue(r.rs.getLong(j + 1));
                            dataSet.setData(j, (DataValue)value);
                            continue block11;
                        }
                        case 2: {
                            Object value = new StringValue(r.rs.getString(j + 1));
                            dataSet.setData(j, (DataValue)value);
                            continue block11;
                        }
                        case 3: {
                            Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
                            GregorianCalendar greg = new GregorianCalendar();
                            greg.setTimeZone(TimeZone.getTimeZone("GMT"));
                            cal.setTimeInMillis(r.rs.getDate(j + 1, (Calendar)greg).getTime());
                            String date = r.rs.getString(j + 1);
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
                            try {
                                long millis = format.parse(date + " +0000").getTime();
                                cal.setTimeInMillis(millis);
                            }
                            catch (Exception e) {
                                throw new SQLException(e.toString());
                            }
                            Object value = new CalendarValue(cal);
                            dataSet.setData(j, (DataValue)value);
                            continue block11;
                        }
                        default: {
                            Object value = new ObjectValue(r.rs.getObject(j + 1));
                            dataSet.setData(j, (DataValue)value);
                        }
                    }
                }
                data.add(dataSet);
            }
        }
        catch (SQLException sqlex) {
            System.out.println("jdbcSQL: " + sqlex);
            sqlex.printStackTrace();
        }
        return data.toArray(new DefaultDataSet[data.size()]);
    }

    QueryResult executeQuery(String query) {
        if (this.isClosed || query == null) {
            return null;
        }
        QueryResult result = new QueryResult();
        try {
            ResultSet rs = null;
            if (rs != null) {
                rs.close();
            }
            rs = this.pgsql.execQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            int[] type = new int[numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                type[i] = rsmd.getColumnTypeName(i + 1).startsWith("int") || rsmd.getColumnTypeName(i + 1).startsWith("INT") || rsmd.getColumnTypeName(i + 1).startsWith("integer") || rsmd.getColumnTypeName(i + 1).startsWith("INTEGER") ? 1 : (rsmd.getColumnTypeName(i + 1).startsWith("float") || rsmd.getColumnTypeName(i + 1).startsWith("FLOAT") ? 0 : (rsmd.getColumnTypeName(i + 1).startsWith("double") || rsmd.getColumnTypeName(i + 1).startsWith("DOUBLE") ? 0 : (rsmd.getColumnTypeName(i + 1).startsWith("numeric") || rsmd.getColumnTypeName(i + 1).startsWith("NUMERIC") ? 0 : (rsmd.getColumnTypeName(i + 1).startsWith("varchar") || rsmd.getColumnTypeName(i + 1).startsWith("VARCHAR") ? 2 : (rsmd.getColumnTypeName(i + 1).startsWith("datetime") || rsmd.getColumnTypeName(i + 1).startsWith("DATETIME") ? 3 : 4)))));
            }
            result.numberOfColumns = numberOfColumns;
            result.type = type;
            result.rs = rs;
        }
        catch (SQLException sqlex) {
            System.err.println("jdbcSQL: " + sqlex);
            sqlex.printStackTrace();
            return null;
        }
        return result;
    }

    private boolean skip(long count) {
        try {
            this.dataResult.rs.relative((int)count - 1);
            this.dataResult.rs.next();
            System.out.println("after skip position is: " + this.dataResult.rs.getString(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    void establishConnection() {
        try {
            if (this.pgsql == null) {
                this.pgsql = new JdbcSQLConnector(this.host, this.db, this.user, this.password, this.driver);
                this.pgsql.connect();
                this.isClosed = false;
            } else {
                this.getClass();
            }
        }
        catch (SQLException sqlex) {
            System.err.println("jdbcSQL: " + sqlex);
            sqlex.printStackTrace();
            this.isClosed = true;
        }
    }

    public void query() {
        this.establishConnection();
        this.dataResult = this.executeQuery(this.query);
    }

    public int init() {
        this.offset = 0;
        if (this.db == null) {
            return -1;
        }
        if (this.user == null) {
            return -1;
        }
        if (this.password == null) {
            return -1;
        }
        if (this.host == null) {
            return -1;
        }
        if (this.query == null && this.metadataQuery == null) {
            return -1;
        }
        if (this.driver == null) {
            this.driver = "jdbc:postgresql";
        }
        return 1;
    }

    private int closeResult(QueryResult r) {
        try {
            if (r != null && r.rs != null) {
                r.rs.close();
                r.rs = null;
            }
        }
        catch (SQLException sqlex) {
            System.out.println("jdbcSQL: " + sqlex);
            sqlex.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int cleanup() {
        try {
            if (this.closeResult(this.metadataResult) != 0) {
                return -1;
            }
            if (this.closeResult(this.dataResult) != 0) {
                return -1;
            }
            if (this.pgsql != null) {
                this.pgsql.close();
                this.pgsql = null;
                this.isClosed = true;
            }
        }
        catch (SQLException sqlex) {
            System.out.println("jdbcSQL: " + sqlex);
            return -1;
        }
        return 0;
    }

    public void setWorkspace(Workspace ws) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.isClosed) {
            this.cleanup();
            return;
        }
        this.query();
        this.skip(this.offset);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    static class QueryResult {
        ResultSet rs;
        int numberOfColumns = -1;
        int[] type;

        QueryResult() {
        }
    }
}

