/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins;

import de.odysseus.el.util.SimpleContext;
import de.odysseus.el.util.SimpleResolver;
import jams.data.JAMSData;
import jams.model.Context;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import jams.workspace.plugins.JdbcSQLConnector;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseOutputDataStore
implements OutputDataStore {
    private static final String TRACE_STRING = "attribute";
    private static final String FILTER_STRING = "filter";
    private static final String CONTEXT_STRING = "context";
    private static final String EXPRESSION_STRING = "expression";
    private static final String ATTRIBUTE_STRING = "id";
    private String id;
    private String[] attributes;
    private DefaultFilter[] filters;
    private String user;
    private String password;
    private String host;
    private String db;
    private String driver;
    private String genericSqlStatement;
    private boolean dataStarted;
    private transient JdbcSQLConnector pgsql;
    ArrayList<String> lineArray = new ArrayList(20);

    public void setUser(String user) {
        this.user = user;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setQuery(String query) {
        this.genericSqlStatement = query;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setDoc(Document doc) {
        Element root = doc.getDocumentElement();
        NodeList traceNodes = root.getElementsByTagName(TRACE_STRING);
        int length = traceNodes.getLength();
        this.attributes = new String[length];
        for (int i = 0; i < length; ++i) {
            Element traceElement = (Element)traceNodes.item(i);
            this.attributes[i] = traceElement.getAttribute(ATTRIBUTE_STRING);
        }
        NodeList filterNodes = root.getElementsByTagName(FILTER_STRING);
        length = filterNodes.getLength();
        this.filters = new DefaultFilter[length];
        for (int i = 0; i < length; ++i) {
            Element filterElement = (Element)filterNodes.item(i);
            this.filters[i] = new DefaultFilter(filterElement.getAttribute(CONTEXT_STRING), filterElement.getAttribute(EXPRESSION_STRING));
        }
    }

    public String getID() {
        return this.id;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void open(boolean append) throws IOException {
        if (this.host == null) {
            throw new IOException("unknown host");
        }
        if (this.db == null) {
            throw new IOException("unknown database");
        }
        if (this.user == null) {
            throw new IOException("unknown user");
        }
        if (this.password == null) {
            throw new IOException("unknown password");
        }
        if (this.driver == null) {
            throw new IOException("unknown driver");
        }
        if (this.genericSqlStatement == null) {
            throw new IOException("unknown sql query");
        }
        if (this.pgsql != null) {
            this.close();
        }
        this.pgsql = new JdbcSQLConnector(this.host, this.db, this.user, this.password, this.driver);
        try {
            this.dataStarted = false;
            this.pgsql.connect();
        }
        catch (SQLException sqlex) {
            System.err.println("DatabaseOutputDataStore: " + sqlex);
            sqlex.printStackTrace();
            throw new IOException(sqlex.toString());
        }
        this.dataStarted = false;
    }

    public void write(Object o) throws IOException {
        if (o.toString().contains("@data")) {
            this.dataStarted = true;
        }
    }

    public void writeCell(Object o) {
        if (o.toString().contains("@data")) {
            this.dataStarted = true;
        } else if (this.dataStarted) {
            this.lineArray.add(o.toString());
        }
    }

    public void nextRow() throws IOException {
        String sqlStatement = this.genericSqlStatement;
        for (int i = 1; i <= this.lineArray.size(); ++i) {
            sqlStatement = sqlStatement.replace("#" + i, "\"" + this.lineArray.get(i - 1) + "\"");
        }
        try {
            if (!sqlStatement.contains("#")) {
                this.pgsql.execUpdate(sqlStatement);
            } else {
                String str = "->";
                for (int i = 1; i <= this.lineArray.size(); ++i) {
                    str = str + this.lineArray.get(i - 1) + "<->";
                }
                System.err.println("DatabaseOutputDataStore: skip line, because not all attributes are known:" + str);
            }
        }
        catch (SQLException sqlex) {
            System.err.println("DatabaseOutputDataStore: " + sqlex);
            sqlex.printStackTrace();
        }
        this.lineArray.clear();
    }

    public void setWorkspace(JAMSWorkspace ws) {
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        try {
            if (this.pgsql != null) {
                this.pgsql.close();
            }
            this.pgsql = null;
        }
        catch (SQLException sqlex) {
            System.out.println("DatabaseOutputDataStore: " + sqlex);
            sqlex.printStackTrace();
            return;
        }
    }

    public DefaultFilter[] getFilters() {
        return this.filters;
    }

    public void setWorkspace(Workspace ws) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.open(true);
            this.dataStarted = true;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
    }

    public boolean isValid() {
        try {
            if (this.pgsql == null) {
                try {
                    this.open(false);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return this.pgsql.isValid();
        }
        catch (SQLException e) {
            return false;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public class DefaultFilter
    implements Filter {
        private String contextName;
        private String expression;
        private Context context = null;
        ExpressionFactory factory = null;
        SimpleContext exprContext = new SimpleContext((ELResolver)new SimpleResolver());
        ValueExpression valueExpr = null;
        ValueExpression idExpr = null;

        public DefaultFilter(String contextName, String expression) {
            this.contextName = contextName;
            this.expression = expression;
        }

        public String getContextName() {
            return this.contextName;
        }

        public String getExpression() {
            return this.expression;
        }

        public boolean isFiltered(String id) {
            this.idExpr.setValue((ELContext)this.exprContext, (Object)id);
            boolean result = (Boolean)this.valueExpr.getValue((ELContext)this.exprContext);
            return result;
        }

        public Context getContext() {
            return this.context;
        }

        public void setContext(Context context) {
            this.context = context;
            for (Context searchContext = this.getContext(); searchContext != null; searchContext = searchContext.getContext()) {
                ValueExpression contextExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${" + searchContext.getInstanceName() + "}", Context.class);
                contextExpr.setValue((ELContext)this.exprContext, (Object)searchContext);
            }
        }

        private class Variable
        implements Serializable {
            String name;
            JAMSData data;
            ValueExpression expr;

            Variable(String name, JAMSData data, ValueExpression expr) {
                this.name = name;
                this.data = data;
                this.expr = expr;
            }
        }
    }
}

