/*
 * Decompiled with CFR 0.152.
 */
package jams.components.unit;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;

public class SpecificHumidityArrayToRelativeHumidity
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="specific humidity", unit="kg / kg")
    public Attribute.DoubleArray specHum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="mean daily temperature", unit="\u00b0C")
    public Attribute.DoubleArray tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="relative humidity", unit="%")
    public Attribute.DoubleArray relHum;

    public void run() {
        double[] s = this.specHum.getValue();
        double p = 1013.0;
        double[] T = this.tmean.getValue();
        double[] r = this.relHum.getValue();
        int n = s.length;
        if (r == null) {
            r = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            double numerator = p * 1000.0 / (623.0 / s[i]);
            double denumerator = 6.107 * Math.pow(10.0, 7.48 * T[i] / 237.3 + T[i]);
            r[i] = 100.0 * numerator / denumerator;
        }
        this.relHum.setValue(r);
    }
}

