/*
 * Decompiled with CFR 0.152.
 */
package jams.components.unit;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;

public class CloudCoverArrayToSunshineDuration
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="fraction of cloud cover in parts", unit="%")
    public Attribute.DoubleArray cloudCoverFraction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Maximum sunshine duration in h", unit="h/d")
    public Attribute.DoubleArray maxSunh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="sunshine duration in h", unit="h/d")
    public Attribute.DoubleArray sunh;

    public void run() {
        double[] sunhArray = this.sunh.getValue();
        double[] cltArray = this.cloudCoverFraction.getValue();
        double[] maxSunhArray = this.maxSunh.getValue();
        int n = cltArray.length;
        if (sunhArray == null) {
            this.sunh.setValue(new double[n]);
        }
        for (int i = 0; i < n; ++i) {
            sunhArray[i] = maxSunhArray[i] * (1.0 - cltArray[i] * 0.01);
        }
        this.sunh.setValue(sunhArray);
    }
}

