/*
 * Decompiled with CFR 0.152.
 */
package jams.components.statistics;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.Arrays;

@JAMSComponentDescription(author="Manfred Fink)", description="Calculates a quantile according to a given percentage", date="2018-07-14", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class Quantile_determination
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Value")
    public Attribute.Double input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="current step as interger")
    public Attribute.Integer timestep;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="quantile value result (only available in the cleanup stage)")
    public Attribute.Double output;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Value array")
    public Attribute.DoubleArray ValueArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="quantile in %", defaultValue="0")
    public Attribute.Double Quantile;
    private long maxSteps;

    public void init() {
        this.maxSteps = this.timeInterval.getNumberOfTimesteps();
        double[] ValArray = new double[(int)this.maxSteps];
        this.ValueArray.setValue(ValArray);
        this.timestep.setValue(0);
        this.output.setValue(0.0);
    }

    public void run() {
        this.maxSteps = this.timeInterval.getNumberOfTimesteps();
        int i = this.timestep.getValue();
        double[] tempArray = this.ValueArray.getValue();
        tempArray[i] = this.input.getValue();
        this.ValueArray.setValue(tempArray);
        this.timestep.setValue(++i);
        this.output.setValue(0.0);
        if ((long)i == this.maxSteps) {
            Arrays.sort(tempArray);
            Double quantilenumber = (double)this.maxSteps * (this.Quantile.getValue() / 100.0);
            int j = (int)Math.round(quantilenumber);
            this.output.setValue(tempArray[j]);
        }
    }

    public void cleanup() {
    }
}

