/*
 * Decompiled with CFR 0.152.
 */
package jams.components.statistics;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;

public class MovingAverage
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current time interval")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current time interval")
    public Attribute.TimeInterval period;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="value")
    public Attribute.Double[] y;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="moving average value")
    public Attribute.Integer windowSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="enabled flag")
    public Attribute.Boolean[] enabled;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="moving average value")
    public Attribute.Double[] movingAvg;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="internal state of the module")
    public Attribute.Entity state;
    int n = 0;
    int m = 0;

    public void init() {
        this.n = this.windowSize.getValue();
        this.m = 0;
        for (int i = 0; i < this.y.length; ++i) {
            if (!this.isEnabled(i)) continue;
            ++this.m;
        }
    }

    public void initAll() {
        float[][] timeserie = new float[this.m][this.n];
        int counter = 0;
        boolean isFull = false;
        this.state.setObject("timeserie", (Object)timeserie);
        this.state.setObject("lastTimeStep", (Object)Long.MIN_VALUE);
        this.state.setObject("counter", (Object)counter);
        this.state.setObject("isFull", (Object)isFull);
    }

    private boolean isEnabled(int i) {
        return this.enabled == null || this.enabled[i].getValue();
    }

    public void run() {
        Long lastTimeStep = (Long)this.state.getObject("lastTimeStep");
        float[][] timeserie = (float[][])this.state.getObject("timeserie");
        int counter = (Integer)this.state.getObject("counter");
        boolean isFull = (Boolean)this.state.getObject("isFull");
        boolean considerData = true;
        if (this.time != null) {
            if (this.time.getTimeInMillis() == -10000000000L) {
                return;
            }
            if (lastTimeStep.longValue() == this.time.getTimeInMillis()) {
                considerData = false;
            } else {
                lastTimeStep = this.time.getTimeInMillis();
            }
            if (this.period != null && (this.time.before(this.period.getStart()) || this.time.after(this.period.getEnd()))) {
                considerData = false;
            }
        }
        if (!considerData) {
            this.state.setObject("timeserie", (Object)timeserie);
            this.state.setObject("lastTimeStep", (Object)lastTimeStep);
            this.state.setObject("counter", (Object)counter);
            this.state.setObject("isFull", (Object)isFull);
            return;
        }
        int c = 0;
        for (int i = 0; i < this.y.length; ++i) {
            double avg = 0.0;
            if (!this.isEnabled(i)) continue;
            timeserie[c][counter] = (float)this.y[i].getValue();
            for (int j = 0; j < this.n; ++j) {
                avg += (double)timeserie[c][j];
            }
            if (isFull) {
                this.movingAvg[i].setValue(avg / (double)this.n);
            } else {
                this.movingAvg[i].setValue(JAMS.getMissingDataValue());
            }
            ++c;
        }
        if (counter == this.n - 1) {
            isFull = true;
        }
        counter = (counter + 1) % this.n;
        this.state.setObject("timeserie", (Object)timeserie);
        this.state.setObject("lastTimeStep", (Object)lastTimeStep);
        this.state.setObject("counter", (Object)counter);
        this.state.setObject("isFull", (Object)isFull);
    }
}

