/*
 * Decompiled with CFR 0.152.
 */
package jams.components.statistics;

import jams.data.AbstractDataSupplier;
import jams.data.Attribute;
import jams.data.DataSupplier;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;

public class MannKendall
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current time interval")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval for trend estimation")
    public Attribute.TimeInterval period;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="window size", defaultValue="100000")
    public Attribute.Integer windowSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="value of trend")
    public Attribute.Double[] y;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="value of trend")
    public Attribute.Boolean[] enabled;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="kendalls p value")
    public Attribute.Double[] p;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="kendalls tau value")
    public Attribute.Double[] tau;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="linreg ax+b")
    public Attribute.Double[] a;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="linreg ax+b")
    public Attribute.Double[] b;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="linreg r2")
    public Attribute.Double[] r2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="coefficient of variation")
    public Attribute.Double[] V;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="internal state of the module")
    public Attribute.Entity state;
    int n;
    int m;
    WrappedDataSupplier supplier = new WrappedDataSupplier(null);

    public void initAll() {
        float[][] timeserie = null;
        int counter = 0;
        boolean isFull = false;
        if (this.period == null) {
            this.n = this.windowSize.getValue();
        } else if (this.windowSize.getValue() != -1) {
            this.period.setTimeUnit(1);
            this.period.setTimeUnitCount(1);
            this.n = Math.min((int)this.period.getNumberOfTimesteps(), this.windowSize.getValue());
        } else {
            this.period.setTimeUnit(1);
            this.period.setTimeUnitCount(1);
            this.n = (int)this.period.getNumberOfTimesteps();
        }
        this.m = 0;
        isFull = false;
        for (int i = 0; i < this.y.length; ++i) {
            if (!this.isEnabled(i)) continue;
            ++this.m;
        }
        timeserie = new float[this.m][this.n];
        counter = 0;
        this.state.setObject("timeserie", (Object)timeserie);
        this.state.setObject("lastTimeStep", (Object)Long.MIN_VALUE);
        this.state.setObject("counter", (Object)counter);
        this.state.setObject("isFull", (Object)isFull);
    }

    private boolean isEnabled(int i) {
        return this.enabled == null || this.enabled[i].getValue();
    }

    public void run() {
        int i;
        Long lastTimeStep = (Long)this.state.getObject("lastTimeStep");
        float[][] timeserie = (float[][])this.state.getObject("timeserie");
        int counter = (Integer)this.state.getObject("counter");
        boolean isFull = (Boolean)this.state.getObject("isFull");
        boolean considerData = true;
        if (this.time != null) {
            if (this.time.getTimeInMillis() == -10000000000L) {
                return;
            }
            if (lastTimeStep.longValue() == this.time.getTimeInMillis()) {
                considerData = false;
            } else {
                lastTimeStep = this.time.getTimeInMillis();
            }
            if (this.period != null && (this.time.before(this.period.getStart()) || this.time.after(this.period.getEnd()))) {
                considerData = false;
            }
        }
        if (!considerData) {
            return;
        }
        int c = 0;
        for (i = 0; i < this.y.length; ++i) {
            if (!this.isEnabled(i)) continue;
            timeserie[c++][counter] = (float)this.y[i].getValue();
        }
        if ((counter = (counter + 1) % this.n) == 0) {
            isFull = true;
        }
        this.time.add(this.period.getTimeUnit(), this.period.getTimeUnitCount());
        if (isFull || !this.time.before(this.period.getEnd())) {
            c = 0;
            for (i = 0; i < this.y.length; ++i) {
                double[] resultKendall = new double[5];
                double[] resultLinReg = new double[4];
                if (this.isEnabled(i)) {
                    this.supplier.setSourceData(timeserie[c], counter);
                    resultKendall = jams.math.statistics.MannKendall.Kendall((DataSupplier)this.supplier);
                    resultLinReg = jams.math.statistics.MannKendall.LinearRegression((DataSupplier)this.supplier);
                    ++c;
                }
                if (this.tau != null) {
                    this.tau[i].setValue(resultKendall[0]);
                }
                if (this.p != null) {
                    this.p[i].setValue(resultKendall[1]);
                }
                if (this.a != null) {
                    this.a[i].setValue(resultLinReg[0]);
                }
                if (this.b != null) {
                    this.b[i].setValue(resultLinReg[1]);
                }
                if (this.r2 != null) {
                    this.r2[i].setValue(resultLinReg[2]);
                }
                if (this.V == null) continue;
                this.V[i].setValue(resultLinReg[3]);
            }
        }
        this.time.add(this.period.getTimeUnit(), -this.period.getTimeUnitCount());
        this.state.setObject("timeserie", (Object)timeserie);
        this.state.setObject("lastTimeStep", (Object)lastTimeStep);
        this.state.setObject("counter", (Object)counter);
        this.state.setObject("isFull", (Object)isFull);
    }

    private class WrappedDataSupplier
    extends AbstractDataSupplier<Double, float[]> {
        int counter;

        WrappedDataSupplier(float[] srcData) {
            super((Object)srcData);
            this.counter = 0;
        }

        public void setSourceData(float[] srcData, int counter) {
            this.input = srcData;
            this.counter = counter;
        }

        public int size() {
            return MannKendall.this.n;
        }

        public Double get(int i) {
            return ((float[])this.input)[(this.counter + i) % MannKendall.this.n];
        }
    }
}

