/*
 * Decompiled with CFR 0.152.
 */
package jams.components.regionalization;

import jams.components.regionalization.IDW;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.workspace.DataSetDefinition;
import jams.workspace.stores.InputDataStore;
import java.util.ArrayList;

@JAMSComponentDescription(title="IDWWeights", author="Peter Krause & Sven Kralisch", date="21/10/2008", description="Get stations coordinates from DataStore and calculate weights for the regionalisation procedure. Based on org.unijena.j2k.regionalization.CalcNidwWeights.")
public class IDWeightCalculator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity x-coordinate")
    public Attribute.Double entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity y-coordinate")
    public Attribute.Double entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Power of IDW function")
    public Attribute.Double pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="weights for IDW part of regionalisation")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Doug Boyle's famous function", defaultValue="false")
    public Attribute.Boolean equalWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of the datastore to read station coordinates from")
    public Attribute.String dataStoreID;
    private double[] statX;
    private double[] statY;
    InputDataStore store = null;

    public void init() {
        if (this.dataStoreID != null) {
            this.store = this.getModel().getWorkspace().getInputDataStore(this.dataStoreID.getValue());
        }
        if (this.store == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.dataStoreID + "\" from " + this.getInstanceName() + ": Datastore could not be found!");
            return;
        }
        DataSetDefinition dsDef = this.store.getDataSetDefinition();
        ArrayList xList = dsDef.getAttributeValues("X");
        ArrayList yList = dsDef.getAttributeValues("Y");
        if (xList.size() != yList.size()) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.dataStoreID + "\" from " + this.getInstanceName() + ": Number of x and y coordinates differ!");
            return;
        }
        this.statX = this.listToDoubleArray(xList);
        this.statY = this.listToDoubleArray(yList);
    }

    private double[] listToDoubleArray(ArrayList<Object> list) {
        double[] result = new double[list.size()];
        int i = 0;
        for (Object o : list) {
            result[i] = (Double)o;
            ++i;
        }
        return result;
    }

    public void run() {
        double[] idwWeights = null;
        if (this.equalWeights == null || !this.equalWeights.getValue()) {
            idwWeights = IDW.calcIDWeights(this.entityX.getValue(), this.entityY.getValue(), this.statX, this.statY, this.pidw.getValue());
        } else if (this.equalWeights.getValue()) {
            idwWeights = IDW.equalWeights(this.statX.length);
        }
        this.statWeights.setValue(idwWeights);
    }

    public void cleanup() {
        double[] weights = this.statWeights.getValue();
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = 0.0;
        }
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

