/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import jams.data.Attribute;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import java.util.HashSet;
import java.util.Random;

public class SubsetSelect
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Integer n;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Entity InputData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="TimeSerie of Temp Data")
    public Attribute.Entity OutputData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="TimeSerie of Temp Data")
    public Attribute.Boolean active;

    public void init() {
    }

    public void run() {
        int i;
        int j;
        int N0;
        double[][] data = null;
        double[] predict = null;
        HashSet<Double> HashFilter = new HashSet<Double>();
        try {
            data = (double[][])this.InputData.getObject("data");
            predict = (double[])this.InputData.getObject("predict");
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendHalt("Could not find input data for subset selection" + e.toString());
            return;
        }
        if (!this.active.getValue()) {
            this.OutputData.setObject("data", (Object)data);
            this.OutputData.setObject("predict", (Object)predict);
            return;
        }
        this.getModel().getRuntime().sendInfoMsg("Optimiere Trainingsdaten!");
        if (this.n.getValue() <= 0) {
            this.getModel().getRuntime().sendHalt("subsetsize less or equal zero!");
            return;
        }
        int Ngoal = this.n.getValue();
        if (Ngoal > (N0 = data.length)) {
            Ngoal = N0;
        }
        int M = data[0].length;
        int[] set = new int[Ngoal];
        double[] variance = new double[N0];
        double[] hash_value = new double[N0];
        boolean[] inSet = new boolean[N0];
        for (int j2 = 0; j2 < N0; ++j2) {
            variance[j2] = 0.0;
            inSet[j2] = false;
            hash_value[j2] = 0.0;
            for (int k = 0; k < M; ++k) {
                int n = j2;
                hash_value[n] = hash_value[n] + data[j2][k];
            }
        }
        inSet[0] = true;
        set[0] = 0;
        for (int i2 = 1; i2 < Ngoal; ++i2) {
            int bestIndex = -1;
            double bestValue = -1.0;
            for (j = 0; j < N0; ++j) {
                if (inSet[j]) continue;
                for (int l = 0; l < M; ++l) {
                    int n = j;
                    variance[n] = variance[n] + (data[j][l] - data[set[i2 - 1]][l]) * (data[j][l] - data[set[i2 - 1]][l]);
                }
                if (!(variance[j] > bestValue)) continue;
                bestValue = variance[j];
                bestIndex = j;
            }
            if (bestValue == -1.0) {
                this.getModel().getRuntime().sendHalt("subset size large than number of available datasets");
            }
            inSet[bestIndex] = true;
            HashFilter.add(new Double(hash_value[bestIndex]));
            set[i2] = bestIndex;
            for (int k = 1; k < N0; ++k) {
                if (!(Math.abs(hash_value[k] - hash_value[bestIndex]) < 1.0E-7)) continue;
                inSet[k] = true;
            }
        }
        double[][] optimizedata = new double[Ngoal][];
        double[] optimizepredict = new double[Ngoal];
        Random r = new Random();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < Ngoal; ++j) {
                int Shuffle = r.nextInt(Ngoal);
                int tmp = set[j];
                set[j] = set[Shuffle];
                set[Shuffle] = tmp;
            }
        }
        for (i = 0; i < Ngoal; ++i) {
            optimizedata[i] = data[set[i]];
            optimizepredict[i] = predict[set[i]];
        }
        this.OutputData.setObject("data", (Object)optimizedata);
        this.OutputData.setObject("predict", (Object)optimizepredict);
        this.getModel().getRuntime().sendInfoMsg("finished subset selection");
    }
}

