/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import Jama.CholeskyDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import jams.components.machineLearning.Learner;
import jams.components.machineLearning.kernels.Exponential;
import jams.components.machineLearning.kernels.FixedMeanModell;
import jams.components.machineLearning.kernels.Kernel;
import jams.components.machineLearning.kernels.LinearMeanModell;
import jams.components.machineLearning.kernels.MaternClass;
import jams.components.machineLearning.kernels.MeanModell;
import jams.components.machineLearning.kernels.NeuralNetwork;
import jams.components.machineLearning.kernels.NeuralNetworkFull;
import jams.components.machineLearning.kernels.NoNoiseExponential;
import jams.components.machineLearning.kernels.QuadraticMeanModell;
import jams.components.machineLearning.kernels.RationalQuadratic;
import jams.components.machineLearning.kernels.SimpleExponential;
import jams.components.machineLearning.kernels.SimpleMatern;
import jams.components.machineLearning.kernels.SimpleNeuralNetwork;
import jams.components.machineLearning.kernels.SimplePeriodic;
import jams.components.machineLearning.kernels.SimpleRationalQuadratic;
import jams.components.machineLearning.kernels.TestKernel;
import jams.data.Attribute;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class GaussianLearner
extends Learner {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Entity optimizationData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Integer kernelMethod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Integer MeanMethod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Integer PerformanceMeasure;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.DoubleArray param_theta;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.String parameterFile = null;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.String resultFile = null;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="component mode", defaultValue="0")
    public Attribute.Integer mode;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="file containing model", defaultValue="")
    public Attribute.String modelDataFile;
    Matrix CovarianzMatrix;
    LUDecomposition Solver;
    CholeskyDecomposition fastSolver = null;
    Matrix Observations;
    Matrix alpha;
    Matrix invCovarianzMatrix;
    double[] logtheta;
    double[] theta;
    double[] meantheta;
    static final int MAXIMIZATION = 1;
    static final int MINIMIZATION = 2;
    static final int ABSMAXIMIZATION = 3;
    static final int ABSMINIMIZATION = 4;
    int MaximizeEff = 1;
    Kernel kernel;
    String[] kernelParameterNames;
    static final double resolution = 0.001;
    static final double limit = 20.0;
    static double[] gaussianDistribution;
    public static final int MODE_TRAIN = 0;
    public static final int MODE_APPLYMODEL = 1;
    public static final int MODE_OPTIMIZE = 2;

    public double getMarginalLikelihood() {
        double n = this.TrainLength;
        double term1 = -0.5 * this.Observations.transpose().times(this.alpha).get(0, 0);
        double term2 = 0.0;
        Matrix L = null;
        L = this.fastSolver != null ? this.fastSolver.getL() : (this.Solver != null ? this.Solver.getL() : this.CovarianzMatrix.lu().getL());
        for (int i = 0; i < L.getColumnDimension(); ++i) {
            term2 += 2.0 * Math.log(L.get(i, i));
        }
        term2 = -0.5 * term2;
        double term3 = -n / 2.0 * Math.log(Math.PI * 2);
        return term1 + term2 + term3;
    }

    public double getLOOlogPredictiveProbability() {
        if (this.invCovarianzMatrix == null) {
            this.invCovarianzMatrix = this.CovarianzMatrix.inverse();
        }
        double logp = 0.0;
        for (int i = 0; i < this.TrainLength; ++i) {
            double mu_i = this.Observations.get(i, 0) - this.alpha.get(i, 0) / this.invCovarianzMatrix.get(i, i);
            double sigma_i = 1.0 / this.invCovarianzMatrix.get(i, i);
            if (sigma_i < 0.0) {
                sigma_i = -sigma_i;
            }
            sigma_i = Math.sqrt(sigma_i);
            logp += -Math.log(sigma_i) - Math.pow((this.Observations.get(i, 0) - mu_i) / sigma_i, 2.0) / 2.0;
        }
        return logp;
    }

    public double getLOOSquareError() {
        if (this.invCovarianzMatrix == null) {
            this.invCovarianzMatrix = this.CovarianzMatrix.inverse();
        }
        double error = 0.0;
        for (int i = 0; i < this.TrainLength; ++i) {
            double mu_i = this.Observations.get(i, 0) - this.alpha.get(i, 0) / this.invCovarianzMatrix.get(i, i);
            error += (mu_i - this.Observations.get(i, 0)) * (mu_i - this.Observations.get(i, 0));
        }
        return -error;
    }

    public double getSplitValidationError() {
        double[] result = null;
        double[] correctValue = null;
        try {
            result = this.Predict(false);
            correctValue = (double[])this.validationData.getObject("predict");
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendInfoMsg("error occured, while calculating performance measure " + e.toString());
        }
        double sum = 0.0;
        for (int i = 0; i < result.length; ++i) {
            sum += (result[i] - correctValue[i]) * (result[i] - correctValue[i]);
        }
        return -sum;
    }

    public double RetrainWithANewObservation(int PerformanceMeasure, double[] input, double obs) {
        Matrix oldCovarianzMatrix = this.CovarianzMatrix;
        this.CovarianzMatrix = new Matrix(this.TrainLength + 1, this.TrainLength + 1);
        this.Observations = new Matrix(this.TrainLength + 1, 1);
        double[][] data_new = new double[this.data.length + 1][this.data[0].length];
        double[] result_new = new double[this.result.length + 1];
        for (int i = 0; i < this.TrainLength; ++i) {
            data_new[i] = this.data[i];
            result_new[i] = this.result[i];
        }
        data_new[this.TrainLength] = input;
        result_new[this.TrainLength] = obs;
        this.data = data_new;
        this.result = result_new;
        this.CovarianzMatrix.setMatrix(0, this.TrainLength - 1, 0, this.TrainLength - 1, oldCovarianzMatrix);
        Matrix u1 = new Matrix(this.TrainLength + 1, 1);
        Matrix v1 = new Matrix(1, this.TrainLength + 1);
        Matrix u2 = new Matrix(this.TrainLength + 1, 1);
        Matrix v2 = new Matrix(1, this.TrainLength + 1);
        for (int i = 0; i < this.TrainLength; ++i) {
            double varianz = this.kernel.kernel(this.normalize(this.data[i]), this.normalize(input), i, this.TrainLength);
            v1.set(0, i, 0.0);
            u1.set(i, 0, varianz);
            v2.set(0, i, varianz);
            u2.set(i, 0, 0.0);
            this.CovarianzMatrix.set(i, this.TrainLength, varianz);
            this.CovarianzMatrix.set(this.TrainLength, i, varianz);
        }
        double varianz = this.kernel.kernel(this.normalize(input), this.normalize(input), this.TrainLength, this.TrainLength);
        this.CovarianzMatrix.set(this.TrainLength, this.TrainLength, varianz);
        v1.set(0, this.TrainLength, 1.0);
        u1.set(this.TrainLength, 0, (varianz - 1.0) / 2.0);
        v2.set(0, this.TrainLength, (varianz - 1.0) / 2.0);
        u2.set(this.TrainLength, 0, 1.0);
        this.Observations = this.kernel.MM.Transform(this.data, this.result);
        if (this.invCovarianzMatrix == null) {
            this.invCovarianzMatrix = this.CovarianzMatrix.inverse();
        } else {
            double a = 1.0 / (1.0 + u1.get(this.TrainLength, 0));
            Matrix biggerInvCovarianzMatrix = Matrix.identity((int)(this.TrainLength + 1), (int)(this.TrainLength + 1));
            biggerInvCovarianzMatrix.setMatrix(0, this.TrainLength - 1, 0, this.TrainLength - 1, this.invCovarianzMatrix);
            Matrix invTu1 = biggerInvCovarianzMatrix.times(u1);
            for (int i = 0; i < this.TrainLength + 1; ++i) {
                biggerInvCovarianzMatrix.set(i, this.TrainLength, biggerInvCovarianzMatrix.get(i, this.TrainLength) - invTu1.get(i, 0) * a);
            }
            this.invCovarianzMatrix = biggerInvCovarianzMatrix;
            Matrix vTA2 = v2.times(this.invCovarianzMatrix);
            a = 1.0 / (1.0 + vTA2.get(0, this.TrainLength));
            Matrix invTu2 = this.invCovarianzMatrix.getMatrix(0, this.TrainLength, this.TrainLength, this.TrainLength).times(a);
            this.invCovarianzMatrix = this.invCovarianzMatrix.minus(invTu2.times(vTA2));
        }
        this.alpha = this.invCovarianzMatrix.times(this.Observations);
        ++this.TrainLength;
        switch (PerformanceMeasure) {
            case 1: {
                return this.getMarginalLikelihood();
            }
            case 2: {
                return this.getLOOlogPredictiveProbability();
            }
            case 3: {
                return this.getLOOSquareError();
            }
            case 4: {
                return this.getSplitValidationError();
            }
        }
        return 0.0;
    }

    public double Train(int PerformanceMeasure) {
        int i;
        this.CovarianzMatrix = new Matrix(this.TrainLength, this.TrainLength);
        this.Observations = new Matrix(this.TrainLength, 1);
        this.theta = new double[this.kernel.getParameterCount()];
        this.meantheta = new double[this.kernel.MM.GetParameterCount()];
        this.logtheta = new double[this.kernel.getParameterCount()];
        this.invCovarianzMatrix = null;
        if ((this.mode.getValue() & 2) == 0 && this.parameterFile != null && this.param_theta == null) {
            try {
                int i2;
                BufferedReader reader = new BufferedReader(new FileReader(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getAbsolutePath(), (String)this.parameterFile.getValue())));
                for (i2 = 0; i2 < this.theta.length; ++i2) {
                    this.logtheta[i2] = new Double(reader.readLine());
                }
                for (i2 = 0; i2 < this.meantheta.length; ++i2) {
                    this.meantheta[i2] = new Double(reader.readLine());
                }
                reader.close();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendInfoMsg("Could not open or read parameter file, becauce:" + e.toString());
                for (int i3 = 0; i3 < this.logtheta.length; ++i3) {
                    this.logtheta[i3] = 0.0;
                }
            }
        } else {
            for (int i4 = 0; i4 < this.logtheta.length; ++i4) {
                this.logtheta[i4] = 0.0;
            }
        }
        if (!this.kernel.MM.isTrained()) {
            this.kernel.MM.create(this.data, this.result);
            this.meantheta = this.kernel.MM.GetParameters();
        }
        if (this.param_theta != null) {
            int i5;
            for (i5 = 0; i5 < this.logtheta.length; ++i5) {
                this.logtheta[i5] = Math.log(this.param_theta.getValue()[i5]);
            }
            for (i5 = 0; i5 < this.kernel.MM.GetParameterCount(); ++i5) {
                this.meantheta[i5] = this.param_theta.getValue()[this.logtheta.length + i5];
            }
        }
        for (i = 0; i < this.theta.length; ++i) {
            this.theta[i] = Math.exp(this.logtheta[i]);
        }
        if (!this.kernel.SetParameter(this.theta)) {
            this.getModel().getRuntime().sendInfoMsg("covariance function has more parameters than specified!");
        }
        if (!this.kernel.MM.SetParameters(this.meantheta)) {
            this.getModel().getRuntime().sendInfoMsg("mean function has more parameters than specified!");
        }
        for (i = 0; i < this.TrainLength; ++i) {
            for (int j = 0; j < i; ++j) {
                double varianz = this.kernel.kernel(this.normalize(this.data[i]), this.normalize(this.data[j]), i, j);
                this.CovarianzMatrix.set(i, j, varianz);
                this.CovarianzMatrix.set(j, i, varianz);
            }
            double varianz = this.kernel.kernel(this.normalize(this.data[i]), this.normalize(this.data[i]), i, i);
            this.CovarianzMatrix.set(i, i, varianz);
        }
        this.Observations = this.kernel.MM.Transform(this.data, this.result);
        this.fastSolver = this.CovarianzMatrix.chol();
        if (!this.fastSolver.isSPD()) {
            this.fastSolver = null;
            this.getModel().getRuntime().sendInfoMsg("current covariancematrix is not SPD, using LU decomposition instead");
            this.Solver = this.CovarianzMatrix.lu();
            if (!this.Solver.isNonsingular()) {
                this.getModel().getRuntime().sendInfoMsg("current covariancematrix is singular, can`t create model with this dataset/parameter combination!");
                return -1.0E12;
            }
        }
        this.alpha = this.fastSolver == null ? this.Solver.solve(this.Observations) : this.fastSolver.solve(this.Observations);
        switch (PerformanceMeasure) {
            case 1: {
                return this.getMarginalLikelihood();
            }
            case 2: {
                return this.getLOOlogPredictiveProbability();
            }
            case 3: {
                return this.getLOOSquareError();
            }
            case 4: {
                return this.getSplitValidationError();
            }
        }
        return 0.0;
    }

    public double getMean(double[] x) {
        Matrix kstar = new Matrix(1, this.TrainLength);
        for (int i = 0; i < this.TrainLength; ++i) {
            double variance = this.kernel.kernel(this.normalize(this.data[i]), this.normalize(x), i, -1);
            kstar.set(0, i, variance);
        }
        Matrix prediction = kstar.times(this.alpha);
        double[][] x_tmp = new double[][]{x};
        double[] result = this.kernel.MM.ReTransform(x_tmp, prediction);
        return result[0];
    }

    public double[] getVariance(double[][] x) {
        double[] predicted_variance = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            predicted_variance[i] = this.getVariance(x[i]);
        }
        return predicted_variance;
    }

    public double getVariance(double[] x) {
        Matrix kstar = new Matrix(1, this.TrainLength);
        Matrix kstarT = new Matrix(this.TrainLength, 1);
        Matrix one = new Matrix(1, this.TrainLength);
        Matrix oneT = new Matrix(this.TrainLength, 1);
        for (int i = 0; i < this.TrainLength; ++i) {
            double variance = this.kernel.kernel(this.normalize(this.data[i]), this.normalize(x), i, -1);
            kstar.set(0, i, variance);
            kstarT.set(i, 0, variance);
            one.set(0, i, 1.0);
            oneT.set(i, 0, 1.0);
        }
        Matrix RMinus1r = null;
        Matrix rRMinus1r = null;
        Matrix RMinus1Eins = null;
        Matrix EinsRMinus1Eins = null;
        if (this.invCovarianzMatrix != null) {
            RMinus1r = this.invCovarianzMatrix.times(kstarT);
            RMinus1Eins = this.invCovarianzMatrix.times(oneT);
        } else if (this.fastSolver != null) {
            RMinus1r = this.fastSolver.solve(kstarT);
            RMinus1Eins = this.fastSolver.solve(oneT);
        } else {
            RMinus1r = this.Solver.solve(kstarT);
            RMinus1Eins = this.Solver.solve(oneT);
        }
        rRMinus1r = kstar.times(RMinus1r);
        EinsRMinus1Eins = one.times(RMinus1Eins);
        double t = 1.0 - rRMinus1r.get(0, 0);
        double tOne = EinsRMinus1Eins.get(0, 0);
        double my_hat = one.times(this.alpha).get(0, 0) / tOne;
        Matrix tmp = new Matrix(1, this.TrainLength);
        for (int i = 0; i < this.TrainLength; ++i) {
            tmp.set(0, i, this.Observations.get(i, 0) - my_hat);
        }
        double k = this.Observations.getRowDimension();
        Matrix solveTmp = null;
        solveTmp = this.invCovarianzMatrix != null ? this.invCovarianzMatrix.times(tmp.transpose()) : (this.fastSolver == null ? this.Solver.solve(tmp.transpose()) : this.fastSolver.solve(tmp.transpose()));
        double my_sigma = tmp.times(solveTmp).get(0, 0) / k;
        double sigma2 = 1.0 - kstar.times(RMinus1r).get(0, 0);
        return Math.abs(my_sigma) * Math.sqrt(sigma2 + sigma2 * sigma2 / tOne);
    }

    public static double NormalDensityFunction(double a) {
        return 1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-0.5 * a * a);
    }

    public static void BuildGaussDistributionTable() {
        double x1 = 0.0;
        double x2 = 0.001;
        gaussianDistribution = new double[20001];
        int counter = 0;
        double integral = 0.5;
        while (x1 < 20.0) {
            GaussianLearner.gaussianDistribution[counter++] = integral += (x2 - x1) / 6.0 * (GaussianLearner.NormalDensityFunction(x1) + 4.0 * GaussianLearner.NormalDensityFunction(0.5 * (x1 + x2)) + GaussianLearner.NormalDensityFunction(x2));
            x1 = x2;
            x2 += 0.001;
        }
    }

    public double CumulativeNormalDistributionFunction(double x) {
        long index = (long)(Math.abs(x) / 20.0 * (double)gaussianDistribution.length);
        double probability = 0.0;
        probability = index >= (long)gaussianDistribution.length ? 1.0 : gaussianDistribution[(int)index];
        if (x < 0.0) {
            probability = 1.0 - probability;
        }
        return probability;
    }

    public double getProbabilityForXLessY(double[] x, double target) {
        double mean = this.getMean(x);
        double variance = this.getVariance(x);
        if (variance < 1.0E-5) {
            return -1000.0;
        }
        target -= mean;
        return this.CumulativeNormalDistributionFunction(target /= variance);
    }

    public double getExpectedImprovement(double[] x, double fmin) {
        double mean = this.getMean(x);
        double variance = this.getVariance(x);
        if (variance < 1.0E-5) {
            return -1000.0;
        }
        double u = (fmin - mean) / variance;
        return variance * (this.CumulativeNormalDistributionFunction(u) * u + GaussianLearner.NormalDensityFunction(u));
    }

    public double getMarginalLikelihoodWithAdditionalSample(double[] x, double value) {
        if (this.invCovarianzMatrix == null) {
            this.invCovarianzMatrix = this.CovarianzMatrix.inverse();
        }
        Matrix kstar = new Matrix(this.TrainLength, 1);
        Matrix one = new Matrix(this.TrainLength, 1);
        for (int i = 0; i < this.TrainLength; ++i) {
            double variance = this.kernel.kernel(this.normalize(this.data[i]), this.normalize(x), i, -1);
            kstar.set(i, 0, variance);
            one.set(i, 0, 1.0);
        }
        Matrix Zu = this.invCovarianzMatrix.times(kstar);
        double uZu = 1.0 / (1.0 + kstar.transpose().times(this.invCovarianzMatrix.times(kstar)).get(0, 0));
        Matrix modifiedInvCovarianzMatrix = this.invCovarianzMatrix.minus(Zu.times(Zu.transpose()).times(uZu));
        double mean = one.transpose().times(modifiedInvCovarianzMatrix.times(this.Observations)).get(0, 0) / one.transpose().times(one).get(0, 0);
        Matrix modifiedObservations = this.Observations.minus(one.times(mean).plus(kstar.times(value - mean)));
        double n = this.TrainLength;
        double term1 = -0.5 * modifiedObservations.transpose().times(modifiedInvCovarianzMatrix.times(modifiedObservations)).get(0, 0);
        double term2 = -0.5 * Math.log(modifiedInvCovarianzMatrix.det());
        double term3 = -n / 2.0 * Math.log(Math.PI * 2);
        return term1 + term2 + term3;
    }

    public double[] Predict(boolean writeOutput) {
        double[][] x = null;
        try {
            x = (double[][])this.validationData.getObject("data");
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendInfoMsg("there are no datasets for validation!" + e.toString());
            return null;
        }
        double[] result = this.Predict(x);
        if (!writeOutput) {
            return result;
        }
        this.writePrediction(result, this.getCorrectValues(), this.getVariance(x));
        return result;
    }

    public double Predict(double[] x) {
        Matrix kstar = new Matrix(1, this.TrainLength);
        for (int i = 0; i < this.TrainLength; ++i) {
            double varianz = this.kernel.kernel(this.normalize(this.data[i]), this.normalize(x), i, -1);
            kstar.set(0, i, varianz);
        }
        Matrix prediction = kstar.times(this.alpha);
        double[][] xx = new double[1][2];
        xx[0][0] = x[0];
        xx[0][1] = x[1];
        return this.kernel.MM.ReTransform(xx, prediction)[0];
    }

    public double[] Predict(double[][] x) {
        Matrix kstar = new Matrix(x.length, this.TrainLength);
        for (int j = 0; j < x.length; ++j) {
            for (int i = 0; i < this.TrainLength; ++i) {
                double varianz = this.kernel.kernel(this.normalize(this.data[i]), this.normalize(x[j]), i, -1);
                kstar.set(j, i, varianz);
            }
        }
        Matrix prediction = kstar.times(this.alpha);
        return this.kernel.MM.ReTransform(x, prediction);
    }

    public void writePrediction(double[] prediction, double[] correctValue, double[] variance) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getAbsolutePath(), (String)this.resultFile.getValue()), true));
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendHalt("could not open result-file, because:" + e.toString() + "\nresults won't be saved!");
            return;
        }
        for (int i = 0; i < prediction.length; ++i) {
            try {
                if (correctValue != null) {
                    writer.write(correctValue[i] + "\t");
                }
                if (variance != null) {
                    writer.write(variance[i] + "\t");
                }
                writer.write(prediction[i] + "\n");
                writer.flush();
                continue;
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendHalt("could not write to result-file, because:" + e.toString());
                return;
            }
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendHalt("Error occured while closing result file" + e.toString());
            return;
        }
    }

    public double[] getCorrectValues() {
        double[] correctValue = null;
        try {
            correctValue = (double[])this.validationData.getObject("predict");
        }
        catch (Exception e) {
            return null;
        }
        return correctValue;
    }

    public void deserializeModel() throws IOException, ClassNotFoundException {
        String file = this.getModel().getWorkspacePath() + "/" + this.modelDataFile.getValue();
        ObjectInputStream objOut = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.min = (double[])objOut.readObject();
        this.max = (double[])objOut.readObject();
        this.base = (double[])objOut.readObject();
        this.data = (double[][])objOut.readObject();
        this.alpha = (Matrix)objOut.readObject();
        this.Observations = (Matrix)objOut.readObject();
        this.TrainLength = this.data.length;
        this.kernel = (Kernel)objOut.readObject();
        this.kernel.MM = (MeanModell)objOut.readObject();
        Object objSolver = objOut.readObject();
        if (objSolver instanceof CholeskyDecomposition) {
            this.fastSolver = (CholeskyDecomposition)objSolver;
        } else {
            this.Solver = (LUDecomposition)objSolver;
        }
        this.invCovarianzMatrix = null;
        objOut.close();
    }

    public void serializeModel() throws IOException {
        String file = this.getModel().getWorkspacePath() + "/" + this.modelDataFile.getValue();
        ObjectOutputStream objOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        objOut.writeObject(this.min);
        objOut.writeObject(this.max);
        objOut.writeObject(this.base);
        objOut.writeObject(this.data);
        objOut.writeObject(this.alpha);
        objOut.writeObject(this.Observations);
        objOut.writeObject(this.kernel);
        objOut.writeObject(this.kernel.MM);
        if (this.fastSolver != null) {
            objOut.writeObject(this.fastSolver);
        } else {
            objOut.writeObject(this.Solver);
        }
        objOut.flush();
        objOut.close();
    }

    public void optInit() {
        this.trainData = this.optimizationData;
        this.validationData = this.validationData;
        try {
            super.run();
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendHalt("Error occured while initializing Gaussian Process Module" + e.toString());
            return;
        }
    }

    public void trainInit() {
        this.trainData = this.trainData;
        this.validationData = this.validationData;
        try {
            super.run();
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendHalt("Error occured while initializing Gaussian Process Module" + e.toString());
            return;
        }
    }

    public double funct(double[] x) {
        int j;
        double value = 0.0;
        if (this.param_theta == null) {
            this.param_theta = this.getModel().getRuntime().getDataFactory().createDoubleArray();
            double[] array = new double[x.length + this.kernel.MM.GetParameterCount()];
            this.param_theta.setValue(array);
        }
        for (j = 0; j < x.length; ++j) {
            this.param_theta.getValue()[j] = Math.exp(x[j]);
        }
        for (j = 0; j < this.kernel.MM.GetParameterCount(); ++j) {
            this.param_theta.getValue()[j + this.kernel.getParameterCount()] = this.kernel.MM.GetParameters()[j];
        }
        double performance = this.Train(this.PerformanceMeasure.getValue());
        if (this.MaximizeEff == 2) {
            return performance;
        }
        if (this.MaximizeEff == 4) {
            return Math.abs(performance);
        }
        if (this.MaximizeEff == 3) {
            return -Math.abs(performance);
        }
        if (this.MaximizeEff == 1) {
            return -performance;
        }
        return 0.0;
    }

    public void GradientDescent(double[] x, String[] paramName) {
        double[] grad = new double[x.length];
        double[] alpha = new double[x.length];
        double[] xp = new double[x.length];
        double alpha_min = 0.001;
        double diff_min = 0.025;
        double approxError = 1.0E-4;
        double diff = 1.0;
        double y1 = this.funct(x);
        double y_neu = 1.0;
        double calpha = 0.1;
        for (int i = 0; i < x.length; ++i) {
            alpha[i] = 0.1;
        }
        this.getModel().getRuntime().sendInfoMsg("Performing Gradient Descent Optimization!");
        this.getModel().getRuntime().sendInfoMsg("starting with function value:" + y1);
        int iteration = 0;
        while (calpha > alpha_min && diff > diff_min) {
            int k;
            this.getModel().getRuntime().sendInfoMsg("iteration:" + ++iteration);
            double y_alt = y1;
            for (int i = 0; i < x.length; ++i) {
                block14: {
                    if (alpha[i] == 0.0) continue;
                    for (int j = 0; j < x.length; ++j) {
                        xp[j] = j == i ? x[j] + approxError : x[j];
                    }
                    double y2 = this.funct(xp);
                    grad[i] = (y2 - y1) / approxError;
                    grad[i] = grad[i] < 0.0 ? -1.0 : 1.0;
                    int n = i;
                    alpha[n] = alpha[n] * 4.0;
                    if (alpha[i] >= 2.0) {
                        alpha[i] = 2.0;
                    }
                    do {
                        for (k = 0; k < x.length; ++k) {
                            xp[k] = x[k];
                            if (k != i) continue;
                            xp[k] = x[i] - alpha[i] * grad[i];
                            if (xp[k] < -10.0) {
                                xp[k] = -10.0;
                            }
                            if (!(xp[k] > 10.0)) continue;
                            xp[k] = 10.0;
                        }
                        y_neu = this.funct(xp);
                        if (y_neu < y1) break block14;
                        int n2 = i;
                        alpha[n2] = alpha[n2] / 2.0;
                    } while (!(alpha[i] < alpha_min));
                    xp[i] = x[i];
                    alpha[i] = 0.0;
                    y_neu = this.funct(xp);
                }
                y1 = y_neu;
                for (k = 0; k < x.length; ++k) {
                    x[k] = xp[k];
                }
            }
            String info = "current parameter - set:\n";
            for (k = 0; k < x.length; ++k) {
                x[k] = xp[k];
                info = info + paramName[k] + ":";
                info = info + Math.exp(x[k]) + "\n";
            }
            for (int t = 0; t < this.kernel.MM.GetParameterCount(); ++t) {
                info = info + this.kernel.MM.getMeanModelParameterNames()[t] + ":";
                info = info + this.kernel.MM.GetParameters()[t] + "\n";
            }
            if (this.getModel() != null) {
                this.getModel().getRuntime().println(info);
                this.getModel().getRuntime().println("function value:\t" + y1 + "\t alpha: " + calpha + "\t diff:" + diff);
            } else {
                System.out.println(info);
                System.out.println("function value:\t" + y1 + "\t Alpha: " + calpha + "\t diff:" + diff);
            }
            for (int i = 0; i < x.length; ++i) {
                if (!(alpha[i] > calpha)) continue;
                calpha = alpha[i];
            }
            diff = Math.abs((y_neu - y_alt) / y_neu);
            y_alt = y_neu;
        }
    }

    public void setKernels() {
        switch (this.kernelMethod.getValue()) {
            case 0: {
                this.kernel = new TestKernel(this.DataLength);
                break;
            }
            case 2: {
                this.kernel = new Exponential(this.DataLength);
                break;
            }
            case 3: {
                this.kernel = new MaternClass(this.DataLength);
                break;
            }
            case 5: {
                this.kernel = new RationalQuadratic(this.DataLength);
                break;
            }
            case 6: {
                this.kernel = new NeuralNetwork(this.DataLength);
                break;
            }
            case 7: {
                this.kernel = new NoNoiseExponential(this.DataLength);
                break;
            }
            case 8: {
                this.kernel = new NeuralNetworkFull(this.DataLength);
                break;
            }
            case 12: {
                this.kernel = new SimpleExponential(this.DataLength);
                break;
            }
            case 13: {
                this.kernel = new SimpleMatern(this.DataLength);
                break;
            }
            case 15: {
                this.kernel = new SimpleRationalQuadratic(this.DataLength);
                break;
            }
            case 16: {
                this.kernel = new SimpleNeuralNetwork(this.DataLength);
                break;
            }
            case 17: {
                this.kernel = new SimplePeriodic(this.DataLength);
                break;
            }
            default: {
                this.kernel = null;
                this.getModel().getRuntime().sendInfoMsg("No valid Kernel specified, using Neural-Network Kernel");
            }
        }
        switch (this.MeanMethod.getValue()) {
            case 0: {
                this.kernel.SetMeanModell(new FixedMeanModell(this.DataLength));
                break;
            }
            case 1: {
                this.kernel.SetMeanModell(new LinearMeanModell(this.DataLength));
                break;
            }
            case 2: {
                this.kernel.SetMeanModell(new QuadraticMeanModell(this.DataLength));
                break;
            }
            default: {
                this.getModel().getRuntime().sendInfoMsg("No valid mean function specified, using Fixed Mean Model");
                this.kernel.SetMeanModell(new FixedMeanModell(this.DataLength));
            }
        }
        this.kernelParameterNames = this.kernel.getParameterNames();
    }

    @Override
    public void run() {
        double performance;
        if ((this.mode.getValue() & 1) != 0) {
            try {
                this.deserializeModel();
                double[] x = this.Predict(false);
                this.writePrediction(x, null, null);
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendInfoMsg("Could not apply model, because: " + e.toString());
            }
            return;
        }
        this.trainInit();
        this.setKernels();
        if ((this.mode.getValue() & 2) != 0) {
            int i;
            this.optInit();
            double[] x = new double[this.kernel.getParameterCount()];
            for (i = 0; i < x.length; ++i) {
                x[i] = this.param_theta != null ? Math.log(this.param_theta.getValue()[i]) : 1.0 / (double)x.length;
            }
            while (this.Train(0) < -100000.0) {
                for (i = 0; i < x.length; ++i) {
                    x[i] = this.generator.nextDouble() * 10.0;
                }
                if (this.param_theta == null) continue;
                this.param_theta.setValue(x);
            }
            this.GradientDescent(x, this.kernelParameterNames);
            try {
                int i2;
                BufferedWriter writer = new BufferedWriter(new FileWriter(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getAbsolutePath(), (String)this.parameterFile.getValue())));
                this.meantheta = this.kernel.MM.GetParameters();
                for (i2 = 0; i2 < this.theta.length; ++i2) {
                    writer.write(Double.toString(this.logtheta[i2]) + "\n");
                }
                for (i2 = 0; i2 < this.meantheta.length; ++i2) {
                    writer.write(Double.toString(this.meantheta[i2]) + "\n");
                }
                writer.close();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendInfoMsg("Could not open or writer parameter file, becauce:" + e.toString());
            }
        }
        this.trainInit();
        while (true) {
            double d;
            performance = this.Train(0);
            if (!(d < -100000.0)) break;
            double[] x = new double[this.kernel.getParameterCount()];
            for (int i = 0; i < x.length; ++i) {
                x[i] = this.generator.nextDouble() * 10.0;
            }
            if (this.param_theta != null) {
                this.param_theta.setValue(x);
            }
            if (!(performance > -100000.0)) continue;
            this.optInit();
            this.GradientDescent(x, this.kernelParameterNames);
        }
        System.out.println("TrainPerformance:" + performance);
        this.Predict(true);
        if (this.modelDataFile != null && !this.modelDataFile.getValue().equals("")) {
            try {
                this.serializeModel();
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendInfoMsg("Could not serialize model to given file:" + e.toString());
            }
        }
    }
}

