/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io.unidata;

import com.google.common.collect.ImmutableList;
import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.tools.FileTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;

@JAMSComponentDescription(title="NetCDFReader", author="Sven Kralisch", description="Reader for NetCDF files", date="2023-01-29", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class NetCDFReader3D
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar currentTime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current entity")
    public Attribute.Entity currentEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="NetCDF file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="name of temporal dimension")
    public Attribute.String timeDimName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="name of lat spatial dimension")
    public Attribute.String latDimName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="name of lon spatial dimension")
    public Attribute.String lonDimName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Date from which time units are counted. If not set, the value will be extracted from the NetCDF.")
    public Attribute.Calendar baseDate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Size of a time step")
    public Attribute.String stepSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Apply data chaching? Will read data of all entities on changing time steps in one go. Not meaningful if spatial iteration is outside temporal iteration.", defaultValue="false")
    public Attribute.Boolean dataCaching;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="names of variables to read")
    public Attribute.String[] varNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="output attributes")
    public Attribute.Double[] values;
    NetcdfFile ncfile;
    List<Variable> vars = new ArrayList<Variable>();
    Dimension timeDim;
    Dimension latDim;
    Dimension lonDim;
    Map<Long, Integer> timeMap = new HashMap<Long, Integer>();
    Map<Double, Integer> latMap = new HashMap<Double, Integer>();
    Map<Double, Integer> lonMap = new HashMap<Double, Integer>();
    Array[] dataArray;
    double[] missingDataValues;
    int[] latIndices;
    int[] lonIndices;
    int[] timeIndices;
    long oldMillis = -1L;
    int tIndex;
    int sIndex;
    Runnable runner;
    int[] origin = new int[]{0, 0};
    int[] shape = new int[]{1, 1};
    Runnable run_normal = new Runnable(){

        @Override
        public void run() {
            long millis = NetCDFReader3D.this.currentTime.getTimeInMillis();
            NetCDFReader3D.this.tIndex = NetCDFReader3D.this.timeMap.get(NetCDFReader3D.this.currentTime.getTimeInMillis());
            for (int i = 0; i < NetCDFReader3D.this.vars.size(); ++i) {
                double value = 0.0;
                NetCDFReader3D.this.origin[NetCDFReader3D.this.timeIndices[i]] = NetCDFReader3D.this.tIndex;
                try {
                    value = NetCDFReader3D.this.vars.get(i).read(NetCDFReader3D.this.origin, NetCDFReader3D.this.shape).getDouble(0);
                }
                catch (IOException ex) {
                    NetCDFReader3D.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader3D.this.fileName.getValue() + "\n" + ex);
                }
                catch (InvalidRangeException ex) {
                    NetCDFReader3D.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader3D.this.fileName.getValue() + "\n" + (Object)((Object)ex));
                }
                if (value == NetCDFReader3D.this.missingDataValues[i]) {
                    value = JAMS.getMissingDataValue();
                }
                NetCDFReader3D.this.values[i].setValue(value);
            }
        }
    };
    Runnable run_cached = new Runnable(){

        @Override
        public void run() {
            int i;
            long millis = NetCDFReader3D.this.currentTime.getTimeInMillis();
            if (millis != NetCDFReader3D.this.oldMillis) {
                NetCDFReader3D.this.oldMillis = millis;
                NetCDFReader3D.this.tIndex = NetCDFReader3D.this.timeMap.get(NetCDFReader3D.this.currentTime.getTimeInMillis());
                for (i = 0; i < NetCDFReader3D.this.vars.size(); ++i) {
                    NetCDFReader3D.this.origin[NetCDFReader3D.this.timeIndices[i]] = NetCDFReader3D.this.tIndex;
                    try {
                        NetCDFReader3D.this.dataArray[i] = NetCDFReader3D.this.vars.get(i).read(NetCDFReader3D.this.origin, NetCDFReader3D.this.shape);
                        continue;
                    }
                    catch (IOException ex) {
                        NetCDFReader3D.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader3D.this.fileName.getValue() + "\n" + ex);
                        continue;
                    }
                    catch (InvalidRangeException ex) {
                        NetCDFReader3D.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader3D.this.fileName.getValue() + "\n" + (Object)((Object)ex));
                    }
                }
            }
            for (i = 0; i < NetCDFReader3D.this.vars.size(); ++i) {
                double value = NetCDFReader3D.this.dataArray[i].getDouble(NetCDFReader3D.this.sIndex);
                if (value == NetCDFReader3D.this.missingDataValues[i]) {
                    value = JAMS.getMissingDataValue();
                }
                NetCDFReader3D.this.values[i].setValue(value);
            }
        }
    };

    public void init() {
        if (this.values == null || this.varNames == null || this.values.length != this.varNames.length) {
            this.getModel().getRuntime().sendHalt("Output values and input var names must be defined and must have same number!");
            return;
        }
        this.dataArray = new Array[this.values.length];
        this.missingDataValues = new double[this.values.length];
        this.latIndices = new int[this.values.length];
        this.lonIndices = new int[this.values.length];
        this.timeIndices = new int[this.values.length];
        try {
            String fileName_ = this.fileName.getValue();
            if (!new File(fileName_).exists() && this.getModel().getWorkspaceDirectory() != null) {
                fileName_ = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)fileName_);
            }
            if (!new File(fileName_).exists()) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't load NetCDF file " + this.fileName + "!\nIf you are not using an absolute path, please ensure you have defined a workspace directory!");
            }
            this.ncfile = NetcdfFiles.open((String)fileName_);
            if (this.timeDimName != null && this.latDimName != null && this.lonDimName != null) {
                this.timeDim = this.ncfile.findDimension(this.timeDimName.getValue());
                this.latDim = this.ncfile.findDimension(this.latDimName.getValue());
                this.lonDim = this.ncfile.findDimension(this.lonDimName.getValue());
            }
            if (this.timeDim == null || this.latDim == null || this.lonDim == null) {
                ImmutableList dimensions = this.ncfile.getDimensions();
                String error = "Please choose one of the following dimensions:";
                for (Dimension dimension : dimensions) {
                    String unit = this.ncfile.findVariable(dimension.getName()).getUnitsString();
                    error = error + "\nDimension: " + dimension + " [" + unit + "]";
                }
                this.getModel().getRuntime().sendHalt("Wrong dimension name. " + error);
                return;
            }
            Variable timeVar = this.ncfile.findVariable(this.timeDim.getShortName());
            Array timeValues = timeVar.read();
            Variable latVar = this.ncfile.findVariable(this.latDim.getShortName());
            Array latValues = latVar.read();
            Variable lonVar = this.ncfile.findVariable(this.lonDim.getShortName());
            Array lonValues = lonVar.read();
            int number_of_hours = 24;
            if (this.baseDate == null) {
                String units = timeVar.getUnitsString();
                String[] splitUnits = units.split("since ");
                String baseDateString = splitUnits[1];
                String timeStep = splitUnits[0];
                if (timeStep.equalsIgnoreCase("hours ")) {
                    number_of_hours = 1;
                }
                this.baseDate = this.getModel().getRuntime().getDataFactory().createCalendar();
                this.baseDate.setValue(baseDateString);
            }
            long baseMillis = this.baseDate.getTimeInMillis();
            int i = 0;
            while ((long)i < timeValues.getSize()) {
                long millis = Math.round(timeValues.getDouble(i) * (double)number_of_hours * 60.0 * 60.0 * 1000.0);
                this.timeMap.put(baseMillis + millis, i);
                ++i;
            }
            i = 0;
            while ((long)i < latValues.getSize()) {
                this.latMap.put(latValues.getDouble(i), i);
                ++i;
            }
            i = 0;
            while ((long)i < lonValues.getSize()) {
                this.lonMap.put(lonValues.getDouble(i), i);
                ++i;
            }
            if (this.varNames == null) {
                String error = "Please choose one or more of the following variables:";
                ImmutableList allVars = this.ncfile.getVariables();
                for (Variable variable : allVars) {
                    error = error + "\nVariable: " + variable.getFullName() + " (Dimensions: " + variable.getDimensionsString() + ")";
                }
                this.getModel().getRuntime().sendHalt("Wrong variable name. " + error);
                return;
            }
            i = 0;
            for (Attribute.String varName : this.varNames) {
                Attribute fillValue;
                Variable var = this.ncfile.findVariable(varName.getValue());
                if (var == null) {
                    String error = "Please choose one or more of the following variables:";
                    ImmutableList allVars = this.ncfile.getVariables();
                    for (Variable variable : allVars) {
                        error = error + "\nVariable: " + variable.getFullName() + " (Dimensions: " + variable.getDimensionsString() + ")";
                    }
                    this.getModel().getRuntime().sendHalt("Wrong variable name. " + error);
                    return;
                }
                this.vars.add(var);
                ImmutableList dimensions = var.getDimensions();
                int j = 0;
                for (Dimension dimension : dimensions) {
                    if (dimension == this.timeDim) {
                        this.timeIndices[i] = j;
                    } else if (dimension == this.latDim) {
                        this.latIndices[i] = j;
                    } else if (dimension == this.lonDim) {
                        this.lonIndices[i] = j;
                    }
                    ++j;
                }
                if (this.dataCaching.getValue()) {
                    // empty if block
                }
                if ((fillValue = var.findAttribute("_FillValue")) != null) {
                    this.missingDataValues[i] = fillValue.getNumericValue().doubleValue();
                }
                ++i;
            }
            this.runner = this.dataCaching.getValue() ? this.run_cached : this.run_normal;
        }
        catch (FileNotFoundException ex) {
            this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + this.fileName.getValue() + "\n" + ex);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + this.fileName.getValue() + "\n" + ex);
        }
    }

    public void run() throws IOException, InvalidRangeException {
        this.runner.run();
    }

    public void cleanup() {
    }
}

