/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.TSDataStore;

@JAMSComponentDescription(title="TimeIntervalFromDataStore", author="Sven Kralisch", description="Extract a time interval object from a data store", date="2021-12-22", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class TimeIntervalFromDataStore
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Datastore ID")
    public Attribute.String id;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The time interval covered by the datastore")
    public Attribute.TimeInterval[] timeIntervals;

    public void init() {
        InputDataStore is = null;
        if (this.id != null) {
            is = this.getModel().getWorkspace().getInputDataStore(this.id.getValue());
        }
        if (is == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Datastore could not be found!");
            return;
        }
        if (!(is instanceof TSDataStore)) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Datastore is not a time series datastore!");
            return;
        }
        TSDataStore store = (TSDataStore)is;
        for (Attribute.TimeInterval timeInterval : this.timeIntervals) {
            timeInterval.setStart(store.getStartDate());
            timeInterval.setEnd(store.getEndDate());
            timeInterval.setTimeUnit(store.getTimeUnit());
            timeInterval.setTimeUnitCount(store.getTimeUnitCount());
        }
    }
}

