/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import com.vividsolutions.jts.geom.MultiPolygon;
import jams.components.gui.MapCollection;
import jams.data.Attribute;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapeTool
extends JPanel {
    private File fileToSave;
    private File dbfFile;
    private ShapefileDataStore store;
    private URL baseShapeUrl;
    private String shpIdColName;
    private String addAttr;
    private Set<String> list;
    private CollectionDataStore feat;
    private JPanel boxes;

    private JPanel getShpAtts() throws IOException {
        this.boxes = new JPanel();
        this.boxes.setLayout(new BoxLayout(this.boxes, 1));
        List shpAtts = this.store.getSchema().getAttributeDescriptors();
        int sz = shpAtts.size();
        this.list = new TreeSet<String>();
        for (int i = 0; i < sz; ++i) {
            this.list.add(((AttributeDescriptor)shpAtts.get(i)).getName().toString());
        }
        String geoAtt = this.store.getSchema().getGeometryDescriptor().getName().toString();
        this.list.remove(geoAtt);
        JCheckBox addAttrCB = new JCheckBox(this.addAttr, true);
        addAttrCB.setEnabled(false);
        this.boxes.add(addAttrCB);
        int i = 1;
        Iterator<String> iterate = this.list.iterator();
        while (iterate.hasNext()) {
            this.boxes.add(new JCheckBox(iterate.next().toString()));
            ++i;
        }
        return this.boxes;
    }

    public ShapeTool(MapCollection features, Attribute.String Shapefile, final JSplitPane panel) throws Exception {
        this.baseShapeUrl = new File(Shapefile.toString().split(";")[0]).toURI().toURL();
        this.dbfFile = new File(Shapefile.toString().split(";")[0].substring(0, Shapefile.toString().split(";")[0].length() - 4) + ".dbf");
        this.shpIdColName = Shapefile.toString().split(";")[1];
        this.store = new ShapefileDataStore(this.baseShapeUrl);
        this.addAttr = features.getDesc();
        this.feat = features.asCollectionDataStore();
        this.setLayout(new BoxLayout(this, 1));
        JPanel t = new JPanel();
        JLabel title = new JLabel("Export to *.SHP:");
        t.add(title);
        this.add(t);
        JScrollPane sc = new JScrollPane(this.getShpAtts());
        this.add(sc);
        JPanel b = new JPanel();
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int div = ((JSplitPane)ShapeTool.this.getParent()).getDividerLocation();
                ((JSplitPane)ShapeTool.this.getParent()).setRightComponent(panel);
                ((JSplitPane)panel.getParent()).setDividerLocation(div);
            }
        });
        JButton export = new JButton("Save");
        export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogType(1);
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "Shapefile (*.shp)";
                        }

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith(".shp");
                        }
                    });
                    fc.showSaveDialog(null);
                    if (!fc.getSelectedFile().getAbsolutePath().endsWith(".shp")) {
                        ShapeTool.this.fileToSave = new File(fc.getSelectedFile().getAbsolutePath() + ".shp");
                    } else {
                        ShapeTool.this.fileToSave = fc.getSelectedFile();
                    }
                    CoordinateReferenceSystem crs = ShapeTool.this.store.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
                    ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
                    HashMap<String, Serializable> create = new HashMap<String, Serializable>();
                    create.put("url", ShapeTool.this.fileToSave.toURI().toURL());
                    create.put("create spatial index", Boolean.TRUE);
                    DataStore ds = factory.createNewDataStore(create);
                    DbaseFileHeader header = new DbaseFileHeader();
                    header.readHeader((ReadableByteChannel)new FileInputStream(ShapeTool.this.dbfFile).getChannel());
                    SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
                    sftb.setName("mapFType");
                    sftb.setCRS(crs);
                    sftb.add("geo", MultiPolygon.class);
                    Component[] comps = ShapeTool.this.boxes.getComponents();
                    ArrayList<Component> attList = new ArrayList<Component>();
                    for (int i = 0; i < comps.length; ++i) {
                        Component comp = comps[i];
                        if (!((JCheckBox)comp).isSelected()) continue;
                        attList.add(comp);
                    }
                    HashMap<String, Class> types = new HashMap<String, Class>();
                    types.put(ShapeTool.this.addAttr, Double.class);
                    for (int i = 0; i < header.getNumFields(); ++i) {
                        types.put(header.getFieldName(i), header.getFieldClass(i));
                    }
                    for (JCheckBox jCheckBox : attList) {
                        sftb.add(jCheckBox.getText(), (Class)types.get(jCheckBox.getText()));
                    }
                    SimpleFeatureType mapFType = sftb.buildFeatureType();
                    ds.createSchema((FeatureType)mapFType);
                    FeatureWriter featureWriter = ds.getFeatureWriter("mapFType", Transaction.AUTO_COMMIT);
                    FeatureIterator reader = ShapeTool.this.store.getFeatureSource().getFeatures().features();
                    HashMap<Long, Object> h = new HashMap<Long, Object>();
                    FeatureIterator it = ShapeTool.this.feat.getCollection().features();
                    while (it.hasNext()) {
                        SimpleFeature q = (SimpleFeature)it.next();
                        h.put(Long.valueOf(q.getID()), q.getAttribute("newAt"));
                    }
                    while (reader.hasNext()) {
                        SimpleFeature f = (SimpleFeature)reader.next();
                        SimpleFeature w = (SimpleFeature)featureWriter.next();
                        w.setAttribute("geo", f.getDefaultGeometry());
                        Iterator iterate = attList.iterator();
                        w.setAttribute(((JCheckBox)iterate.next()).getText(), h.get(Long.valueOf(f.getAttribute(ShapeTool.this.shpIdColName).toString())));
                        while (iterate.hasNext()) {
                            String s = ((JCheckBox)iterate.next()).getText();
                            w.setAttribute(s, f.getAttribute(s));
                        }
                        featureWriter.write();
                    }
                    featureWriter.close();
                    JOptionPane.showMessageDialog(null, "Shapefile " + ShapeTool.this.fileToSave.getName() + " created!");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
                int div = ((JSplitPane)ShapeTool.this.getParent()).getDividerLocation();
                ((JSplitPane)ShapeTool.this.getParent()).setRightComponent(panel);
                ((JSplitPane)panel.getParent()).setDividerLocation(div);
            }
        });
        b.add(cancel);
        b.add(export);
        this.add(b);
        this.setVisible(true);
    }
}

