/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.HashMap;
import java.util.Map;

@JAMSComponentDescription(title="MODIS_ET_Regionalizer", author="Sven Kralisch", description="Distribute monthly MODIS ET data to model entities", date="2016-04-14", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2016-04-14", comment="Initial version"), @VersionComments.Entry(version="1.1_0", date="2016-04-20", comment="Fixed handling of missing data values")})
public class MODIS_ET_Assigner
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="MODIS ET values of current time step")
    public Attribute.DoubleArray modisETArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of HRU IDs from MODIS file")
    public Attribute.IntegerArray hruIDArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU ID")
    public Attribute.Double hruID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU area", unit="m\u00b2")
    public Attribute.Double hruArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="MODIS ET value", unit="L")
    public Attribute.Double modisET;
    Map<Integer, Integer> hru2idMap;

    public void run() {
        if (this.hru2idMap == null) {
            this.hru2idMap = new HashMap<Integer, Integer>();
            int[] hruID = this.hruIDArray.getValue();
            for (int i = 0; i < hruID.length; ++i) {
                this.hru2idMap.put(hruID[i], i);
            }
        }
        double value = this.modisETArray.getValue()[this.hru2idMap.get((int)this.hruID.getValue())];
        int days = this.time.getActualMaximum(5);
        if (value < 0.0) {
            value = this.modisET.getValue();
        }
        this.modisET.setValue(value * this.hruArea.getValue() / (double)days);
    }
}

