/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.Model;
import jams.tools.FileTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

@JAMSComponentDescription(title="StandardEntityReader", author="Sven Kralisch & Christian Fischer", description="This component reads two ASCII files containing data of hru and reach entities and creates two collections of entities accordingly. 1:n topologies between different entities are created based on provided attribute names. Additionally, the topologies are checked for cycles.", date="2010-01-29", version="1.1_0")
public class LinkedEntityReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU parameter file name")
    public Attribute.String hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach parameter file name")
    public Attribute.String reachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the HRU identifiers", defaultValue="ID")
    public Attribute.String hruIDAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the reach identifiers", defaultValue="ID")
    public Attribute.String reachIDAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_poly")
    public Attribute.String hru2hruAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String hru2reachAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the reach to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String reach2reachAttribute;

    public void init() {
        ArrayList<Attribute.Entity> hruCollection = this.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.hruFileName.getValue()), this.getModel());
        for (Attribute.Entity e : hruCollection) {
            try {
                e.setId((long)e.getDouble(this.hruFileName.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K HRUu parameter file (" + this.hruFileName.getValue() + ")!");
            }
        }
        this.hrus.setEntities(hruCollection);
        ArrayList<Attribute.Entity> reachCollection = this.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.reachFileName.getValue()), this.getModel());
        for (Attribute.Entity e : reachCollection) {
            try {
                e.setId((long)e.getDouble(this.reachFileName.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K Reach parameter file (" + this.reachFileName.getValue() + ")!");
            }
        }
        this.reaches.setEntities(reachCollection);
        this.createTopology();
        this.getModel().getRuntime().println("Create ordered hru-list", 2);
        this.createOrderedList(this.hrus, this.hru2hruAttribute.getValue());
        this.getModel().getRuntime().println("HRU entities read successfully", 1);
        this.getModel().getRuntime().println("Create ordered reach-list", 2);
        this.createOrderedList(this.reaches, this.reach2reachAttribute.getValue());
        this.getModel().getRuntime().println("Reach entities read successfully", 1);
    }

    protected boolean cycleCheck(Attribute.Entity node, Stack<Attribute.Entity> searchStack, HashSet<Long> closedList, HashSet<Long> visitedList) {
        if (searchStack.indexOf(node) != -1) {
            int index = searchStack.indexOf(node);
            String cyc_output = new String();
            for (int i = index; i < searchStack.size(); ++i) {
                cyc_output = cyc_output + ((Attribute.Entity)searchStack.get(i)).getId() + " ";
            }
            this.getModel().getRuntime().println("Found circle with ids:" + cyc_output);
            return true;
        }
        if (closedList.contains(node.getId())) {
            return false;
        }
        visitedList.add(node.getId());
        Attribute.Entity child_node = (Attribute.Entity)node.getObject(this.hru2hruAttribute.getValue());
        if (child_node != null && child_node.isEmpty()) {
            child_node = null;
        }
        if (child_node != null) {
            searchStack.push(node);
            boolean result = this.cycleCheck(child_node, searchStack, closedList, visitedList);
            searchStack.pop();
            return result;
        }
        return false;
    }

    protected boolean cycleCheck() {
        HashSet<Long> closedList = new HashSet<Long>();
        HashSet<Long> visitedList = new HashSet<Long>();
        this.getModel().getRuntime().println("Cycle checking...");
        Iterator hruIterator = this.hrus.getEntities().iterator();
        boolean result = false;
        while (hruIterator.hasNext()) {
            Attribute.Entity start_node = (Attribute.Entity)hruIterator.next();
            if (closedList.contains(start_node.getId())) continue;
            if (this.cycleCheck(start_node, new Stack<Attribute.Entity>(), closedList, visitedList)) {
                result = true;
            }
            closedList.addAll(visitedList);
            visitedList.clear();
        }
        return result;
    }

    protected void createTopology() {
        Attribute.Entity toReach;
        HashMap<Double, Attribute.Entity> hruMap = new HashMap<Double, Attribute.Entity>();
        HashMap<Double, Attribute.Entity> reachMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity e : this.hrus.getEntities()) {
            hruMap.put(e.getDouble(this.hruIDAttribute.getValue()), e);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            reachMap.put(e.getDouble(this.reachIDAttribute.getValue()), e);
        }
        Attribute.Entity nullEntity = this.getModel().getRuntime().getDataFactory().createEntity();
        hruMap.put(new Double(0.0), nullEntity);
        reachMap.put(new Double(0.0), nullEntity);
        for (Attribute.Entity e : this.hrus.getEntities()) {
            Attribute.Entity toPoly = (Attribute.Entity)hruMap.get(e.getDouble(this.hru2hruAttribute.getValue()));
            toReach = (Attribute.Entity)reachMap.get(e.getDouble(this.hru2reachAttribute.getValue()));
            if (toPoly == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological hru neighbour for HRU with ID " + e.getId() + " could not be found. This may cause errors! The neighbour in question is " + this.hru2hruAttribute.getValue());
            }
            if (toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological reach neighbour for HRU with ID " + e.getId() + " could not be found. This may cause errors! The neighbour in question is " + this.hru2reachAttribute.getValue());
            }
            e.setObject(this.hru2hruAttribute.getValue(), (Object)toPoly);
            e.setObject(this.hru2reachAttribute.getValue(), (Object)toReach);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            toReach = (Attribute.Entity)reachMap.get(e.getDouble(this.reach2reachAttribute.getValue()));
            if (toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological neighbour for reach with ID " + e.getId() + " could not be found. This may cause errors!");
            }
            e.setObject(this.reach2reachAttribute.getValue(), (Object)toReach);
        }
        if (this.getModel().getRuntime().getDebugLevel() >= 3) {
            if (this.cycleCheck()) {
                this.getModel().getRuntime().sendHalt("HRUs --> cycle found ... :( ");
            } else {
                this.getModel().getRuntime().println("HRUs --> no cycle found");
            }
        }
    }

    protected void createOrderedList(Attribute.EntityCollection col, String asso) {
        int i;
        ArrayList<Attribute.Entity> newList = new ArrayList<Attribute.Entity>();
        HashMap<Object, Integer> depthMap = new HashMap<Object, Integer>();
        boolean mapChanged = true;
        Iterator hruIterator = col.getEntities().iterator();
        while (hruIterator.hasNext()) {
            depthMap.put(hruIterator.next(), new Integer(0));
        }
        int maxDepth = 0;
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e : col.getEntities()) {
                Attribute.Entity f = (Attribute.Entity)e.getObject(asso);
                if (f != null && f.isEmpty()) {
                    f = null;
                }
                if (f == null) continue;
                Integer eDepth = (Integer)depthMap.get(e);
                Integer fDepth = (Integer)depthMap.get(f);
                if (fDepth > eDepth) continue;
                depthMap.put(f, new Integer(eDepth + 1));
                mapChanged = true;
            }
        }
        maxDepth = 0;
        for (Attribute.Entity e : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e : col.getEntities()) {
            int depth = (Integer)depthMap.get(e);
            ((ArrayList)alList.get(depth)).add(e);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity e : (ArrayList)alList.get(i)) {
                newList.add(e);
            }
        }
        col.setEntities(newList);
    }

    private ArrayList<Attribute.Entity> readParas(String fileName, Model model) {
        ArrayList<Attribute.Entity> entityList = new ArrayList<Attribute.Entity>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            Vector<String> attributeNames = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(s, "\t");
            while (tokenizer.hasMoreTokens()) {
                String aName = tokenizer.nextToken();
                if (aName.equals("to-reach")) {
                    aName = "to_reach";
                }
                attributeNames.add(aName);
            }
            reader.readLine();
            reader.readLine();
            reader.readLine();
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                Attribute.Entity e = this.getModel().getRuntime().getDataFactory().createEntity();
                tokenizer = new StringTokenizer(s, "\t");
                for (int i = 0; i < attributeNames.size(); ++i) {
                    String token = tokenizer.nextToken();
                    try {
                        e.setDouble((String)attributeNames.get(i), Double.parseDouble(token));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        e.setObject((String)attributeNames.get(i), (Object)token);
                    }
                }
                entityList.add(e);
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            model.getRuntime().handle((Throwable)ioe);
        }
        return entityList;
    }
}

