/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.data.JAMSTimeInterval;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

@JAMSComponentDescription(title="Entity file writer (spatial+monthly)", author="D. Varga", description="Base: StandardEntityWriterN (S.Kralisch).Use: For calculating monthly averages, the time Interval should be always one day longer.")
public class EntityWriterMonthlyAgg_DiffBuilder
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EntitySet")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The model time interval")
    public Attribute.TimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The aggregation time interval")
    public Attribute.TimeInterval aggTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.String header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attribute names")
    public Attribute.StringArray attributeNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity attribute name for weight [attName | none]")
    public Attribute.String weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.Boolean monthlyValuesWriting;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.Boolean monthlyAverage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.Boolean stDev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="type of calculation - sum, average, stDev")
    public Attribute.String type;
    private GenericDataWriter writer;
    private double[][] valueMatrix;
    private double[] valueMatrixAverage;
    private double[] valueMatrixStDev;
    private double[] StDev;
    private double[] dailyValue;
    private double[] attrbValue;
    private double[] oldDailyValue;
    private double[] diffValue;
    private double[][] diffValueMatrix;
    private double[] weightVal;
    private String[] dateVals;
    private String timeFormat = "%1$td.%1$tm.%1$tY";
    private DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private DateFormat dateMonthFormat = new SimpleDateFormat("ddd");
    private int tcounter;
    private int daycounter;
    private long dayBeforeAggTI;
    private int oldMonth;
    private int nEnts;
    private double[][] aggMatrix;
    private int[] aggCounter;
    private String[] aggFieldNames;
    private Attribute.TimeInterval timeInterval2;
    private int nAttrbs;
    private int counter = 0;
    private int aggTsteps = 0;

    public void init() {
        Attribute.Calendar model_sd = this.modelTimeInterval.getStart().clone();
        Attribute.Calendar model_ed = this.modelTimeInterval.getEnd().clone();
        int model_tres = this.modelTimeInterval.getTimeUnit();
        long sdMod = model_sd.getTimeInMillis();
        long edMod = model_ed.getTimeInMillis();
        long model_tsteps = 0L;
        model_tsteps = this.modelTimeInterval.getNumberOfTimesteps();
        Attribute.Calendar agg_sd = this.aggTimeInterval.getStart().clone();
        Attribute.Calendar agg_ed = this.aggTimeInterval.getEnd().clone();
        int agg_tres = this.aggTimeInterval.getTimeUnit();
        long sdAgg = agg_sd.getTimeInMillis();
        long edAgg = agg_ed.getTimeInMillis();
        if (agg_sd.before(model_sd)) {
            this.aggTimeInterval.setStart(model_sd);
            this.getModel().getRuntime().println("aggStartdate was set equal to model startdate", 1);
        }
        if (model_ed.before(agg_ed)) {
            this.aggTimeInterval.setEnd(model_ed);
            this.getModel().getRuntime().println("aggEnddate was set equal to model enddate", 1);
        }
        this.aggTsteps = (int)this.aggTimeInterval.getNumberOfTimesteps();
        int ts = (int)this.getContext().getNumberOfIterations();
        this.getModel().getRuntime().println("aggStartdate:\t" + agg_sd.toString(), 2);
        this.getModel().getRuntime().println("aggEnddate:\t" + agg_ed.toString(), 2);
        this.dayBeforeAggTI = sdAgg - 86400000L;
        agg_ed.setTimeInMillis(edAgg += 86400000L);
        this.aggTimeInterval.setEnd(agg_ed);
        this.writer = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.fileName.getValue());
        this.timeInterval2 = new JAMSTimeInterval(this.aggTimeInterval.getStart(), this.aggTimeInterval.getEnd(), 2, 1);
        int tsteps = (int)this.timeInterval2.getNumberOfTimesteps();
        this.nEnts = this.entities.getEntityArray().length;
        this.valueMatrix = new double[tsteps + 1][this.nEnts];
        this.valueMatrixAverage = new double[this.nEnts];
        this.StDev = new double[this.nEnts];
        this.dailyValue = new double[this.nEnts];
        this.attrbValue = new double[this.nEnts];
        this.oldDailyValue = new double[this.nEnts];
        this.weightVal = new double[this.nEnts];
        this.diffValue = new double[this.nEnts];
        this.dateVals = new String[tsteps];
        this.nAttrbs = this.attributeNames.getValue().length;
        this.timeFormat = "%1$tb/%1$ty";
        this.dateFormat = new SimpleDateFormat("MMM/yy");
        this.aggMatrix = new double[12][this.nEnts];
        this.aggCounter = new int[12];
        this.aggFieldNames = new String[12];
        this.tcounter = 0;
        int oldMonth = this.time.get(2);
    }

    public void run() {
        long checkTime = this.time.getTimeInMillis();
        if (checkTime == this.dayBeforeAggTI) {
            int a;
            int i;
            if (this.weight.getValue().equals("none")) {
                for (i = 0; i < this.nEnts; ++i) {
                    for (a = 0; a < this.nAttrbs; ++a) {
                        this.attrbValue[i] = ((Attribute.Double)this.entities.getEntityArray()[i].getObject(this.attributeNames.getValue()[a])).getValue();
                        this.oldDailyValue[i] = this.oldDailyValue[i] + this.attrbValue[i];
                    }
                }
            } else {
                for (i = 0; i < this.nEnts; ++i) {
                    this.weightVal[i] = ((Attribute.Double)this.entities.getEntityArray()[i].getObject(this.weight.getValue())).getValue();
                    for (a = 0; a < this.nAttrbs; ++a) {
                        this.attrbValue[i] = ((Attribute.Double)this.entities.getEntityArray()[i].getObject(this.attributeNames.getValue()[a])).getValue();
                        this.oldDailyValue[i] = this.oldDailyValue[i] + this.attrbValue[i] / this.weightVal[i];
                    }
                }
            }
        }
        if (!this.time.after(this.aggTimeInterval.getEnd()) && !this.time.before(this.aggTimeInterval.getStart())) {
            int a;
            int i;
            int newMonth = this.time.get(2);
            if (newMonth != this.oldMonth) {
                this.dateVals[this.tcounter] = this.time.toString(this.dateFormat);
                if (this.tcounter > 0) {
                    int i2;
                    int month = this.oldMonth;
                    this.aggFieldNames[month] = this.time.toString(this.dateMonthFormat);
                    if (this.type.getValue().equals("average")) {
                        for (i2 = 0; i2 < this.nEnts; ++i2) {
                            this.valueMatrixAverage[i2] = this.valueMatrix[this.tcounter][i2] / (double)this.daycounter;
                            double[] dArray = this.aggMatrix[month];
                            int n = i2;
                            dArray[n] = dArray[n] + this.valueMatrixAverage[i2];
                            this.valueMatrix[this.tcounter][i2] = this.valueMatrixAverage[i2];
                        }
                    } else if (this.type.getValue().equals("stDev")) {
                        for (i2 = 0; i2 < this.nEnts; ++i2) {
                            this.valueMatrixAverage[i2] = this.valueMatrix[this.tcounter][i2] / (double)this.daycounter;
                            double sum = 0.0;
                            for (int d = 0; d < this.daycounter; ++d) {
                                sum += Math.pow(this.diffValueMatrix[d][i2] - this.valueMatrixAverage[i2], 2.0);
                            }
                            this.StDev[i2] = Math.sqrt(sum / (double)(this.daycounter - 1));
                            this.valueMatrix[this.tcounter][i2] = this.StDev[i2];
                            double[] dArray = this.aggMatrix[month];
                            int n = i2;
                            dArray[n] = dArray[n] + this.valueMatrix[this.tcounter][i2];
                        }
                    } else if (this.type.getValue().equals("sum")) {
                        for (i2 = 0; i2 < this.nEnts; ++i2) {
                            double[] dArray = this.aggMatrix[month];
                            int n = i2;
                            dArray[n] = dArray[n] + this.valueMatrix[this.tcounter][i2];
                        }
                    }
                    int n = month;
                    this.aggCounter[n] = this.aggCounter[n] + 1;
                }
                ++this.tcounter;
                this.daycounter = 0;
            }
            if (this.daycounter == 0) {
                int d = this.time.getActualMaximum(5);
                this.diffValueMatrix = new double[d][this.nEnts];
            }
            if (this.weight.getValue().equals("none")) {
                for (i = 0; i < this.nEnts; ++i) {
                    for (a = 0; a < this.nAttrbs; ++a) {
                        this.attrbValue[i] = ((Attribute.Double)this.entities.getEntityArray()[i].getObject(this.attributeNames.getValue()[a])).getValue();
                        this.dailyValue[i] = this.dailyValue[i] + this.attrbValue[i];
                    }
                    this.diffValue[i] = this.dailyValue[i] - this.oldDailyValue[i];
                    if (this.type.getValue().equals("stDev")) {
                        this.diffValueMatrix[this.daycounter][i] = this.diffValue[i];
                    }
                    this.valueMatrix[this.tcounter][i] = this.valueMatrix[this.tcounter][i] + this.diffValue[i];
                    this.oldDailyValue[i] = this.dailyValue[i];
                }
            } else {
                for (i = 0; i < this.nEnts; ++i) {
                    this.weightVal[i] = ((Attribute.Double)this.entities.getEntityArray()[i].getObject(this.weight.getValue())).getValue();
                    this.dailyValue[i] = 0.0;
                    for (a = 0; a < this.nAttrbs; ++a) {
                        this.attrbValue[i] = ((Attribute.Double)this.entities.getEntityArray()[i].getObject(this.attributeNames.getValue()[a])).getValue();
                        this.dailyValue[i] = this.dailyValue[i] + this.attrbValue[i] / this.weightVal[i];
                    }
                    this.diffValue[i] = this.dailyValue[i] - this.oldDailyValue[i];
                    if (this.type.getValue().equals("stDev")) {
                        this.diffValueMatrix[this.daycounter][i] = this.diffValue[i];
                    }
                    this.valueMatrix[this.tcounter][i] = this.valueMatrix[this.tcounter][i] + this.diffValue[i];
                    this.oldDailyValue[i] = this.dailyValue[i];
                }
            }
            ++this.daycounter;
            this.oldMonth = this.time.get(2);
        }
    }

    public void cleanup() {
        this.getModel().getRuntime().println("Writing distributed output file ... may take a while ... please wait ...", 1);
        this.getModel().getRuntime().println("Number of entities: " + this.nEnts + ", number of timeSteps: " + this.dateVals.length);
        try {
            this.writer.addComment("J2K model output: " + this.header.getValue());
            this.writer.addComment("");
            this.writer.addColumn("ID");
            if (this.monthlyValuesWriting.getValue()) {
                for (int i = 0; i < this.tcounter - 1; ++i) {
                    this.writer.addColumn(this.dateVals[i]);
                }
            }
            this.writer.addColumn("Jan");
            this.writer.addColumn("Feb");
            this.writer.addColumn("Mar");
            this.writer.addColumn("Apr");
            this.writer.addColumn("May");
            this.writer.addColumn("Jun");
            this.writer.addColumn("Jul");
            this.writer.addColumn("Aug");
            this.writer.addColumn("Sep");
            this.writer.addColumn("Oct");
            this.writer.addColumn("Nov");
            this.writer.addColumn("Dec");
            this.writer.addColumn("Year");
            this.writer.writeHeader();
            for (int e = 0; e < this.nEnts; ++e) {
                String dStr;
                int ID = (int)((Attribute.Double)this.entities.getEntityArray()[e].getObject("ID")).getValue();
                this.writer.addData((Object)ID);
                if (this.monthlyValuesWriting.getValue()) {
                    for (int t = 1; t < this.tcounter; ++t) {
                        String dStr2 = String.format(Locale.US, "%.3f", this.valueMatrix[t][e]);
                        this.writer.addData((Object)dStr2);
                    }
                }
                double aggSum = 0.0;
                for (int t = 0; t < 12; ++t) {
                    aggSum += this.aggMatrix[t][e] / (double)this.aggCounter[t];
                    String dStr3 = String.format(Locale.US, "%.3f", this.aggMatrix[t][e] / (double)this.aggCounter[t]);
                    this.writer.addData((Object)dStr3);
                }
                if (!this.type.getValue().equals("sum")) {
                    aggSum /= 12.0;
                }
                if (this.weight.getValue().equals("none")) {
                    dStr = String.format(Locale.US, "%.3f", aggSum);
                    this.writer.addData((Object)dStr);
                } else {
                    dStr = String.format(Locale.US, "%.3f", aggSum);
                    this.writer.addData((Object)dStr);
                }
                this.writer.writeData();
            }
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Throwable)jre);
        }
        this.writer.flush();
        this.writer.close();
        this.getModel().getRuntime().println("Finished distributed output file ... you may continue ...", 1);
    }
}

