/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.JAMS;
import jams.data.Attribute;
import jams.io.XMLProcessor;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import jams.tools.XMLTools;
import java.io.File;
import java.io.IOException;
import org.xml.sax.SAXException;

public class DocumentLoader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.String modelFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.String workspaceDir;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects")
    public Attribute.Document modelDoc;

    public String init_withResponse() {
        try {
            String info = "";
            String modelFilename = FileTools.createAbsoluteFileName((String)this.workspaceDir.toString(), (String)this.modelFile.toString());
            File file = new File(modelFilename);
            if (!file.exists()) {
                return JAMS.i18n((String)"Model_file_") + modelFilename + JAMS.i18n((String)"_could_not_be_found_-_exiting!");
            }
            String newModelFilename = XMLProcessor.modelDocConverter((String)modelFilename);
            if (!newModelFilename.equalsIgnoreCase(modelFilename)) {
                info = JAMS.i18n((String)"The_model_definition_in_") + modelFilename + JAMS.i18n((String)"_has_been_adapted_in_order_to_meet_changes_in_the_JAMS_model_specification.The_new_definition_has_been_stored_in_") + newModelFilename + JAMS.i18n((String)"_while_your_original_file_was_left_untouched.");
                modelFilename = newModelFilename;
            }
            String xmlString = FileTools.fileToString((String)modelFilename);
            Object args = null;
            if (args != null) {
                for (int i = 0; i < (args).length; ++i) {
                    xmlString = xmlString.replaceAll("%" + i, (String)args[i]);
                }
            }
            try {
                this.modelDoc.setValue(XMLTools.getDocumentFromString((String)xmlString));
            }
            catch (IOException ioe) {
                return JAMS.i18n((String)"The_model_definition_file_") + modelFilename + JAMS.i18n((String)"_could_not_be_loaded,_because:_") + ioe.toString();
            }
            catch (SAXException se) {
                return JAMS.i18n((String)"The_model_definition_file_") + modelFilename + JAMS.i18n((String)"_contained_errors!");
            }
        }
        catch (Exception e) {
            return JAMS.i18n((String)"Can^t_load_model_file,_because_") + e.toString();
        }
        return null;
    }

    public void init() {
        String error = this.init_withResponse();
        if (error != null) {
            this.getModel().getRuntime().sendHalt(error);
        }
    }
}

