/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@JAMSComponentDescription(title="Title", author="Author", description="Description", date="YYYY-MM-DD", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class DataSerializer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.DoubleArray obsInArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.StringArray obsIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.Double simValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.Double simID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Description", defaultValue="True")
    public Attribute.Boolean includeMissing;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Description")
    public Attribute.Object simOutArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Description")
    public Attribute.Object obsOutArray;
    private Map<Double, Integer> order = null;

    public void initAll() {
        this.simOutArray.setValue(new ArrayList());
        this.obsOutArray.setValue(new ArrayList());
    }

    public void run() {
        int pos;
        if (this.order == null) {
            this.order = new HashMap<Double, Integer>();
            pos = 0;
            for (String s : this.obsIDs.getValue()) {
                this.order.put(Double.valueOf(s), pos++);
            }
        }
        if (!this.order.containsKey(this.simID.getValue())) {
            return;
        }
        pos = this.order.get(this.simID.getValue());
        double obsValue = this.obsInArray.getValue()[pos];
        if (this.includeMissing.getValue()) {
            ((ArrayList)this.simOutArray.getValue()).add(this.simValue.getValue());
            ((ArrayList)this.obsOutArray.getValue()).add(obsValue);
        } else if (obsValue != Double.POSITIVE_INFINITY) {
            ((ArrayList)this.simOutArray.getValue()).add(this.simValue.getValue());
            ((ArrayList)this.obsOutArray.getValue()).add(obsValue);
        }
    }

    public void cleanup() {
    }
}

