/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.JAMS;
import jams.components.aggregate.TSAggregator;
import jams.components.indices.StandardPrecipitationIndex;
import jams.components.indices.TimeSeriesIndicators;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

@JAMSComponentDescription(title="TNC_Precip_Indicators", author="Sven Kralisch", description="Calculates various time series indicators such as:- Standard Precipitation Index (SPI)- accumulated annual rainfall- total number of days with/without rain in a hydrological year- number of consecutive days with/without rain- number of days with extreme precipitation (e.g.  >100 mm/day)", date="2019-03-06", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class TNC_PrecipIndicators
extends TimeSeriesIndicators {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="DAY/MONTH indicating start of hydrological year", defaultValue="01/11")
    public Attribute.String hydroYearStart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Treshold for extreme precip", defaultValue="100")
    public Attribute.Double extremePrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of JSON output file (leave empty to diable)")
    public Attribute.String jsonFileName;

    public void run() {
        this.readTSData();
        ArrayList<String> years = new ArrayList<String>();
        String[] s = this.hydroYearStart.getValue().split("/");
        Attribute.Calendar hStart = ((Attribute.Calendar)this.dates.get(0)).clone();
        hStart.set(5, Integer.parseInt(s[0]));
        hStart.set(2, Integer.parseInt(s[1]) - 1);
        if (hStart.before((Attribute.Calendar)this.dates.get(0))) {
            hStart.add(1, 1);
        }
        JSONObject json = new JSONObject();
        json.put("dates", (Collection)this.dateStrings);
        json.put("hYStart", (Object)this.hydroYearStart.getValue());
        json.put("extremeThreshold", this.extremePrecip.getValue());
        json.put("nColumns", this.values.length);
        JSONObject jsonColumn = new JSONObject();
        json.put("columns", (Object)jsonColumn);
        for (int i = 0; i < this.values.length; ++i) {
            double[] array = new double[this.values[i].size()];
            for (int j = 0; j < this.values[i].size(); ++j) {
                array[j] = (Double)this.values[i].get(j);
            }
            JSONObject colStats = new JSONObject();
            jsonColumn.put(Integer.toString(i), (Object)colStats);
            JSONObject jsonPprecipSum = new JSONObject();
            colStats.put("precipSum", (Object)jsonPprecipSum);
            JSONObject jsonDryDays = new JSONObject();
            colStats.put("dryDays", (Object)jsonDryDays);
            JSONObject jsonWetDays = new JSONObject();
            colStats.put("wetDays", (Object)jsonWetDays);
            JSONObject jsonExtremeDays = new JSONObject();
            colStats.put("extremeDays", (Object)jsonExtremeDays);
            JSONObject jsonSPI = new JSONObject();
            colStats.put("spi", (Object)jsonSPI);
            JSONObject jsonMissingDays = new JSONObject();
            colStats.put("missingTimeSteps", (Object)jsonMissingDays);
            jsonSPI.put("missingDataValue", StandardPrecipitationIndex.MISSING_DATA_VALUE);
            TSAggregator aggr = new TSAggregator(array, this.dates, 0);
            TSAggregator.Aggregate aggrResult = aggr.toMonthly();
            double[] a = aggrResult.values;
            String[] dateArray = new String[aggrResult.dates.size()];
            for (int j = 0; j < aggrResult.dates.size(); ++j) {
                dateArray[j] = aggrResult.dates.get(j).toString();
            }
            jsonSPI.put("dates", (Object)dateArray);
            double[] spi = StandardPrecipitationIndex.calcSPI(Arrays.copyOf(a, a.length));
            this.round(spi);
            jsonSPI.put("m1", (Object)spi);
            spi = StandardPrecipitationIndex.calcSPIn(Arrays.copyOf(a, a.length), 3);
            this.round(spi);
            jsonSPI.put("m3", (Object)spi);
            spi = StandardPrecipitationIndex.calcSPIn(Arrays.copyOf(a, a.length), 12);
            this.round(spi);
            jsonSPI.put("m12", (Object)spi);
            spi = StandardPrecipitationIndex.calcSPIn(Arrays.copyOf(a, a.length), 24);
            this.round(spi);
            jsonSPI.put("m24", (Object)spi);
            spi = StandardPrecipitationIndex.calcSPIn(Arrays.copyOf(a, a.length), 48);
            this.round(spi);
            jsonSPI.put("m48", (Object)spi);
            double sum = 0.0;
            double count = 0.0;
            int year = -1;
            int wetCount = 0;
            int dryCount = 0;
            int consWetCount = 0;
            int consDryCount = 0;
            int extremeCount = 0;
            int missingCount = 0;
            boolean isWet = false;
            boolean inMissingTI = false;
            ArrayList<Double> sumValues = new ArrayList<Double>();
            ArrayList<Integer> consDryValues = new ArrayList<Integer>();
            ArrayList<Integer> consWetValues = new ArrayList<Integer>();
            ArrayList<String[]> missingTIs = new ArrayList<String[]>();
            for (int j = 0; j < this.values[i].size(); ++j) {
                double d = array[j];
                if (((Attribute.Calendar)this.dates.get(j)).compareTo(hStart, 2) == 0) {
                    hStart.add(1, 1);
                    if (year > 0) {
                        if (i == 0) {
                            years.add(Integer.toString(year));
                        }
                        jsonPprecipSum.put(Integer.toString(year), sumValues);
                        jsonDryDays.put(Integer.toString(year), dryCount);
                        jsonWetDays.put(Integer.toString(year), wetCount);
                        jsonExtremeDays.put(Integer.toString(year), extremeCount);
                        jsonMissingDays.put(Integer.toString(year), missingCount);
                    }
                    sum = 0.0;
                    count = 0.0;
                    wetCount = 0;
                    dryCount = 0;
                    missingCount = 0;
                    extremeCount = 0;
                    sumValues.clear();
                    year = ((Attribute.Calendar)this.dates.get(j)).get(1);
                }
                if (d == JAMS.getMissingDataValue()) {
                    if (!inMissingTI) {
                        String[] gap = new String[2];
                        gap[0] = ((Attribute.Calendar)this.dates.get(j)).toString();
                        missingTIs.add(gap);
                        inMissingTI = true;
                    }
                } else if (inMissingTI) {
                    ((String[])missingTIs.get((int)(missingTIs.size() - 1)))[1] = ((Attribute.Calendar)this.dates.get(j - 1)).toString();
                    inMissingTI = false;
                }
                if (!inMissingTI) {
                    count += 1.0;
                    sum += d;
                    if (isWet && !(d > 0.0)) {
                        consWetCount = 0;
                        isWet = false;
                    } else if (!isWet && d > 0.0) {
                        consDryCount = 0;
                        isWet = true;
                    }
                    if (d > 0.0) {
                        ++wetCount;
                        ++consWetCount;
                    } else {
                        ++dryCount;
                        ++consDryCount;
                    }
                    if (d >= this.extremePrecip.getValue()) {
                        ++extremeCount;
                    }
                    sumValues.add((double)Math.round(sum * 100.0) / 100.0);
                } else {
                    ++missingCount;
                    consWetCount = 0;
                    consDryCount = 0;
                    isWet = false;
                    sumValues.add(null);
                }
                consDryValues.add(consDryCount);
                consWetValues.add(consWetCount);
            }
            if (this.lastPlusOne.compareTo(hStart, 5) == 0 && year > 0) {
                if (i == 0) {
                    years.add(Integer.toString(year));
                }
                jsonPprecipSum.put(Integer.toString(year), sumValues);
                jsonDryDays.put(Integer.toString(year), dryCount);
                jsonWetDays.put(Integer.toString(year), wetCount);
                jsonExtremeDays.put(Integer.toString(year), extremeCount);
                jsonMissingDays.put(Integer.toString(year), missingCount);
                String[] lastMissing = (String[])missingTIs.get(missingTIs.size() - 1);
                if (lastMissing[1].isEmpty()) {
                    lastMissing[1] = ((Attribute.Calendar)this.dates.get(this.dates.size() - 1)).toString();
                }
            }
            colStats.put("consDryDays", consDryValues);
            colStats.put("consWetDays", consWetValues);
            colStats.put("missingIntervals", missingTIs);
        }
        json.put("hYears", years);
        if (this.jsonFileName != null) {
            try {
                FileWriter writer = new FileWriter(new File(this.getModel().getWorkspace().getOutputDataDirectory(), this.jsonFileName.getValue()));
                writer.write(json.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TNC_PrecipIndicators.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println(json.toString());
        }
    }

    private void round(double[] a) {
        for (int n = 0; n < a.length; ++n) {
            a[n] = (double)Math.round(a[n] * 100.0) / 100.0;
        }
    }
}

