/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

@JAMSComponentDescription(title="SnowLine", author="Sven Kralisch", description="Calculate whether or not an entity is part of the snow line", date="2021-09-30", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SnowLineElevation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="list of model entities")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow water equivalent attribute name", defaultValue="snowTotSWE")
    public Attribute.String sweName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="elevation attribute name", defaultValue="elevation")
    public Attribute.String elevationName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="area attribute name", defaultValue="area")
    public Attribute.String areaName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="elevation sampling step size", defaultValue="10", unit="m")
    public Attribute.Double stepSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="snow line elevation")
    public Attribute.Double snowLineElevation;
    private List<Attribute.Entity> orderedList;
    private List<double[]> values = new ArrayList<double[]>();
    private List<Double> elevations = new ArrayList<Double>();

    public void init() {
    }

    public void run() {
        double area;
        double elev;
        double bestSle = 0.0;
        double minError = Double.POSITIVE_INFINITY;
        if (this.orderedList == null) {
            this.orderedList = new ArrayList<Attribute.Entity>(this.entities.getEntities());
            Comparator<Attribute.Entity> comp = new Comparator<Attribute.Entity>(){

                @Override
                public int compare(Attribute.Entity e1, Attribute.Entity e2) {
                    double elev2;
                    double elev1 = e1.getDouble(SnowLineElevation.this.elevationName.getValue());
                    if (elev1 < (elev2 = e2.getDouble(SnowLineElevation.this.elevationName.getValue()))) {
                        return 1;
                    }
                    if (elev1 > elev2) {
                        return -1;
                    }
                    return 0;
                }
            };
            Collections.sort(this.orderedList, comp);
            for (Attribute.Entity e : this.orderedList) {
                elev = e.getDouble(this.elevationName.getValue());
                area = e.getDouble(this.areaName.getValue());
                double[] v = new double[]{elev, area, 0.0};
                this.values.add(v);
            }
            for (double e = this.values.get(0)[0]; e > this.values.get(this.values.size() - 1)[0]; e -= this.stepSize.getValue()) {
                this.elevations.add(e);
            }
        }
        int i = 0;
        for (double[] v : this.values) {
            v[2] = this.orderedList.get(i).getDouble(this.sweName.getValue());
            ++i;
        }
        Iterator<Object> iterator = this.elevations.iterator();
        while (iterator.hasNext()) {
            double sle = (Double)iterator.next();
            double error = 0.0;
            double sweSum = 0.0;
            for (double[] v : this.values) {
                elev = v[0];
                area = v[1];
                double swe = v[2];
                sweSum += swe;
                if (!(elev >= sle && swe == 0.0) && (!(elev < sle) || swe == 0.0)) continue;
                error += area;
            }
            if (!(error <= minError)) continue;
            minError = error;
            bestSle = sle;
        }
        if (bestSle == this.values.get(0)[0]) {
            bestSle = JAMS.getMissingDataValue();
        }
        this.snowLineElevation.setValue(bestSle);
    }

    public void cleanup() {
    }
}

