/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.components.indices.AbstractDICalc;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Evapotranspiration Deficit Index (ETDI) Calculator", author="Sven Kralisch", description="This component calculates the Evapotranspiration Deficit Index (ETDI) based on\nNarasimhan, B. & Srinivasan, R. (2005) Development and evaluation of Soil Moisture Deficit Index (SMDI) and Evapotranspiration Deficit Index (ETDI) for agricultural drought monitoring. Agricultural and Forest Meteorology 133(1\u20134), 69\u201388. doi:10.1016/j.agrformet.2005.07.012", date="2017-04-17", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class ETDI_Calc
extends AbstractDICalc {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of collected soil water content values")
    public Attribute.DoubleArray wsValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Statistics for SMDI calculation")
    public Attribute.Object etdiStats;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Current soil water average")
    public Attribute.Double currentWS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Water stress anomaly")
    public Attribute.Double wsa;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Evapotranspiration Deficit Index (ETDI)")
    public Attribute.Double etdi;

    @Override
    public void run() {
        AbstractDICalc.Stats stats;
        if (this.etdiStats.getValue() == null) {
            stats = this.calcStats(this.wsValues.getValue());
            this.etdiStats.setValue((Object)stats);
        } else {
            stats = (AbstractDICalc.Stats)this.etdiStats.getValue();
        }
        int day = this.date.get(6);
        if (day > 365) {
            return;
        }
        if (day % this.tres != 0) {
            return;
        }
        int timeIndex = day / this.tres - 1;
        int c = this.counter.getValue();
        double ws = this.wsValues.getValue()[c];
        this.counter.setValue(c + 1);
        double mws = stats.median[timeIndex];
        double min = stats.min[timeIndex];
        double max = stats.max[timeIndex];
        double wsa_ = ws <= mws ? (mws == min ? 0.0 : 100.0 * (mws - ws) / (mws - min)) : (mws == max ? 0.0 : 100.0 * (mws - ws) / (max - mws));
        double etdi_ = 0.5 * this.etdi.getValue() + wsa_ / 50.0;
        this.etdi.setValue(etdi_);
        this.wsa.setValue(wsa_);
        this.currentWS.setValue(ws);
    }
}

