/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.JAMSTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

@JAMSComponentDescription(title="JAMS simple progress bar", author="Sven Kralisch", date="1. December 2005", description="This visual component creates a small progress bar showing how many iterations of the enclosing context already have passed.")
public class JAMSProgress
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for progress bar")
    public Attribute.String title;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Progress bar height")
    public Attribute.Integer height;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Progress bar width")
    public Attribute.Integer width;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Progress bar always on top?")
    public Attribute.Boolean ontop;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Progress bar always on top?")
    public Attribute.Integer counter;
    private JProgressBar jamsProgressBar;
    private JFrame frame;
    private JButton cancelButton;
    private Runnable updatePBar;

    public void init() {
        this.counter.setValue(0);
        this.frame = new JFrame();
        this.jamsProgressBar = new JProgressBar();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setAlwaysOnTop(this.ontop.getValue());
        this.frame.setTitle(this.title.getValue());
        this.frame.setName("JAMSProgress");
        this.frame.setResizable(false);
        this.frame.setUndecorated(true);
        this.jamsProgressBar.setPreferredSize(new Dimension(this.width.getValue(), this.height.getValue()));
        this.jamsProgressBar.setString(this.title.getValue());
        this.jamsProgressBar.setStringPainted(true);
        this.jamsProgressBar.setIndeterminate(false);
        this.frame.getContentPane().add((Component)this.jamsProgressBar, "Center");
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAMSProgress.this.cancelButtonActionPerformed(evt);
            }
        });
        this.frame.getContentPane().add((Component)this.cancelButton, "East");
        this.frame.setIconImages(JAMSTools.getJAMSIcons());
        this.frame.pack();
        this.frame.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.frame.getWidth()) / 2, (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - (double)this.frame.getHeight()) / 2);
        this.jamsProgressBar.setMinimum(0);
        this.jamsProgressBar.setMaximum((int)this.getContext().getNumberOfIterations());
        this.jamsProgressBar.setValue(this.counter.getValue());
        this.updatePBar = new Runnable(){

            @Override
            public void run() {
                int c = JAMSProgress.this.counter.getValue();
                JAMSProgress.this.jamsProgressBar.setValue(++c);
                JAMSProgress.this.counter.setValue(c);
            }
        };
        this.frame.setVisible(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.getModel().getRuntime().sendHalt();
    }

    public void run() {
        SwingUtilities.invokeLater(this.updatePBar);
    }

    public void cleanup() {
        this.frame.dispose();
        System.out.println("aufrufe:" + this.counter.getValue());
    }
}

