/*
 * Decompiled with CFR 0.152.
 */
package jams.components.debug;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="DataLoop", author="Sven Kralisch", date="2013-04-24", version="1.0_0", description="This context loops over a double interval defined by start value, end value and a step size")
public class DataLoop
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Start value")
    public Attribute.Double start;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="End value")
    public Attribute.Double end;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Step size")
    public Attribute.Double step;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Current value")
    public Attribute.Double current;

    public void init() {
        super.init();
        this.current.setValue(this.start.getValue());
    }

    public void run() {
        super.run();
    }

    public ComponentEnumerator getRunEnumerator() {
        if (!this.components.isEmpty()) {
            return new RunEnumerator();
        }
        return new RunEnumerator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Component next() {
                return null;
            }

            @Override
            public void reset() {
            }
        };
    }

    public long getNumberOfIterations() {
        return Math.round(this.start.getValue() - this.end.getValue() / this.step.getValue());
    }

    public String getTraceMark() {
        return this.current.toString();
    }

    class RunEnumerator
    implements ComponentEnumerator {
        ComponentEnumerator ce;

        RunEnumerator() {
            this.ce = DataLoop.this.getChildrenEnumerator();
        }

        public boolean hasNext() {
            boolean nextValue = DataLoop.this.current.getValue() < DataLoop.this.end.getValue() - DataLoop.this.step.getValue();
            boolean nextComp = this.ce.hasNext();
            return nextValue || nextComp;
        }

        public boolean hasPrevious() {
            boolean prevTime = DataLoop.this.current.getValue() >= DataLoop.this.start.getValue() + DataLoop.this.step.getValue();
            boolean prevComp = this.ce.hasPrevious();
            return prevTime || prevComp;
        }

        public Component next() {
            if (!this.ce.hasNext() && DataLoop.this.current.getValue() < DataLoop.this.end.getValue() - DataLoop.this.step.getValue()) {
                DataLoop.this.current.setValue(DataLoop.this.current.getValue() + DataLoop.this.step.getValue());
                this.ce.reset();
            }
            return this.ce.next();
        }

        public void reset() {
            DataLoop.this.current.setValue(DataLoop.this.start.getValue());
            this.ce.reset();
        }

        public Component previous() {
            if (this.ce.hasPrevious()) {
                return this.ce.previous();
            }
            DataLoop.this.current.setValue(DataLoop.this.current.getValue() - DataLoop.this.step.getValue());
            while (this.ce.hasNext()) {
                this.ce.next();
            }
            return this.ce.previous();
        }
    }
}

