/*
 * Decompiled with CFR 0.152.
 */
package jams.components.datatransfer;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="ArrayIterator", author="Sven Kralisch", description="This component takes a (list of) double array(s) as input and returns the next array element at each invocationof the run methods, this way iterating over the array(s).", date="2019-03-26", version="1.1_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.1_0", comment="Fixed buggy behaviour in case of repeated use (e.g. calibration)")})
public class ArrayIterator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Input double array")
    public Attribute.DoubleArray[] array;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Current index value")
    public Attribute.Integer arrayIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Output double scalar")
    public Attribute.Double[] value;

    public void initAll() {
        this.arrayIndex.setValue(0);
    }

    public void run() {
        for (int i = 0; i < this.array.length; ++i) {
            this.value[i].setValue(this.array[i].getValue()[this.arrayIndex.getValue()]);
        }
        this.arrayIndex.setValue(this.arrayIndex.getValue() + 1);
    }

    public void cleanup() {
    }
}

