/*
 * Decompiled with CFR 0.152.
 */
package jams.components.core;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.JAMSLong;
import jams.io.BufferedFileReader;
import jams.io.datatracer.AbstractTracer;
import jams.io.datatracer.DataTracer;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.Context;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

@JAMSComponentDescription(title="TemporalFileInputContext", author="Sven Kralisch", description="Context that iterates over lines in a tab-separated text file and offers the current time step stored in the first column (attribute \"time\") and the data in other columns (attribute \"values\").", date="2024-11-24", version="1.1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2018-09-12", comment="Initial version"), @VersionComments.Entry(version="1.1", date="2024-11-24", comment="Complete rework of the component")})
public class TemporalFileInputContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval of temporal context")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The name of the file to read from")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The key word that indicates the start of the data section", defaultValue="@dataVal")
    public Attribute.String startIndicator;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The format string for the date format given", defaultValue="yyyy-MM-dd HH:mm")
    public Attribute.String dateFormatString;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Read the values in each line of the input file?", defaultValue="False")
    public Attribute.Boolean readValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Column index at which to start in case readValues is true (first column index is 0)", defaultValue="1")
    public Attribute.Integer firstColumn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Print the current time every \"printTime\" time steps", defaultValue="0")
    public Attribute.Integer printTime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The values in each line of the input file")
    public Attribute.Double[] values;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The current time, if \"parseDateTime\" was set to \"true\"")
    public Attribute.Calendar current;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Lines skipped to reach timeInterval start")
    public Attribute.Integer skipLines;
    private transient BufferedFileReader fileReader;
    private String line;
    private int counter;
    private List<Attribute.Calendar> dates = new ArrayList<Attribute.Calendar>();
    private int calIndex;

    protected DataTracer createDataTracer(OutputDataStore store) {
        return new AbstractTracer((Context)this, store, JAMSLong.class){

            public void trace() {
                for (Filter filter : this.store.getFilters()) {
                    String string;
                    if (filter.getContext() == TemporalFileInputContext.this || filter.isFiltered(string = filter.getContext().getTraceMark())) continue;
                    return;
                }
                String traceMark = TemporalFileInputContext.this.getTraceMark();
                for (Filter filter : this.store.getFilters()) {
                    if (filter.getContext() != TemporalFileInputContext.this || filter.isFiltered(traceMark)) continue;
                    return;
                }
                if (!this.hasOutput()) {
                    this.setOutput(true);
                    this.startMark();
                }
                this.output(traceMark);
                for (Filter filter : this.getAccessorObjects()) {
                    this.output(filter.getComponentObject());
                }
                this.nextRow();
                this.flush();
            }
        };
    }

    public void init() {
        super.init();
        this.initFile();
    }

    public void initAll() {
        super.initAll();
    }

    public void cleanupAll() {
        super.cleanupAll();
    }

    private void initFile() {
        DataFactory f = this.getModel().getRuntime().getDataFactory();
        Attribute.Calendar date = f.createCalendar();
        try {
            this.fileReader = new BufferedFileReader(new FileInputStream(new File(this.getModel().getWorkspacePath(), this.fileName.getValue())), JAMS.getCharset());
            while ((this.line = this.fileReader.readLine()) != null && !this.line.trim().equals(this.startIndicator.getValue())) {
            }
            this.line = this.fileReader.readLine();
            String[] cols = this.line.split("\t");
            date.setValue(cols[0], this.dateFormatString.getValue());
            if (date.compareTo(this.timeInterval.getStart(), this.timeInterval.getTimeUnit()) > 0) {
                this.getModel().getRuntime().sendHalt("Error: First date in data file is after start of timeInterval.");
            }
            int skipLines = 0;
            while (date.compareTo(this.timeInterval.getStart(), this.timeInterval.getTimeUnit()) < 0) {
                this.line = this.fileReader.readLine();
                cols = this.line.split("\t");
                date.setValue(cols[0], this.dateFormatString.getValue());
                ++skipLines;
            }
            while (!this.line.startsWith("#") && date.compareTo(this.timeInterval.getEnd(), this.timeInterval.getTimeUnit()) <= 0) {
                Attribute.Calendar newDate = f.createCalendar();
                newDate.setValue(date);
                this.dates.add(newDate);
                this.line = this.fileReader.readLine();
                if (this.line.startsWith("#")) continue;
                cols = this.line.split("\t");
                date.setValue(cols[0], this.dateFormatString.getValue());
            }
            this.getModel().getRuntime().println(this.dates.get(0) + " <-> " + this.dates.get(this.dates.size() - 1), 2);
            this.calIndex = 0;
            this.current.setValue(this.dates.get(this.calIndex));
            this.counter = 0;
            this.skipLines.setValue(skipLines);
        }
        catch (FileNotFoundException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
        catch (IOException | ParseException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
    }

    public void run() {
        super.run();
        if (!this.isPaused) {
            for (DataTracer dataTracer : this.dataTracers) {
                if (!dataTracer.hasOutput()) continue;
                dataTracer.endMark();
                dataTracer.setOutput(false);
            }
        }
    }

    public void cleanup() {
        super.cleanup();
        try {
            this.fileReader.close();
        }
        catch (IOException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
    }

    protected ComponentEnumerator getInitAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getCleanupAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getRunEnumerator() {
        if (!this.components.isEmpty()) {
            return new ComponentEnumerator(){
                ComponentEnumerator ce;
                {
                    this.ce = TemporalFileInputContext.this.getFICChildrenEnumerator();
                }

                public boolean hasNext() {
                    boolean nextComp = this.ce.hasNext();
                    boolean nextTime = TemporalFileInputContext.this.calIndex < TemporalFileInputContext.this.dates.size() - 1;
                    return nextTime || nextComp;
                }

                public boolean hasPrevious() {
                    boolean prevTime = TemporalFileInputContext.this.calIndex > 0;
                    boolean prevComp = this.ce.hasPrevious();
                    return prevTime || prevComp;
                }

                public Component next() {
                    if (!this.ce.hasNext() && TemporalFileInputContext.this.calIndex < TemporalFileInputContext.this.dates.size() - 1) {
                        for (DataTracer dataTracer : TemporalFileInputContext.this.getDataTracers()) {
                            dataTracer.trace();
                        }
                        TemporalFileInputContext.this.calIndex++;
                        TemporalFileInputContext.this.current.setValue((Attribute.Calendar)TemporalFileInputContext.this.dates.get(TemporalFileInputContext.this.calIndex));
                        this.printTime();
                        this.ce.reset();
                    }
                    return this.ce.next();
                }

                public void reset() {
                    TemporalFileInputContext.this.calIndex = 0;
                    this.printTime();
                    this.ce.reset();
                }

                public Component previous() {
                    if (this.ce.hasPrevious()) {
                        return this.ce.previous();
                    }
                    TemporalFileInputContext.this.calIndex--;
                    TemporalFileInputContext.this.current.setValue((Attribute.Calendar)TemporalFileInputContext.this.dates.get(TemporalFileInputContext.this.calIndex));
                    while (this.ce.hasNext()) {
                        this.ce.next();
                    }
                    return this.ce.previous();
                }

                private void printTime() {
                    if (TemporalFileInputContext.this.printTime.getValue() > 0) {
                        if (TemporalFileInputContext.this.counter % TemporalFileInputContext.this.printTime.getValue() == 0) {
                            TemporalFileInputContext.this.counter = 0;
                            TemporalFileInputContext.this.getModel().getRuntime().println(TemporalFileInputContext.this.getInstanceName() + " " + TemporalFileInputContext.this.current, 0);
                        }
                        TemporalFileInputContext.this.counter++;
                    }
                }
            };
        }
        return new ComponentEnumerator(){

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }

            public Component next() {
                return null;
            }

            public Component previous() {
                return null;
            }

            public void reset() {
            }
        };
    }

    private ComponentEnumerator getFICChildrenEnumerator() {
        return this.getChildrenEnumerator();
    }

    private DataTracer[] getDataTracers() {
        return this.dataTracers;
    }

    public long getNumberOfIterations() {
        return this.dates.size();
    }

    public String getTraceMark() {
        return this.current.toString();
    }
}

