/*
 * Decompiled with CFR 0.152.
 */
package jams.components.concurrency;

import jams.JAMS;
import jams.JAMSException;
import jams.components.concurrency.CAProxy;
import jams.components.concurrency.ConcurrentContext;
import jams.components.core.Context;
import jams.components.core.SpatialContext;
import jams.meta.ComponentCollection;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.MetaProcessor;
import jams.meta.ModelDescriptor;
import jams.meta.ModelNode;
import jams.meta.OutputDSDescriptor;
import jams.runtime.JAMSRuntime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ConcurrentContextProcessor
implements MetaProcessor {
    private int nthreads = 1;
    private List<String> excludeComponents;
    private String partitionerClassName = "jams.components.concurrency.EntityPartitioner";
    private Map<String, String> partitionerParams = new HashMap<String, String>();

    public void setValue(String key, String value) {
        if (key.equals("scale_factor")) {
            this.nthreads = (int)Math.floor((double)Runtime.getRuntime().availableProcessors() * Double.parseDouble(value));
        }
        if (key.equals("exclude_component")) {
            this.excludeComponents = Arrays.asList(value.split(";"));
        }
        if (key.equals("partitioner_class")) {
            this.partitionerClassName = value;
        }
        if (key.startsWith("partitioner_param_")) {
            String paramName = key.substring(18);
            this.partitionerParams.put(paramName, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void process(ContextDescriptor context, ModelDescriptor model, JAMSRuntime rt) {
        Object n;
        Class<?> partitionerClass;
        if (!context.isEnabled() || this.nthreads < 2 || !SpatialContext.class.isAssignableFrom(context.getClazz())) {
            rt.sendErrorMsg(MessageFormat.format(JAMS.i18n((String)"No_concurrent_processing_for_context"), context.getInstanceName()));
            return;
        }
        ContextDescriptor controller = new ContextDescriptor(ConcurrentContext.class, null, (ComponentCollection)model);
        ContextDescriptor cContainer = new ContextDescriptor(controller.getInstanceName() + "Container", Context.class, null, (ComponentCollection)model);
        try {
            partitionerClass = Class.forName(this.partitionerClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new JAMSException("Error while loading class " + this.partitionerClassName, (Throwable)ex);
        }
        ComponentDescriptor partitioner = new ComponentDescriptor(partitionerClass, null, (ComponentCollection)model);
        ModelNode node = context.getNode();
        ModelNode parent = (ModelNode)node.getParent();
        int index = parent.getIndex((TreeNode)node);
        ModelNode cContainerNode = new ModelNode((Object)cContainer);
        cContainerNode.setType(1);
        ModelNode cNode = new ModelNode((Object)controller.cloneNode());
        cNode.setType(1);
        cContainerNode.insert((MutableTreeNode)cNode, 0);
        ComponentField inEntities = (ComponentField)partitioner.getComponentFields().get("inEntities");
        ComponentField outEntities = (ComponentField)partitioner.getComponentFields().get("outEntities");
        ComponentField entitiesField = (ComponentField)context.getComponentFields().get("entities");
        String entitiesAttributeName = entitiesField.getAttribute();
        ContextDescriptor entitiesProvider = entitiesField.getContext();
        inEntities.linkToAttribute(entitiesProvider, entitiesAttributeName);
        String newAttributeName = entitiesAttributeName + "_1";
        for (int i = 1; i < this.nthreads; ++i) {
            newAttributeName = newAttributeName + ";" + entitiesAttributeName + "_" + (i + 1);
        }
        outEntities.linkToAttribute(cContainer, newAttributeName);
        for (Map.Entry<String, String> param : this.partitionerParams.entrySet()) {
            ComponentField paramField = (ComponentField)partitioner.getComponentFields().get(param.getKey());
            if (paramField != null) {
                paramField.setValue(param.getValue());
                continue;
            }
            rt.sendErrorMsg(MessageFormat.format(JAMS.i18n((String)"Tried to set parameter \"{0}\" but it could not be found!"), param.getKey()));
        }
        ModelNode partitionerNode = new ModelNode((Object)partitioner);
        partitionerNode.setType(0);
        cContainerNode.insert((MutableTreeNode)partitionerNode, 0);
        parent.insert((MutableTreeNode)cContainerNode, index);
        node.removeFromParent();
        rt.println("    Removed context " + context.getInstanceName() + " and added new context " + cContainer.getInstanceName());
        ModelNode serialContextNode = node.clone((ComponentCollection)new ModelDescriptor(), true, new HashMap());
        ContextDescriptor serialContext = (ContextDescriptor)serialContextNode.getUserObject();
        serialContext.setInstanceName(context.getInstanceName() + "_Serial");
        cContainerNode.insert((MutableTreeNode)serialContextNode, 2);
        rt.println("    Added new serial context " + serialContext.getInstanceName());
        ArrayList<ModelNode> serialNodeList = new ArrayList<ModelNode>();
        Enumeration nodeEnum = serialContextNode.depthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            ModelNode n2 = (ModelNode)nodeEnum.nextElement();
            ComponentDescriptor cd = (ComponentDescriptor)n2.getUserObject();
            if (!this.excludeComponents.contains(cd.getInstanceName())) continue;
            serialNodeList.add(n2);
        }
        nodeEnum = serialContextNode.depthFirstEnumeration();
        ArrayList<Object> removeList = new ArrayList<Object>();
        while (nodeEnum.hasMoreElements()) {
            n = (ModelNode)nodeEnum.nextElement();
            boolean bl = true;
            if (serialNodeList.contains(n)) {
                bl = false;
            }
            for (ModelNode serialNode : serialNodeList) {
                if (!n.isNodeDescendant((DefaultMutableTreeNode)serialNode)) continue;
                bl = false;
                break;
            }
            if (bl && !n.equals(serialContextNode)) {
                removeList.add(n);
                continue;
            }
            ComponentDescriptor cd = (ComponentDescriptor)n.getUserObject();
            cd.register((ComponentCollection)model);
        }
        for (ModelNode modelNode : removeList) {
            modelNode.removeFromParent();
        }
        removeList = new ArrayList();
        nodeEnum = node.depthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            n = (ModelNode)nodeEnum.nextElement();
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)n.getUserObject();
            if (!this.excludeComponents.contains(componentDescriptor.getInstanceName())) continue;
            removeList.add(n);
        }
        for (ModelNode modelNode : removeList) {
            modelNode.removeFromParent();
        }
        for (int i = 0; i < this.nthreads; ++i) {
            ModelNode modelNode = node.clone((ComponentCollection)model, true, new HashMap());
            ContextDescriptor cdCopy = (ContextDescriptor)modelNode.getUserObject();
            ComponentField entities = (ComponentField)cdCopy.getComponentFields().get("entities");
            entities.linkToAttribute(cContainer, entities.getAttribute() + "_" + (i + 1));
            cNode.add((MutableTreeNode)modelNode);
        }
        ComponentField proxyAttributes = null;
        Object var26_36 = null;
        HashSet attributes = new HashSet();
        HashMap stores = model.getDatastores();
        for (OutputDSDescriptor store : stores.values()) {
            void var26_37;
            if (store.getContext() != context) continue;
            if (var26_37 == null) {
                ComponentDescriptor componentDescriptor = new ComponentDescriptor(context.getInstanceName() + "_DSProxy", CAProxy.class, null, (ComponentCollection)model);
                ModelNode caProxyNode = new ModelNode((Object)componentDescriptor);
                caProxyNode.setType(0);
                serialContextNode.insert((MutableTreeNode)caProxyNode, 0);
                proxyAttributes = (ComponentField)componentDescriptor.getComponentFields().get("attributes");
            }
            store.setContext(serialContext);
            attributes.addAll(store.getContextAttributes());
        }
        for (ContextAttribute ca : attributes) {
            proxyAttributes.linkToAttribute(serialContext, ca.getName(), false);
        }
    }
}

