/*
 * Decompiled with CFR 0.152.
 */
package jams.components.calc;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.operator.Operator;

@JAMSComponentDescription(title="EventCounter", author="Sven Kralisch", description="Counts the number of occurrences of a specific event withregard to numeric values, e.g. double attribute being higher/lower than a certain value", date="2017-09-05", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class EventCounter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double a;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double b;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double c;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double d;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double e;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double f;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double g;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double i;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Argument slot", defaultValue="0")
    public Attribute.Double j;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Event expression. This must be a boolean result type and follows Java syntax, e.g. \"sqrt(a) + b^2 <= c\". For a list of built-in functions, have a look at http://projects.congrace.de/exp4j.", defaultValue="a + b > 0")
    public Attribute.String expression;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Event occurrence? \"1\" if event occurred, \"0\" otherwise")
    public Attribute.Double result;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Accumulated event occurrence", defaultValue="0")
    public Attribute.Double result_accum;
    private Operator st;
    private Operator steq;
    private Operator gt;
    private Operator gteq;
    private Operator eq;
    private Expression exp;
    static double x = 1.0;

    public void init() {
        this.st = new Operator("<", 2, true, 499){

            public double apply(double[] values) {
                if (values[0] < values[1]) {
                    return 1.0;
                }
                return 0.0;
            }
        };
        this.steq = new Operator("<=", 2, true, 499){

            public double apply(double[] values) {
                if (values[0] <= values[1]) {
                    return 1.0;
                }
                return 0.0;
            }
        };
        this.gt = new Operator(">", 2, true, 499){

            public double apply(double[] values) {
                if (values[0] > values[1]) {
                    return 1.0;
                }
                return 0.0;
            }
        };
        this.gteq = new Operator(">=", 2, true, 499){

            public double apply(double[] values) {
                if (values[0] >= values[1]) {
                    return 1.0;
                }
                return 0.0;
            }
        };
        this.eq = new Operator("==", 2, true, 499){

            public double apply(double[] values) {
                if (values[0] == values[1]) {
                    return 1.0;
                }
                return 0.0;
            }
        };
        this.exp = new ExpressionBuilder(this.expression.getValue()).operator(this.st).operator(this.gt).operator(this.steq).operator(this.gteq).operator(this.eq).variables(new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}).build();
    }

    public void run() {
        double r = this.exp.setVariable("a", this.a.getValue()).setVariable("b", this.b.getValue()).setVariable("c", this.c.getValue()).setVariable("d", this.d.getValue()).setVariable("e", this.e.getValue()).setVariable("f", this.f.getValue()).setVariable("g", this.g.getValue()).setVariable("h", this.h.getValue()).setVariable("i", this.i.getValue()).setVariable("j", this.j.getValue()).evaluate();
        this.result.setValue(r);
        if (r == 1.0) {
            this.result_accum.setValue(this.result_accum.getValue() + 1.0);
        }
    }

    public void cleanup() {
    }

    public static void main(String[] args) {
        int i;
        double x = 212.0;
        double y = 210.0;
        Operator st = new Operator("==", 2, true, 499){

            public double apply(double[] values) {
                if (values[0] == values[1]) {
                    return 1.0;
                }
                return 0.0;
            }
        };
        Expression e = new ExpressionBuilder("x - 1 == 0").operator(st).variables(new String[]{"x", "y"}).build();
        System.out.println(1.0 == e.setVariable("x", EventCounter.getX()).evaluate());
        System.out.println(1.0 == e.setVariable("x", EventCounter.getX()).evaluate());
        long start = System.currentTimeMillis();
        for (i = 0; i < 10000000; ++i) {
            double d = e.evaluate();
        }
        System.out.println(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        for (i = 0; i < 10000000; ++i) {
            boolean bl = x - y < (double)i;
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    public static double getX() {
        double d = x;
        x = d + 1.0;
        return d;
    }
}

