/*
 * Decompiled with CFR 0.152.
 */
package jams.components.calc;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import de.odysseus.el.util.SimpleResolver;
import jams.components.calc.DoubleFunctions;
import jams.data.Attribute;
import jams.model.Context;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

public class EntityCalculator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the attribute for which values are calculated")
    public Attribute.String targetAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the attribute for which values are calculated")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time object")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time period")
    public Attribute.TimeInterval I;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="expression")
    public Attribute.String expr;
    transient ExpressionFactory factory = null;
    transient SimpleContext exprContext = new SimpleContext((ELResolver)new SimpleResolver());
    ValueExpression entityExpr = null;
    ValueExpression valueExpr = null;
    ValueExpression timeExpr = null;
    ValueExpression intervalExpr = null;
    transient boolean isInit = false;

    public void reinit() {
        Properties properties = new Properties();
        properties.put("javax.el.cacheSize", "1000");
        properties.put("javax.el.methodInvocations", "false");
        properties.put("javax.el.nullProperties", "false");
        properties.put("javax.el.varArgs", "false");
        properties.put("javax.el.ignoreReturnType", "false");
        this.factory = new ExpressionFactoryImpl(properties);
        this.exprContext = EntityCalculator.getExpressionContext();
        this.valueExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${" + this.expr.getValue() + "}", Double.TYPE);
        this.timeExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${time}", Attribute.Calendar.class);
        this.intervalExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${I}", Attribute.TimeInterval.class);
        this.entityExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${E}", Attribute.Entity.class);
        for (Context searchContext = this.getContext(); searchContext != null; searchContext = searchContext.getContext()) {
            ValueExpression contextExpr = this.factory.createValueExpression((ELContext)this.exprContext, "${" + searchContext.getInstanceName() + "}", Context.class);
            contextExpr.setValue((ELContext)this.exprContext, (Object)searchContext);
        }
        this.isInit = true;
    }

    public static double getEntityAttribute(Attribute.Entity e, String attributeName) {
        try {
            return e.getDouble(attributeName);
        }
        catch (Attribute.Entity.NoSuchAttributeException nsae) {
            nsae.printStackTrace();
            return 0.0;
        }
    }

    private static SimpleContext getExpressionContext() {
        SimpleContext context = DoubleFunctions.getContext();
        try {
            context.setFunction("", "getEntityAttribute", EntityCalculator.class.getMethod("getEntityAttribute", Attribute.Entity.class, String.class));
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        return context;
    }

    public void run() {
        if (!this.isInit) {
            this.reinit();
        }
        if (this.time != null && this.time.getValue() != null) {
            this.timeExpr.setValue((ELContext)this.exprContext, (Object)this.time.getValue());
        }
        if (this.I != null && this.I.getValue() != null) {
            this.intervalExpr.setValue((ELContext)this.exprContext, (Object)this.I);
        }
        for (Attribute.Entity e : this.entities.getEntities()) {
            this.entityExpr.setValue((ELContext)this.exprContext, (Object)e);
            Double d = (Double)this.valueExpr.getValue((ELContext)this.exprContext);
            e.setDouble(this.targetAttribute.getValue(), d.doubleValue());
        }
    }

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        this.isInit = false;
    }
}

