/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.JAMS;
import jams.aggregators.Aggregator;
import jams.aggregators.CompoundTemporalAggregator;
import jams.aggregators.DoubleAggregator;
import jams.aggregators.MultiTemporalAggregator;
import jams.aggregators.TemporalAggregator;
import jams.components.aggregate.TemporalAggregator;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.text.MessageFormat;
import java.util.Collection;

@JAMSComponentDescription(title="TimePeriodAggregator", author="Christian Fischer", description="Aggregates timeseries values to a given time period of day, month, year or dekade")
public class TwoStageTemporalAggregator
extends TemporalAggregator {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="aggregationMode: sum; avg; min; max; ind;")
    public Attribute.String[] outerAggregationMode;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The reference time period for aggregation, e.g. yearly mean of months mean, possible values are: hourly, daily, monthly, seasonal, halfyear, hydhalfyear, yearly, decadly")
    public Attribute.String outerTimeUnit;
    private TemporalAggregator.AggregationTimePeriod outerTimeUnitID = TemporalAggregator.AggregationTimePeriod.YEARLY;
    private Aggregator.AggregationMode[] outerAggregationModeID = null;

    protected Aggregator.AggregationMode getOuterAggregationModeID(int i) {
        return this.outerAggregationModeID[i];
    }

    protected TemporalAggregator.AggregationTimePeriod getOuterTimeUnitID() {
        return this.outerTimeUnitID;
    }

    @Override
    protected boolean checkConfiguration() {
        super.checkConfiguration();
        if (this.outerAggregationMode != null && this.outerAggregationMode.length != this.n) {
            this.getModel().getRuntime().sendInfoMsg("Number of values in parameter \"outerAggregationMode\" does not match the number of attributes");
            return false;
        }
        if (this.outerTimeUnitID == null) {
            this.getModel().getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n((String)("Unknown time unit:" + this.outerTimeUnit.getValue() + ".\nPossible values are daily, monthly, yearly and decadly.")), this.getInstanceName()));
        }
        return true;
    }

    @Override
    public void init() {
        super.init();
        this.outerTimeUnitID = TemporalAggregator.AggregationTimePeriod.fromString((String)this.outerTimeUnit.getValue());
        if (this.outerTimeUnitID == null) {
            this.getModel().getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n((String)("Unknown time unit:" + this.outerTimeUnit.getValue() + ".\nPossible values are daily, monthly, yearly and decadly.")), this.getInstanceName()));
        }
        this.outerAggregationModeID = new Aggregator.AggregationMode[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.outerAggregationModeID[i] = Aggregator.AggregationMode.fromAbbreviation((String)this.outerAggregationMode[i].getValue());
        }
    }

    @Override
    public void initAll() {
        super.initAll();
        jams.aggregators.TemporalAggregator[] aggregators = new jams.aggregators.TemporalAggregator[this.getNumberOfAttributes()];
        jams.aggregators.TemporalAggregator[] innerAggregators = (jams.aggregators.TemporalAggregator[])this.internalState.getObject("aggregators");
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (!this.isEnabled(i)) continue;
            Aggregator.AggregationMode outerMode = this.getOuterAggregationModeID(i);
            TemporalAggregator.AggregationTimePeriod outerTimeUnitID = this.getOuterTimeUnitID();
            jams.aggregators.TemporalAggregator innerAggregator = innerAggregators[i];
            innerAggregator.removeConsumers();
            Object outerAggregator = outerMode != Aggregator.AggregationMode.INDEPENDENT ? new CompoundTemporalAggregator((Aggregator)DoubleAggregator.create((Aggregator.AggregationMode)outerMode), innerAggregator, outerTimeUnitID, (Collection)this.customTimePeriods) : new MultiTemporalAggregator(innerAggregator, outerTimeUnitID, (Collection)this.customTimePeriods);
            outerAggregator.addConsumer((TemporalAggregator.Consumer)new TemporalAggregator.DataConsumer(this.outputAttributes[i]));
            outerAggregator.init();
            aggregators[i] = outerAggregator;
        }
        this.internalState.setObject("aggregators", (Object)aggregators);
    }
}

