/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(author="Sven Kralisch", description="Component for the weighted aggregation of time-variant data over a time interval", version="1.1", date="2016-05-12")
@VersionComments(entries={@VersionComments.Entry(version="1.0", date="2006-07-19", comment="initial version"), @VersionComments.Entry(version="1.1", date="2016-05-12", comment="fixed month filter function and changed usage of month values (1==January, 2==February, ...)")})
public class TemporalSumAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The value(s) to be aggregated")
    public Attribute.Double[] value;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="A weight to be used to calculate the weighted aggregate", defaultValue="1")
    public Attribute.Double weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="The resulting weighted aggregate(s) of the given values")
    public Attribute.Double[] sum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="A time interval defining start and end of the weighted temporal aggregation")
    public Attribute.TimeInterval[] aggregationTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="If months are listed, aggregation will be performed only during the listed months")
    public Attribute.Integer[] months;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculate the average value? If average is false, the sum will be calculated.", defaultValue="true")
    public Attribute.Boolean average;
    private long count;

    public void init() {
        for (int i = 0; i < this.value.length; ++i) {
            this.sum[i].setValue(0.0);
        }
        Attribute.Calendar start = null;
        Attribute.Calendar end = null;
        for (Attribute.TimeInterval I : this.aggregationTimeInterval) {
            if (start == null) {
                start = I.getStart().clone();
            } else if (start.after(I.getStart())) {
                start = I.getStart().clone();
            }
            if (end == null) {
                end = I.getEnd().clone();
                continue;
            }
            if (!end.before(I.getEnd())) continue;
            end = I.getEnd().clone();
        }
        this.count = 0L;
        if (this.average.getValue()) {
            while (!start.after(end)) {
                boolean isIn = false;
                for (Attribute.TimeInterval t : this.aggregationTimeInterval) {
                    if (start.before(t.getStart()) || start.after(t.getEnd())) continue;
                    isIn = true;
                    break;
                }
                if (this.months != null) {
                    boolean isInMonth = false;
                    int month = start.get(2);
                    for (int i = 0; i < this.months.length; ++i) {
                        if (this.months[i].getValue() - 1 != month) continue;
                        isInMonth = true;
                        break;
                    }
                    if (!isInMonth) {
                        isIn = false;
                    }
                }
                if (isIn) {
                    ++this.count;
                }
                start.add(this.aggregationTimeInterval[0].getTimeUnit(), this.aggregationTimeInterval[0].getTimeUnitCount());
            }
        } else {
            this.count = 1L;
        }
    }

    public void run() {
        boolean isIn = false;
        for (Attribute.TimeInterval t : this.aggregationTimeInterval) {
            if (this.time.before(t.getStart()) || this.time.after(t.getEnd())) continue;
            isIn = true;
            break;
        }
        if (this.months != null) {
            boolean isInMonth = false;
            int month = this.time.get(2);
            for (int i = 0; i < this.months.length; ++i) {
                if (this.months[i].getValue() - 1 != month) continue;
                isInMonth = true;
                break;
            }
            if (!isInMonth) {
                isIn = false;
            }
        }
        if (isIn) {
            for (int i = 0; i < this.value.length; ++i) {
                this.sum[i].setValue(this.sum[i].getValue() + this.value[i].getValue() / (this.weight.getValue() * (double)this.count));
            }
        }
    }
}

