/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="TemporalPeriodeAggregator", author="Christian Fischer", date="2013-05-13", version="1.0_0", description="Component to calculate monthly averages")
public class MonthlyLowFlowDuration
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="is subtimestep finished?")
    public Attribute.Boolean subTimeStepStarted;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lowFlowThresholds (12 semicolon-separated values - one for each month")
    public Attribute.Double[] lowFlowThresholds;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="runoff in cbm/s")
    public Attribute.Double totQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of days with lowflow in timeperiod", defaultValue="0")
    public Attribute.Integer lowflowDays;

    public void run() {
        if (this.subTimeStepStarted.getValue()) {
            this.lowflowDays.setValue(0);
        }
        int m = this.time.get(2);
        if (this.totQ.getValue() < this.lowFlowThresholds[m].getValue()) {
            this.lowflowDays.setValue(this.lowflowDays.getValue() + 1);
        }
    }
}

