/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="FlexibleAggregator", author="Sven Kralisch", description="Aggreagate double data A as long as data B is NaN, then output aggregate A. Output NaN instead if B is NaN", date="2025-06-15", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class FlexibleAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="data to be aggregated")
    public Attribute.Double valueA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="data controlling the aggregation")
    public Attribute.Double valueB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="calculater the average? if not, the sum is calculated", defaultValue="true")
    public Attribute.Boolean avg;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="aggregate of valueA")
    public Attribute.Double aggregate;
    double sum;
    int counter;

    public void init() {
        this.sum = 0.0;
        this.counter = 0;
    }

    public void run() {
        this.sum += this.valueA.getValue();
        ++this.counter;
        if (this.valueB.getValue() != JAMS.getMissingDataValue()) {
            if (this.avg.getValue()) {
                this.sum /= (double)this.counter;
            }
            this.aggregate.setValue(this.sum);
            this.sum = 0.0;
            this.counter = 0;
        }
    }
}

