/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.spreadsheet;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.explorer.JAMSExplorer;
import jams.explorer.spreadsheet.CTSPlot;
import jams.explorer.spreadsheet.GraphProperties;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.explorer.spreadsheet.JAMSTimePlot;
import jams.explorer.spreadsheet.PropertyPanel;
import jams.explorer.spreadsheet.SpreadsheetConstants;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.workspace.JAMSWorkspace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class JTSConfigurator
extends JFrame {
    private JAMSWorkspace workspace;
    GroupLayout gLayout;
    GroupLayout.SequentialGroup hGroup;
    GroupLayout.SequentialGroup vGroup;
    GroupLayout.Group group1;
    GroupLayout.Group group2;
    GroupLayout.Group group3;
    GroupLayout.Group group4;
    GroupLayout.Group group5;
    GroupLayout.Group group6;
    GroupLayout.Group group7;
    GroupLayout.Group group8;
    GroupLayout.Group group9;
    GroupLayout.Group group10;
    GroupLayout.Group group11;
    GroupLayout.Group group12;
    GroupLayout.Group group13;
    GroupLayout.Group group14;
    GroupLayout.Group group15;
    private JTSConfigurator thisJTS = this;
    private JFrame parent;
    private JPanel frame;
    private JPanel mainpanel;
    private JPanel plotpanel;
    private JPanel optionpanel;
    private JPanel graphpanel;
    private JPanel southpanel;
    private JPanel edTitlePanel;
    private JPanel edLeftAxisPanel;
    private JPanel edRightAxisPanel;
    private JPanel savePanel;
    private File templateFile;
    private JSplitPane split_hor = new JSplitPane(1);
    private JSplitPane split_vert = new JSplitPane(0);
    private JScrollPane graphScPane;
    private JScrollPane optScPane;
    private String[] headers;
    private boolean output_ttp = false;
    private int rows_cnt;
    private Vector<double[]> arrayVector;
    private Vector<Attribute.Calendar> timeVector;
    private JLabel edTitle = new JLabel("Plot Title: ");
    private JLabel edLeft = new JLabel("Left axis title: ");
    private JLabel edXAxis = new JLabel("X axis title");
    private JLabel edRight = new JLabel("Right axis title: ");
    private JLabel rLeftLabel = new JLabel("Renderer left");
    private JLabel rRightLabel = new JLabel("Renderer right");
    private JLabel timeFormatLabel = new JLabel("Time format");
    private JTextField edTitleField = new JTextField(14);
    private JTextField edLeftField = new JTextField(14);
    private JTextField edRightField = new JTextField(14);
    private JTextField edXAxisField = new JTextField(14);
    private String[] types = new String[]{"Line and Shape", "Bar", "Area", "Step", "StepArea", "Difference"};
    private JComboBox rLeftBox = new JComboBox<String>(this.types);
    private JComboBox rRightBox = new JComboBox<String>(this.types);
    private JCheckBox invLeftBox = new JCheckBox("Invert left Axis");
    private JCheckBox invRightBox = new JCheckBox("Invert right Axis");
    private JCheckBox timeFormat_yy = new JCheckBox("yy");
    private JCheckBox timeFormat_mm = new JCheckBox("mm");
    private JCheckBox timeFormat_dd = new JCheckBox("dd");
    private JCheckBox timeFormat_hm = new JCheckBox("hh:mm");
    private JButton applyButton = new JButton("PLOT");
    private JButton addButton = new JButton("Add Graph");
    private JButton saveButton = new JButton("EPS export");
    private JButton saveTempButton = new JButton("Save Template");
    private JButton loadTempButton = new JButton("Load Template");
    private Vector<GraphProperties> propVector = new Vector();
    private Vector<PropertyPanel> panelVector = new Vector();
    private JAMSTimePlot jts = new JAMSTimePlot();
    private JAMSSpreadSheet sheet;
    private int index;
    private int colour_cnt;
    HashMap<String, Color> colorTable = new HashMap();
    int[] rows;
    int[] columns;
    JTable table;
    CTSPlot ctsplot;
    int columnCount = 0;
    int graphCount = 0;
    JCheckBox[] activate;
    JComboBox[] datachoice;
    JComboBox[] poschoice;
    JComboBox[] typechoice;
    JComboBox[] colorchoice;
    ActionListener[] activationChange;
    ActionListener titleListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            JTSConfigurator.this.ctsplot.getChart().setTitle(JTSConfigurator.this.edTitleField.getText());
        }
    };
    ActionListener rendererColorListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            for (int i = 0; i < JTSConfigurator.this.panelVector.size(); ++i) {
                ((PropertyPanel)JTSConfigurator.this.panelVector.get(i)).setColorLabelColor();
            }
        }
    };
    ActionListener timeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            JTSConfigurator.this.jts.setDateFormat(JTSConfigurator.this.timeFormat_yy.isSelected(), JTSConfigurator.this.timeFormat_mm.isSelected(), JTSConfigurator.this.timeFormat_dd.isSelected(), JTSConfigurator.this.timeFormat_hm.isSelected());
        }
    };
    ActionListener propbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTSConfigurator.this.ctsplot.getChartPanel().doEditChartProperties();
        }
    };
    ActionListener addbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphProperties prop = JTSConfigurator.this.propVector.size() > 0 ? (GraphProperties)JTSConfigurator.this.propVector.get(0) : new GraphProperties(JTSConfigurator.this);
            JTSConfigurator.this.addGraph(prop);
        }
    };
    ActionListener plotbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTSConfigurator.this.plotAllGraphs();
            JTSConfigurator.this.setVisible(true);
        }
    };
    ActionListener actChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    ActionListener saveImageAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = JTSConfigurator.this.sheet.getEPSFileChooser();
                int returnVal = chooser.showSaveDialog(JTSConfigurator.this);
                if (returnVal == 0) {
                    final File file = chooser.getSelectedFile();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            JTSConfigurator.this.jts.saveAsEPS(file);
                        }
                    };
                    WorkerDlg dlg = new WorkerDlg((Window)JTSConfigurator.this.parent, "EPS Export");
                    dlg.setTask(r);
                    dlg.execute();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    ActionListener saveTempListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String fileID = JTSConfigurator.this.saveTemplate();
            StringTokenizer name_tokenizer = new StringTokenizer(fileID, ".");
            String filename = "";
            filename = name_tokenizer.hasMoreTokens() ? name_tokenizer.nextToken() + ".sdat" : fileID + ".sdat";
            if (JTSConfigurator.this.sheet.isOutputSheet()) {
                String[] headers_with_time = new String[JTSConfigurator.this.headers.length + 1];
                headers_with_time[0] = "ID";
                System.arraycopy(JTSConfigurator.this.headers, 0, headers_with_time, 1, JTSConfigurator.this.headers.length);
                JTSConfigurator.this.sheet.saveAll(filename);
            }
        }
    };
    ActionListener loadTempListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal = -1;
            try {
                returnVal = JTSConfigurator.this.sheet.getTemplateChooser().showOpenDialog(JTSConfigurator.this);
                if (returnVal == 0) {
                    File file = JTSConfigurator.this.sheet.getTemplateChooser().getSelectedFile();
                    JTSConfigurator.this.loadTemplate(file);
                    JTSConfigurator.this.plotAllGraphs();
                }
            }
            catch (Exception fnfexc) {
                returnVal = -1;
            }
        }
    };

    public JTSConfigurator() {
    }

    public JTSConfigurator(JFrame parent, JAMSSpreadSheet sheet, JAMSExplorer explorer) {
        this.setParent(parent);
        this.setIconImage(parent.getIconImage());
        this.setDefaultCloseOperation(2);
        explorer.registerChild(this);
        this.setTitle("JTS Viewer");
        this.workspace = explorer.getWorkspace();
        this.setLayout(new FlowLayout());
        Point parentloc = parent.getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        this.sheet = sheet;
        this.table = sheet.table;
        if (this.table.getSelectedColumn() == -1) {
            this.table.selectAll();
        }
        this.columnCount = this.table.getColumnCount();
        this.rows = this.table.getSelectedRows();
        this.columns = this.table.getSelectedColumns();
        this.graphCount = this.columns.length;
        try {
            if (this.columns[0] == 0) {
                --this.graphCount;
                int[] arraycopy = new int[this.graphCount];
                System.arraycopy(this.columns, 1, arraycopy, 0, this.graphCount);
                this.columns = arraycopy;
            }
        }
        catch (ArrayIndexOutOfBoundsException arraycopy) {
            // empty catch block
        }
        this.headers = new String[this.graphCount];
        for (int k = 0; k < this.graphCount; ++k) {
            this.headers[k] = this.table.getColumnName(this.columns[k]);
        }
        this.createPanel();
        this.pack();
        this.setVisible(true);
    }

    public JTSConfigurator(JFrame parent, JAMSSpreadSheet sheet, File templateFile, JAMSExplorer explorer) {
        this.setParent(parent);
        this.setIconImage(parent.getIconImage());
        this.setDefaultCloseOperation(2);
        explorer.registerChild(this);
        this.setTitle("JTS Viewer");
        this.workspace = explorer.getWorkspace();
        this.setLayout(new FlowLayout());
        Point parentloc = parent.getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        Properties properties = new Properties();
        String output_type = new String();
        this.templateFile = templateFile;
        try {
            FileInputStream fin = new FileInputStream(templateFile);
            properties.load(fin);
            fin.close();
            output_type = properties.getProperty("output");
        }
        catch (Exception e) {
            output_type = "false";
        }
        this.sheet = sheet;
        this.table = sheet.table;
        this.rows = this.table.getSelectedRows();
        this.columns = this.table.getSelectedColumns();
        this.graphCount = this.columns.length;
        this.headers = new String[this.graphCount];
        for (int k = 0; k < this.graphCount; ++k) {
            this.headers[k] = this.table.getColumnName(this.columns[k]);
        }
        this.setPreferredSize(new Dimension(1024, 768));
        this.createPanel();
        this.pack();
        this.setVisible(true);
    }

    public void createPanel() {
        block5: {
            this.colour_cnt = 0;
            this.colorTable.put("yellow", Color.yellow);
            this.colorTable.put("orange", Color.orange);
            this.colorTable.put("red", Color.red);
            this.colorTable.put("pink", Color.pink);
            this.colorTable.put("magenta", Color.magenta);
            this.colorTable.put("cyan", Color.cyan);
            this.colorTable.put("blue", Color.blue);
            this.colorTable.put("green", Color.green);
            this.colorTable.put("gray", Color.gray);
            this.colorTable.put("lightgray", Color.lightGray);
            this.colorTable.put("black", Color.black);
            JLabel nameLabel = new JLabel("Name");
            JLabel posLabel = new JLabel("Position");
            JLabel typeLabel = new JLabel("Renderer");
            JLabel colorLabel = new JLabel("Colour");
            JLabel dataLabel = new JLabel("Select Data / Legend Entry");
            JLabel timeLabel = new JLabel("Time Interval");
            JLabel emptyTimeLabel = new JLabel("    ");
            JLabel legendLabel = new JLabel("Legend Entry");
            nameLabel.setBackground(Color.DARK_GRAY);
            posLabel.setBackground(Color.DARK_GRAY);
            typeLabel.setBackground(Color.DARK_GRAY);
            colorLabel.setBackground(Color.DARK_GRAY);
            dataLabel.setBackground(Color.DARK_GRAY);
            timeLabel.setBackground(Color.DARK_GRAY);
            this.savePanel = new JPanel();
            GridBagLayout sgbl = new GridBagLayout();
            this.savePanel.setLayout(sgbl);
            GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.saveButton, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.saveTempButton, (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.loadTempButton, (int)2, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            this.saveButton.addActionListener(this.saveImageAction);
            this.saveTempButton.addActionListener(this.saveTempListener);
            this.loadTempButton.addActionListener(this.loadTempListener);
            this.setLayout(new BorderLayout());
            this.plotpanel = new JPanel();
            this.plotpanel.setLayout(new BorderLayout());
            this.frame = new JPanel();
            this.frame.setLayout(new BorderLayout());
            this.graphScPane = new JScrollPane();
            this.optionpanel = new JPanel();
            this.graphpanel = new JPanel();
            this.initGroupUI();
            this.southpanel = new JPanel();
            this.southpanel.setLayout(new FlowLayout());
            this.edTitlePanel = new JPanel();
            this.edTitlePanel.setLayout(new FlowLayout());
            this.edLeftAxisPanel = new JPanel();
            this.edLeftAxisPanel.setLayout(new FlowLayout());
            this.edRightAxisPanel = new JPanel();
            this.edRightAxisPanel.setLayout(new FlowLayout());
            this.edTitleField.setText(this.sheet.getID());
            this.edTitleField.setSize(40, 10);
            this.edTitleField.addActionListener(this.plotbuttonclick);
            this.edLeftField.setText("Left Axis Title");
            this.edLeftField.addActionListener(this.plotbuttonclick);
            this.edLeftField.setSize(40, 10);
            this.edRightField.setText("Right Axis Title");
            this.edRightField.addActionListener(this.plotbuttonclick);
            this.edRightField.setSize(40, 10);
            this.edXAxisField.setText("Time");
            this.edXAxisField.addActionListener(this.plotbuttonclick);
            this.applyButton.addActionListener(this.plotbuttonclick);
            this.optionpanel.add(this.edTitle);
            this.optionpanel.add(this.edTitleField);
            this.optionpanel.add(this.edLeft);
            this.optionpanel.add(this.edLeftField);
            this.optionpanel.add(this.edRight);
            this.optionpanel.add(this.edRightField);
            this.optionpanel.add(this.applyButton);
            this.rLeftBox.setSelectedIndex(0);
            this.rLeftBox.addActionListener(this.rendererColorListener);
            this.rRightBox.setSelectedIndex(0);
            this.rRightBox.addActionListener(this.rendererColorListener);
            if (this.templateFile != null && this.templateFile.exists()) {
                try {
                    if (!this.output_ttp) {
                        this.loadTemplate(this.templateFile);
                        break block5;
                    }
                    this.loadTemplate(this.templateFile);
                }
                catch (Exception fnfe) {
                    Logger.getLogger(JTSConfigurator.class.getName()).log(Level.SEVERE, null, fnfe);
                    this.initGraphLoad();
                }
            } else {
                this.initGraphLoad();
            }
        }
        this.createOptionPanel();
        this.handleRenderer();
        this.jts.setPropVector(this.propVector);
        this.jts.createPlot();
        JPanel graphPanel = new JPanel();
        JPanel optPanel = new JPanel();
        graphPanel.add(this.graphpanel);
        optPanel.add(this.optionpanel);
        this.graphScPane = new JScrollPane(graphPanel);
        this.graphScPane.setSize(new Dimension(512, 300));
        this.graphScPane.setVerticalScrollBarPolicy(22);
        this.jts.getPanel().add((Component)this.savePanel, "South");
        this.optionpanel.setBorder(new EtchedBorder());
        this.optScPane = new JScrollPane(optPanel);
        this.split_hor.add((Component)this.optScPane, 0);
        this.split_hor.add((Component)this.graphScPane, 1);
        this.split_vert.add((Component)this.split_hor, 0);
        this.split_vert.add((Component)this.jts.getPanel(), 1);
        this.add(this.split_vert);
        this.jts.setDateFormat(this.timeFormat_yy.isSelected(), this.timeFormat_mm.isSelected(), this.timeFormat_dd.isSelected(), this.timeFormat_hm.isSelected());
        this.plotAllGraphs();
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    private void initGraphLoad() {
        for (int k = 0; k < this.graphCount; ++k) {
            GraphProperties prop = new GraphProperties(this.thisJTS);
            prop.setIndex(k);
            prop.setSelectedColumn(this.columns[k]);
            prop.setSelectedRows(this.rows);
            prop.setTimeSTART(this.rows[0]);
            prop.setTimeEND(this.rows[this.rows.length - 1]);
            int color_cnt = k < 9 ? k : 0;
            String[] colors = this.getColorScheme(color_cnt);
            prop.setSeriesPaint(this.colorTable.get(colors[0]));
            prop.setSeriesFillPaint(this.colorTable.get(colors[1]));
            prop.setSeriesOutlinePaint(this.colorTable.get(colors[2]));
            prop.setShapesVisible(true);
            prop.setLinesVisible(true);
            prop.setStroke(1);
            prop.setShape(1, 3);
            String s = this.table.getColumnName(this.columns[k]);
            prop.setLegendName(s);
            prop.setName(s);
            PropertyPanel ppanel = new PropertyPanel(this.thisJTS, prop);
            this.addPropGroup(ppanel);
            this.propVector.add(k, prop);
            this.panelVector.add(k, ppanel);
        }
        this.finishGroupUI();
    }

    private String[] getColorScheme(int scheme) {
        String[] colors = new String[3];
        switch (scheme) {
            case 0: {
                colors[0] = "red";
                colors[1] = "red";
                colors[2] = "gray";
                break;
            }
            case 1: {
                colors[0] = "blue";
                colors[1] = "blue";
                colors[2] = "black";
                break;
            }
            case 2: {
                colors[0] = "green";
                colors[1] = "green";
                colors[2] = "gray";
                break;
            }
            case 3: {
                colors[0] = "black";
                colors[1] = "black";
                colors[2] = "yellow";
                break;
            }
            case 4: {
                colors[0] = "orange";
                colors[1] = "orange";
                colors[2] = "cyan";
                break;
            }
            case 5: {
                colors[0] = "cyan";
                colors[1] = "cyan";
                colors[2] = "black";
                break;
            }
            case 6: {
                colors[0] = "magenta";
                colors[1] = "yellow";
                colors[2] = "magenta";
                break;
            }
            case 7: {
                colors[0] = "lightgray";
                colors[1] = "orange";
                colors[2] = "lightgray";
                break;
            }
            default: {
                colors[0] = "red";
                colors[1] = "blue";
                colors[2] = "red";
            }
        }
        return colors;
    }

    public void addGraph(GraphProperties prop) {
        AddGraphDlg dlg = new AddGraphDlg();
        dlg.setVisible(true);
        if (dlg.getResult()) {
            int i = this.propVector.indexOf(prop);
            GraphProperties newProp = new GraphProperties(this);
            newProp.setPosition(dlg.getSide());
            int pos = dlg.getPosition();
            dlg.dispose();
            newProp.setSeriesPaint(Color.BLACK);
            newProp.setSeriesFillPaint(Color.BLACK);
            newProp.setSeriesOutlinePaint(Color.BLACK);
            newProp.setSelectedColumn(prop.getSelectedColumn());
            newProp.setLegendName(prop.getLegendName());
            newProp.setLinesVisible(prop.getLinesVisible());
            newProp.setShapesVisible(prop.getShapesVisible());
            newProp.setStroke(prop.getStrokeType());
            newProp.setShape(prop.getShapeType(), prop.getSizeType());
            newProp.setOutlineStroke(prop.getOutlineType());
            if (pos >= 0) {
                int t_s = prop.getTimeSTART();
                int t_e = prop.getTimeEND();
                newProp.setTimeSTART(t_s);
                newProp.setTimeEND(t_e);
            }
            PropertyPanel newPanel = new PropertyPanel(this, newProp);
            this.propVector.add(pos, newProp);
            this.panelVector.add(pos, newPanel);
            this.graphCount = this.propVector.size();
            this.initGroupUI();
            this.handleRenderer();
            for (int k = 0; k < this.graphCount; ++k) {
                newProp = this.propVector.get(k);
                newProp.setIndex(k);
                newPanel = this.panelVector.get(k);
                this.addPropGroup(newPanel);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void removeGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        if (this.graphCount > 1) {
            this.propVector.remove(i);
            this.panelVector.remove(i);
            this.graphCount = this.propVector.size();
            this.handleRenderer();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                PropertyPanel newPanel = this.panelVector.get(k);
                this.addPropGroup(newPanel);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void upGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        PropertyPanel ppanel = this.panelVector.get(i);
        if (i - 1 >= 0 && i - 1 < this.graphCount) {
            this.propVector.remove(prop);
            this.panelVector.remove(i);
            this.propVector.add(i - 1, prop);
            this.panelVector.add(i - 1, ppanel);
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                ppanel = this.panelVector.get(k);
                this.addPropGroup(ppanel);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void downGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        if (i + 1 < this.propVector.size()) {
            GraphProperties newProp = this.propVector.get(i + 1);
            PropertyPanel newPanel = this.panelVector.get(i + 1);
            if (i + 1 >= 0 && i + 1 < this.graphCount) {
                this.propVector.remove(i + 1);
                this.panelVector.remove(i + 1);
                this.propVector.add(i, newProp);
                this.panelVector.add(i, newPanel);
                this.graphCount = this.propVector.size();
                this.initGroupUI();
                for (int k = 0; k < this.graphCount; ++k) {
                    newProp = this.propVector.get(k);
                    newProp.setIndex(k);
                    this.addPropGroup(newPanel);
                }
                this.finishGroupUI();
                this.repaint();
            }
        }
    }

    private void updatePropVector() {
        if (!this.output_ttp) {
            for (int i = 0; i < this.propVector.size(); ++i) {
                this.propVector.get(i).applyTSProperties();
            }
        } else {
            for (int i = 0; i < this.propVector.size(); ++i) {
                this.propVector.get(i).applySTPProperties(this.arrayVector, this.timeVector);
            }
        }
    }

    public void plotAllGraphs() {
        this.updatePropVector();
        int l = 0;
        int r = 0;
        int rLeft = this.rLeftBox.getSelectedIndex();
        int rRight = this.rRightBox.getSelectedIndex();
        XYLineAndShapeRenderer rendererLeft = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer rendererRight = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer lsr_R = new XYLineAndShapeRenderer();
        XYBarRenderer brr_R = new XYBarRenderer();
        XYDifferenceRenderer dfr_R = new XYDifferenceRenderer();
        XYAreaRenderer ar_R = new XYAreaRenderer();
        XYStepRenderer str_R = new XYStepRenderer();
        XYStepAreaRenderer sar_R = new XYStepAreaRenderer();
        XYLineAndShapeRenderer lsr_L = new XYLineAndShapeRenderer();
        XYBarRenderer brr_L = new XYBarRenderer();
        XYDifferenceRenderer dfr_L = new XYDifferenceRenderer();
        XYAreaRenderer ar_L = new XYAreaRenderer();
        XYStepRenderer str_L = new XYStepRenderer();
        XYStepAreaRenderer sar_L = new XYStepAreaRenderer();
        block18: for (int i = 0; i < this.propVector.size(); ++i) {
            GraphProperties prop = this.propVector.get(i);
            if (prop.getPosition() == 0) {
                ++l;
                switch (rLeft) {
                    case 0: {
                        lsr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                        lsr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                        lsr_L.setSeriesShape(i - r, prop.getSeriesShape());
                        lsr_L.setSeriesShapesVisible(i - r, prop.getShapesVisible());
                        lsr_L.setSeriesLinesVisible(i - r, prop.getLinesVisible());
                        lsr_L.setDrawOutlines(prop.getOutlineVisible());
                        lsr_L.setUseOutlinePaint(prop.getOutlineVisible());
                        lsr_L.setSeriesFillPaint(i - r, (Paint)prop.getSeriesFillPaint());
                        lsr_L.setUseFillPaint(true);
                        lsr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                        lsr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                        rendererLeft = lsr_L;
                        break;
                    }
                    case 1: {
                        brr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                        brr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                        brr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                        brr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                        rendererLeft = brr_L;
                        break;
                    }
                    case 2: {
                        ar_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                        ar_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                        ar_L.setSeriesShape(i - r, prop.getSeriesShape());
                        ar_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                        ar_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                        ar_L.setOutline(prop.getOutlineVisible());
                        rendererLeft = ar_L;
                        break;
                    }
                    case 3: {
                        str_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                        str_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                        str_L.setSeriesShape(i - r, prop.getSeriesShape());
                        rendererLeft = str_L;
                        break;
                    }
                    case 4: {
                        sar_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                        sar_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                        sar_L.setSeriesShape(i - r, prop.getSeriesShape());
                        sar_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                        sar_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                        sar_L.setOutline(prop.getOutlineVisible());
                        rendererLeft = sar_L;
                        break;
                    }
                    case 5: {
                        dfr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                        dfr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                        dfr_L.setSeriesShape(i - r, prop.getSeriesShape());
                        dfr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                        dfr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                        dfr_L.setShapesVisible(prop.getShapesVisible());
                        rendererLeft = dfr_L;
                        break;
                    }
                    default: {
                        lsr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                        lsr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                        lsr_L.setSeriesShape(i - r, prop.getSeriesShape());
                        lsr_L.setSeriesShapesVisible(i - r, prop.getShapesVisible());
                        lsr_L.setSeriesLinesVisible(i - r, prop.getLinesVisible());
                        lsr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                        lsr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                        rendererLeft = lsr_L;
                    }
                }
            }
            if (prop.getPosition() != 1) continue;
            ++r;
            switch (rRight) {
                case 0: {
                    lsr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                    lsr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                    lsr_R.setSeriesShape(i - l, prop.getSeriesShape());
                    lsr_R.setSeriesShapesVisible(i - l, prop.getShapesVisible());
                    lsr_R.setSeriesLinesVisible(i - l, prop.getLinesVisible());
                    lsr_R.setDrawOutlines(prop.getOutlineVisible());
                    lsr_R.setUseOutlinePaint(prop.getOutlineVisible());
                    lsr_R.setSeriesFillPaint(i - l, (Paint)prop.getSeriesFillPaint());
                    lsr_R.setUseFillPaint(true);
                    lsr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                    lsr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = lsr_R;
                    continue block18;
                }
                case 1: {
                    brr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                    brr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                    brr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                    brr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = brr_R;
                    continue block18;
                }
                case 2: {
                    ar_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                    ar_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                    ar_R.setSeriesShape(i - l, prop.getSeriesShape());
                    ar_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                    ar_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = ar_R;
                    continue block18;
                }
                case 3: {
                    str_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                    str_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                    str_R.setSeriesShape(i - l, prop.getSeriesShape());
                    str_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                    str_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = str_R;
                    continue block18;
                }
                case 4: {
                    sar_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                    sar_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                    sar_R.setSeriesShape(i - l, prop.getSeriesShape());
                    sar_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                    sar_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = sar_R;
                    continue block18;
                }
                case 5: {
                    dfr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                    dfr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                    dfr_R.setSeriesShape(i - l, prop.getSeriesShape());
                    dfr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                    dfr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                    dfr_R.setShapesVisible(prop.getShapesVisible());
                    rendererRight = dfr_R;
                    continue block18;
                }
                default: {
                    lsr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                    lsr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                    lsr_R.setSeriesShape(i - l, prop.getSeriesShape());
                    lsr_R.setSeriesShapesVisible(i - l, prop.getShapesVisible());
                    lsr_R.setSeriesLinesVisible(i - l, prop.getLinesVisible());
                    lsr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                    lsr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = lsr_R;
                }
            }
        }
        this.jts.setPropVector(this.propVector);
        try {
            if (l > 0) {
                this.jts.plotLeft((XYItemRenderer)rendererLeft, this.edLeftField.getText(), this.edXAxisField.getText(), this.invLeftBox.isSelected());
            }
            if (r > 0) {
                this.jts.plotRight((XYItemRenderer)rendererRight, this.edRightField.getText(), this.edXAxisField.getText(), this.invRightBox.isSelected());
            }
            if (r == 0 && l == 0) {
                this.jts.plotEmpty();
            }
            this.jts.setTitle(this.edTitleField.getText());
            this.jts.setDateFormat(this.timeFormat_yy.isSelected(), this.timeFormat_mm.isSelected(), this.timeFormat_dd.isSelected(), this.timeFormat_hm.isSelected());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void updateGUI() {
        this.repaint();
    }

    public void handleRenderer() {
        int r = 0;
        int l = 0;
        for (int i = 0; i < this.propVector.size(); ++i) {
            if (this.propVector.get(i).getPosition() == 0) {
                ++l;
            }
            if (this.propVector.get(i).getPosition() != 1) continue;
            ++r;
        }
        if ((l < 2 || l > 2) && this.rLeftBox.getItemCount() == 6) {
            this.rLeftBox.removeItemAt(5);
        }
        if ((r < 2 || r > 2) && this.rRightBox.getItemCount() == 6) {
            this.rRightBox.removeItemAt(5);
        }
        if (l == 2 && this.rLeftBox.getItemCount() == 5) {
            this.rLeftBox.addItem("Difference");
        }
        if (r == 2 && this.rRightBox.getItemCount() == 5) {
            this.rRightBox.addItem("Difference");
        }
    }

    public int getRendererLeft() {
        return this.rLeftBox.getSelectedIndex();
    }

    public int getRendererRight() {
        return this.rRightBox.getSelectedIndex();
    }

    public void setRendererLeft(int type) {
        this.rLeftBox.setSelectedIndex(type);
    }

    public void setRendererRight(int type) {
        this.rRightBox.setSelectedIndex(type);
    }

    private void createOptionPanel() {
        GroupLayout optLayout = new GroupLayout(this.optionpanel);
        JPanel timeFormatPanel = new JPanel();
        timeFormatPanel.add(this.timeFormat_dd);
        timeFormatPanel.add(this.timeFormat_mm);
        timeFormatPanel.add(this.timeFormat_yy);
        timeFormatPanel.add(this.timeFormat_hm);
        this.timeFormat_yy.setSelected(true);
        this.timeFormat_mm.setSelected(true);
        this.timeFormat_dd.setSelected(true);
        this.timeFormat_hm.setSelected(false);
        this.addButton.addActionListener(this.addbuttonclick);
        this.optionpanel.setLayout(optLayout);
        optLayout.setAutoCreateGaps(true);
        optLayout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup optHGroup = optLayout.createSequentialGroup();
        GroupLayout.SequentialGroup optVGroup = optLayout.createSequentialGroup();
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edTitleField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edLeft).addComponent(this.edLeftField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edRight).addComponent(this.edRightField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edXAxis).addComponent(this.edXAxisField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rLeftLabel).addComponent(this.rLeftBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rRightLabel).addComponent(this.rRightBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invLeftBox).addComponent(this.addButton));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invRightBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.timeFormatLabel));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(timeFormatPanel).addComponent(this.applyButton));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edLeft).addComponent(this.edRight).addComponent(this.edXAxis).addComponent(this.rLeftLabel).addComponent(this.rRightLabel).addComponent(this.invLeftBox).addComponent(this.invRightBox).addComponent(this.timeFormatLabel).addComponent(timeFormatPanel));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitleField).addComponent(this.edLeftField).addComponent(this.edRightField).addComponent(this.edXAxisField).addComponent(this.rLeftBox).addComponent(this.rRightBox).addComponent(this.addButton).addGap(1, 1, 1).addComponent(this.applyButton));
        optLayout.setHorizontalGroup(optHGroup);
        optLayout.setVerticalGroup(optVGroup);
    }

    private void initGroupUI() {
        this.graphpanel.removeAll();
        JLabel typeLabel = new JLabel("Colour / Position");
        JLabel dataLabel = new JLabel("Data / Legend Entry");
        JLabel timeLabel = new JLabel("Time Interval");
        this.gLayout = new GroupLayout(this.graphpanel);
        this.graphpanel.setLayout(this.gLayout);
        this.gLayout.setAutoCreateGaps(true);
        this.gLayout.setAutoCreateContainerGaps(true);
        this.hGroup = this.gLayout.createSequentialGroup();
        this.vGroup = this.gLayout.createSequentialGroup();
        this.group1 = this.gLayout.createParallelGroup();
        this.group2 = this.gLayout.createParallelGroup();
        this.group3 = this.gLayout.createParallelGroup();
        this.group4 = this.gLayout.createParallelGroup();
        this.group5 = this.gLayout.createParallelGroup();
        this.group6 = this.gLayout.createParallelGroup();
        this.group7 = this.gLayout.createParallelGroup();
        this.group8 = this.gLayout.createParallelGroup();
        this.group9 = this.gLayout.createParallelGroup();
        this.group10 = this.gLayout.createParallelGroup();
        this.group11 = this.gLayout.createParallelGroup();
        this.group12 = this.gLayout.createParallelGroup();
        this.group13 = this.gLayout.createParallelGroup();
        this.group14 = this.gLayout.createParallelGroup();
        this.group15 = this.gLayout.createParallelGroup();
        this.group1.addComponent(dataLabel);
        this.group2.addComponent(timeLabel);
        this.group3.addComponent(typeLabel);
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(dataLabel).addComponent(timeLabel).addComponent(typeLabel));
    }

    private void addPropGroup(PropertyPanel ppanel) {
        JLabel space1 = new JLabel(" ");
        JLabel space2 = new JLabel(" ");
        JLabel space3 = new JLabel(" ");
        JLabel space4 = new JLabel(" ");
        JLabel space5 = new JLabel("   ");
        JLabel space6 = new JLabel("   ");
        JLabel lf = ppanel.getLegendLabel();
        this.group6.addComponent(space5).addComponent(space6);
        this.group1.addComponent(ppanel.getDataChoice()).addComponent(lf).addGap(20);
        this.group2.addComponent(ppanel.getTimeChoiceSTART()).addComponent(ppanel.getTimeChoiceEND());
        this.group3.addComponent(ppanel.getCustomizeButton()).addComponent(ppanel.getPosChoice());
        this.group9.addComponent(space3);
        this.group11.addComponent(space4);
        this.group13.addComponent(ppanel.getColorLabel()).addComponent(ppanel.getRemButton());
        this.group14.addComponent(ppanel.getSColorLabel()).addComponent(ppanel.getUpButton());
        this.group15.addComponent(ppanel.getDownButton());
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(ppanel.getDataChoice()).addComponent(ppanel.getTimeChoiceSTART()).addComponent(space5).addComponent(ppanel.getCustomizeButton()).addGap(10).addComponent(ppanel.getColorLabel()).addComponent(ppanel.getSColorLabel()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lf).addComponent(ppanel.getTimeChoiceEND()).addComponent(space6).addComponent(ppanel.getPosChoice()).addComponent(space3).addComponent(space4).addComponent(ppanel.getRemButton()).addComponent(ppanel.getUpButton()).addComponent(ppanel.getDownButton()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup().addGap(20));
    }

    private void finishGroupUI() {
        this.hGroup.addGroup(this.group1);
        this.hGroup.addGroup(this.group2);
        this.hGroup.addGroup(this.group6);
        this.hGroup.addGroup(this.group3);
        this.hGroup.addGroup(this.group9);
        this.hGroup.addGroup(this.group10);
        this.hGroup.addGroup(this.group11);
        this.hGroup.addGroup(this.group12);
        this.hGroup.addGroup(this.group13);
        this.hGroup.addGroup(this.group14);
        this.hGroup.addGroup(this.group15);
        this.gLayout.setHorizontalGroup(this.hGroup);
        this.gLayout.setVerticalGroup(this.vGroup);
    }

    public JPanel getPanel() {
        return this.mainpanel;
    }

    public JPanel getCTSPlot() {
        return this.ctsplot.getPanel();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    private String saveTemplate() {
        Properties properties = new Properties();
        int no_of_props = this.propVector.size();
        String store = "";
        try {
            store = this.sheet.getID();
        }
        catch (NullPointerException npe) {
            store = "DEFAULT";
        }
        String names = "";
        String number = "" + no_of_props;
        String output = this.sheet.isOutputSheet() ? "true" : "false";
        properties.setProperty("output", output);
        properties.setProperty("template_type", "TIME");
        properties.setProperty("number", number);
        properties.setProperty("store", store);
        properties.setProperty("title", this.edTitleField.getText());
        properties.setProperty("axisLTitle", this.edLeftField.getText());
        properties.setProperty("axisRTitle", this.edRightField.getText());
        properties.setProperty("xAxisTitle", this.edXAxisField.getText());
        properties.setProperty("renderer_left", "" + this.rLeftBox.getSelectedIndex());
        properties.setProperty("renderer_right", "" + this.rRightBox.getSelectedIndex());
        properties.setProperty("inv_left", "" + this.invLeftBox.isSelected());
        properties.setProperty("inv_right", "" + this.invRightBox.isSelected());
        properties.setProperty("x_series_index", "DEFAULT");
        properties.setProperty("dataSTART", "DEFAULT");
        properties.setProperty("dataEND", "DEFAULT");
        properties.setProperty("timeFormat_yy", "" + this.timeFormat_yy.isSelected());
        properties.setProperty("timeFormat_mmy", "" + this.timeFormat_mm.isSelected());
        properties.setProperty("timeFormat_dd", "" + this.timeFormat_dd.isSelected());
        properties.setProperty("timeFormat_hm", "" + this.timeFormat_hm.isSelected());
        for (int i = 0; i < no_of_props; ++i) {
            GraphProperties gprop = this.propVector.get(i);
            String name = gprop.getName();
            names = i == 0 ? name : names + "," + name;
            properties.setProperty(name + ".legendname", gprop.getLegendName());
            properties.setProperty(name + ".position", "" + gprop.getPosition());
            properties.setProperty(name + ".timeSTART", gprop.getTimeIntervals()[gprop.getTimeSTART()]);
            properties.setProperty(name + ".timeEND", gprop.getTimeIntervals()[gprop.getTimeEND()]);
            String stroke_type = "" + gprop.getStrokeType();
            properties.setProperty(name + ".linestroke", stroke_type);
            Color linecolor_load = gprop.getSeriesPaint();
            String stroke_color = "" + linecolor_load.getRed() + "," + linecolor_load.getGreen() + "," + linecolor_load.getBlue();
            properties.setProperty(name + ".linecolor", stroke_color);
            String lines_vis = "" + gprop.getLinesVisible();
            properties.setProperty(name + ".linesvisible", lines_vis);
            String shapes_vis = "" + gprop.getShapesVisible();
            properties.setProperty(name + ".shapesvisible", shapes_vis);
            String shape_type = "" + gprop.getShapeType();
            properties.setProperty(name + ".shapetype", shape_type);
            String size_type = "" + gprop.getSizeType();
            properties.setProperty(name + ".shapesize", size_type);
            Color fillcolor_load = gprop.getSeriesFillPaint();
            String shape_color = "" + fillcolor_load.getRed() + "," + fillcolor_load.getGreen() + "," + fillcolor_load.getBlue();
            properties.setProperty(name + ".shapecolor", shape_color);
            String outline_type = "" + gprop.getOutlineType();
            properties.setProperty(name + ".outlinestroke", outline_type);
            Color outcolor_load = gprop.getSeriesOutlinePaint();
            String outline_color = "" + outcolor_load.getRed() + "," + outcolor_load.getGreen() + "," + outcolor_load.getBlue();
            properties.setProperty(name + ".outlinecolor", outline_color);
        }
        properties.setProperty("names", names);
        String filename = "";
        String inputString = "";
        StringTokenizer name_tokenizer = new StringTokenizer(store, ".");
        String storename = "";
        storename = name_tokenizer.hasMoreTokens() ? name_tokenizer.nextToken() : store;
        try {
            boolean dont_save = true;
            while (dont_save) {
                inputString = GUIHelper.showInputDlg((Component)this, (String)SpreadsheetConstants.INFO_MSG_SAVETEMP, (String)storename);
                if (inputString != null) {
                    FileOutputStream fout;
                    int result;
                    String fileexists;
                    FileOutputStream fout2;
                    File file;
                    inputString = inputString + ".ttp";
                    if (this.sheet.isOutputSheet()) {
                        file = new File(this.sheet.getOutputDSDir(), inputString);
                        if (!file.exists()) {
                            filename = file.getName();
                            fout2 = new FileOutputStream(file);
                            properties.store(fout2, "");
                            fout2.close();
                            dont_save = false;
                            continue;
                        }
                        fileexists = "The File " + file + " already exists.\n Overwrite?";
                        result = GUIHelper.showYesNoDlg((Component)this, (String)fileexists, (String)"File already exists");
                        if (result != 0) continue;
                        filename = file.getName();
                        fout = new FileOutputStream(file);
                        properties.store(fout, "");
                        fout.close();
                        dont_save = false;
                        continue;
                    }
                    file = new File(this.workspace.getDirectory().toString() + "/explorer", inputString);
                    if (!file.exists()) {
                        filename = file.getName();
                        fout2 = new FileOutputStream(file);
                        properties.store(fout2, "");
                        fout2.close();
                        dont_save = false;
                        continue;
                    }
                    fileexists = "The File " + file + " already exists.\n Overwrite?";
                    result = GUIHelper.showYesNoDlg((Component)this, (String)fileexists, (String)"File already exists");
                    if (result != 0) continue;
                    filename = file.getName();
                    fout = new FileOutputStream(file);
                    properties.store(fout, "");
                    fout.close();
                    dont_save = false;
                    continue;
                }
                dont_save = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filename;
    }

    private void loadOutputTemplate(File templateFile) {
        int no_of_props;
        Properties properties = new Properties();
        boolean load_prop = false;
        int returnVal = -1;
        try {
            FileInputStream fin = new FileInputStream(templateFile);
            properties.load(fin);
            fin.close();
        }
        catch (Exception fin) {
            // empty catch block
        }
        String names = properties.getProperty("names");
        this.graphCount = no_of_props = new Integer(properties.getProperty("number")).intValue();
        StringTokenizer nameTokenizer = new StringTokenizer(names, ",");
        for (int i = 0; i < no_of_props; ++i) {
            load_prop = false;
            GraphProperties gprop = new GraphProperties(this);
            if (!nameTokenizer.hasMoreTokens()) continue;
            String name = nameTokenizer.nextToken();
            for (int k = 0; k < this.graphCount; ++k) {
                if (this.headers[k + 1].compareTo(name) != 0) continue;
                gprop.setSelectedColumn(k);
                load_prop = true;
                break;
            }
            boolean readStart = false;
            boolean readEnd = false;
            gprop.setTimeSTART(0);
            gprop.setTimeEND(this.rows_cnt - 1);
            if (!load_prop) continue;
            gprop.setLegendName(properties.getProperty(name + ".legendname", "legend name"));
            int pos = new Integer(properties.getProperty(name + ".position"));
            gprop.setPosition(pos);
            String timeSTART = properties.getProperty(name + ".timeSTART");
            String timeEND = properties.getProperty(name + ".timeEND");
            String read = null;
            for (int tc = 0; !(tc >= this.rows_cnt || readStart && readEnd); ++tc) {
                read = gprop.getTimeIntervals()[tc].toString();
                if (!readStart) {
                    if (!read.equals(timeSTART)) continue;
                    gprop.setTimeSTART(tc);
                    readStart = true;
                    continue;
                }
                if (!read.equals(timeEND)) continue;
                gprop.setTimeEND(tc);
                readEnd = true;
            }
            gprop.setName(name);
            gprop.setStroke(new Integer(properties.getProperty(name + ".linestroke", "2")));
            String stroke_color = properties.getProperty(name + ".linecolor", "255,0,0");
            StringTokenizer colorTokenizer = new StringTokenizer(stroke_color, ",");
            gprop.setSeriesPaint(new Color(new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken())));
            boolean lv = new Boolean(properties.getProperty(name + ".linesvisible"));
            gprop.setLinesVisible(lv);
            boolean sv = new Boolean(properties.getProperty(name + ".shapesvisible"));
            gprop.setShapesVisible(sv);
            int stype = new Integer(properties.getProperty(name + ".shapetype", "0"));
            int ssize = new Integer(properties.getProperty(name + ".shapesize"));
            gprop.setShape(stype, ssize);
            String shape_color = properties.getProperty(name + ".shapecolor", "255,0,0");
            StringTokenizer shapeTokenizer = new StringTokenizer(shape_color, ",");
            gprop.setSeriesFillPaint(new Color(new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken())));
            int os = new Integer(properties.getProperty(name + ".outlinestroke"));
            gprop.setOutlineStroke(os);
            String outline_color = properties.getProperty(name + ".outlinecolor", "255,0,0");
            StringTokenizer outTokenizer = new StringTokenizer(outline_color, ",");
            gprop.setSeriesOutlinePaint(new Color(new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken())));
            PropertyPanel ppanel = new PropertyPanel(this, gprop);
            this.propVector.add(gprop);
            this.panelVector.add(ppanel);
        }
        this.edTitleField.setText(properties.getProperty("title"));
        this.edLeftField.setText(properties.getProperty("axisLTitle"));
        this.edRightField.setText(properties.getProperty("axisRTitle"));
        this.edXAxisField.setText(properties.getProperty("xAxisTitle"));
        this.rLeftBox.setSelectedIndex(new Integer(properties.getProperty("renderer_left")));
        this.rRightBox.setSelectedIndex(new Integer(properties.getProperty("renderer_right")));
        this.invLeftBox.setSelected(new Boolean(properties.getProperty("inv_left")));
        this.invRightBox.setSelected(new Boolean(properties.getProperty("inv_right")));
        this.timeFormat_yy.setSelected(new Boolean(properties.getProperty("timeFormat_yy")));
        this.timeFormat_mm.setSelected(new Boolean(properties.getProperty("timeFormat_mmy")));
        this.timeFormat_dd.setSelected(new Boolean(properties.getProperty("timeFormat_dd")));
        this.timeFormat_hm.setSelected(new Boolean(properties.getProperty("timeFormat_hm")));
    }

    private void loadTemplate(File templateFile) {
        int no_of_props;
        Properties properties = new Properties();
        boolean load_prop = false;
        int returnVal = -1;
        try {
            FileInputStream fin = new FileInputStream(templateFile);
            properties.load(fin);
            fin.close();
        }
        catch (Exception fin) {
            // empty catch block
        }
        this.propVector = new Vector();
        String names = properties.getProperty("names");
        this.graphCount = no_of_props = new Integer(properties.getProperty("number")).intValue();
        StringTokenizer nameTokenizer = new StringTokenizer(names, ",");
        this.initGroupUI();
        for (int i = 0; i < no_of_props; ++i) {
            load_prop = false;
            GraphProperties gprop = new GraphProperties(this);
            if (!nameTokenizer.hasMoreTokens()) continue;
            String name = nameTokenizer.nextToken();
            for (int k = 0; k < this.table.getColumnCount(); ++k) {
                if (this.table.getColumnName(k).compareTo(name) != 0) continue;
                gprop.setSelectedColumn(k);
                load_prop = true;
                break;
            }
            boolean readStart = false;
            boolean readEnd = false;
            gprop.setTimeSTART(0);
            gprop.setTimeEND(this.table.getRowCount() - 1);
            if (!load_prop) continue;
            gprop.setLegendName(properties.getProperty(name + ".legendname", "legend name"));
            int pos = new Integer(properties.getProperty(name + ".position"));
            gprop.setPosition(pos);
            String timeSTART = properties.getProperty(name + ".timeSTART");
            String timeEND = properties.getProperty(name + ".timeEND");
            String read = null;
            if (timeSTART.compareTo("DEFAULT") != 0) {
                for (int tc = 0; !(tc >= this.table.getRowCount() || readStart && readEnd); ++tc) {
                    read = gprop.getTimeIntervals()[tc].toString();
                    if (!readStart) {
                        if (!read.equals(timeSTART)) continue;
                        gprop.setTimeSTART(tc);
                        readStart = true;
                        continue;
                    }
                    if (!read.equals(timeEND)) continue;
                    gprop.setTimeEND(tc);
                    readEnd = true;
                }
            } else {
                gprop.setTimeSTART(0);
                gprop.setTimeEND(this.table.getRowCount() - 1);
            }
            gprop.setName(name);
            gprop.setStroke(new Integer(properties.getProperty(name + ".linestroke", "2")));
            String stroke_color = properties.getProperty(name + ".linecolor", "255,0,0");
            StringTokenizer colorTokenizer = new StringTokenizer(stroke_color, ",");
            gprop.setSeriesPaint(new Color(new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken())));
            boolean lv = new Boolean(properties.getProperty(name + ".linesvisible"));
            gprop.setLinesVisible(lv);
            boolean sv = new Boolean(properties.getProperty(name + ".shapesvisible"));
            gprop.setShapesVisible(sv);
            int stype = new Integer(properties.getProperty(name + ".shapetype", "0"));
            int ssize = new Integer(properties.getProperty(name + ".shapesize"));
            gprop.setShape(stype, ssize);
            String shape_color = properties.getProperty(name + ".shapecolor", "255,0,0");
            StringTokenizer shapeTokenizer = new StringTokenizer(shape_color, ",");
            gprop.setSeriesFillPaint(new Color(new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken())));
            int os = new Integer(properties.getProperty(name + ".outlinestroke"));
            gprop.setOutlineStroke(os);
            String outline_color = properties.getProperty(name + ".outlinecolor", "255,0,0");
            StringTokenizer outTokenizer = new StringTokenizer(outline_color, ",");
            gprop.setSeriesOutlinePaint(new Color(new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken())));
            PropertyPanel ppanel = new PropertyPanel(this, gprop);
            this.propVector.add(gprop);
            this.panelVector.add(ppanel);
            this.addPropGroup(ppanel);
        }
        this.edTitleField.setText(properties.getProperty("title"));
        this.edLeftField.setText(properties.getProperty("axisLTitle"));
        this.edRightField.setText(properties.getProperty("axisRTitle"));
        this.edXAxisField.setText(properties.getProperty("xAxisTitle"));
        this.rLeftBox.setSelectedIndex(new Integer(properties.getProperty("renderer_left")));
        this.rRightBox.setSelectedIndex(new Integer(properties.getProperty("renderer_right")));
        this.invLeftBox.setSelected(new Boolean(properties.getProperty("inv_left")));
        this.invRightBox.setSelected(new Boolean(properties.getProperty("inv_right")));
        this.timeFormat_yy.setSelected(new Boolean(properties.getProperty("timeFormat_yy")));
        this.timeFormat_mm.setSelected(new Boolean(properties.getProperty("timeFormat_mmy")));
        this.timeFormat_dd.setSelected(new Boolean(properties.getProperty("timeFormat_dd")));
        this.timeFormat_hm.setSelected(new Boolean(properties.getProperty("timeFormat_hm")));
        this.finishGroupUI();
        this.jts.setPropVector(this.propVector);
    }

    private void loadOutputTTPData(File file) {
        this.arrayVector = new Vector();
        this.timeVector = new Vector();
        StringTokenizer st = new StringTokenizer("\t");
        ArrayList<String> headerList = new ArrayList<String>();
        boolean b_headers = false;
        boolean b_data = false;
        boolean time_set = false;
        boolean stop = false;
        int file_columns = 0;
        String ST_DATA = "#data";
        String ST_HEADERS = "#headers";
        String ST_END = "#end";
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            while (in.ready()) {
                String s = in.readLine();
                st = new StringTokenizer(s, "\t");
                String actual_string = "";
                if (b_data) {
                    int i = 0;
                    Attribute.Calendar timeval = DefaultDataFactory.getDataFactory().createCalendar();
                    double[] rowBuffer = new double[file_columns];
                    while (st.hasMoreTokens()) {
                        actual_string = st.nextToken();
                        if (actual_string.compareTo("#end") != 0) {
                            if (!time_set) {
                                timeval.setValue(actual_string, "yyyy-MM-dd hh:mm");
                                this.timeVector.add(timeval);
                                time_set = true;
                                continue;
                            }
                            try {
                                Double val = new Double(actual_string);
                                rowBuffer[i++] = val;
                            }
                            catch (Exception pe2) {
                                Logger.getLogger(JTSConfigurator.class.getName()).log(Level.SEVERE, null, pe2);
                            }
                            continue;
                        }
                        stop = true;
                    }
                    if (stop) continue;
                    this.arrayVector.add(rowBuffer);
                    time_set = false;
                    continue;
                }
                while (st.hasMoreTokens()) {
                    String test = st.nextToken();
                    if (test.compareTo("#data") == 0) {
                        b_data = true;
                        b_headers = false;
                        file_columns = headerList.size();
                    }
                    if (b_headers) {
                        headerList.add(test);
                    }
                    if (test.compareTo("#headers") != 0) continue;
                    b_headers = true;
                }
            }
            in.close();
            this.headers = new String[file_columns];
            this.headers = headerList.toArray(this.headers);
            this.graphCount = file_columns - 1;
            this.rows_cnt = this.arrayVector.size();
        }
        catch (FileNotFoundException fnfex) {
            String ERROR_NODAT_MSG = "File not found: " + file.getName() + "!";
            GUIHelper.showErrorDlg((Component)this, (String)ERROR_NODAT_MSG, (String)"DAT file not found!");
        }
        catch (Exception eee) {
            Logger.getLogger(JTSConfigurator.class.getName()).log(Level.SEVERE, null, eee);
        }
    }

    public void createActionListener() {
        Vector addAction = new Vector();
        for (int k = 0; k < this.graphCount; ++k) {
            this.activationChange[k] = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }
    }

    private class AddGraphDlg
    extends JDialog {
        boolean result;
        int max;
        String side;
        int side_index;
        int position;
        JSpinner posSpinner;
        JComboBox sideChoice;
        JButton okButton;
        JLabel pos_label;
        JLabel side_label;
        ActionListener ok;

        public AddGraphDlg() {
            super(JTSConfigurator.this, "Add Graph", true);
            this.result = false;
            this.ok = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddGraphDlg.this.side_index = AddGraphDlg.this.sideChoice.getSelectedIndex();
                    AddGraphDlg.this.position = (Integer)AddGraphDlg.this.posSpinner.getValue();
                    AddGraphDlg.this.result = true;
                    AddGraphDlg.this.setVisible(false);
                }
            };
            Point parentloc = JTSConfigurator.this.parent.getLocation();
            this.setLocation(parentloc.x + 50, parentloc.y + 50);
            this.createPanel();
        }

        void createPanel() {
            this.setLayout(new FlowLayout());
            this.max = JTSConfigurator.this.propVector.size();
            String[] posArray = new String[]{"left", "right"};
            this.posSpinner = this.max > 0 ? new JSpinner(new SpinnerNumberModel(this.max, 1, this.max, 1)) : new JSpinner(new SpinnerNumberModel(0, 0, 0, 0));
            this.sideChoice = new JComboBox<String>(posArray);
            this.sideChoice.setSelectedIndex(0);
            JButton okButton = new JButton("OK");
            this.pos_label = new JLabel("position after: ");
            this.side_label = new JLabel("side: ");
            this.add(this.side_label);
            this.add(this.sideChoice);
            this.add(this.pos_label);
            this.add(this.posSpinner);
            this.add(okButton);
            okButton.addActionListener(this.ok);
            this.pack();
        }

        int getSide() {
            return this.side_index;
        }

        int getPosition() {
            return this.position;
        }

        boolean getResult() {
            return this.result;
        }
    }

    private class HiResPanel
    extends JPanel {
        BufferedImage bi;

        public HiResPanel(BufferedImage bi) {
            this.bi = bi;
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.bi, 0, 0, this);
        }
    }
}

