/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.spreadsheet;

import jams.data.Attribute;
import jams.data.JAMSCalendar;
import jams.data.JAMSDouble;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class JAMSTableModel
extends AbstractTableModel
implements Serializable {
    private Vector<double[]> arrayVector = new Vector();
    private Vector<Attribute.Calendar> timeVector = new Vector();
    private int rows = 0;
    private int columns = 0;
    private String[] colnames;
    private boolean colnamesset = false;
    private boolean timeRuns = false;

    public JAMSTableModel() {
    }

    public JAMSTableModel(Vector<double[]> arrayData) {
        this.arrayVector = arrayData;
        int columnscount = 0;
        if (!this.arrayVector.isEmpty()) {
            for (int i = 0; i < this.arrayVector.size(); ++i) {
                if (columnscount >= this.arrayVector.get(i).length) continue;
                columnscount = this.arrayVector.get(i).length;
            }
        }
        this.columns = columnscount;
        this.colnames = new String[this.columns];
    }

    public JAMSTableModel getTableModel() {
        return this;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        return this.arrayVector.size();
    }

    @Override
    public String getColumnName(int index) {
        String name = this.colnamesset ? (index < this.colnames.length ? this.colnames[index] : "COL" + index) : "COL" + index;
        return name;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex < this.rows && columnIndex < this.columns;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        if (!this.timeRuns) {
            value = columnIndex < this.arrayVector.get(rowIndex).length ? Double.valueOf(this.arrayVector.get(rowIndex)[columnIndex]) : "-";
        }
        if (this.timeRuns) {
            value = columnIndex < this.arrayVector.get(rowIndex).length + 1 ? (columnIndex == 0 ? this.timeVector.get(rowIndex) : Double.valueOf(this.arrayVector.get(rowIndex)[columnIndex - 1])) : "-";
        }
        return value;
    }

    public double[] getColumnArray(int col) {
        double[] colArray;
        block3: {
            int size;
            block2: {
                size = this.arrayVector.size();
                colArray = new double[size];
                if (!this.timeRuns) break block2;
                if (col == 0) break block3;
                for (int k = 0; k < size; ++k) {
                    colArray[k] = this.arrayVector.get(k)[col];
                }
                break block3;
            }
            for (int k = 0; k < size; ++k) {
                colArray[k] = this.arrayVector.get(k)[col];
            }
        }
        return colArray;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public Vector<double[]> getDataVector() {
        return this.arrayVector;
    }

    public void setNewDataVector(Vector<double[]> inputvector) {
        this.arrayVector = inputvector;
        if (!this.arrayVector.isEmpty()) {
            for (int i = 0; i < this.arrayVector.size(); ++i) {
                if (!this.timeRuns) {
                    if (this.columns >= this.arrayVector.get(i).length) continue;
                    this.columns = this.arrayVector.get(i).length;
                    continue;
                }
                if (this.columns >= this.arrayVector.get(i).length + 1) continue;
                this.columns = this.arrayVector.get(i).length + 1;
            }
        }
        this.columns = this.columns;
    }

    public Vector<Attribute.Calendar> getTimeVector() {
        if (this.timeRuns) {
            return this.timeVector;
        }
        return null;
    }

    public void setTimeVector(Vector<Attribute.Calendar> timeVector) {
        this.timeVector = timeVector;
        this.timeRuns = true;
    }

    public void addRowArray(JAMSDouble[] rowdata) {
        int c = rowdata.length;
        double[] data = new double[c];
        for (int i = 0; i < c; ++i) {
            data[i] = rowdata[i].getValue();
        }
        this.arrayVector.add(data);
        if (this.columns < c) {
            this.columns = c;
        }
        ++this.rows;
    }

    public void addTime(JAMSCalendar time) {
        JAMSCalendar nextTime = time.clone();
        this.timeVector.add((Attribute.Calendar)nextTime);
    }

    public String[] getCoulumnNameArray() {
        String[] cnames = new String[this.columns];
        if (!this.colnamesset) {
            for (int i = 0; i < this.columns; ++i) {
                cnames[i] = "COL " + i;
            }
        } else {
            cnames = this.colnames;
        }
        return cnames;
    }

    public void setColumnNames(String[] names) {
        if (this.columns == 0) {
            this.columns = names.length;
            this.colnames = names;
        }
        if (names.length > this.columns) {
            this.columns = names.length;
        }
        if (names.length == this.columns) {
            this.colnames = names;
        } else {
            int i;
            String[] cnames = new String[this.columns];
            if (names.length > this.columns) {
                for (i = 0; i < this.columns; ++i) {
                    cnames[i] = names[i];
                }
            }
            if (names.length < this.columns) {
                for (i = 0; i < names.length; ++i) {
                    cnames[i] = names[i];
                }
                for (int j = names.length; j < this.columns; ++j) {
                    cnames[j] = "Col " + j;
                }
            }
            this.colnames = cnames;
        }
        this.colnamesset = true;
    }

    public void setTimeRuns(boolean isTimeRunning) {
        this.timeRuns = isTimeRunning;
    }
}

