/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.gui;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.explorer.DataCollectionViewController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.EfficiencyEnsemble;
import optas.data.Ensemble;
import optas.data.Measurement;
import optas.data.SimpleEnsemble;
import optas.data.TimeFilter;
import optas.data.TimeFilterFactory;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.DataCollectionPanel;
import optas.gui.MCAT5.MCAT5Toolbar;
import optas.tools.PatchedChartPanel;
import org.jdesktop.swingx.JXDatePicker;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class DataCollectionView
extends JComponent
implements DataCollectionPanel {
    private DataCollectionViewController delegate;
    private Attribute.TimeInterval maximumInterval = null;
    private JTable ensembleList = null;
    private JTable dataSetList = null;
    private JScrollPane ensembleListScrollPane = null;
    private JScrollPane dataSetListScrollPane = null;
    private JButton closeButton = new JButton("Close Tab");
    private JPanel displayPanel = null;
    private JButton displayDataButton = null;
    private JButton sumTSData = null;
    private JPanel timeIntervalPanel = null;
    private JLabel startDateLabel = null;
    private JLabel finalDateLabel = null;
    private JXDatePicker startDatePicker = null;
    private JXDatePicker finalDatePicker = null;
    private TitledBorder enabledTimeIntervalPanelBorder = null;
    private TitledBorder disabledTimeIntervalPanelBorder = null;
    private JPanel simIDPanel = null;
    private JLabel fromIDLabel = null;
    private JLabel toIDLabel = null;
    private JSpinner fromIDSpinner = null;
    private JSpinner toIDSpinner = null;
    private TitledBorder enabledIDPanelBorder = null;
    private TitledBorder disabledIDPanelBorder = null;
    private JPanel filterPanel = null;
    private JPanel filterSimPanel = null;
    private JLabel filterFromValueLabel = null;
    private JLabel filterToValueLabel = null;
    private JTextField filterFromValueField = null;
    private JTextField filterToValueField = null;
    private TitledBorder enabledValueFilterPanelBorder = null;
    private TitledBorder disabledValueFilterPanelBorder = null;
    private JPanel filterTimeIntervalPanel = null;
    private JLabel filterStartDateLabel = null;
    private JLabel filterFinalDateLabel = null;
    private JXDatePicker filterStartDatePicker = null;
    private JXDatePicker filterFinalDatePicker = null;
    private TitledBorder enabledTimeIntervalFilterPanelBorder = null;
    private TitledBorder disabledTimeIntervalFilterPanelBorder = null;
    private JPanel filterPercentilPanel = null;
    private JLabel filterFromPercentilLabel = null;
    private JLabel filterToPercentilLabel = null;
    private JTextField filterFromPercentilField = null;
    private JTextField filterToPercentilField = null;
    private TitledBorder enabledPercentilFilterPanelBorder = null;
    private TitledBorder disabledPercentilFilterPanelBorder = null;
    private JButton filterButton = null;
    private JButton inverseFilterButton = null;
    private JButton clearTimeFilterButton = null;
    private JButton clearValueFilterButton = null;
    private JButton deleteFilteredValuesButton = null;
    private JButton deleteAttribute = null;
    private JXDatePicker extractDatePicker = null;
    private JButton extractButton;
    private JTable table = null;
    private TableModel defaultTableModel = null;
    private TableModel tableModel = null;
    private JScrollPane tableScrollPane = null;
    private JButton showGraphButton = null;
    private MCAT5Toolbar mcat5Toolbar;

    public DataCollectionView(DataCollectionViewController delegate) {
        this.delegate = delegate;
        this.initComponents();
        this.layoutComponents();
    }

    private String[] getSelectedDataSets() {
        int row = this.ensembleList.getSelectedRow();
        if (row == -1) {
            return null;
        }
        DataType type = (DataType)((Object)this.ensembleList.getValueAt(row, 0));
        return this.delegate.getItemIdentifiersForDataType(type);
    }

    private void switchSelectedIDComponentState(boolean enabled, Object item) {
        if (enabled) {
            this.simIDPanel.setBorder(this.enabledIDPanelBorder);
            this.fromIDLabel.setForeground(Color.BLACK);
            this.toIDLabel.setForeground(Color.BLACK);
            this.fromIDSpinner.setEnabled(true);
            this.toIDSpinner.setEnabled(true);
            Object[] ids = this.delegate.getSimulationIDs();
            final SpinnerListModel fromIDSpinnerListModel = new SpinnerListModel(ids);
            fromIDSpinnerListModel.setValue(ids[0]);
            this.fromIDSpinner.setModel(fromIDSpinnerListModel);
            final SpinnerListModel toIDSpinnerListModel = new SpinnerListModel(ids);
            toIDSpinnerListModel.setValue(ids[ids.length - 1]);
            this.toIDSpinner.setModel(toIDSpinnerListModel);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int toID;
                    boolean validRange;
                    int fromID = (Integer)fromIDSpinnerListModel.getValue();
                    boolean bl = validRange = fromID <= (toID = ((Integer)toIDSpinnerListModel.getValue()).intValue());
                    if (!validRange) {
                        if (e.getSource().equals(fromIDSpinnerListModel)) {
                            fromIDSpinnerListModel.setValue(toID);
                        } else {
                            toIDSpinnerListModel.setValue(fromID);
                        }
                    }
                }
            };
            fromIDSpinnerListModel.addChangeListener(changeListener);
            toIDSpinnerListModel.addChangeListener(changeListener);
        } else {
            this.simIDPanel.setBorder(this.disabledIDPanelBorder);
            this.fromIDLabel.setForeground(Color.GRAY);
            this.toIDLabel.setForeground(Color.GRAY);
            this.fromIDSpinner.setEnabled(false);
            this.toIDSpinner.setEnabled(false);
        }
    }

    private void switchTimeIntervalComponentState(boolean enabled, Object item) {
        if (enabled && item != null) {
            this.timeIntervalPanel.setBorder(this.enabledTimeIntervalPanelBorder);
            this.startDateLabel.setForeground(Color.BLACK);
            this.finalDateLabel.setForeground(Color.BLACK);
            this.startDatePicker.setEnabled(true);
            this.finalDatePicker.setEnabled(true);
            this.maximumInterval = this.delegate.getTimeInterval(item);
            this.startDatePicker.setTimeZone(((Calendar)this.maximumInterval.getStart()).getTimeZone());
            this.finalDatePicker.setTimeZone(((Calendar)this.maximumInterval.getEnd()).getTimeZone());
            this.startDatePicker.setDate(this.maximumInterval.getStart().getTime());
            this.finalDatePicker.setDate(this.maximumInterval.getEnd().getTime());
        } else {
            this.timeIntervalPanel.setBorder(this.disabledTimeIntervalPanelBorder);
            this.startDateLabel.setForeground(Color.GRAY);
            this.finalDateLabel.setForeground(Color.GRAY);
            this.startDatePicker.setEnabled(false);
            this.finalDatePicker.setEnabled(false);
        }
    }

    private void switchValueFilterComponentState(boolean enabled, Object item) {
        Object o = null;
        if (enabled && item != null) {
            o = this.delegate.getItemForIdentifier(item);
        }
        if (enabled && o != null && o instanceof SimpleEnsemble) {
            double max;
            SimpleEnsemble ensemble = (SimpleEnsemble)o;
            double min = ensemble.getMin();
            if (min > (max = ensemble.getMax())) {
                double tmp = max;
                max = min;
                min = tmp;
            }
            min = (double)Math.round(min * 1000.0) / 1000.0;
            max = (double)Math.round(max * 1000.0) / 1000.0;
            this.filterFromValueField.setEnabled(true);
            this.filterToValueField.setEnabled(true);
            this.filterFromValueField.setText(Double.toString(min));
            this.filterToValueField.setText(Double.toString(max));
            this.filterToValueField.setEnabled(true);
            this.filterFromValueField.setEnabled(true);
            this.filterSimPanel.setBorder(this.enabledValueFilterPanelBorder);
            this.filterButton.setEnabled(true);
            this.inverseFilterButton.setEnabled(true);
        } else {
            this.filterSimPanel.setBorder(this.disabledValueFilterPanelBorder);
            this.filterFromValueField.setEnabled(false);
            this.filterToValueField.setEnabled(false);
            this.filterFromValueField.setText("");
            this.filterToValueField.setText("");
            this.inverseFilterButton.setEnabled(false);
        }
    }

    private void switchPercentilFilterComponentState(boolean enabled, Object item) {
        Object o = null;
        if (enabled && item != null) {
            o = this.delegate.getItemForIdentifier(item);
        }
        if (enabled && o != null && o instanceof SimpleEnsemble) {
            this.filterPercentilPanel.setBorder(this.enabledPercentilFilterPanelBorder);
            this.filterFromPercentilField.setEnabled(true);
            this.filterToPercentilField.setEnabled(true);
            this.filterFromPercentilField.setText("0.0");
            this.filterToPercentilField.setText("1.0");
            this.filterToPercentilField.setEnabled(true);
            this.filterFromPercentilField.setEnabled(true);
            this.filterButton.setEnabled(true);
            this.inverseFilterButton.setEnabled(true);
        } else {
            this.filterPercentilPanel.setBorder(this.disabledPercentilFilterPanelBorder);
            this.filterFromPercentilField.setEnabled(false);
            this.filterToPercentilField.setEnabled(false);
            this.filterFromPercentilField.setText("");
            this.filterToPercentilField.setText("");
            this.inverseFilterButton.setEnabled(false);
        }
    }

    private void switchTimeFilterComponentState(boolean enabled, Object item) {
        this.sumTSData.setEnabled(enabled & item != null);
        this.sumTSData.putClientProperty("item", item);
        if (enabled && item != null) {
            this.filterTimeIntervalPanel.setBorder(this.enabledTimeIntervalFilterPanelBorder);
            this.filterFinalDatePicker.setEnabled(true);
            this.filterStartDatePicker.setEnabled(true);
            this.filterStartDateLabel.setForeground(Color.BLACK);
            this.filterFinalDateLabel.setForeground(Color.BLACK);
            this.maximumInterval = this.delegate.getTimeInterval(item);
            this.filterStartDatePicker.setTimeZone(((Calendar)this.maximumInterval.getStart()).getTimeZone());
            this.filterFinalDatePicker.setTimeZone(((Calendar)this.maximumInterval.getEnd()).getTimeZone());
            this.filterStartDatePicker.setDate(this.maximumInterval.getStart().getTime());
            this.filterFinalDatePicker.setDate(this.maximumInterval.getEnd().getTime());
            this.filterButton.setEnabled(true);
        } else {
            this.filterTimeIntervalPanel.setBorder(this.disabledTimeIntervalFilterPanelBorder);
            this.filterFinalDatePicker.setEnabled(false);
            this.filterStartDatePicker.setEnabled(false);
            this.filterStartDateLabel.setForeground(Color.GRAY);
            this.filterFinalDateLabel.setForeground(Color.GRAY);
        }
    }

    private void initComponents() {
        Object[] columns = new String[]{"Ensembles"};
        DataType[] types = this.delegate.getAvailableDataTypes();
        DataType[][] entries = new DataType[types.length][1];
        for (int i = 0; i < types.length; ++i) {
            entries[i][0] = types[i];
        }
        this.ensembleList = new JTable((Object[][])entries, columns){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.ensembleList.setSelectionMode(0);
        this.ensembleList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataCollectionView.this.table.setModel(DataCollectionView.this.defaultTableModel);
                ((AbstractTableModel)DataCollectionView.this.dataSetList.getModel()).fireTableDataChanged();
            }
        });
        this.ensembleListScrollPane = new JScrollPane(this.ensembleList);
        this.dataSetList = new JTable(new DefaultTableModel(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return "Data Sets";
            }

            @Override
            public int getRowCount() {
                String[] selectedDataSets = DataCollectionView.this.getSelectedDataSets();
                if (selectedDataSets == null) {
                    return 1;
                }
                return selectedDataSets.length;
            }

            @Override
            public Object getValueAt(int row, int column) {
                String[] selectedDataSets = DataCollectionView.this.getSelectedDataSets();
                if (selectedDataSets == null) {
                    return "Select Ensemble...";
                }
                return selectedDataSets[row];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                String[] selectedDataSets = DataCollectionView.this.getSelectedDataSets();
                return selectedDataSets.length > row;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                String[] selectedDataSets = DataCollectionView.this.getSelectedDataSets();
                if (selectedDataSets.length > row) {
                    String name = selectedDataSets[row];
                    DataCollectionView.this.delegate.getDataCollection().renameDataset(name, aValue.toString());
                }
            }
        });
        this.dataSetList.setSelectionMode(0);
        this.dataSetList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataCollectionView.this.filterButton.setEnabled(false);
                DataCollectionView.this.inverseFilterButton.setEnabled(false);
                if (DataCollectionView.this.dataSetList.getSelectedRow() == -1) {
                    DataCollectionView.this.switchTimeFilterComponentState(false, null);
                    DataCollectionView.this.switchValueFilterComponentState(false, null);
                    DataCollectionView.this.switchPercentilFilterComponentState(false, null);
                    DataCollectionView.this.switchTimeIntervalComponentState(false, null);
                    DataCollectionView.this.switchSelectedIDComponentState(false, null);
                    DataCollectionView.this.displayDataButton.setEnabled(false);
                    DataCollectionView.this.filterButton.setEnabled(false);
                    DataCollectionView.this.inverseFilterButton.setEnabled(false);
                    return;
                }
                DataCollectionView.this.table.setModel(DataCollectionView.this.defaultTableModel);
                DataCollectionView.this.showGraphButton.setEnabled(false);
                Object item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                DataCollectionView.this.filterButton.setEnabled(false);
                DataCollectionView.this.inverseFilterButton.setEnabled(false);
                if (DataCollectionView.this.delegate.hasTimeInterval(item)) {
                    DataCollectionView.this.switchTimeFilterComponentState(true, item);
                    DataCollectionView.this.switchTimeIntervalComponentState(true, item);
                    DataCollectionView.this.switchValueFilterComponentState(false, item);
                    DataCollectionView.this.switchPercentilFilterComponentState(false, item);
                } else {
                    DataCollectionView.this.switchTimeFilterComponentState(false, item);
                    DataCollectionView.this.switchTimeIntervalComponentState(false, item);
                }
                if (DataCollectionView.this.delegate.isMultirun(item)) {
                    DataCollectionView.this.switchSelectedIDComponentState(true, item);
                } else {
                    DataCollectionView.this.switchSelectedIDComponentState(false, item);
                }
                if (!DataCollectionView.this.delegate.hasTimeInterval(item) && DataCollectionView.this.delegate.isMultirun(item)) {
                    DataCollectionView.this.switchValueFilterComponentState(true, item);
                    DataCollectionView.this.switchPercentilFilterComponentState(true, item);
                }
                DataCollectionView.this.displayDataButton.setEnabled(true);
            }
        });
        this.dataSetListScrollPane = new JScrollPane(this.dataSetList);
        this.displayPanel = new JPanel();
        this.displayPanel.setBorder(new TitledBorder(null, " Display Data ", 0, 0, null, Color.BLACK));
        this.enabledTimeIntervalPanelBorder = new TitledBorder(null, " Time interval ", 0, 0, null, Color.BLACK);
        this.disabledTimeIntervalPanelBorder = new TitledBorder(null, " Time interval ", 0, 0, null, Color.GRAY);
        this.filterTimeIntervalPanel = new JPanel();
        this.enabledTimeIntervalFilterPanelBorder = new TitledBorder(null, " Time interval ", 0, 0, null, Color.BLACK);
        this.disabledTimeIntervalFilterPanelBorder = new TitledBorder(null, " Time interval ", 0, 0, null, Color.GRAY);
        this.enabledValueFilterPanelBorder = new TitledBorder(null, " Value filter ", 0, 0, null, Color.BLACK);
        this.disabledValueFilterPanelBorder = new TitledBorder(null, " Value filter ", 0, 0, null, Color.GRAY);
        this.enabledPercentilFilterPanelBorder = new TitledBorder(null, " Percentil filter ", 0, 0, null, Color.BLACK);
        this.disabledPercentilFilterPanelBorder = new TitledBorder(null, " Percentil filter ", 0, 0, null, Color.GRAY);
        this.filterPanel = new JPanel();
        this.filterPanel.setBorder(new TitledBorder(null, " Filter Data ", 0, 0, null, Color.BLACK));
        this.filterSimPanel = new JPanel();
        this.filterSimPanel.setBorder(this.disabledValueFilterPanelBorder);
        this.filterPercentilPanel = new JPanel();
        this.filterPercentilPanel.setBorder(this.disabledPercentilFilterPanelBorder);
        this.filterTimeIntervalPanel.setBorder(this.disabledTimeIntervalFilterPanelBorder);
        this.timeIntervalPanel = new JPanel();
        this.timeIntervalPanel.setBorder(this.disabledTimeIntervalPanelBorder);
        this.startDateLabel = new JLabel("From:");
        this.startDateLabel.setForeground(Color.GRAY);
        this.finalDateLabel = new JLabel("To:");
        this.finalDateLabel.setForeground(Color.GRAY);
        this.filterStartDateLabel = new JLabel("From:");
        this.filterStartDateLabel.setForeground(Color.GRAY);
        this.filterFinalDateLabel = new JLabel("To:");
        this.filterFinalDateLabel.setForeground(Color.GRAY);
        this.startDatePicker = new JXDatePicker(System.currentTimeMillis());
        this.finalDatePicker = new JXDatePicker(System.currentTimeMillis());
        this.startDatePicker.setEnabled(false);
        this.finalDatePicker.setEnabled(false);
        this.filterStartDatePicker = new JXDatePicker(System.currentTimeMillis());
        this.filterFinalDatePicker = new JXDatePicker(System.currentTimeMillis());
        this.filterStartDatePicker.setEnabled(false);
        this.filterFinalDatePicker.setEnabled(false);
        this.sumTSData = new JButton("Sum up TimeSerie");
        this.sumTSData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSet ts;
                Object item = ((JButton)e.getSource()).getClientProperty("item");
                if (item != null && (ts = DataCollectionView.this.delegate.getDataCollection().getDataSet((String)item)) instanceof TimeSerieEnsemble) {
                    SimpleEnsemble se = ((TimeSerieEnsemble)ts).sumTS();
                    DataCollectionView.this.delegate.getDataCollection().addEnsemble(se);
                }
            }
        });
        this.deleteAttribute = new JButton("Delete Attribute");
        this.deleteAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                DataCollectionView.this.delegate.getDataCollection().removeDataset(item.toString());
                ((AbstractTableModel)DataCollectionView.this.dataSetList.getModel()).fireTableDataChanged();
            }
        });
        ActionListener datePickerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean validFinalDate2;
                Calendar startCal = (Calendar)DataCollectionView.this.maximumInterval.getStart().clone();
                Calendar endCal = (Calendar)DataCollectionView.this.maximumInterval.getEnd().clone();
                startCal.set(10, 0);
                startCal.set(12, 0);
                endCal.set(10, 0);
                endCal.set(12, 0);
                boolean validStartDate = DataCollectionView.this.startDatePicker.getDateInMillis() >= startCal.getTimeInMillis();
                boolean validFinalDate = DataCollectionView.this.finalDatePicker.getDateInMillis() <= endCal.getTimeInMillis();
                boolean validStartDate2 = DataCollectionView.this.filterStartDatePicker.getDateInMillis() >= startCal.getTimeInMillis();
                boolean bl = validFinalDate2 = DataCollectionView.this.filterFinalDatePicker.getDateInMillis() <= endCal.getTimeInMillis();
                if (!validStartDate) {
                    DataCollectionView.this.startDatePicker.setDate(startCal.getTime());
                }
                if (!validFinalDate) {
                    DataCollectionView.this.finalDatePicker.setDate(endCal.getTime());
                }
                if (!validStartDate2) {
                    DataCollectionView.this.filterStartDatePicker.setDate(startCal.getTime());
                }
                if (!validFinalDate2) {
                    DataCollectionView.this.filterFinalDatePicker.setDate(endCal.getTime());
                }
            }
        };
        this.startDatePicker.addActionListener(datePickerActionListener);
        this.finalDatePicker.addActionListener(datePickerActionListener);
        this.filterStartDatePicker.addActionListener(datePickerActionListener);
        this.filterFinalDatePicker.addActionListener(datePickerActionListener);
        this.extractDatePicker = new JXDatePicker(System.currentTimeMillis());
        this.extractButton = new JButton("Extract");
        this.extractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date d = DataCollectionView.this.extractDatePicker.getDate();
                Object item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                DataSet dataset = DataCollectionView.this.delegate.getDataCollection().getDataSet(item.toString());
                if (dataset instanceof TimeSerieEnsemble) {
                    TimeSerieEnsemble ts = (TimeSerieEnsemble)dataset;
                    int r = -1;
                    for (int i = 0; i < ts.getTimesteps(); ++i) {
                        if (!ts.getDate(i).after(d) && !ts.getDate(i).equals(d)) continue;
                        r = i;
                        break;
                    }
                    if (r != -1) {
                        Set s = DataCollectionView.this.delegate.getDataCollection().getDatasets(Measurement.class);
                        String first = (String)s.iterator().next();
                        Measurement m = (Measurement)DataCollectionView.this.delegate.getDataCollection().getDataSet(first);
                        double value = m.getValue(r);
                        EfficiencyEnsemble eff = new EfficiencyEnsemble(ts.get(r), false);
                        eff.calcPlus(-value);
                        eff.calcAbs();
                        DataCollectionView.this.delegate.getDataCollection().addEnsemble((SimpleEnsemble)eff);
                    }
                }
            }
        });
        this.enabledIDPanelBorder = new TitledBorder(null, " Simulation ID ", 0, 0, null, Color.BLACK);
        this.disabledIDPanelBorder = new TitledBorder(null, " Simulation ID ", 0, 0, null, Color.GRAY);
        this.simIDPanel = new JPanel();
        this.simIDPanel.setBorder(this.disabledIDPanelBorder);
        this.fromIDLabel = new JLabel("From:");
        this.fromIDLabel.setForeground(Color.GRAY);
        this.toIDLabel = new JLabel("To:");
        this.toIDLabel.setForeground(Color.GRAY);
        this.filterFromValueLabel = new JLabel("From:");
        this.filterFromValueLabel.setForeground(Color.GRAY);
        this.filterToValueLabel = new JLabel("To:");
        this.filterToValueLabel.setForeground(Color.GRAY);
        this.filterFromPercentilLabel = new JLabel("From:");
        this.filterFromPercentilLabel.setForeground(Color.GRAY);
        this.filterToPercentilLabel = new JLabel("To:");
        this.filterToPercentilLabel.setForeground(Color.GRAY);
        this.fromIDSpinner = new JSpinner();
        this.fromIDSpinner.setEnabled(false);
        this.toIDSpinner = new JSpinner();
        this.toIDSpinner.setEnabled(false);
        this.filterFromValueField = new JTextField("");
        this.filterFromValueField.setEnabled(false);
        this.filterToValueField = new JTextField("");
        this.filterToValueField.setEnabled(false);
        this.filterFromPercentilField = new JTextField("");
        this.filterFromPercentilField.setEnabled(false);
        this.filterToPercentilField = new JTextField("");
        this.filterToPercentilField.setEnabled(false);
        this.displayDataButton = new JButton(new AbstractAction("Display"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                DataCollectionView.this.showGraphButton.setEnabled(!DataCollectionView.this.delegate.hasTimeInterval(item));
                DataCollectionView.this.displayData(DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0));
            }
        });
        this.displayDataButton.setEnabled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Container c = DataCollectionView.this.getParent();
                if (c != null && c instanceof JTabbedPane) {
                    JTabbedPane pane = (JTabbedPane)c;
                    pane.remove(DataCollectionView.this);
                }
            }
        });
        columns = new String[]{"Simulation ID", "Timestep"};
        this.table = new JTable();
        this.table.setAutoResizeMode(0);
        this.defaultTableModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Simulation ID";
                    }
                }
                return "Values";
            }

            @Override
            public int getRowCount() {
                return 0;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return null;
            }
        };
        this.table.setModel(this.defaultTableModel);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataCollectionView.this.showGraphButton.setEnabled(true);
            }
        });
        this.tableScrollPane = new JScrollPane(this.table);
        this.showGraphButton = new JButton("Show graph...");
        this.showGraphButton.setEnabled(false);
        this.showGraphButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                            String itemName = (String)item;
                            JDialog chartWindow = new JDialog((Frame)((JFrame)DataCollectionView.this.getRootPane().getParent()), itemName);
                            chartWindow.setSize(800, 600);
                            chartWindow.setLocation(100, 100);
                            JFreeChart chart = null;
                            if (DataCollectionView.this.delegate.hasTimeInterval(item)) {
                                int[] rows;
                                TimeSeriesCollection collection = new TimeSeriesCollection();
                                int numberOfCols = DataCollectionView.this.tableModel.getColumnCount();
                                for (int row : rows = DataCollectionView.this.table.getSelectedRows()) {
                                    TimeSeries series = new TimeSeries((Comparable)((Object)("time series #" + row)), Day.class);
                                    for (int i = 1; i < numberOfCols; ++i) {
                                        Date date = DateFormat.getDateInstance().parse(DataCollectionView.this.tableModel.getColumnName(i));
                                        series.add((RegularTimePeriod)new Day(date), (Number)((Double)DataCollectionView.this.tableModel.getValueAt(row, i)));
                                    }
                                    collection.addSeries(series);
                                }
                                chart = ChartFactory.createTimeSeriesChart((String)itemName, null, null, (XYDataset)collection, (boolean)false, (boolean)false, (boolean)false);
                            } else {
                                DefaultXYDataset dataset = new DefaultXYDataset();
                                int[] rows = null;
                                if (DataCollectionView.this.table.getSelectedRow() == -1) {
                                    rows = new int[DataCollectionView.this.tableModel.getRowCount()];
                                    for (int i = 0; i < rows.length; ++i) {
                                        rows[i] = i;
                                    }
                                } else {
                                    rows = DataCollectionView.this.table.getSelectedRows();
                                }
                                double[][] data = new double[2][rows.length];
                                int index = 0;
                                for (int row : rows) {
                                    Object o = DataCollectionView.this.tableModel.getValueAt(row, 0);
                                    if (o == null) continue;
                                    int id = (Integer)DataCollectionView.this.tableModel.getValueAt(row, 0);
                                    double value = (Double)DataCollectionView.this.tableModel.getValueAt(row, 1);
                                    data[0][index] = id;
                                    data[1][index] = value;
                                    ++index;
                                }
                                dataset.addSeries((Comparable)((Object)itemName), data);
                                chart = ChartFactory.createScatterPlot((String)itemName, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                            }
                            PatchedChartPanel chartPanel = new PatchedChartPanel(chart);
                            chartWindow.getContentPane().add((Component)chartPanel);
                            chartWindow.setVisible(true);
                        }
                        catch (ParseException ex) {
                            ex.printStackTrace();
                        }
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        });
        this.filterButton = new JButton("Filter");
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj;
                Object item;
                if (DataCollectionView.this.filterStartDatePicker.isEnabled() && DataCollectionView.this.filterFinalDatePicker.isEnabled()) {
                    Date startDate = DataCollectionView.this.filterStartDatePicker.getDate();
                    Date endDate = DataCollectionView.this.filterFinalDatePicker.getDate();
                    Attribute.TimeInterval interval = DefaultDataFactory.getDataFactory().createTimeInterval();
                    interval.getStart().setTime(startDate);
                    interval.getEnd().setTime(endDate);
                    Object item2 = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                    DataCollectionView.this.getDataCollection().filterTimeDomain(TimeFilterFactory.getRangeFilter((Attribute.TimeInterval)interval));
                }
                if (DataCollectionView.this.filterFromValueField.isEnabled() && DataCollectionView.this.filterToValueField.isEnabled()) {
                    try {
                        double minValue = Double.parseDouble(DataCollectionView.this.filterFromValueField.getText());
                        double maxValue = Double.parseDouble(DataCollectionView.this.filterToValueField.getText());
                        item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                        obj = DataCollectionView.this.delegate.getItemForIdentifier(item);
                        if (obj instanceof SimpleEnsemble) {
                            DataCollectionView.this.delegate.filter(item, minValue, maxValue, false);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(DataCollectionView.this.ensembleList, "Unrecongnized value " + nfe.getLocalizedMessage());
                    }
                }
                if (DataCollectionView.this.filterFromPercentilField.isEnabled() && DataCollectionView.this.filterToPercentilLabel.isEnabled()) {
                    try {
                        double minValue = Double.parseDouble(DataCollectionView.this.filterFromPercentilField.getText());
                        double maxValue = Double.parseDouble(DataCollectionView.this.filterToPercentilField.getText());
                        item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                        obj = DataCollectionView.this.delegate.getItemForIdentifier(item);
                        if (obj instanceof SimpleEnsemble) {
                            DataCollectionView.this.delegate.filterPercentil(item, minValue, maxValue, false);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(DataCollectionView.this.ensembleList, "Unrecongnized value " + nfe.getLocalizedMessage());
                    }
                }
            }
        });
        this.inverseFilterButton = new JButton("Inverse Filter");
        this.inverseFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj;
                Object item;
                if (DataCollectionView.this.filterStartDatePicker.isEnabled() && DataCollectionView.this.filterFinalDatePicker.isEnabled()) {
                    Date startDate = DataCollectionView.this.filterStartDatePicker.getDate();
                    Date endDate = DataCollectionView.this.filterFinalDatePicker.getDate();
                    Attribute.TimeInterval interval = DefaultDataFactory.getDataFactory().createTimeInterval();
                    interval.getStart().setTime(startDate);
                    interval.getEnd().setTime(endDate);
                    TimeFilter f = TimeFilterFactory.getRangeFilter((Attribute.TimeInterval)interval);
                    f.setInverted(true);
                    DataCollectionView.this.getDataCollection().filterTimeDomain(f);
                }
                if (DataCollectionView.this.filterFromValueField.isEnabled() && DataCollectionView.this.filterToValueField.isEnabled()) {
                    try {
                        double minValue = Double.parseDouble(DataCollectionView.this.filterFromValueField.getText());
                        double maxValue = Double.parseDouble(DataCollectionView.this.filterToValueField.getText());
                        item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                        obj = DataCollectionView.this.delegate.getItemForIdentifier(item);
                        if (obj instanceof SimpleEnsemble) {
                            DataCollectionView.this.delegate.filter(item, minValue, maxValue, true);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(DataCollectionView.this.ensembleList, "Unrecongnized value " + nfe.getLocalizedMessage());
                    }
                }
                if (DataCollectionView.this.filterFromPercentilField.isEnabled() && DataCollectionView.this.filterToPercentilLabel.isEnabled()) {
                    try {
                        double minValue = Double.parseDouble(DataCollectionView.this.filterFromPercentilField.getText());
                        double maxValue = Double.parseDouble(DataCollectionView.this.filterToPercentilField.getText());
                        item = DataCollectionView.this.dataSetList.getValueAt(DataCollectionView.this.dataSetList.getSelectedRow(), 0);
                        obj = DataCollectionView.this.delegate.getItemForIdentifier(item);
                        if (obj instanceof SimpleEnsemble) {
                            DataCollectionView.this.delegate.filterPercentil(item, minValue, maxValue, true);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(DataCollectionView.this.ensembleList, "Unrecongnized value " + nfe.getLocalizedMessage());
                    }
                }
            }
        });
        this.clearTimeFilterButton = new JButton("Clear Time-Filter");
        this.clearTimeFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCollectionView.this.delegate.clearTimeFilter();
            }
        });
        this.clearValueFilterButton = new JButton("Clear ID-Filters");
        this.clearValueFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCollectionView.this.delegate.clearIDFilter();
            }
        });
        this.deleteFilteredValuesButton = new JButton("Delete");
        this.deleteFilteredValuesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(DataCollectionView.this.ensembleList, "Do you really want to delete all filtered items") == 0) {
                    DataCollectionView.this.delegate.commitFilter();
                }
            }
        });
        this.mcat5Toolbar = new MCAT5Toolbar((DataCollectionPanel)this);
    }

    public void refreshView() {
        try {
            Object[] columns = new String[]{"Ensembles"};
            DataType[] types = this.delegate.getAvailableDataTypes();
            DataType[][] entries = new DataType[types.length][1];
            for (int i = 0; i < types.length; ++i) {
                entries[i][0] = types[i];
            }
            DefaultTableModel ensembleTableModel = new DefaultTableModel();
            ensembleTableModel.setDataVector((Object[][])entries, columns);
            this.ensembleList.setModel(ensembleTableModel);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void layoutComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        this.mcat5Toolbar.setPreferredSize(new Dimension(250, 300));
        this.mcat5Toolbar.setSize(new Dimension(250, 300));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.mcat5Toolbar).addGap(0, 1000, 100000).addComponent(this.closeButton)).addGroup(layout.createSequentialGroup().addComponent(this.ensembleListScrollPane).addComponent(this.dataSetListScrollPane).addGap(25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.displayDataButton).addComponent(this.sumTSData).addComponent(this.deleteAttribute)).addGroup(layout.createSequentialGroup().addComponent(this.filterPanel)))).addComponent(this.tableScrollPane).addComponent(this.showGraphButton));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent((Component)this.mcat5Toolbar).addComponent(this.closeButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ensembleListScrollPane).addComponent(this.dataSetListScrollPane).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.displayDataButton).addComponent(this.sumTSData).addComponent(this.deleteAttribute)).addGroup(layout.createParallelGroup().addComponent(this.filterPanel))).addGap(25)).addComponent(this.tableScrollPane).addComponent(this.showGraphButton));
        layout = new GroupLayout(this.timeIntervalPanel);
        this.timeIntervalPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startDateLabel).addComponent((Component)this.startDatePicker).addComponent(this.finalDateLabel).addComponent((Component)this.finalDatePicker).addGap(25));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.startDateLabel).addComponent((Component)this.startDatePicker).addGap(10).addComponent(this.finalDateLabel).addComponent((Component)this.finalDatePicker));
        layout = new GroupLayout(this.simIDPanel);
        this.simIDPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fromIDLabel).addComponent(this.fromIDSpinner).addGap(25).addComponent(this.toIDLabel).addComponent(this.toIDSpinner));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.fromIDLabel).addComponent(this.fromIDSpinner).addComponent(this.toIDLabel).addComponent(this.toIDSpinner));
        layout = new GroupLayout(this.displayPanel);
        this.displayPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.timeIntervalPanel).addComponent(this.simIDPanel).addComponent(this.displayDataButton));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.timeIntervalPanel).addComponent(this.simIDPanel).addComponent(this.displayDataButton));
        layout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.filterTimeIntervalPanel).addComponent(this.filterSimPanel).addComponent(this.filterPercentilPanel).addGroup(layout.createSequentialGroup().addComponent(this.filterButton).addComponent(this.inverseFilterButton).addComponent(this.deleteFilteredValuesButton)).addGroup(layout.createSequentialGroup().addComponent(this.clearTimeFilterButton).addComponent(this.clearValueFilterButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.filterTimeIntervalPanel).addComponent(this.filterSimPanel).addComponent(this.filterPercentilPanel).addGroup(layout.createParallelGroup().addComponent(this.filterButton).addComponent(this.inverseFilterButton).addComponent(this.deleteFilteredValuesButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.clearTimeFilterButton).addComponent(this.clearValueFilterButton)));
        layout = new GroupLayout(this.filterTimeIntervalPanel);
        this.filterTimeIntervalPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.filterStartDateLabel).addComponent((Component)this.filterStartDatePicker).addComponent(this.filterFinalDateLabel).addComponent((Component)this.filterFinalDatePicker));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.filterStartDateLabel).addComponent((Component)this.filterStartDatePicker).addComponent(this.filterFinalDateLabel).addComponent((Component)this.filterFinalDatePicker));
        layout = new GroupLayout(this.filterSimPanel);
        this.filterSimPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.filterFromValueLabel).addComponent(this.filterFromValueField).addComponent(this.filterToValueLabel).addComponent(this.filterToValueField));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.filterFromValueLabel).addComponent(this.filterFromValueField).addComponent(this.filterToValueLabel).addComponent(this.filterToValueField));
        layout = new GroupLayout(this.filterPercentilPanel);
        this.filterPercentilPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.filterFromPercentilLabel).addComponent(this.filterFromPercentilField).addComponent(this.filterToPercentilLabel).addComponent(this.filterToPercentilField));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.filterFromPercentilLabel).addComponent(this.filterFromPercentilField).addComponent(this.filterToPercentilLabel).addComponent(this.filterToPercentilField));
    }

    public DataCollection getDataCollection() {
        if (this.delegate instanceof DataCollectionViewController) {
            DataCollectionViewController controller = this.delegate;
            return controller.getDataCollection();
        }
        return null;
    }

    private void displayData(Object identifier) {
        this.delegate.itemIsBeingDisplayed(identifier);
        Object item = this.delegate.getItemForIdentifier(identifier);
        final Ensemble ensemble = (Ensemble)item;
        long tmp = 0L;
        if (ensemble instanceof TimeSerieEnsemble) {
            tmp = ((TimeSerieEnsemble)ensemble).getTimesteps();
        }
        long offset = 0L;
        final long numberOfSteps = tmp;
        this.tableModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                if (ensemble instanceof TimeSerieEnsemble) {
                    switch (column) {
                        case 0: {
                            return "Simulation ID";
                        }
                    }
                    return new SimpleDateFormat("dd.MM.yyyy").format(((TimeSerieEnsemble)ensemble).getDate(column - 1));
                }
                switch (column) {
                    case 0: {
                        return "Simulation ID";
                    }
                    case 1: {
                        return "Values";
                    }
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return ensemble.getIds().length;
            }

            @Override
            public int getColumnCount() {
                if (ensemble instanceof TimeSerieEnsemble) {
                    return (int)numberOfSteps + 1;
                }
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                int simIDOffset = (Integer)DataCollectionView.this.fromIDSpinner.getValue();
                if (ensemble.getSize() <= rowIndex + simIDOffset) {
                    return null;
                }
                if (ensemble instanceof TimeSerieEnsemble) {
                    switch (columnIndex) {
                        case 0: {
                            return ((TimeSerieEnsemble)ensemble).getId(rowIndex);
                        }
                    }
                    return ((TimeSerieEnsemble)ensemble).get(columnIndex - 1 + 0, ((TimeSerieEnsemble)ensemble).getId(rowIndex));
                }
                switch (columnIndex) {
                    case 0: {
                        return ((SimpleEnsemble)ensemble).getId(rowIndex);
                    }
                    case 1: {
                        return ((SimpleEnsemble)ensemble).getValue(((SimpleEnsemble)ensemble).getId(rowIndex));
                    }
                }
                return 0;
            }
        };
        this.table.setModel(this.tableModel);
    }

    public static enum DataType {
        TIME_SERIES,
        MEASUREMENT,
        OBJECTIVE,
        VARIABLE,
        PARAMETER;


        public String toString() {
            switch (this) {
                case TIME_SERIES: {
                    return "Time Series";
                }
                case MEASUREMENT: {
                    return "Measurement";
                }
                case OBJECTIVE: {
                    return "Objective";
                }
                case VARIABLE: {
                    return "Variable";
                }
                case PARAMETER: {
                    return "Parameter";
                }
            }
            return null;
        }
    }
}

