/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.ensembles.implementation;

import jams.aggregators.Aggregator;
import jams.aggregators.DoubleAggregator;
import jams.data.ArrayDataSupplier;
import jams.data.Attribute;
import jams.data.NamedDataSupplier;
import jams.explorer.ensembles.api.Ensemble;
import jams.explorer.ensembles.api.Model;
import jams.explorer.ensembles.implementation.AbstractEnsemble;
import jams.explorer.ensembles.implementation.ClimateEnsembleProcessor;
import jams.explorer.ensembles.implementation.ClimateModel;
import jams.io.ShapeFileOutputDataStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="ClimateEnsemble")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClimateEnsemble
extends AbstractEnsemble<ClimateModel> {
    @XmlTransient
    DefaultTreeModel treeModel = null;
    String relativePathToShapeFileTemplate;
    @XmlTransient
    public File basePath = new File("").getAbsoluteFile();

    public ClimateEnsemble() {
        super("");
    }

    public ClimateEnsemble(String name) {
        super(name);
    }

    public void setShapeFileTemplate(File f) {
        String relativePath;
        if (f == null) {
            this.relativePathToShapeFileTemplate = null;
            return;
        }
        Path p_shape = f.toPath().toAbsolutePath();
        Path p_base = this.basePath.toPath().toAbsolutePath();
        this.relativePathToShapeFileTemplate = relativePath = p_base.relativize(p_shape).toString();
    }

    public void setRelativePathToShapeFileTemplate(String f) {
        this.relativePathToShapeFileTemplate = f;
    }

    public String getRelativePathToShapeFileTemplate() {
        return this.relativePathToShapeFileTemplate;
    }

    public File getShapeFileTemplate() {
        if (this.relativePathToShapeFileTemplate == null) {
            return null;
        }
        return new File(this.basePath.getAbsoluteFile(), this.relativePathToShapeFileTemplate);
    }

    public void save() {
        for (ClimateModel model : this.modelSet) {
            model.relocate(this.basePath);
            model.save();
        }
    }

    public void relocate(File newBasePath) {
        File shapeFileTemplate = this.getShapeFileTemplate();
        this.basePath = newBasePath;
        this.setShapeFileTemplate(shapeFileTemplate);
        for (ClimateModel model : this.modelSet) {
            model.relocate(newBasePath);
        }
    }

    public void setBasePath(File newBasePath) {
        this.basePath = newBasePath;
        for (ClimateModel model : this.modelSet) {
            model.setBasePath(newBasePath);
        }
    }

    public void aggregateEnsembleToFile(File target, String output, Aggregator.AggregationMode mode, Double modeParameter, Attribute.TimeInterval refPeriod) throws IOException {
        NamedDataSupplier[] result = this.aggregateEnsemble(output, mode, modeParameter, refPeriod);
        String modeString = mode.toString();
        if (modeParameter != null && mode == Aggregator.AggregationMode.MEDIAN) {
            modeString = "Q" + String.format("%.0f", modeParameter * 100.0);
        }
        File targetDir = new File(target, "/ensemble/" + modeString + "/" + output);
        targetDir.mkdirs();
        ShapeFileOutputDataStore shpStore = new ShapeFileOutputDataStore(new File(this.getShapeFileTemplate().getAbsolutePath()), targetDir);
        List<String> fieldNames = Arrays.asList(shpStore.getFieldNames());
        if (fieldNames.contains("ID")) {
            shpStore.addDataToShpFiles(result, "ID");
        } else if (fieldNames.contains("OBJECTID")) {
            shpStore.addDataToShpFiles(result, "OBJECTID");
        } else {
            throw new IOException("Unknown ID field name!");
        }
    }

    private String date() {
        return "[" + new Date().getTime() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClimateDataSupplier<Double>[] aggregateEnsemble(String output, Aggregator.AggregationMode mode, Double modeParameter, Attribute.TimeInterval refPeriod) {
        System.out.println(this.date() + ": Start");
        ClimateEnsembleProcessor proc = new ClimateEnsembleProcessor(this, output);
        try {
            int j;
            System.out.println(this.date() + ": Init");
            proc.init();
            System.out.println(this.date() + ": getTimeDomain");
            Attribute.Calendar[] dates = proc.getTimeDomain();
            System.out.println(this.date() + ": getEntityIDs");
            long[] entityIDs = proc.getEntityIDs();
            int K = entityIDs.length;
            int T = dates.length;
            int m = this.getModelSet().size();
            ClimateDataSupplier[] result = new ClimateDataSupplier[T];
            double[][] refMean = new double[m][K];
            if (refPeriod != null) {
                System.out.println(this.date() + ": Working on reference period!");
                int k = 0;
                for (ClimateModel model : proc.procs.keySet()) {
                    System.out.println(this.date() + ":Working on model " + model.toString());
                    double[][] modelSlice = proc.getModelSlice(model);
                    System.out.println("Working on entities!");
                    for (j = 0; j < K; ++j) {
                        DoubleAggregator aggregator = DoubleAggregator.create((Aggregator.AggregationMode)Aggregator.AggregationMode.AVERAGE);
                        aggregator.init();
                        for (int i = 0; i < T; ++i) {
                            if (!dates[i].after(refPeriod.getStart()) || !dates[i].before(refPeriod.getEnd())) continue;
                            aggregator.consider((Object)modelSlice[i][j]);
                        }
                        aggregator.finish();
                        refMean[k][j] = aggregator.get();
                    }
                    ++k;
                }
            }
            System.out.println("Working on full time period!");
            for (int i = 0; i < T; ++i) {
                System.out.println("Working on timestep " + i + " of " + T);
                double[][] timeSlice = proc.getTimeSlice(entityIDs, dates[i].toString());
                DoubleAggregator aggregator = DoubleAggregator.create((Aggregator.AggregationMode)mode);
                if (modeParameter != null && aggregator instanceof DoubleAggregator.IndexAggregator) {
                    ((DoubleAggregator.IndexAggregator)aggregator).setSelectionIndex(modeParameter.intValue());
                }
                Double[] tmp = new Double[K];
                for (j = 0; j < K; ++j) {
                    aggregator.init();
                    for (int k = 0; k < timeSlice.length; ++k) {
                        aggregator.consider((Object)(timeSlice[k][j] - refMean[k][j]));
                    }
                    aggregator.finish();
                    double v = 0.0;
                    v = modeParameter != null && aggregator instanceof DoubleAggregator.MedianAggregator ? ((DoubleAggregator.MedianAggregator)aggregator).getQuantile(modeParameter) : aggregator.get().doubleValue();
                    tmp[j] = v;
                }
                result[i] = i == 0 ? new ClimateDataSupplier<Double>(dates[i].toString(), entityIDs, tmp) : result[i - 1].copy(dates[i].toString(), tmp);
            }
            ClimateDataSupplier[] climateDataSupplierArray = result;
            return climateDataSupplierArray;
        }
        catch (Throwable e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Sorry, I failed to perform the aggregation!", e);
        }
        finally {
            try {
                proc.close();
            }
            catch (SQLException sqle) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Sorry, I failed to perform the aggregation!", sqle);
            }
        }
        return null;
    }

    public TreeModel getTreeModel() {
        EnsembleTreeNode root = new EnsembleTreeNode(this);
        for (ClimateModel model : this.modelSet) {
            ModelTreeNode modelNode = new ModelTreeNode(model);
            root.add(modelNode);
            for (String outputDir : model.getOutputs()) {
                OutputDirectoryTreeNode dirNode = new OutputDirectoryTreeNode(model, outputDir);
                modelNode.add(dirNode);
            }
        }
        this.treeModel = new DefaultTreeModel(root);
        return this.treeModel;
    }

    public String toString() {
        return this.name;
    }

    public class OutputTreeNode
    extends DefaultMutableTreeNode {
        ClimateModel model;

        OutputTreeNode(ClimateModel model, File o) {
            super(o);
            this.model = model;
        }

        public ClimateModel getModel() {
            return this.model;
        }

        public File getOutput() {
            return (File)this.getUserObject();
        }

        @Override
        public String toString() {
            return ((File)this.getUserObject()).getName();
        }
    }

    public class OutputDirectoryTreeNode
    extends DefaultMutableTreeNode {
        ClimateModel model;

        OutputDirectoryTreeNode(ClimateModel model, String o) {
            super(o);
            this.model = model;
        }

        public ClimateModel getModel() {
            return this.model;
        }

        public String getOutputDirectory() {
            return (String)this.getUserObject();
        }
    }

    public class EnsembleTreeNode
    extends DefaultMutableTreeNode {
        EnsembleTreeNode(Ensemble e) {
            super(e);
        }

        public ClimateEnsemble getEnsemble() {
            return (ClimateEnsemble)this.getUserObject();
        }
    }

    public class ModelTreeNode
    extends DefaultMutableTreeNode {
        ModelTreeNode(ClimateModel model) {
            super(model);
            model.removeAllModelDataChangeListener();
            model.addModelDataChangeListener(new Model.ModelDataChangeListener(){

                @Override
                public void changed(Model model, String key) {
                    ModelTreeNode.this.setUserObject(model);
                    ClimateEnsemble.this.treeModel.nodeChanged((TreeNode)ClimateEnsemble.this.treeModel.getRoot());
                }
            });
        }

        public ClimateModel getModel() {
            return (ClimateModel)this.getUserObject();
        }
    }

    public class ClimateDataSupplier<T>
    extends ArrayDataSupplier<T>
    implements NamedDataSupplier<T> {
        String name;
        long[] entityIDs;
        HashMap<Integer, Integer> indexMap;

        ClimateDataSupplier(ClimateDataSupplier<T> parent) {
            super((Object[])parent.input);
            this.indexMap = new HashMap();
            this.name = parent.name;
            this.indexMap = parent.indexMap;
            this.entityIDs = parent.entityIDs;
        }

        ClimateDataSupplier(String name, long[] entityIDs, T[] values) {
            super((Object[])values);
            this.indexMap = new HashMap();
            this.name = name;
            this.entityIDs = entityIDs;
            for (int i = 0; i < entityIDs.length; ++i) {
                this.indexMap.put((int)entityIDs[i], i);
            }
        }

        public ClimateDataSupplier copy(String name, T[] values) {
            ClimateDataSupplier<T> copy = new ClimateDataSupplier<T>(this);
            copy.name = name;
            copy.input = values;
            return copy;
        }

        public String getName() {
            return this.name;
        }

        public long[] getEntityIDs() {
            return this.entityIDs;
        }

        public T get(int id) {
            Integer i = this.indexMap.get(id);
            if (i == null) {
                return null;
            }
            return (T)((Object[])this.input)[i];
        }
    }
}

